/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.Entity;
import software.amazon.awssdk.services.glue.model.ListEntitiesRequest;
import software.amazon.awssdk.services.glue.model.ListEntitiesResponse;

public class ListEntitiesPublisher
implements SdkPublisher<ListEntitiesResponse> {
    private final GlueAsyncClient client;
    private final ListEntitiesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEntitiesPublisher(GlueAsyncClient client, ListEntitiesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEntitiesPublisher(GlueAsyncClient client, ListEntitiesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEntitiesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEntitiesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Entity> entities() {
        return this.flatMapIterable(response -> response.entities());
    }

    private class ListEntitiesResponseFetcher
    implements AsyncPageFetcher<ListEntitiesResponse> {
        private ListEntitiesResponseFetcher() {
        }

        public boolean hasNextPage(ListEntitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEntitiesResponse> nextPage(ListEntitiesResponse previousPage) {
            if (previousPage == null) {
                return ListEntitiesPublisher.this.client.listEntities(ListEntitiesPublisher.this.firstRequest);
            }
            return ListEntitiesPublisher.this.client.listEntities((ListEntitiesRequest)((Object)ListEntitiesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

