/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.ConnectionTypeBrief;
import software.amazon.awssdk.services.glue.model.ListConnectionTypesRequest;
import software.amazon.awssdk.services.glue.model.ListConnectionTypesResponse;

public class ListConnectionTypesPublisher
implements SdkPublisher<ListConnectionTypesResponse> {
    private final GlueAsyncClient client;
    private final ListConnectionTypesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListConnectionTypesPublisher(GlueAsyncClient client, ListConnectionTypesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListConnectionTypesPublisher(GlueAsyncClient client, ListConnectionTypesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListConnectionTypesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListConnectionTypesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ConnectionTypeBrief> connectionTypes() {
        return this.flatMapIterable(response -> response.connectionTypes());
    }

    private class ListConnectionTypesResponseFetcher
    implements AsyncPageFetcher<ListConnectionTypesResponse> {
        private ListConnectionTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListConnectionTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListConnectionTypesResponse> nextPage(ListConnectionTypesResponse previousPage) {
            if (previousPage == null) {
                return ListConnectionTypesPublisher.this.client.listConnectionTypes(ListConnectionTypesPublisher.this.firstRequest);
            }
            return ListConnectionTypesPublisher.this.client.listConnectionTypes((ListConnectionTypesRequest)((Object)ListConnectionTypesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

