/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DDBELTCatalogAdditionalOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DDBELTCatalogAdditionalOptions> {
    private static final SdkField<String> DYNAMODB_EXPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DynamodbExport").getter(DDBELTCatalogAdditionalOptions.getter(DDBELTCatalogAdditionalOptions::dynamodbExport)).setter(DDBELTCatalogAdditionalOptions.setter(Builder::dynamodbExport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamodbExport").build()}).build();
    private static final SdkField<Boolean> DYNAMODB_UNNEST_DDB_JSON_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DynamodbUnnestDDBJson").getter(DDBELTCatalogAdditionalOptions.getter(DDBELTCatalogAdditionalOptions::dynamodbUnnestDDBJson)).setter(DDBELTCatalogAdditionalOptions.setter(Builder::dynamodbUnnestDDBJson)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamodbUnnestDDBJson").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DYNAMODB_EXPORT_FIELD, DYNAMODB_UNNEST_DDB_JSON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DDBELTCatalogAdditionalOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dynamodbExport;
    private final Boolean dynamodbUnnestDDBJson;

    private DDBELTCatalogAdditionalOptions(BuilderImpl builder) {
        this.dynamodbExport = builder.dynamodbExport;
        this.dynamodbUnnestDDBJson = builder.dynamodbUnnestDDBJson;
    }

    public final String dynamodbExport() {
        return this.dynamodbExport;
    }

    public final Boolean dynamodbUnnestDDBJson() {
        return this.dynamodbUnnestDDBJson;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamodbExport());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamodbUnnestDDBJson());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DDBELTCatalogAdditionalOptions)) {
            return false;
        }
        DDBELTCatalogAdditionalOptions other = (DDBELTCatalogAdditionalOptions)obj;
        return Objects.equals(this.dynamodbExport(), other.dynamodbExport()) && Objects.equals(this.dynamodbUnnestDDBJson(), other.dynamodbUnnestDDBJson());
    }

    public final String toString() {
        return ToString.builder((String)"DDBELTCatalogAdditionalOptions").add("DynamodbExport", (Object)this.dynamodbExport()).add("DynamodbUnnestDDBJson", (Object)this.dynamodbUnnestDDBJson()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DynamodbExport": {
                return Optional.ofNullable(clazz.cast(this.dynamodbExport()));
            }
            case "DynamodbUnnestDDBJson": {
                return Optional.ofNullable(clazz.cast(this.dynamodbUnnestDDBJson()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DynamodbExport", DYNAMODB_EXPORT_FIELD);
        map.put("DynamodbUnnestDDBJson", DYNAMODB_UNNEST_DDB_JSON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DDBELTCatalogAdditionalOptions, T> g) {
        return obj -> g.apply((DDBELTCatalogAdditionalOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dynamodbExport;
        private Boolean dynamodbUnnestDDBJson;

        private BuilderImpl() {
        }

        private BuilderImpl(DDBELTCatalogAdditionalOptions model) {
            this.dynamodbExport(model.dynamodbExport);
            this.dynamodbUnnestDDBJson(model.dynamodbUnnestDDBJson);
        }

        public final String getDynamodbExport() {
            return this.dynamodbExport;
        }

        public final void setDynamodbExport(String dynamodbExport) {
            this.dynamodbExport = dynamodbExport;
        }

        @Override
        public final Builder dynamodbExport(String dynamodbExport) {
            this.dynamodbExport = dynamodbExport;
            return this;
        }

        public final Boolean getDynamodbUnnestDDBJson() {
            return this.dynamodbUnnestDDBJson;
        }

        public final void setDynamodbUnnestDDBJson(Boolean dynamodbUnnestDDBJson) {
            this.dynamodbUnnestDDBJson = dynamodbUnnestDDBJson;
        }

        @Override
        public final Builder dynamodbUnnestDDBJson(Boolean dynamodbUnnestDDBJson) {
            this.dynamodbUnnestDDBJson = dynamodbUnnestDDBJson;
            return this;
        }

        public DDBELTCatalogAdditionalOptions build() {
            return new DDBELTCatalogAdditionalOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DDBELTCatalogAdditionalOptions> {
        public Builder dynamodbExport(String var1);

        public Builder dynamodbUnnestDDBJson(Boolean var1);
    }
}

