/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.MaterializedViewRefreshState;
import software.amazon.awssdk.services.glue.model.MaterializedViewRefreshType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MaterializedViewRefreshTaskRun
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MaterializedViewRefreshTaskRun> {
    private static final SdkField<String> CUSTOMER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerId").getter(MaterializedViewRefreshTaskRun.getter(MaterializedViewRefreshTaskRun::customerId)).setter(MaterializedViewRefreshTaskRun.setter(Builder::customerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerId").build()}).build();
    private static final SdkField<String> MATERIALIZED_VIEW_REFRESH_TASK_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaterializedViewRefreshTaskRunId").getter(MaterializedViewRefreshTaskRun.getter(MaterializedViewRefreshTaskRun::materializedViewRefreshTaskRunId)).setter(MaterializedViewRefreshTaskRun.setter(Builder::materializedViewRefreshTaskRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaterializedViewRefreshTaskRunId").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(MaterializedViewRefreshTaskRun.getter(MaterializedViewRefreshTaskRun::databaseName)).setter(MaterializedViewRefreshTaskRun.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(MaterializedViewRefreshTaskRun.getter(MaterializedViewRefreshTaskRun::tableName)).setter(MaterializedViewRefreshTaskRun.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogId").getter(MaterializedViewRefreshTaskRun.getter(MaterializedViewRefreshTaskRun::catalogId)).setter(MaterializedViewRefreshTaskRun.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(MaterializedViewRefreshTaskRun.getter(MaterializedViewRefreshTaskRun::role)).setter(MaterializedViewRefreshTaskRun.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(MaterializedViewRefreshTaskRun.getter(MaterializedViewRefreshTaskRun::statusAsString)).setter(MaterializedViewRefreshTaskRun.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(MaterializedViewRefreshTaskRun.getter(MaterializedViewRefreshTaskRun::creationTime)).setter(MaterializedViewRefreshTaskRun.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdated").getter(MaterializedViewRefreshTaskRun.getter(MaterializedViewRefreshTaskRun::lastUpdated)).setter(MaterializedViewRefreshTaskRun.setter(Builder::lastUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdated").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(MaterializedViewRefreshTaskRun.getter(MaterializedViewRefreshTaskRun::startTime)).setter(MaterializedViewRefreshTaskRun.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(MaterializedViewRefreshTaskRun.getter(MaterializedViewRefreshTaskRun::endTime)).setter(MaterializedViewRefreshTaskRun.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(MaterializedViewRefreshTaskRun.getter(MaterializedViewRefreshTaskRun::errorMessage)).setter(MaterializedViewRefreshTaskRun.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<Double> DPU_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("DPUSeconds").getter(MaterializedViewRefreshTaskRun.getter(MaterializedViewRefreshTaskRun::dpuSeconds)).setter(MaterializedViewRefreshTaskRun.setter(Builder::dpuSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DPUSeconds").build()}).build();
    private static final SdkField<String> REFRESH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RefreshType").getter(MaterializedViewRefreshTaskRun.getter(MaterializedViewRefreshTaskRun::refreshTypeAsString)).setter(MaterializedViewRefreshTaskRun.setter(Builder::refreshType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshType").build()}).build();
    private static final SdkField<Long> PROCESSED_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ProcessedBytes").getter(MaterializedViewRefreshTaskRun.getter(MaterializedViewRefreshTaskRun::processedBytes)).setter(MaterializedViewRefreshTaskRun.setter(Builder::processedBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessedBytes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_ID_FIELD, MATERIALIZED_VIEW_REFRESH_TASK_RUN_ID_FIELD, DATABASE_NAME_FIELD, TABLE_NAME_FIELD, CATALOG_ID_FIELD, ROLE_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_FIELD, START_TIME_FIELD, END_TIME_FIELD, ERROR_MESSAGE_FIELD, DPU_SECONDS_FIELD, REFRESH_TYPE_FIELD, PROCESSED_BYTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MaterializedViewRefreshTaskRun.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String customerId;
    private final String materializedViewRefreshTaskRunId;
    private final String databaseName;
    private final String tableName;
    private final String catalogId;
    private final String role;
    private final String status;
    private final Instant creationTime;
    private final Instant lastUpdated;
    private final Instant startTime;
    private final Instant endTime;
    private final String errorMessage;
    private final Double dpuSeconds;
    private final String refreshType;
    private final Long processedBytes;

    private MaterializedViewRefreshTaskRun(BuilderImpl builder) {
        this.customerId = builder.customerId;
        this.materializedViewRefreshTaskRunId = builder.materializedViewRefreshTaskRunId;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.catalogId = builder.catalogId;
        this.role = builder.role;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastUpdated = builder.lastUpdated;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.errorMessage = builder.errorMessage;
        this.dpuSeconds = builder.dpuSeconds;
        this.refreshType = builder.refreshType;
        this.processedBytes = builder.processedBytes;
    }

    public final String customerId() {
        return this.customerId;
    }

    public final String materializedViewRefreshTaskRunId() {
        return this.materializedViewRefreshTaskRunId;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final String role() {
        return this.role;
    }

    public final MaterializedViewRefreshState status() {
        return MaterializedViewRefreshState.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastUpdated() {
        return this.lastUpdated;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final Double dpuSeconds() {
        return this.dpuSeconds;
    }

    public final MaterializedViewRefreshType refreshType() {
        return MaterializedViewRefreshType.fromValue(this.refreshType);
    }

    public final String refreshTypeAsString() {
        return this.refreshType;
    }

    public final Long processedBytes() {
        return this.processedBytes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.customerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.materializedViewRefreshTaskRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.dpuSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.processedBytes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaterializedViewRefreshTaskRun)) {
            return false;
        }
        MaterializedViewRefreshTaskRun other = (MaterializedViewRefreshTaskRun)obj;
        return Objects.equals(this.customerId(), other.customerId()) && Objects.equals(this.materializedViewRefreshTaskRunId(), other.materializedViewRefreshTaskRunId()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdated(), other.lastUpdated()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.dpuSeconds(), other.dpuSeconds()) && Objects.equals(this.refreshTypeAsString(), other.refreshTypeAsString()) && Objects.equals(this.processedBytes(), other.processedBytes());
    }

    public final String toString() {
        return ToString.builder((String)"MaterializedViewRefreshTaskRun").add("CustomerId", (Object)this.customerId()).add("MaterializedViewRefreshTaskRunId", (Object)this.materializedViewRefreshTaskRunId()).add("DatabaseName", (Object)this.databaseName()).add("TableName", (Object)this.tableName()).add("CatalogId", (Object)this.catalogId()).add("Role", (Object)this.role()).add("Status", (Object)this.statusAsString()).add("CreationTime", (Object)this.creationTime()).add("LastUpdated", (Object)this.lastUpdated()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("ErrorMessage", (Object)this.errorMessage()).add("DPUSeconds", (Object)this.dpuSeconds()).add("RefreshType", (Object)this.refreshTypeAsString()).add("ProcessedBytes", (Object)this.processedBytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomerId": {
                return Optional.ofNullable(clazz.cast(this.customerId()));
            }
            case "MaterializedViewRefreshTaskRunId": {
                return Optional.ofNullable(clazz.cast(this.materializedViewRefreshTaskRunId()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastUpdated": {
                return Optional.ofNullable(clazz.cast(this.lastUpdated()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "DPUSeconds": {
                return Optional.ofNullable(clazz.cast(this.dpuSeconds()));
            }
            case "RefreshType": {
                return Optional.ofNullable(clazz.cast(this.refreshTypeAsString()));
            }
            case "ProcessedBytes": {
                return Optional.ofNullable(clazz.cast(this.processedBytes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CustomerId", CUSTOMER_ID_FIELD);
        map.put("MaterializedViewRefreshTaskRunId", MATERIALIZED_VIEW_REFRESH_TASK_RUN_ID_FIELD);
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("TableName", TABLE_NAME_FIELD);
        map.put("CatalogId", CATALOG_ID_FIELD);
        map.put("Role", ROLE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastUpdated", LAST_UPDATED_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        map.put("DPUSeconds", DPU_SECONDS_FIELD);
        map.put("RefreshType", REFRESH_TYPE_FIELD);
        map.put("ProcessedBytes", PROCESSED_BYTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MaterializedViewRefreshTaskRun, T> g) {
        return obj -> g.apply((MaterializedViewRefreshTaskRun)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String customerId;
        private String materializedViewRefreshTaskRunId;
        private String databaseName;
        private String tableName;
        private String catalogId;
        private String role;
        private String status;
        private Instant creationTime;
        private Instant lastUpdated;
        private Instant startTime;
        private Instant endTime;
        private String errorMessage;
        private Double dpuSeconds;
        private String refreshType;
        private Long processedBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(MaterializedViewRefreshTaskRun model) {
            this.customerId(model.customerId);
            this.materializedViewRefreshTaskRunId(model.materializedViewRefreshTaskRunId);
            this.databaseName(model.databaseName);
            this.tableName(model.tableName);
            this.catalogId(model.catalogId);
            this.role(model.role);
            this.status(model.status);
            this.creationTime(model.creationTime);
            this.lastUpdated(model.lastUpdated);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.errorMessage(model.errorMessage);
            this.dpuSeconds(model.dpuSeconds);
            this.refreshType(model.refreshType);
            this.processedBytes(model.processedBytes);
        }

        public final String getCustomerId() {
            return this.customerId;
        }

        public final void setCustomerId(String customerId) {
            this.customerId = customerId;
        }

        @Override
        public final Builder customerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public final String getMaterializedViewRefreshTaskRunId() {
            return this.materializedViewRefreshTaskRunId;
        }

        public final void setMaterializedViewRefreshTaskRunId(String materializedViewRefreshTaskRunId) {
            this.materializedViewRefreshTaskRunId = materializedViewRefreshTaskRunId;
        }

        @Override
        public final Builder materializedViewRefreshTaskRunId(String materializedViewRefreshTaskRunId) {
            this.materializedViewRefreshTaskRunId = materializedViewRefreshTaskRunId;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MaterializedViewRefreshState status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdated() {
            return this.lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final Double getDpuSeconds() {
            return this.dpuSeconds;
        }

        public final void setDpuSeconds(Double dpuSeconds) {
            this.dpuSeconds = dpuSeconds;
        }

        @Override
        public final Builder dpuSeconds(Double dpuSeconds) {
            this.dpuSeconds = dpuSeconds;
            return this;
        }

        public final String getRefreshType() {
            return this.refreshType;
        }

        public final void setRefreshType(String refreshType) {
            this.refreshType = refreshType;
        }

        @Override
        public final Builder refreshType(String refreshType) {
            this.refreshType = refreshType;
            return this;
        }

        @Override
        public final Builder refreshType(MaterializedViewRefreshType refreshType) {
            this.refreshType(refreshType == null ? null : refreshType.toString());
            return this;
        }

        public final Long getProcessedBytes() {
            return this.processedBytes;
        }

        public final void setProcessedBytes(Long processedBytes) {
            this.processedBytes = processedBytes;
        }

        @Override
        public final Builder processedBytes(Long processedBytes) {
            this.processedBytes = processedBytes;
            return this;
        }

        public MaterializedViewRefreshTaskRun build() {
            return new MaterializedViewRefreshTaskRun(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MaterializedViewRefreshTaskRun> {
        public Builder customerId(String var1);

        public Builder materializedViewRefreshTaskRunId(String var1);

        public Builder databaseName(String var1);

        public Builder tableName(String var1);

        public Builder catalogId(String var1);

        public Builder role(String var1);

        public Builder status(String var1);

        public Builder status(MaterializedViewRefreshState var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdated(Instant var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder errorMessage(String var1);

        public Builder dpuSeconds(Double var1);

        public Builder refreshType(String var1);

        public Builder refreshType(MaterializedViewRefreshType var1);

        public Builder processedBytes(Long var1);
    }
}

