/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.GetJobRunsRequest;
import software.amazon.awssdk.services.glue.model.GetJobRunsResponse;
import software.amazon.awssdk.services.glue.model.JobRun;

public class GetJobRunsIterable
implements SdkIterable<GetJobRunsResponse> {
    private final GlueClient client;
    private final GetJobRunsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetJobRunsIterable(GlueClient client, GetJobRunsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetJobRunsResponseFetcher();
    }

    public Iterator<GetJobRunsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<JobRun> jobRuns() {
        Function<GetJobRunsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobRuns() != null) {
                return response.jobRuns().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetJobRunsResponseFetcher
    implements SyncPageFetcher<GetJobRunsResponse> {
        private GetJobRunsResponseFetcher() {
        }

        public boolean hasNextPage(GetJobRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetJobRunsResponse nextPage(GetJobRunsResponse previousPage) {
            if (previousPage == null) {
                return GetJobRunsIterable.this.client.getJobRuns(GetJobRunsIterable.this.firstRequest);
            }
            return GetJobRunsIterable.this.client.getJobRuns((GetJobRunsRequest)((Object)GetJobRunsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

