/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RunMetrics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RunMetrics> {
    private static final SdkField<String> NUMBER_OF_BYTES_COMPACTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NumberOfBytesCompacted").getter(RunMetrics.getter(RunMetrics::numberOfBytesCompacted)).setter(RunMetrics.setter(Builder::numberOfBytesCompacted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfBytesCompacted").build()}).build();
    private static final SdkField<String> NUMBER_OF_FILES_COMPACTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NumberOfFilesCompacted").getter(RunMetrics.getter(RunMetrics::numberOfFilesCompacted)).setter(RunMetrics.setter(Builder::numberOfFilesCompacted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfFilesCompacted").build()}).build();
    private static final SdkField<String> NUMBER_OF_DPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NumberOfDpus").getter(RunMetrics.getter(RunMetrics::numberOfDpus)).setter(RunMetrics.setter(Builder::numberOfDpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfDpus").build()}).build();
    private static final SdkField<String> JOB_DURATION_IN_HOUR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobDurationInHour").getter(RunMetrics.getter(RunMetrics::jobDurationInHour)).setter(RunMetrics.setter(Builder::jobDurationInHour)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDurationInHour").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_OF_BYTES_COMPACTED_FIELD, NUMBER_OF_FILES_COMPACTED_FIELD, NUMBER_OF_DPUS_FIELD, JOB_DURATION_IN_HOUR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RunMetrics.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String numberOfBytesCompacted;
    private final String numberOfFilesCompacted;
    private final String numberOfDpus;
    private final String jobDurationInHour;

    private RunMetrics(BuilderImpl builder) {
        this.numberOfBytesCompacted = builder.numberOfBytesCompacted;
        this.numberOfFilesCompacted = builder.numberOfFilesCompacted;
        this.numberOfDpus = builder.numberOfDpus;
        this.jobDurationInHour = builder.jobDurationInHour;
    }

    public final String numberOfBytesCompacted() {
        return this.numberOfBytesCompacted;
    }

    public final String numberOfFilesCompacted() {
        return this.numberOfFilesCompacted;
    }

    public final String numberOfDpus() {
        return this.numberOfDpus;
    }

    public final String jobDurationInHour() {
        return this.jobDurationInHour;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfBytesCompacted());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfFilesCompacted());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfDpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDurationInHour());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunMetrics)) {
            return false;
        }
        RunMetrics other = (RunMetrics)obj;
        return Objects.equals(this.numberOfBytesCompacted(), other.numberOfBytesCompacted()) && Objects.equals(this.numberOfFilesCompacted(), other.numberOfFilesCompacted()) && Objects.equals(this.numberOfDpus(), other.numberOfDpus()) && Objects.equals(this.jobDurationInHour(), other.jobDurationInHour());
    }

    public final String toString() {
        return ToString.builder((String)"RunMetrics").add("NumberOfBytesCompacted", (Object)this.numberOfBytesCompacted()).add("NumberOfFilesCompacted", (Object)this.numberOfFilesCompacted()).add("NumberOfDpus", (Object)this.numberOfDpus()).add("JobDurationInHour", (Object)this.jobDurationInHour()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NumberOfBytesCompacted": {
                return Optional.ofNullable(clazz.cast(this.numberOfBytesCompacted()));
            }
            case "NumberOfFilesCompacted": {
                return Optional.ofNullable(clazz.cast(this.numberOfFilesCompacted()));
            }
            case "NumberOfDpus": {
                return Optional.ofNullable(clazz.cast(this.numberOfDpus()));
            }
            case "JobDurationInHour": {
                return Optional.ofNullable(clazz.cast(this.jobDurationInHour()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("NumberOfBytesCompacted", NUMBER_OF_BYTES_COMPACTED_FIELD);
        map.put("NumberOfFilesCompacted", NUMBER_OF_FILES_COMPACTED_FIELD);
        map.put("NumberOfDpus", NUMBER_OF_DPUS_FIELD);
        map.put("JobDurationInHour", JOB_DURATION_IN_HOUR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RunMetrics, T> g) {
        return obj -> g.apply((RunMetrics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String numberOfBytesCompacted;
        private String numberOfFilesCompacted;
        private String numberOfDpus;
        private String jobDurationInHour;

        private BuilderImpl() {
        }

        private BuilderImpl(RunMetrics model) {
            this.numberOfBytesCompacted(model.numberOfBytesCompacted);
            this.numberOfFilesCompacted(model.numberOfFilesCompacted);
            this.numberOfDpus(model.numberOfDpus);
            this.jobDurationInHour(model.jobDurationInHour);
        }

        public final String getNumberOfBytesCompacted() {
            return this.numberOfBytesCompacted;
        }

        public final void setNumberOfBytesCompacted(String numberOfBytesCompacted) {
            this.numberOfBytesCompacted = numberOfBytesCompacted;
        }

        @Override
        public final Builder numberOfBytesCompacted(String numberOfBytesCompacted) {
            this.numberOfBytesCompacted = numberOfBytesCompacted;
            return this;
        }

        public final String getNumberOfFilesCompacted() {
            return this.numberOfFilesCompacted;
        }

        public final void setNumberOfFilesCompacted(String numberOfFilesCompacted) {
            this.numberOfFilesCompacted = numberOfFilesCompacted;
        }

        @Override
        public final Builder numberOfFilesCompacted(String numberOfFilesCompacted) {
            this.numberOfFilesCompacted = numberOfFilesCompacted;
            return this;
        }

        public final String getNumberOfDpus() {
            return this.numberOfDpus;
        }

        public final void setNumberOfDpus(String numberOfDpus) {
            this.numberOfDpus = numberOfDpus;
        }

        @Override
        public final Builder numberOfDpus(String numberOfDpus) {
            this.numberOfDpus = numberOfDpus;
            return this;
        }

        public final String getJobDurationInHour() {
            return this.jobDurationInHour;
        }

        public final void setJobDurationInHour(String jobDurationInHour) {
            this.jobDurationInHour = jobDurationInHour;
        }

        @Override
        public final Builder jobDurationInHour(String jobDurationInHour) {
            this.jobDurationInHour = jobDurationInHour;
            return this;
        }

        public RunMetrics build() {
            return new RunMetrics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RunMetrics> {
        public Builder numberOfBytesCompacted(String var1);

        public Builder numberOfFilesCompacted(String var1);

        public Builder numberOfDpus(String var1);

        public Builder jobDurationInHour(String var1);
    }
}

