/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.ListMaterializedViewRefreshTaskRunsRequest;
import software.amazon.awssdk.services.glue.model.ListMaterializedViewRefreshTaskRunsResponse;
import software.amazon.awssdk.services.glue.model.MaterializedViewRefreshTaskRun;

public class ListMaterializedViewRefreshTaskRunsPublisher
implements SdkPublisher<ListMaterializedViewRefreshTaskRunsResponse> {
    private final GlueAsyncClient client;
    private final ListMaterializedViewRefreshTaskRunsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMaterializedViewRefreshTaskRunsPublisher(GlueAsyncClient client, ListMaterializedViewRefreshTaskRunsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMaterializedViewRefreshTaskRunsPublisher(GlueAsyncClient client, ListMaterializedViewRefreshTaskRunsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMaterializedViewRefreshTaskRunsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMaterializedViewRefreshTaskRunsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MaterializedViewRefreshTaskRun> materializedViewRefreshTaskRuns() {
        return this.flatMapIterable(response -> response.materializedViewRefreshTaskRuns());
    }

    private class ListMaterializedViewRefreshTaskRunsResponseFetcher
    implements AsyncPageFetcher<ListMaterializedViewRefreshTaskRunsResponse> {
        private ListMaterializedViewRefreshTaskRunsResponseFetcher() {
        }

        public boolean hasNextPage(ListMaterializedViewRefreshTaskRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMaterializedViewRefreshTaskRunsResponse> nextPage(ListMaterializedViewRefreshTaskRunsResponse previousPage) {
            if (previousPage == null) {
                return ListMaterializedViewRefreshTaskRunsPublisher.this.client.listMaterializedViewRefreshTaskRuns(ListMaterializedViewRefreshTaskRunsPublisher.this.firstRequest);
            }
            return ListMaterializedViewRefreshTaskRunsPublisher.this.client.listMaterializedViewRefreshTaskRuns((ListMaterializedViewRefreshTaskRunsRequest)((Object)ListMaterializedViewRefreshTaskRunsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

