/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.OneInputCopier;
import software.amazon.awssdk.services.glue.model.UpsertRedshiftTargetOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RedshiftTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RedshiftTarget> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(RedshiftTarget.getter(RedshiftTarget::name)).setter(RedshiftTarget.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Inputs").getter(RedshiftTarget.getter(RedshiftTarget::inputs)).setter(RedshiftTarget.setter(Builder::inputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Database").getter(RedshiftTarget.getter(RedshiftTarget::database)).setter(RedshiftTarget.setter(Builder::database)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()}).build();
    private static final SdkField<String> TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Table").getter(RedshiftTarget.getter(RedshiftTarget::table)).setter(RedshiftTarget.setter(Builder::table)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()}).build();
    private static final SdkField<String> REDSHIFT_TMP_DIR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RedshiftTmpDir").getter(RedshiftTarget.getter(RedshiftTarget::redshiftTmpDir)).setter(RedshiftTarget.setter(Builder::redshiftTmpDir)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftTmpDir").build()}).build();
    private static final SdkField<String> TMP_DIR_IAM_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TmpDirIAMRole").getter(RedshiftTarget.getter(RedshiftTarget::tmpDirIAMRole)).setter(RedshiftTarget.setter(Builder::tmpDirIAMRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TmpDirIAMRole").build()}).build();
    private static final SdkField<UpsertRedshiftTargetOptions> UPSERT_REDSHIFT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UpsertRedshiftOptions").getter(RedshiftTarget.getter(RedshiftTarget::upsertRedshiftOptions)).setter(RedshiftTarget.setter(Builder::upsertRedshiftOptions)).constructor(UpsertRedshiftTargetOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpsertRedshiftOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INPUTS_FIELD, DATABASE_FIELD, TABLE_FIELD, REDSHIFT_TMP_DIR_FIELD, TMP_DIR_IAM_ROLE_FIELD, UPSERT_REDSHIFT_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RedshiftTarget.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<String> inputs;
    private final String database;
    private final String table;
    private final String redshiftTmpDir;
    private final String tmpDirIAMRole;
    private final UpsertRedshiftTargetOptions upsertRedshiftOptions;

    private RedshiftTarget(BuilderImpl builder) {
        this.name = builder.name;
        this.inputs = builder.inputs;
        this.database = builder.database;
        this.table = builder.table;
        this.redshiftTmpDir = builder.redshiftTmpDir;
        this.tmpDirIAMRole = builder.tmpDirIAMRole;
        this.upsertRedshiftOptions = builder.upsertRedshiftOptions;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasInputs() {
        return this.inputs != null && !(this.inputs instanceof SdkAutoConstructList);
    }

    public final List<String> inputs() {
        return this.inputs;
    }

    public final String database() {
        return this.database;
    }

    public final String table() {
        return this.table;
    }

    public final String redshiftTmpDir() {
        return this.redshiftTmpDir;
    }

    public final String tmpDirIAMRole() {
        return this.tmpDirIAMRole;
    }

    public final UpsertRedshiftTargetOptions upsertRedshiftOptions() {
        return this.upsertRedshiftOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputs() ? this.inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.table());
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftTmpDir());
        hashCode = 31 * hashCode + Objects.hashCode(this.tmpDirIAMRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.upsertRedshiftOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftTarget)) {
            return false;
        }
        RedshiftTarget other = (RedshiftTarget)obj;
        return Objects.equals(this.name(), other.name()) && this.hasInputs() == other.hasInputs() && Objects.equals(this.inputs(), other.inputs()) && Objects.equals(this.database(), other.database()) && Objects.equals(this.table(), other.table()) && Objects.equals(this.redshiftTmpDir(), other.redshiftTmpDir()) && Objects.equals(this.tmpDirIAMRole(), other.tmpDirIAMRole()) && Objects.equals(this.upsertRedshiftOptions(), other.upsertRedshiftOptions());
    }

    public final String toString() {
        return ToString.builder((String)"RedshiftTarget").add("Name", (Object)this.name()).add("Inputs", this.hasInputs() ? this.inputs() : null).add("Database", (Object)this.database()).add("Table", (Object)this.table()).add("RedshiftTmpDir", (Object)this.redshiftTmpDir()).add("TmpDirIAMRole", (Object)this.tmpDirIAMRole()).add("UpsertRedshiftOptions", (Object)this.upsertRedshiftOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Inputs": {
                return Optional.ofNullable(clazz.cast(this.inputs()));
            }
            case "Database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
            case "Table": {
                return Optional.ofNullable(clazz.cast(this.table()));
            }
            case "RedshiftTmpDir": {
                return Optional.ofNullable(clazz.cast(this.redshiftTmpDir()));
            }
            case "TmpDirIAMRole": {
                return Optional.ofNullable(clazz.cast(this.tmpDirIAMRole()));
            }
            case "UpsertRedshiftOptions": {
                return Optional.ofNullable(clazz.cast(this.upsertRedshiftOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Inputs", INPUTS_FIELD);
        map.put("Database", DATABASE_FIELD);
        map.put("Table", TABLE_FIELD);
        map.put("RedshiftTmpDir", REDSHIFT_TMP_DIR_FIELD);
        map.put("TmpDirIAMRole", TMP_DIR_IAM_ROLE_FIELD);
        map.put("UpsertRedshiftOptions", UPSERT_REDSHIFT_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RedshiftTarget, T> g) {
        return obj -> g.apply((RedshiftTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();
        private String database;
        private String table;
        private String redshiftTmpDir;
        private String tmpDirIAMRole;
        private UpsertRedshiftTargetOptions upsertRedshiftOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftTarget model) {
            this.name(model.name);
            this.inputs(model.inputs);
            this.database(model.database);
            this.table(model.table);
            this.redshiftTmpDir(model.redshiftTmpDir);
            this.tmpDirIAMRole(model.tmpDirIAMRole);
            this.upsertRedshiftOptions(model.upsertRedshiftOptions);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getInputs() {
            if (this.inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String ... inputs) {
            this.inputs(Arrays.asList(inputs));
            return this;
        }

        public final String getDatabase() {
            return this.database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getTable() {
            return this.table;
        }

        public final void setTable(String table) {
            this.table = table;
        }

        @Override
        public final Builder table(String table) {
            this.table = table;
            return this;
        }

        public final String getRedshiftTmpDir() {
            return this.redshiftTmpDir;
        }

        public final void setRedshiftTmpDir(String redshiftTmpDir) {
            this.redshiftTmpDir = redshiftTmpDir;
        }

        @Override
        public final Builder redshiftTmpDir(String redshiftTmpDir) {
            this.redshiftTmpDir = redshiftTmpDir;
            return this;
        }

        public final String getTmpDirIAMRole() {
            return this.tmpDirIAMRole;
        }

        public final void setTmpDirIAMRole(String tmpDirIAMRole) {
            this.tmpDirIAMRole = tmpDirIAMRole;
        }

        @Override
        public final Builder tmpDirIAMRole(String tmpDirIAMRole) {
            this.tmpDirIAMRole = tmpDirIAMRole;
            return this;
        }

        public final UpsertRedshiftTargetOptions.Builder getUpsertRedshiftOptions() {
            return this.upsertRedshiftOptions != null ? this.upsertRedshiftOptions.toBuilder() : null;
        }

        public final void setUpsertRedshiftOptions(UpsertRedshiftTargetOptions.BuilderImpl upsertRedshiftOptions) {
            this.upsertRedshiftOptions = upsertRedshiftOptions != null ? upsertRedshiftOptions.build() : null;
        }

        @Override
        public final Builder upsertRedshiftOptions(UpsertRedshiftTargetOptions upsertRedshiftOptions) {
            this.upsertRedshiftOptions = upsertRedshiftOptions;
            return this;
        }

        public RedshiftTarget build() {
            return new RedshiftTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RedshiftTarget> {
        public Builder name(String var1);

        public Builder inputs(Collection<String> var1);

        public Builder inputs(String ... var1);

        public Builder database(String var1);

        public Builder table(String var1);

        public Builder redshiftTmpDir(String var1);

        public Builder tmpDirIAMRole(String var1);

        public Builder upsertRedshiftOptions(UpsertRedshiftTargetOptions var1);

        default public Builder upsertRedshiftOptions(Consumer<UpsertRedshiftTargetOptions.Builder> upsertRedshiftOptions) {
            return this.upsertRedshiftOptions((UpsertRedshiftTargetOptions)((UpsertRedshiftTargetOptions.Builder)UpsertRedshiftTargetOptions.builder().applyMutation(upsertRedshiftOptions)).build());
        }
    }
}

