/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.model.GetConnectionsRequest;
import software.amazon.awssdk.services.glue.model.GetConnectionsResponse;

public class GetConnectionsPublisher
implements SdkPublisher<GetConnectionsResponse> {
    private final GlueAsyncClient client;
    private final GetConnectionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetConnectionsPublisher(GlueAsyncClient client, GetConnectionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetConnectionsPublisher(GlueAsyncClient client, GetConnectionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetConnectionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetConnectionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final GetConnectionsPublisher resume(GetConnectionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetConnectionsPublisher(this.client, (GetConnectionsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetConnectionsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super GetConnectionsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class GetConnectionsResponseFetcher
    implements AsyncPageFetcher<GetConnectionsResponse> {
        private GetConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(GetConnectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetConnectionsResponse> nextPage(GetConnectionsResponse previousPage) {
            if (previousPage == null) {
                return GetConnectionsPublisher.this.client.getConnections(GetConnectionsPublisher.this.firstRequest);
            }
            return GetConnectionsPublisher.this.client.getConnections((GetConnectionsRequest)((Object)GetConnectionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

