/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.ParametersMapCopier;
import software.amazon.awssdk.services.glue.model.StorageDescriptor;
import software.amazon.awssdk.services.glue.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PartitionInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PartitionInput> {
    private static final SdkField<List<String>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Values").getter(PartitionInput.getter(PartitionInput::values)).setter(PartitionInput.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_ACCESS_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastAccessTime").getter(PartitionInput.getter(PartitionInput::lastAccessTime)).setter(PartitionInput.setter(Builder::lastAccessTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAccessTime").build()}).build();
    private static final SdkField<StorageDescriptor> STORAGE_DESCRIPTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StorageDescriptor").getter(PartitionInput.getter(PartitionInput::storageDescriptor)).setter(PartitionInput.setter(Builder::storageDescriptor)).constructor(StorageDescriptor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageDescriptor").build()}).build();
    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Parameters").getter(PartitionInput.getter(PartitionInput::parameters)).setter(PartitionInput.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_ANALYZED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastAnalyzedTime").getter(PartitionInput.getter(PartitionInput::lastAnalyzedTime)).setter(PartitionInput.setter(Builder::lastAnalyzedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAnalyzedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUES_FIELD, LAST_ACCESS_TIME_FIELD, STORAGE_DESCRIPTOR_FIELD, PARAMETERS_FIELD, LAST_ANALYZED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PartitionInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> values;
    private final Instant lastAccessTime;
    private final StorageDescriptor storageDescriptor;
    private final Map<String, String> parameters;
    private final Instant lastAnalyzedTime;

    private PartitionInput(BuilderImpl builder) {
        this.values = builder.values;
        this.lastAccessTime = builder.lastAccessTime;
        this.storageDescriptor = builder.storageDescriptor;
        this.parameters = builder.parameters;
        this.lastAnalyzedTime = builder.lastAnalyzedTime;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<String> values() {
        return this.values;
    }

    public final Instant lastAccessTime() {
        return this.lastAccessTime;
    }

    public final StorageDescriptor storageDescriptor() {
        return this.storageDescriptor;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> parameters() {
        return this.parameters;
    }

    public final Instant lastAnalyzedTime() {
        return this.lastAnalyzedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAccessTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageDescriptor());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAnalyzedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartitionInput)) {
            return false;
        }
        PartitionInput other = (PartitionInput)obj;
        return this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values()) && Objects.equals(this.lastAccessTime(), other.lastAccessTime()) && Objects.equals(this.storageDescriptor(), other.storageDescriptor()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.lastAnalyzedTime(), other.lastAnalyzedTime());
    }

    public final String toString() {
        return ToString.builder((String)"PartitionInput").add("Values", this.hasValues() ? this.values() : null).add("LastAccessTime", (Object)this.lastAccessTime()).add("StorageDescriptor", (Object)this.storageDescriptor()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("LastAnalyzedTime", (Object)this.lastAnalyzedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
            case "LastAccessTime": {
                return Optional.ofNullable(clazz.cast(this.lastAccessTime()));
            }
            case "StorageDescriptor": {
                return Optional.ofNullable(clazz.cast(this.storageDescriptor()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "LastAnalyzedTime": {
                return Optional.ofNullable(clazz.cast(this.lastAnalyzedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Values", VALUES_FIELD);
        map.put("LastAccessTime", LAST_ACCESS_TIME_FIELD);
        map.put("StorageDescriptor", STORAGE_DESCRIPTOR_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("LastAnalyzedTime", LAST_ANALYZED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PartitionInput, T> g) {
        return obj -> g.apply((PartitionInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> values = DefaultSdkAutoConstructList.getInstance();
        private Instant lastAccessTime;
        private StorageDescriptor storageDescriptor;
        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();
        private Instant lastAnalyzedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(PartitionInput model) {
            this.values(model.values);
            this.lastAccessTime(model.lastAccessTime);
            this.storageDescriptor(model.storageDescriptor);
            this.parameters(model.parameters);
            this.lastAnalyzedTime(model.lastAnalyzedTime);
        }

        public final Collection<String> getValues() {
            if (this.values instanceof SdkAutoConstructList) {
                return null;
            }
            return this.values;
        }

        public final void setValues(Collection<String> values) {
            this.values = ValueStringListCopier.copy(values);
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = ValueStringListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public final Instant getLastAccessTime() {
            return this.lastAccessTime;
        }

        public final void setLastAccessTime(Instant lastAccessTime) {
            this.lastAccessTime = lastAccessTime;
        }

        @Override
        public final Builder lastAccessTime(Instant lastAccessTime) {
            this.lastAccessTime = lastAccessTime;
            return this;
        }

        public final StorageDescriptor.Builder getStorageDescriptor() {
            return this.storageDescriptor != null ? this.storageDescriptor.toBuilder() : null;
        }

        public final void setStorageDescriptor(StorageDescriptor.BuilderImpl storageDescriptor) {
            this.storageDescriptor = storageDescriptor != null ? storageDescriptor.build() : null;
        }

        @Override
        public final Builder storageDescriptor(StorageDescriptor storageDescriptor) {
            this.storageDescriptor = storageDescriptor;
            return this;
        }

        public final Map<String, String> getParameters() {
            if (this.parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public final Instant getLastAnalyzedTime() {
            return this.lastAnalyzedTime;
        }

        public final void setLastAnalyzedTime(Instant lastAnalyzedTime) {
            this.lastAnalyzedTime = lastAnalyzedTime;
        }

        @Override
        public final Builder lastAnalyzedTime(Instant lastAnalyzedTime) {
            this.lastAnalyzedTime = lastAnalyzedTime;
            return this;
        }

        public PartitionInput build() {
            return new PartitionInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PartitionInput> {
        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);

        public Builder lastAccessTime(Instant var1);

        public Builder storageDescriptor(StorageDescriptor var1);

        default public Builder storageDescriptor(Consumer<StorageDescriptor.Builder> storageDescriptor) {
            return this.storageDescriptor((StorageDescriptor)((StorageDescriptor.Builder)StorageDescriptor.builder().applyMutation(storageDescriptor)).build());
        }

        public Builder parameters(Map<String, String> var1);

        public Builder lastAnalyzedTime(Instant var1);
    }
}

