/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GroupFilters;
import software.amazon.awssdk.services.glue.model.GroupFiltersListCopier;
import software.amazon.awssdk.services.glue.model.OneInputCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Route
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Route> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Route.getter(Route::name)).setter(Route.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Inputs").getter(Route.getter(Route::inputs)).setter(Route.setter(Builder::inputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<GroupFilters>> GROUP_FILTERS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GroupFiltersList").getter(Route.getter(Route::groupFiltersList)).setter(Route.setter(Builder::groupFiltersList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupFiltersList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INPUTS_FIELD, GROUP_FILTERS_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Route.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<String> inputs;
    private final List<GroupFilters> groupFiltersList;

    private Route(BuilderImpl builder) {
        this.name = builder.name;
        this.inputs = builder.inputs;
        this.groupFiltersList = builder.groupFiltersList;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasInputs() {
        return this.inputs != null && !(this.inputs instanceof SdkAutoConstructList);
    }

    public final List<String> inputs() {
        return this.inputs;
    }

    public final boolean hasGroupFiltersList() {
        return this.groupFiltersList != null && !(this.groupFiltersList instanceof SdkAutoConstructList);
    }

    public final List<GroupFilters> groupFiltersList() {
        return this.groupFiltersList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputs() ? this.inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupFiltersList() ? this.groupFiltersList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Route)) {
            return false;
        }
        Route other = (Route)obj;
        return Objects.equals(this.name(), other.name()) && this.hasInputs() == other.hasInputs() && Objects.equals(this.inputs(), other.inputs()) && this.hasGroupFiltersList() == other.hasGroupFiltersList() && Objects.equals(this.groupFiltersList(), other.groupFiltersList());
    }

    public final String toString() {
        return ToString.builder((String)"Route").add("Name", (Object)this.name()).add("Inputs", this.hasInputs() ? this.inputs() : null).add("GroupFiltersList", this.hasGroupFiltersList() ? this.groupFiltersList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Inputs": {
                return Optional.ofNullable(clazz.cast(this.inputs()));
            }
            case "GroupFiltersList": {
                return Optional.ofNullable(clazz.cast(this.groupFiltersList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Inputs", INPUTS_FIELD);
        map.put("GroupFiltersList", GROUP_FILTERS_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Route, T> g) {
        return obj -> g.apply((Route)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();
        private List<GroupFilters> groupFiltersList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Route model) {
            this.name(model.name);
            this.inputs(model.inputs);
            this.groupFiltersList(model.groupFiltersList);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getInputs() {
            if (this.inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String ... inputs) {
            this.inputs(Arrays.asList(inputs));
            return this;
        }

        public final List<GroupFilters.Builder> getGroupFiltersList() {
            List<GroupFilters.Builder> result = GroupFiltersListCopier.copyToBuilder(this.groupFiltersList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupFiltersList(Collection<GroupFilters.BuilderImpl> groupFiltersList) {
            this.groupFiltersList = GroupFiltersListCopier.copyFromBuilder(groupFiltersList);
        }

        @Override
        public final Builder groupFiltersList(Collection<GroupFilters> groupFiltersList) {
            this.groupFiltersList = GroupFiltersListCopier.copy(groupFiltersList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupFiltersList(GroupFilters ... groupFiltersList) {
            this.groupFiltersList(Arrays.asList(groupFiltersList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupFiltersList(Consumer<GroupFilters.Builder> ... groupFiltersList) {
            this.groupFiltersList(Stream.of(groupFiltersList).map(c -> (GroupFilters)((GroupFilters.Builder)GroupFilters.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Route build() {
            return new Route(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Route> {
        public Builder name(String var1);

        public Builder inputs(Collection<String> var1);

        public Builder inputs(String ... var1);

        public Builder groupFiltersList(Collection<GroupFilters> var1);

        public Builder groupFiltersList(GroupFilters ... var1);

        public Builder groupFiltersList(Consumer<GroupFilters.Builder> ... var1);
    }
}

