/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OAuth2ClientApplication
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OAuth2ClientApplication> {
    private static final SdkField<String> USER_MANAGED_CLIENT_APPLICATION_CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserManagedClientApplicationClientId").getter(OAuth2ClientApplication.getter(OAuth2ClientApplication::userManagedClientApplicationClientId)).setter(OAuth2ClientApplication.setter(Builder::userManagedClientApplicationClientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserManagedClientApplicationClientId").build()}).build();
    private static final SdkField<String> AWS_MANAGED_CLIENT_APPLICATION_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AWSManagedClientApplicationReference").getter(OAuth2ClientApplication.getter(OAuth2ClientApplication::awsManagedClientApplicationReference)).setter(OAuth2ClientApplication.setter(Builder::awsManagedClientApplicationReference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AWSManagedClientApplicationReference").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_MANAGED_CLIENT_APPLICATION_CLIENT_ID_FIELD, AWS_MANAGED_CLIENT_APPLICATION_REFERENCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OAuth2ClientApplication.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String userManagedClientApplicationClientId;
    private final String awsManagedClientApplicationReference;

    private OAuth2ClientApplication(BuilderImpl builder) {
        this.userManagedClientApplicationClientId = builder.userManagedClientApplicationClientId;
        this.awsManagedClientApplicationReference = builder.awsManagedClientApplicationReference;
    }

    public final String userManagedClientApplicationClientId() {
        return this.userManagedClientApplicationClientId;
    }

    public final String awsManagedClientApplicationReference() {
        return this.awsManagedClientApplicationReference;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userManagedClientApplicationClientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsManagedClientApplicationReference());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OAuth2ClientApplication)) {
            return false;
        }
        OAuth2ClientApplication other = (OAuth2ClientApplication)obj;
        return Objects.equals(this.userManagedClientApplicationClientId(), other.userManagedClientApplicationClientId()) && Objects.equals(this.awsManagedClientApplicationReference(), other.awsManagedClientApplicationReference());
    }

    public final String toString() {
        return ToString.builder((String)"OAuth2ClientApplication").add("UserManagedClientApplicationClientId", (Object)this.userManagedClientApplicationClientId()).add("AWSManagedClientApplicationReference", (Object)this.awsManagedClientApplicationReference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserManagedClientApplicationClientId": {
                return Optional.ofNullable(clazz.cast(this.userManagedClientApplicationClientId()));
            }
            case "AWSManagedClientApplicationReference": {
                return Optional.ofNullable(clazz.cast(this.awsManagedClientApplicationReference()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("UserManagedClientApplicationClientId", USER_MANAGED_CLIENT_APPLICATION_CLIENT_ID_FIELD);
        map.put("AWSManagedClientApplicationReference", AWS_MANAGED_CLIENT_APPLICATION_REFERENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OAuth2ClientApplication, T> g) {
        return obj -> g.apply((OAuth2ClientApplication)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userManagedClientApplicationClientId;
        private String awsManagedClientApplicationReference;

        private BuilderImpl() {
        }

        private BuilderImpl(OAuth2ClientApplication model) {
            this.userManagedClientApplicationClientId(model.userManagedClientApplicationClientId);
            this.awsManagedClientApplicationReference(model.awsManagedClientApplicationReference);
        }

        public final String getUserManagedClientApplicationClientId() {
            return this.userManagedClientApplicationClientId;
        }

        public final void setUserManagedClientApplicationClientId(String userManagedClientApplicationClientId) {
            this.userManagedClientApplicationClientId = userManagedClientApplicationClientId;
        }

        @Override
        public final Builder userManagedClientApplicationClientId(String userManagedClientApplicationClientId) {
            this.userManagedClientApplicationClientId = userManagedClientApplicationClientId;
            return this;
        }

        public final String getAwsManagedClientApplicationReference() {
            return this.awsManagedClientApplicationReference;
        }

        public final void setAwsManagedClientApplicationReference(String awsManagedClientApplicationReference) {
            this.awsManagedClientApplicationReference = awsManagedClientApplicationReference;
        }

        @Override
        public final Builder awsManagedClientApplicationReference(String awsManagedClientApplicationReference) {
            this.awsManagedClientApplicationReference = awsManagedClientApplicationReference;
            return this;
        }

        public OAuth2ClientApplication build() {
            return new OAuth2ClientApplication(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OAuth2ClientApplication> {
        public Builder userManagedClientApplicationClientId(String var1);

        public Builder awsManagedClientApplicationReference(String var1);
    }
}

