/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details on the configuration of a table optimizer. You pass this configuration when creating or updating a
 * table optimizer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableOptimizerConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TableOptimizerConfiguration.Builder, TableOptimizerConfiguration> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(TableOptimizerConfiguration::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(TableOptimizerConfiguration::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<TableOptimizerVpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField
            .<TableOptimizerVpcConfiguration> builder(MarshallingType.SDK_POJO).memberName("vpcConfiguration")
            .getter(getter(TableOptimizerConfiguration::vpcConfiguration)).setter(setter(Builder::vpcConfiguration))
            .constructor(TableOptimizerVpcConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfiguration").build()).build();

    private static final SdkField<CompactionConfiguration> COMPACTION_CONFIGURATION_FIELD = SdkField
            .<CompactionConfiguration> builder(MarshallingType.SDK_POJO).memberName("compactionConfiguration")
            .getter(getter(TableOptimizerConfiguration::compactionConfiguration))
            .setter(setter(Builder::compactionConfiguration)).constructor(CompactionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compactionConfiguration").build())
            .build();

    private static final SdkField<RetentionConfiguration> RETENTION_CONFIGURATION_FIELD = SdkField
            .<RetentionConfiguration> builder(MarshallingType.SDK_POJO).memberName("retentionConfiguration")
            .getter(getter(TableOptimizerConfiguration::retentionConfiguration)).setter(setter(Builder::retentionConfiguration))
            .constructor(RetentionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionConfiguration").build())
            .build();

    private static final SdkField<OrphanFileDeletionConfiguration> ORPHAN_FILE_DELETION_CONFIGURATION_FIELD = SdkField
            .<OrphanFileDeletionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("orphanFileDeletionConfiguration")
            .getter(getter(TableOptimizerConfiguration::orphanFileDeletionConfiguration))
            .setter(setter(Builder::orphanFileDeletionConfiguration))
            .constructor(OrphanFileDeletionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orphanFileDeletionConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, ENABLED_FIELD,
            VPC_CONFIGURATION_FIELD, COMPACTION_CONFIGURATION_FIELD, RETENTION_CONFIGURATION_FIELD,
            ORPHAN_FILE_DELETION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String roleArn;

    private final Boolean enabled;

    private final TableOptimizerVpcConfiguration vpcConfiguration;

    private final CompactionConfiguration compactionConfiguration;

    private final RetentionConfiguration retentionConfiguration;

    private final OrphanFileDeletionConfiguration orphanFileDeletionConfiguration;

    private TableOptimizerConfiguration(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.enabled = builder.enabled;
        this.vpcConfiguration = builder.vpcConfiguration;
        this.compactionConfiguration = builder.compactionConfiguration;
        this.retentionConfiguration = builder.retentionConfiguration;
        this.orphanFileDeletionConfiguration = builder.orphanFileDeletionConfiguration;
    }

    /**
     * <p>
     * A role passed by the caller which gives the service permission to update the resources associated with the
     * optimizer on the caller's behalf.
     * </p>
     * 
     * @return A role passed by the caller which gives the service permission to update the resources associated with
     *         the optimizer on the caller's behalf.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Whether table optimization is enabled.
     * </p>
     * 
     * @return Whether table optimization is enabled.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * A <code>TableOptimizerVpcConfiguration</code> object representing the VPC configuration for a table optimizer.
     * </p>
     * <p>
     * This configuration is necessary to perform optimization on tables that are in a customer VPC.
     * </p>
     * 
     * @return A <code>TableOptimizerVpcConfiguration</code> object representing the VPC configuration for a table
     *         optimizer.</p>
     *         <p>
     *         This configuration is necessary to perform optimization on tables that are in a customer VPC.
     */
    public final TableOptimizerVpcConfiguration vpcConfiguration() {
        return vpcConfiguration;
    }

    /**
     * <p>
     * The configuration for a compaction optimizer. This configuration defines how data files in your table will be
     * compacted to improve query performance and reduce storage costs.
     * </p>
     * 
     * @return The configuration for a compaction optimizer. This configuration defines how data files in your table
     *         will be compacted to improve query performance and reduce storage costs.
     */
    public final CompactionConfiguration compactionConfiguration() {
        return compactionConfiguration;
    }

    /**
     * <p>
     * The configuration for a snapshot retention optimizer.
     * </p>
     * 
     * @return The configuration for a snapshot retention optimizer.
     */
    public final RetentionConfiguration retentionConfiguration() {
        return retentionConfiguration;
    }

    /**
     * <p>
     * The configuration for an orphan file deletion optimizer.
     * </p>
     * 
     * @return The configuration for an orphan file deletion optimizer.
     */
    public final OrphanFileDeletionConfiguration orphanFileDeletionConfiguration() {
        return orphanFileDeletionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(compactionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(retentionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(orphanFileDeletionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableOptimizerConfiguration)) {
            return false;
        }
        TableOptimizerConfiguration other = (TableOptimizerConfiguration) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(enabled(), other.enabled())
                && Objects.equals(vpcConfiguration(), other.vpcConfiguration())
                && Objects.equals(compactionConfiguration(), other.compactionConfiguration())
                && Objects.equals(retentionConfiguration(), other.retentionConfiguration())
                && Objects.equals(orphanFileDeletionConfiguration(), other.orphanFileDeletionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableOptimizerConfiguration").add("RoleArn", roleArn()).add("Enabled", enabled())
                .add("VpcConfiguration", vpcConfiguration()).add("CompactionConfiguration", compactionConfiguration())
                .add("RetentionConfiguration", retentionConfiguration())
                .add("OrphanFileDeletionConfiguration", orphanFileDeletionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "vpcConfiguration":
            return Optional.ofNullable(clazz.cast(vpcConfiguration()));
        case "compactionConfiguration":
            return Optional.ofNullable(clazz.cast(compactionConfiguration()));
        case "retentionConfiguration":
            return Optional.ofNullable(clazz.cast(retentionConfiguration()));
        case "orphanFileDeletionConfiguration":
            return Optional.ofNullable(clazz.cast(orphanFileDeletionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("enabled", ENABLED_FIELD);
        map.put("vpcConfiguration", VPC_CONFIGURATION_FIELD);
        map.put("compactionConfiguration", COMPACTION_CONFIGURATION_FIELD);
        map.put("retentionConfiguration", RETENTION_CONFIGURATION_FIELD);
        map.put("orphanFileDeletionConfiguration", ORPHAN_FILE_DELETION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TableOptimizerConfiguration, T> g) {
        return obj -> g.apply((TableOptimizerConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableOptimizerConfiguration> {
        /**
         * <p>
         * A role passed by the caller which gives the service permission to update the resources associated with the
         * optimizer on the caller's behalf.
         * </p>
         * 
         * @param roleArn
         *        A role passed by the caller which gives the service permission to update the resources associated with
         *        the optimizer on the caller's behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Whether table optimization is enabled.
         * </p>
         * 
         * @param enabled
         *        Whether table optimization is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * A <code>TableOptimizerVpcConfiguration</code> object representing the VPC configuration for a table
         * optimizer.
         * </p>
         * <p>
         * This configuration is necessary to perform optimization on tables that are in a customer VPC.
         * </p>
         * 
         * @param vpcConfiguration
         *        A <code>TableOptimizerVpcConfiguration</code> object representing the VPC configuration for a table
         *        optimizer.</p>
         *        <p>
         *        This configuration is necessary to perform optimization on tables that are in a customer VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfiguration(TableOptimizerVpcConfiguration vpcConfiguration);

        /**
         * <p>
         * A <code>TableOptimizerVpcConfiguration</code> object representing the VPC configuration for a table
         * optimizer.
         * </p>
         * <p>
         * This configuration is necessary to perform optimization on tables that are in a customer VPC.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableOptimizerVpcConfiguration.Builder}
         * avoiding the need to create one manually via {@link TableOptimizerVpcConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableOptimizerVpcConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #vpcConfiguration(TableOptimizerVpcConfiguration)}.
         * 
         * @param vpcConfiguration
         *        a consumer that will call methods on {@link TableOptimizerVpcConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfiguration(TableOptimizerVpcConfiguration)
         */
        default Builder vpcConfiguration(Consumer<TableOptimizerVpcConfiguration.Builder> vpcConfiguration) {
            return vpcConfiguration(TableOptimizerVpcConfiguration.builder().applyMutation(vpcConfiguration).build());
        }

        /**
         * <p>
         * The configuration for a compaction optimizer. This configuration defines how data files in your table will be
         * compacted to improve query performance and reduce storage costs.
         * </p>
         * 
         * @param compactionConfiguration
         *        The configuration for a compaction optimizer. This configuration defines how data files in your table
         *        will be compacted to improve query performance and reduce storage costs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compactionConfiguration(CompactionConfiguration compactionConfiguration);

        /**
         * <p>
         * The configuration for a compaction optimizer. This configuration defines how data files in your table will be
         * compacted to improve query performance and reduce storage costs.
         * </p>
         * This is a convenience method that creates an instance of the {@link CompactionConfiguration.Builder} avoiding
         * the need to create one manually via {@link CompactionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CompactionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #compactionConfiguration(CompactionConfiguration)}.
         * 
         * @param compactionConfiguration
         *        a consumer that will call methods on {@link CompactionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #compactionConfiguration(CompactionConfiguration)
         */
        default Builder compactionConfiguration(Consumer<CompactionConfiguration.Builder> compactionConfiguration) {
            return compactionConfiguration(CompactionConfiguration.builder().applyMutation(compactionConfiguration).build());
        }

        /**
         * <p>
         * The configuration for a snapshot retention optimizer.
         * </p>
         * 
         * @param retentionConfiguration
         *        The configuration for a snapshot retention optimizer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionConfiguration(RetentionConfiguration retentionConfiguration);

        /**
         * <p>
         * The configuration for a snapshot retention optimizer.
         * </p>
         * This is a convenience method that creates an instance of the {@link RetentionConfiguration.Builder} avoiding
         * the need to create one manually via {@link RetentionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetentionConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #retentionConfiguration(RetentionConfiguration)}.
         * 
         * @param retentionConfiguration
         *        a consumer that will call methods on {@link RetentionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retentionConfiguration(RetentionConfiguration)
         */
        default Builder retentionConfiguration(Consumer<RetentionConfiguration.Builder> retentionConfiguration) {
            return retentionConfiguration(RetentionConfiguration.builder().applyMutation(retentionConfiguration).build());
        }

        /**
         * <p>
         * The configuration for an orphan file deletion optimizer.
         * </p>
         * 
         * @param orphanFileDeletionConfiguration
         *        The configuration for an orphan file deletion optimizer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orphanFileDeletionConfiguration(OrphanFileDeletionConfiguration orphanFileDeletionConfiguration);

        /**
         * <p>
         * The configuration for an orphan file deletion optimizer.
         * </p>
         * This is a convenience method that creates an instance of the {@link OrphanFileDeletionConfiguration.Builder}
         * avoiding the need to create one manually via {@link OrphanFileDeletionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OrphanFileDeletionConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #orphanFileDeletionConfiguration(OrphanFileDeletionConfiguration)}.
         * 
         * @param orphanFileDeletionConfiguration
         *        a consumer that will call methods on {@link OrphanFileDeletionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orphanFileDeletionConfiguration(OrphanFileDeletionConfiguration)
         */
        default Builder orphanFileDeletionConfiguration(
                Consumer<OrphanFileDeletionConfiguration.Builder> orphanFileDeletionConfiguration) {
            return orphanFileDeletionConfiguration(OrphanFileDeletionConfiguration.builder()
                    .applyMutation(orphanFileDeletionConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private Boolean enabled;

        private TableOptimizerVpcConfiguration vpcConfiguration;

        private CompactionConfiguration compactionConfiguration;

        private RetentionConfiguration retentionConfiguration;

        private OrphanFileDeletionConfiguration orphanFileDeletionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(TableOptimizerConfiguration model) {
            roleArn(model.roleArn);
            enabled(model.enabled);
            vpcConfiguration(model.vpcConfiguration);
            compactionConfiguration(model.compactionConfiguration);
            retentionConfiguration(model.retentionConfiguration);
            orphanFileDeletionConfiguration(model.orphanFileDeletionConfiguration);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final TableOptimizerVpcConfiguration.Builder getVpcConfiguration() {
            return vpcConfiguration != null ? vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(TableOptimizerVpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(TableOptimizerVpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public final CompactionConfiguration.Builder getCompactionConfiguration() {
            return compactionConfiguration != null ? compactionConfiguration.toBuilder() : null;
        }

        public final void setCompactionConfiguration(CompactionConfiguration.BuilderImpl compactionConfiguration) {
            this.compactionConfiguration = compactionConfiguration != null ? compactionConfiguration.build() : null;
        }

        @Override
        public final Builder compactionConfiguration(CompactionConfiguration compactionConfiguration) {
            this.compactionConfiguration = compactionConfiguration;
            return this;
        }

        public final RetentionConfiguration.Builder getRetentionConfiguration() {
            return retentionConfiguration != null ? retentionConfiguration.toBuilder() : null;
        }

        public final void setRetentionConfiguration(RetentionConfiguration.BuilderImpl retentionConfiguration) {
            this.retentionConfiguration = retentionConfiguration != null ? retentionConfiguration.build() : null;
        }

        @Override
        public final Builder retentionConfiguration(RetentionConfiguration retentionConfiguration) {
            this.retentionConfiguration = retentionConfiguration;
            return this;
        }

        public final OrphanFileDeletionConfiguration.Builder getOrphanFileDeletionConfiguration() {
            return orphanFileDeletionConfiguration != null ? orphanFileDeletionConfiguration.toBuilder() : null;
        }

        public final void setOrphanFileDeletionConfiguration(
                OrphanFileDeletionConfiguration.BuilderImpl orphanFileDeletionConfiguration) {
            this.orphanFileDeletionConfiguration = orphanFileDeletionConfiguration != null ? orphanFileDeletionConfiguration
                    .build() : null;
        }

        @Override
        public final Builder orphanFileDeletionConfiguration(OrphanFileDeletionConfiguration orphanFileDeletionConfiguration) {
            this.orphanFileDeletionConfiguration = orphanFileDeletionConfiguration;
            return this;
        }

        @Override
        public TableOptimizerConfiguration build() {
            return new TableOptimizerConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
