/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a HyperDirect data target that writes to Amazon S3.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3HyperDirectTarget implements SdkPojo, Serializable,
        ToCopyableBuilder<S3HyperDirectTarget.Builder, S3HyperDirectTarget> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(S3HyperDirectTarget::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> INPUTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Inputs")
            .getter(getter(S3HyperDirectTarget::inputs))
            .setter(setter(Builder::inputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Format")
            .getter(getter(S3HyperDirectTarget::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()).build();

    private static final SdkField<List<List<String>>> PARTITION_KEYS_FIELD = SdkField
            .<List<List<String>>> builder(MarshallingType.LIST)
            .memberName("PartitionKeys")
            .getter(getter(S3HyperDirectTarget::partitionKeys))
            .setter(setter(Builder::partitionKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Path")
            .getter(getter(S3HyperDirectTarget::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final SdkField<String> COMPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Compression").getter(getter(S3HyperDirectTarget::compressionAsString))
            .setter(setter(Builder::compression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Compression").build()).build();

    private static final SdkField<DirectSchemaChangePolicy> SCHEMA_CHANGE_POLICY_FIELD = SdkField
            .<DirectSchemaChangePolicy> builder(MarshallingType.SDK_POJO).memberName("SchemaChangePolicy")
            .getter(getter(S3HyperDirectTarget::schemaChangePolicy)).setter(setter(Builder::schemaChangePolicy))
            .constructor(DirectSchemaChangePolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaChangePolicy").build())
            .build();

    private static final SdkField<AutoDataQuality> AUTO_DATA_QUALITY_FIELD = SdkField
            .<AutoDataQuality> builder(MarshallingType.SDK_POJO).memberName("AutoDataQuality")
            .getter(getter(S3HyperDirectTarget::autoDataQuality)).setter(setter(Builder::autoDataQuality))
            .constructor(AutoDataQuality::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoDataQuality").build()).build();

    private static final SdkField<List<GlueSchema>> OUTPUT_SCHEMAS_FIELD = SdkField
            .<List<GlueSchema>> builder(MarshallingType.LIST)
            .memberName("OutputSchemas")
            .getter(getter(S3HyperDirectTarget::outputSchemas))
            .setter(setter(Builder::outputSchemas))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputSchemas").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GlueSchema> builder(MarshallingType.SDK_POJO)
                                            .constructor(GlueSchema::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INPUTS_FIELD,
            FORMAT_FIELD, PARTITION_KEYS_FIELD, PATH_FIELD, COMPRESSION_FIELD, SCHEMA_CHANGE_POLICY_FIELD,
            AUTO_DATA_QUALITY_FIELD, OUTPUT_SCHEMAS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<String> inputs;

    private final String format;

    private final List<List<String>> partitionKeys;

    private final String path;

    private final String compression;

    private final DirectSchemaChangePolicy schemaChangePolicy;

    private final AutoDataQuality autoDataQuality;

    private final List<GlueSchema> outputSchemas;

    private S3HyperDirectTarget(BuilderImpl builder) {
        this.name = builder.name;
        this.inputs = builder.inputs;
        this.format = builder.format;
        this.partitionKeys = builder.partitionKeys;
        this.path = builder.path;
        this.compression = builder.compression;
        this.schemaChangePolicy = builder.schemaChangePolicy;
        this.autoDataQuality = builder.autoDataQuality;
        this.outputSchemas = builder.outputSchemas;
    }

    /**
     * <p>
     * The unique identifier for the HyperDirect target node.
     * </p>
     * 
     * @return The unique identifier for the HyperDirect target node.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Inputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInputs() {
        return inputs != null && !(inputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the input source for the HyperDirect target.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputs} method.
     * </p>
     * 
     * @return Specifies the input source for the HyperDirect target.
     */
    public final List<String> inputs() {
        return inputs;
    }

    /**
     * <p>
     * Specifies the data output format for the HyperDirect target.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link TargetFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return Specifies the data output format for the HyperDirect target.
     * @see TargetFormat
     */
    public final TargetFormat format() {
        return TargetFormat.fromValue(format);
    }

    /**
     * <p>
     * Specifies the data output format for the HyperDirect target.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link TargetFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return Specifies the data output format for the HyperDirect target.
     * @see TargetFormat
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * For responses, this returns true if the service returned a value for the PartitionKeys property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPartitionKeys() {
        return partitionKeys != null && !(partitionKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Defines the partitioning strategy for the output data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPartitionKeys} method.
     * </p>
     * 
     * @return Defines the partitioning strategy for the output data.
     */
    public final List<List<String>> partitionKeys() {
        return partitionKeys;
    }

    /**
     * <p>
     * The S3 location where the output data will be written.
     * </p>
     * 
     * @return The S3 location where the output data will be written.
     */
    public final String path() {
        return path;
    }

    /**
     * <p>
     * The compression type to apply to the output data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compression} will
     * return {@link HyperTargetCompressionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #compressionAsString}.
     * </p>
     * 
     * @return The compression type to apply to the output data.
     * @see HyperTargetCompressionType
     */
    public final HyperTargetCompressionType compression() {
        return HyperTargetCompressionType.fromValue(compression);
    }

    /**
     * <p>
     * The compression type to apply to the output data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compression} will
     * return {@link HyperTargetCompressionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #compressionAsString}.
     * </p>
     * 
     * @return The compression type to apply to the output data.
     * @see HyperTargetCompressionType
     */
    public final String compressionAsString() {
        return compression;
    }

    /**
     * <p>
     * Defines how schema changes are handled during write operations.
     * </p>
     * 
     * @return Defines how schema changes are handled during write operations.
     */
    public final DirectSchemaChangePolicy schemaChangePolicy() {
        return schemaChangePolicy;
    }

    /**
     * <p>
     * Specifies whether to automatically enable data quality evaluation for the S3 Hyper direct target. When set to
     * <code>true</code>, data quality checks are performed automatically during the write operation.
     * </p>
     * 
     * @return Specifies whether to automatically enable data quality evaluation for the S3 Hyper direct target. When
     *         set to <code>true</code>, data quality checks are performed automatically during the write operation.
     */
    public final AutoDataQuality autoDataQuality() {
        return autoDataQuality;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputSchemas property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputSchemas() {
        return outputSchemas != null && !(outputSchemas instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the data schema for the S3 Hyper direct target.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputSchemas} method.
     * </p>
     * 
     * @return Specifies the data schema for the S3 Hyper direct target.
     */
    public final List<GlueSchema> outputSchemas() {
        return outputSchemas;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputs() ? inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasPartitionKeys() ? partitionKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(compressionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(schemaChangePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(autoDataQuality());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputSchemas() ? outputSchemas() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3HyperDirectTarget)) {
            return false;
        }
        S3HyperDirectTarget other = (S3HyperDirectTarget) obj;
        return Objects.equals(name(), other.name()) && hasInputs() == other.hasInputs()
                && Objects.equals(inputs(), other.inputs()) && Objects.equals(formatAsString(), other.formatAsString())
                && hasPartitionKeys() == other.hasPartitionKeys() && Objects.equals(partitionKeys(), other.partitionKeys())
                && Objects.equals(path(), other.path()) && Objects.equals(compressionAsString(), other.compressionAsString())
                && Objects.equals(schemaChangePolicy(), other.schemaChangePolicy())
                && Objects.equals(autoDataQuality(), other.autoDataQuality()) && hasOutputSchemas() == other.hasOutputSchemas()
                && Objects.equals(outputSchemas(), other.outputSchemas());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3HyperDirectTarget").add("Name", name()).add("Inputs", hasInputs() ? inputs() : null)
                .add("Format", formatAsString()).add("PartitionKeys", hasPartitionKeys() ? partitionKeys() : null)
                .add("Path", path()).add("Compression", compressionAsString()).add("SchemaChangePolicy", schemaChangePolicy())
                .add("AutoDataQuality", autoDataQuality()).add("OutputSchemas", hasOutputSchemas() ? outputSchemas() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Inputs":
            return Optional.ofNullable(clazz.cast(inputs()));
        case "Format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "PartitionKeys":
            return Optional.ofNullable(clazz.cast(partitionKeys()));
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        case "Compression":
            return Optional.ofNullable(clazz.cast(compressionAsString()));
        case "SchemaChangePolicy":
            return Optional.ofNullable(clazz.cast(schemaChangePolicy()));
        case "AutoDataQuality":
            return Optional.ofNullable(clazz.cast(autoDataQuality()));
        case "OutputSchemas":
            return Optional.ofNullable(clazz.cast(outputSchemas()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Inputs", INPUTS_FIELD);
        map.put("Format", FORMAT_FIELD);
        map.put("PartitionKeys", PARTITION_KEYS_FIELD);
        map.put("Path", PATH_FIELD);
        map.put("Compression", COMPRESSION_FIELD);
        map.put("SchemaChangePolicy", SCHEMA_CHANGE_POLICY_FIELD);
        map.put("AutoDataQuality", AUTO_DATA_QUALITY_FIELD);
        map.put("OutputSchemas", OUTPUT_SCHEMAS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3HyperDirectTarget, T> g) {
        return obj -> g.apply((S3HyperDirectTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3HyperDirectTarget> {
        /**
         * <p>
         * The unique identifier for the HyperDirect target node.
         * </p>
         * 
         * @param name
         *        The unique identifier for the HyperDirect target node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies the input source for the HyperDirect target.
         * </p>
         * 
         * @param inputs
         *        Specifies the input source for the HyperDirect target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Collection<String> inputs);

        /**
         * <p>
         * Specifies the input source for the HyperDirect target.
         * </p>
         * 
         * @param inputs
         *        Specifies the input source for the HyperDirect target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(String... inputs);

        /**
         * <p>
         * Specifies the data output format for the HyperDirect target.
         * </p>
         * 
         * @param format
         *        Specifies the data output format for the HyperDirect target.
         * @see TargetFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetFormat
         */
        Builder format(String format);

        /**
         * <p>
         * Specifies the data output format for the HyperDirect target.
         * </p>
         * 
         * @param format
         *        Specifies the data output format for the HyperDirect target.
         * @see TargetFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetFormat
         */
        Builder format(TargetFormat format);

        /**
         * <p>
         * Defines the partitioning strategy for the output data.
         * </p>
         * 
         * @param partitionKeys
         *        Defines the partitioning strategy for the output data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionKeys(Collection<? extends Collection<String>> partitionKeys);

        /**
         * <p>
         * Defines the partitioning strategy for the output data.
         * </p>
         * 
         * @param partitionKeys
         *        Defines the partitioning strategy for the output data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionKeys(Collection<String>... partitionKeys);

        /**
         * <p>
         * The S3 location where the output data will be written.
         * </p>
         * 
         * @param path
         *        The S3 location where the output data will be written.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The compression type to apply to the output data.
         * </p>
         * 
         * @param compression
         *        The compression type to apply to the output data.
         * @see HyperTargetCompressionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HyperTargetCompressionType
         */
        Builder compression(String compression);

        /**
         * <p>
         * The compression type to apply to the output data.
         * </p>
         * 
         * @param compression
         *        The compression type to apply to the output data.
         * @see HyperTargetCompressionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HyperTargetCompressionType
         */
        Builder compression(HyperTargetCompressionType compression);

        /**
         * <p>
         * Defines how schema changes are handled during write operations.
         * </p>
         * 
         * @param schemaChangePolicy
         *        Defines how schema changes are handled during write operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaChangePolicy(DirectSchemaChangePolicy schemaChangePolicy);

        /**
         * <p>
         * Defines how schema changes are handled during write operations.
         * </p>
         * This is a convenience method that creates an instance of the {@link DirectSchemaChangePolicy.Builder}
         * avoiding the need to create one manually via {@link DirectSchemaChangePolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DirectSchemaChangePolicy.Builder#build()} is called immediately
         * and its result is passed to {@link #schemaChangePolicy(DirectSchemaChangePolicy)}.
         * 
         * @param schemaChangePolicy
         *        a consumer that will call methods on {@link DirectSchemaChangePolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaChangePolicy(DirectSchemaChangePolicy)
         */
        default Builder schemaChangePolicy(Consumer<DirectSchemaChangePolicy.Builder> schemaChangePolicy) {
            return schemaChangePolicy(DirectSchemaChangePolicy.builder().applyMutation(schemaChangePolicy).build());
        }

        /**
         * <p>
         * Specifies whether to automatically enable data quality evaluation for the S3 Hyper direct target. When set to
         * <code>true</code>, data quality checks are performed automatically during the write operation.
         * </p>
         * 
         * @param autoDataQuality
         *        Specifies whether to automatically enable data quality evaluation for the S3 Hyper direct target. When
         *        set to <code>true</code>, data quality checks are performed automatically during the write operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoDataQuality(AutoDataQuality autoDataQuality);

        /**
         * <p>
         * Specifies whether to automatically enable data quality evaluation for the S3 Hyper direct target. When set to
         * <code>true</code>, data quality checks are performed automatically during the write operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoDataQuality.Builder} avoiding the
         * need to create one manually via {@link AutoDataQuality#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoDataQuality.Builder#build()} is called immediately and its
         * result is passed to {@link #autoDataQuality(AutoDataQuality)}.
         * 
         * @param autoDataQuality
         *        a consumer that will call methods on {@link AutoDataQuality.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoDataQuality(AutoDataQuality)
         */
        default Builder autoDataQuality(Consumer<AutoDataQuality.Builder> autoDataQuality) {
            return autoDataQuality(AutoDataQuality.builder().applyMutation(autoDataQuality).build());
        }

        /**
         * <p>
         * Specifies the data schema for the S3 Hyper direct target.
         * </p>
         * 
         * @param outputSchemas
         *        Specifies the data schema for the S3 Hyper direct target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputSchemas(Collection<GlueSchema> outputSchemas);

        /**
         * <p>
         * Specifies the data schema for the S3 Hyper direct target.
         * </p>
         * 
         * @param outputSchemas
         *        Specifies the data schema for the S3 Hyper direct target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputSchemas(GlueSchema... outputSchemas);

        /**
         * <p>
         * Specifies the data schema for the S3 Hyper direct target.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.GlueSchema.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.glue.model.GlueSchema#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.GlueSchema.Builder#build()} is called immediately and its
         * result is passed to {@link #outputSchemas(List<GlueSchema>)}.
         * 
         * @param outputSchemas
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.GlueSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputSchemas(java.util.Collection<GlueSchema>)
         */
        Builder outputSchemas(Consumer<GlueSchema.Builder>... outputSchemas);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();

        private String format;

        private List<List<String>> partitionKeys = DefaultSdkAutoConstructList.getInstance();

        private String path;

        private String compression;

        private DirectSchemaChangePolicy schemaChangePolicy;

        private AutoDataQuality autoDataQuality;

        private List<GlueSchema> outputSchemas = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(S3HyperDirectTarget model) {
            name(model.name);
            inputs(model.inputs);
            format(model.format);
            partitionKeys(model.partitionKeys);
            path(model.path);
            compression(model.compression);
            schemaChangePolicy(model.schemaChangePolicy);
            autoDataQuality(model.autoDataQuality);
            outputSchemas(model.outputSchemas);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getInputs() {
            if (inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String... inputs) {
            inputs(Arrays.asList(inputs));
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(TargetFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final Collection<? extends Collection<String>> getPartitionKeys() {
            if (partitionKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return partitionKeys;
        }

        public final void setPartitionKeys(Collection<? extends Collection<String>> partitionKeys) {
            this.partitionKeys = GlueStudioPathListCopier.copy(partitionKeys);
        }

        @Override
        public final Builder partitionKeys(Collection<? extends Collection<String>> partitionKeys) {
            this.partitionKeys = GlueStudioPathListCopier.copy(partitionKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionKeys(Collection<String>... partitionKeys) {
            partitionKeys(Arrays.asList(partitionKeys));
            return this;
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getCompression() {
            return compression;
        }

        public final void setCompression(String compression) {
            this.compression = compression;
        }

        @Override
        public final Builder compression(String compression) {
            this.compression = compression;
            return this;
        }

        @Override
        public final Builder compression(HyperTargetCompressionType compression) {
            this.compression(compression == null ? null : compression.toString());
            return this;
        }

        public final DirectSchemaChangePolicy.Builder getSchemaChangePolicy() {
            return schemaChangePolicy != null ? schemaChangePolicy.toBuilder() : null;
        }

        public final void setSchemaChangePolicy(DirectSchemaChangePolicy.BuilderImpl schemaChangePolicy) {
            this.schemaChangePolicy = schemaChangePolicy != null ? schemaChangePolicy.build() : null;
        }

        @Override
        public final Builder schemaChangePolicy(DirectSchemaChangePolicy schemaChangePolicy) {
            this.schemaChangePolicy = schemaChangePolicy;
            return this;
        }

        public final AutoDataQuality.Builder getAutoDataQuality() {
            return autoDataQuality != null ? autoDataQuality.toBuilder() : null;
        }

        public final void setAutoDataQuality(AutoDataQuality.BuilderImpl autoDataQuality) {
            this.autoDataQuality = autoDataQuality != null ? autoDataQuality.build() : null;
        }

        @Override
        public final Builder autoDataQuality(AutoDataQuality autoDataQuality) {
            this.autoDataQuality = autoDataQuality;
            return this;
        }

        public final List<GlueSchema.Builder> getOutputSchemas() {
            List<GlueSchema.Builder> result = GlueSchemasCopier.copyToBuilder(this.outputSchemas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputSchemas(Collection<GlueSchema.BuilderImpl> outputSchemas) {
            this.outputSchemas = GlueSchemasCopier.copyFromBuilder(outputSchemas);
        }

        @Override
        public final Builder outputSchemas(Collection<GlueSchema> outputSchemas) {
            this.outputSchemas = GlueSchemasCopier.copy(outputSchemas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSchemas(GlueSchema... outputSchemas) {
            outputSchemas(Arrays.asList(outputSchemas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSchemas(Consumer<GlueSchema.Builder>... outputSchemas) {
            outputSchemas(Stream.of(outputSchemas).map(c -> GlueSchema.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public S3HyperDirectTarget build() {
            return new S3HyperDirectTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
