/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyIntegrationRequest extends GlueRequest implements
        ToCopyableBuilder<ModifyIntegrationRequest.Builder, ModifyIntegrationRequest> {
    private static final SdkField<String> INTEGRATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IntegrationIdentifier").getter(getter(ModifyIntegrationRequest::integrationIdentifier))
            .setter(setter(Builder::integrationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationIdentifier").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ModifyIntegrationRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DATA_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataFilter").getter(getter(ModifyIntegrationRequest::dataFilter)).setter(setter(Builder::dataFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataFilter").build()).build();

    private static final SdkField<IntegrationConfig> INTEGRATION_CONFIG_FIELD = SdkField
            .<IntegrationConfig> builder(MarshallingType.SDK_POJO).memberName("IntegrationConfig")
            .getter(getter(ModifyIntegrationRequest::integrationConfig)).setter(setter(Builder::integrationConfig))
            .constructor(IntegrationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationConfig").build()).build();

    private static final SdkField<String> INTEGRATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IntegrationName").getter(getter(ModifyIntegrationRequest::integrationName))
            .setter(setter(Builder::integrationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGRATION_IDENTIFIER_FIELD,
            DESCRIPTION_FIELD, DATA_FILTER_FIELD, INTEGRATION_CONFIG_FIELD, INTEGRATION_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String integrationIdentifier;

    private final String description;

    private final String dataFilter;

    private final IntegrationConfig integrationConfig;

    private final String integrationName;

    private ModifyIntegrationRequest(BuilderImpl builder) {
        super(builder);
        this.integrationIdentifier = builder.integrationIdentifier;
        this.description = builder.description;
        this.dataFilter = builder.dataFilter;
        this.integrationConfig = builder.integrationConfig;
        this.integrationName = builder.integrationName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the integration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the integration.
     */
    public final String integrationIdentifier() {
        return integrationIdentifier;
    }

    /**
     * <p>
     * A description of the integration.
     * </p>
     * 
     * @return A description of the integration.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Selects source tables for the integration using Maxwell filter syntax.
     * </p>
     * 
     * @return Selects source tables for the integration using Maxwell filter syntax.
     */
    public final String dataFilter() {
        return dataFilter;
    }

    /**
     * Returns the value of the IntegrationConfig property for this object.
     * 
     * @return The value of the IntegrationConfig property for this object.
     */
    public final IntegrationConfig integrationConfig() {
        return integrationConfig;
    }

    /**
     * <p>
     * A unique name for an integration in Glue.
     * </p>
     * 
     * @return A unique name for an integration in Glue.
     */
    public final String integrationName() {
        return integrationName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(integrationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(dataFilter());
        hashCode = 31 * hashCode + Objects.hashCode(integrationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(integrationName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyIntegrationRequest)) {
            return false;
        }
        ModifyIntegrationRequest other = (ModifyIntegrationRequest) obj;
        return Objects.equals(integrationIdentifier(), other.integrationIdentifier())
                && Objects.equals(description(), other.description()) && Objects.equals(dataFilter(), other.dataFilter())
                && Objects.equals(integrationConfig(), other.integrationConfig())
                && Objects.equals(integrationName(), other.integrationName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyIntegrationRequest").add("IntegrationIdentifier", integrationIdentifier())
                .add("Description", description()).add("DataFilter", dataFilter()).add("IntegrationConfig", integrationConfig())
                .add("IntegrationName", integrationName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IntegrationIdentifier":
            return Optional.ofNullable(clazz.cast(integrationIdentifier()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DataFilter":
            return Optional.ofNullable(clazz.cast(dataFilter()));
        case "IntegrationConfig":
            return Optional.ofNullable(clazz.cast(integrationConfig()));
        case "IntegrationName":
            return Optional.ofNullable(clazz.cast(integrationName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IntegrationIdentifier", INTEGRATION_IDENTIFIER_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DataFilter", DATA_FILTER_FIELD);
        map.put("IntegrationConfig", INTEGRATION_CONFIG_FIELD);
        map.put("IntegrationName", INTEGRATION_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyIntegrationRequest, T> g) {
        return obj -> g.apply((ModifyIntegrationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyIntegrationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the integration.
         * </p>
         * 
         * @param integrationIdentifier
         *        The Amazon Resource Name (ARN) for the integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationIdentifier(String integrationIdentifier);

        /**
         * <p>
         * A description of the integration.
         * </p>
         * 
         * @param description
         *        A description of the integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Selects source tables for the integration using Maxwell filter syntax.
         * </p>
         * 
         * @param dataFilter
         *        Selects source tables for the integration using Maxwell filter syntax.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataFilter(String dataFilter);

        /**
         * Sets the value of the IntegrationConfig property for this object.
         *
         * @param integrationConfig
         *        The new value for the IntegrationConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationConfig(IntegrationConfig integrationConfig);

        /**
         * Sets the value of the IntegrationConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link IntegrationConfig.Builder} avoiding the
         * need to create one manually via {@link IntegrationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IntegrationConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #integrationConfig(IntegrationConfig)}.
         * 
         * @param integrationConfig
         *        a consumer that will call methods on {@link IntegrationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #integrationConfig(IntegrationConfig)
         */
        default Builder integrationConfig(Consumer<IntegrationConfig.Builder> integrationConfig) {
            return integrationConfig(IntegrationConfig.builder().applyMutation(integrationConfig).build());
        }

        /**
         * <p>
         * A unique name for an integration in Glue.
         * </p>
         * 
         * @param integrationName
         *        A unique name for an integration in Glue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationName(String integrationName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String integrationIdentifier;

        private String description;

        private String dataFilter;

        private IntegrationConfig integrationConfig;

        private String integrationName;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyIntegrationRequest model) {
            super(model);
            integrationIdentifier(model.integrationIdentifier);
            description(model.description);
            dataFilter(model.dataFilter);
            integrationConfig(model.integrationConfig);
            integrationName(model.integrationName);
        }

        public final String getIntegrationIdentifier() {
            return integrationIdentifier;
        }

        public final void setIntegrationIdentifier(String integrationIdentifier) {
            this.integrationIdentifier = integrationIdentifier;
        }

        @Override
        public final Builder integrationIdentifier(String integrationIdentifier) {
            this.integrationIdentifier = integrationIdentifier;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDataFilter() {
            return dataFilter;
        }

        public final void setDataFilter(String dataFilter) {
            this.dataFilter = dataFilter;
        }

        @Override
        public final Builder dataFilter(String dataFilter) {
            this.dataFilter = dataFilter;
            return this;
        }

        public final IntegrationConfig.Builder getIntegrationConfig() {
            return integrationConfig != null ? integrationConfig.toBuilder() : null;
        }

        public final void setIntegrationConfig(IntegrationConfig.BuilderImpl integrationConfig) {
            this.integrationConfig = integrationConfig != null ? integrationConfig.build() : null;
        }

        @Override
        public final Builder integrationConfig(IntegrationConfig integrationConfig) {
            this.integrationConfig = integrationConfig;
            return this;
        }

        public final String getIntegrationName() {
            return integrationName;
        }

        public final void setIntegrationName(String integrationName) {
            this.integrationName = integrationName;
        }

        @Override
        public final Builder integrationName(String integrationName) {
            this.integrationName = integrationName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyIntegrationRequest build() {
            return new ModifyIntegrationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
