/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies connection options for DynamoDB ELT (Extract, Load, Transform) operations. This structure contains
 * configuration parameters for connecting to and extracting data from DynamoDB tables using the ELT connector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DDBELTConnectionOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<DDBELTConnectionOptions.Builder, DDBELTConnectionOptions> {
    private static final SdkField<String> DYNAMODB_EXPORT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DynamodbExport").getter(getter(DDBELTConnectionOptions::dynamodbExportAsString))
            .setter(setter(Builder::dynamodbExport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamodbExport").build()).build();

    private static final SdkField<Boolean> DYNAMODB_UNNEST_DDB_JSON_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DynamodbUnnestDDBJson").getter(getter(DDBELTConnectionOptions::dynamodbUnnestDDBJson))
            .setter(setter(Builder::dynamodbUnnestDDBJson))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamodbUnnestDDBJson").build())
            .build();

    private static final SdkField<String> DYNAMODB_TABLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DynamodbTableArn").getter(getter(DDBELTConnectionOptions::dynamodbTableArn))
            .setter(setter(Builder::dynamodbTableArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamodbTableArn").build()).build();

    private static final SdkField<String> DYNAMODB_S3_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DynamodbS3Bucket").getter(getter(DDBELTConnectionOptions::dynamodbS3Bucket))
            .setter(setter(Builder::dynamodbS3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamodbS3Bucket").build()).build();

    private static final SdkField<String> DYNAMODB_S3_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DynamodbS3Prefix").getter(getter(DDBELTConnectionOptions::dynamodbS3Prefix))
            .setter(setter(Builder::dynamodbS3Prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamodbS3Prefix").build()).build();

    private static final SdkField<String> DYNAMODB_S3_BUCKET_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DynamodbS3BucketOwner").getter(getter(DDBELTConnectionOptions::dynamodbS3BucketOwner))
            .setter(setter(Builder::dynamodbS3BucketOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamodbS3BucketOwner").build())
            .build();

    private static final SdkField<String> DYNAMODB_STS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DynamodbStsRoleArn").getter(getter(DDBELTConnectionOptions::dynamodbStsRoleArn))
            .setter(setter(Builder::dynamodbStsRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamodbStsRoleArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DYNAMODB_EXPORT_FIELD,
            DYNAMODB_UNNEST_DDB_JSON_FIELD, DYNAMODB_TABLE_ARN_FIELD, DYNAMODB_S3_BUCKET_FIELD, DYNAMODB_S3_PREFIX_FIELD,
            DYNAMODB_S3_BUCKET_OWNER_FIELD, DYNAMODB_STS_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dynamodbExport;

    private final Boolean dynamodbUnnestDDBJson;

    private final String dynamodbTableArn;

    private final String dynamodbS3Bucket;

    private final String dynamodbS3Prefix;

    private final String dynamodbS3BucketOwner;

    private final String dynamodbStsRoleArn;

    private DDBELTConnectionOptions(BuilderImpl builder) {
        this.dynamodbExport = builder.dynamodbExport;
        this.dynamodbUnnestDDBJson = builder.dynamodbUnnestDDBJson;
        this.dynamodbTableArn = builder.dynamodbTableArn;
        this.dynamodbS3Bucket = builder.dynamodbS3Bucket;
        this.dynamodbS3Prefix = builder.dynamodbS3Prefix;
        this.dynamodbS3BucketOwner = builder.dynamodbS3BucketOwner;
        this.dynamodbStsRoleArn = builder.dynamodbStsRoleArn;
    }

    /**
     * <p>
     * Specifies the export type for DynamoDB data extraction. This parameter determines how data is exported from the
     * DynamoDB table during the ELT process.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dynamodbExport}
     * will return {@link DdbExportType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dynamodbExportAsString}.
     * </p>
     * 
     * @return Specifies the export type for DynamoDB data extraction. This parameter determines how data is exported
     *         from the DynamoDB table during the ELT process.
     * @see DdbExportType
     */
    public final DdbExportType dynamodbExport() {
        return DdbExportType.fromValue(dynamodbExport);
    }

    /**
     * <p>
     * Specifies the export type for DynamoDB data extraction. This parameter determines how data is exported from the
     * DynamoDB table during the ELT process.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dynamodbExport}
     * will return {@link DdbExportType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dynamodbExportAsString}.
     * </p>
     * 
     * @return Specifies the export type for DynamoDB data extraction. This parameter determines how data is exported
     *         from the DynamoDB table during the ELT process.
     * @see DdbExportType
     */
    public final String dynamodbExportAsString() {
        return dynamodbExport;
    }

    /**
     * <p>
     * A boolean value that specifies whether to unnest DynamoDB JSON format during data extraction. When set to
     * <code>true</code>, the connector will flatten nested JSON structures from DynamoDB items. When set to
     * <code>false</code>, the original DynamoDB JSON structure is preserved.
     * </p>
     * 
     * @return A boolean value that specifies whether to unnest DynamoDB JSON format during data extraction. When set to
     *         <code>true</code>, the connector will flatten nested JSON structures from DynamoDB items. When set to
     *         <code>false</code>, the original DynamoDB JSON structure is preserved.
     */
    public final Boolean dynamodbUnnestDDBJson() {
        return dynamodbUnnestDDBJson;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the DynamoDB table to extract data from. This parameter specifies the source
     * table for the ELT operation.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the DynamoDB table to extract data from. This parameter specifies the
     *         source table for the ELT operation.
     */
    public final String dynamodbTableArn() {
        return dynamodbTableArn;
    }

    /**
     * <p>
     * The name of the Amazon S3 bucket used for intermediate storage during the DynamoDB ELT process. This bucket is
     * used to temporarily store exported DynamoDB data before it is processed by the ELT job.
     * </p>
     * 
     * @return The name of the Amazon S3 bucket used for intermediate storage during the DynamoDB ELT process. This
     *         bucket is used to temporarily store exported DynamoDB data before it is processed by the ELT job.
     */
    public final String dynamodbS3Bucket() {
        return dynamodbS3Bucket;
    }

    /**
     * <p>
     * The S3 object key prefix for files stored in the intermediate S3 bucket during the DynamoDB ELT process. This
     * prefix helps organize and identify the temporary files created during data extraction.
     * </p>
     * 
     * @return The S3 object key prefix for files stored in the intermediate S3 bucket during the DynamoDB ELT process.
     *         This prefix helps organize and identify the temporary files created during data extraction.
     */
    public final String dynamodbS3Prefix() {
        return dynamodbS3Prefix;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the owner of the S3 bucket specified in <code>DynamodbS3Bucket</code>. This
     * parameter is required when the S3 bucket is owned by a different Amazon Web Services account than the one running
     * the ELT job, enabling cross-account access to the intermediate storage bucket.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the owner of the S3 bucket specified in
     *         <code>DynamodbS3Bucket</code>. This parameter is required when the S3 bucket is owned by a different
     *         Amazon Web Services account than the one running the ELT job, enabling cross-account access to the
     *         intermediate storage bucket.
     */
    public final String dynamodbS3BucketOwner() {
        return dynamodbS3BucketOwner;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Web Services Security Token Service (STS) role to assume for
     * accessing DynamoDB and S3 resources during the ELT operation. This role must have the necessary permissions to
     * read from the DynamoDB table and write to the intermediate S3 bucket.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Web Services Security Token Service (STS) role to assume for
     *         accessing DynamoDB and S3 resources during the ELT operation. This role must have the necessary
     *         permissions to read from the DynamoDB table and write to the intermediate S3 bucket.
     */
    public final String dynamodbStsRoleArn() {
        return dynamodbStsRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dynamodbExportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dynamodbUnnestDDBJson());
        hashCode = 31 * hashCode + Objects.hashCode(dynamodbTableArn());
        hashCode = 31 * hashCode + Objects.hashCode(dynamodbS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(dynamodbS3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(dynamodbS3BucketOwner());
        hashCode = 31 * hashCode + Objects.hashCode(dynamodbStsRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DDBELTConnectionOptions)) {
            return false;
        }
        DDBELTConnectionOptions other = (DDBELTConnectionOptions) obj;
        return Objects.equals(dynamodbExportAsString(), other.dynamodbExportAsString())
                && Objects.equals(dynamodbUnnestDDBJson(), other.dynamodbUnnestDDBJson())
                && Objects.equals(dynamodbTableArn(), other.dynamodbTableArn())
                && Objects.equals(dynamodbS3Bucket(), other.dynamodbS3Bucket())
                && Objects.equals(dynamodbS3Prefix(), other.dynamodbS3Prefix())
                && Objects.equals(dynamodbS3BucketOwner(), other.dynamodbS3BucketOwner())
                && Objects.equals(dynamodbStsRoleArn(), other.dynamodbStsRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DDBELTConnectionOptions").add("DynamodbExport", dynamodbExportAsString())
                .add("DynamodbUnnestDDBJson", dynamodbUnnestDDBJson()).add("DynamodbTableArn", dynamodbTableArn())
                .add("DynamodbS3Bucket", dynamodbS3Bucket()).add("DynamodbS3Prefix", dynamodbS3Prefix())
                .add("DynamodbS3BucketOwner", dynamodbS3BucketOwner()).add("DynamodbStsRoleArn", dynamodbStsRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DynamodbExport":
            return Optional.ofNullable(clazz.cast(dynamodbExportAsString()));
        case "DynamodbUnnestDDBJson":
            return Optional.ofNullable(clazz.cast(dynamodbUnnestDDBJson()));
        case "DynamodbTableArn":
            return Optional.ofNullable(clazz.cast(dynamodbTableArn()));
        case "DynamodbS3Bucket":
            return Optional.ofNullable(clazz.cast(dynamodbS3Bucket()));
        case "DynamodbS3Prefix":
            return Optional.ofNullable(clazz.cast(dynamodbS3Prefix()));
        case "DynamodbS3BucketOwner":
            return Optional.ofNullable(clazz.cast(dynamodbS3BucketOwner()));
        case "DynamodbStsRoleArn":
            return Optional.ofNullable(clazz.cast(dynamodbStsRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DynamodbExport", DYNAMODB_EXPORT_FIELD);
        map.put("DynamodbUnnestDDBJson", DYNAMODB_UNNEST_DDB_JSON_FIELD);
        map.put("DynamodbTableArn", DYNAMODB_TABLE_ARN_FIELD);
        map.put("DynamodbS3Bucket", DYNAMODB_S3_BUCKET_FIELD);
        map.put("DynamodbS3Prefix", DYNAMODB_S3_PREFIX_FIELD);
        map.put("DynamodbS3BucketOwner", DYNAMODB_S3_BUCKET_OWNER_FIELD);
        map.put("DynamodbStsRoleArn", DYNAMODB_STS_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DDBELTConnectionOptions, T> g) {
        return obj -> g.apply((DDBELTConnectionOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DDBELTConnectionOptions> {
        /**
         * <p>
         * Specifies the export type for DynamoDB data extraction. This parameter determines how data is exported from
         * the DynamoDB table during the ELT process.
         * </p>
         * 
         * @param dynamodbExport
         *        Specifies the export type for DynamoDB data extraction. This parameter determines how data is exported
         *        from the DynamoDB table during the ELT process.
         * @see DdbExportType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DdbExportType
         */
        Builder dynamodbExport(String dynamodbExport);

        /**
         * <p>
         * Specifies the export type for DynamoDB data extraction. This parameter determines how data is exported from
         * the DynamoDB table during the ELT process.
         * </p>
         * 
         * @param dynamodbExport
         *        Specifies the export type for DynamoDB data extraction. This parameter determines how data is exported
         *        from the DynamoDB table during the ELT process.
         * @see DdbExportType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DdbExportType
         */
        Builder dynamodbExport(DdbExportType dynamodbExport);

        /**
         * <p>
         * A boolean value that specifies whether to unnest DynamoDB JSON format during data extraction. When set to
         * <code>true</code>, the connector will flatten nested JSON structures from DynamoDB items. When set to
         * <code>false</code>, the original DynamoDB JSON structure is preserved.
         * </p>
         * 
         * @param dynamodbUnnestDDBJson
         *        A boolean value that specifies whether to unnest DynamoDB JSON format during data extraction. When set
         *        to <code>true</code>, the connector will flatten nested JSON structures from DynamoDB items. When set
         *        to <code>false</code>, the original DynamoDB JSON structure is preserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamodbUnnestDDBJson(Boolean dynamodbUnnestDDBJson);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the DynamoDB table to extract data from. This parameter specifies the
         * source table for the ELT operation.
         * </p>
         * 
         * @param dynamodbTableArn
         *        The Amazon Resource Name (ARN) of the DynamoDB table to extract data from. This parameter specifies
         *        the source table for the ELT operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamodbTableArn(String dynamodbTableArn);

        /**
         * <p>
         * The name of the Amazon S3 bucket used for intermediate storage during the DynamoDB ELT process. This bucket
         * is used to temporarily store exported DynamoDB data before it is processed by the ELT job.
         * </p>
         * 
         * @param dynamodbS3Bucket
         *        The name of the Amazon S3 bucket used for intermediate storage during the DynamoDB ELT process. This
         *        bucket is used to temporarily store exported DynamoDB data before it is processed by the ELT job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamodbS3Bucket(String dynamodbS3Bucket);

        /**
         * <p>
         * The S3 object key prefix for files stored in the intermediate S3 bucket during the DynamoDB ELT process. This
         * prefix helps organize and identify the temporary files created during data extraction.
         * </p>
         * 
         * @param dynamodbS3Prefix
         *        The S3 object key prefix for files stored in the intermediate S3 bucket during the DynamoDB ELT
         *        process. This prefix helps organize and identify the temporary files created during data extraction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamodbS3Prefix(String dynamodbS3Prefix);

        /**
         * <p>
         * The Amazon Web Services account ID of the owner of the S3 bucket specified in <code>DynamodbS3Bucket</code>.
         * This parameter is required when the S3 bucket is owned by a different Amazon Web Services account than the
         * one running the ELT job, enabling cross-account access to the intermediate storage bucket.
         * </p>
         * 
         * @param dynamodbS3BucketOwner
         *        The Amazon Web Services account ID of the owner of the S3 bucket specified in
         *        <code>DynamodbS3Bucket</code>. This parameter is required when the S3 bucket is owned by a different
         *        Amazon Web Services account than the one running the ELT job, enabling cross-account access to the
         *        intermediate storage bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamodbS3BucketOwner(String dynamodbS3BucketOwner);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Web Services Security Token Service (STS) role to assume for
         * accessing DynamoDB and S3 resources during the ELT operation. This role must have the necessary permissions
         * to read from the DynamoDB table and write to the intermediate S3 bucket.
         * </p>
         * 
         * @param dynamodbStsRoleArn
         *        The Amazon Resource Name (ARN) of the Amazon Web Services Security Token Service (STS) role to assume
         *        for accessing DynamoDB and S3 resources during the ELT operation. This role must have the necessary
         *        permissions to read from the DynamoDB table and write to the intermediate S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamodbStsRoleArn(String dynamodbStsRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String dynamodbExport;

        private Boolean dynamodbUnnestDDBJson;

        private String dynamodbTableArn;

        private String dynamodbS3Bucket;

        private String dynamodbS3Prefix;

        private String dynamodbS3BucketOwner;

        private String dynamodbStsRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DDBELTConnectionOptions model) {
            dynamodbExport(model.dynamodbExport);
            dynamodbUnnestDDBJson(model.dynamodbUnnestDDBJson);
            dynamodbTableArn(model.dynamodbTableArn);
            dynamodbS3Bucket(model.dynamodbS3Bucket);
            dynamodbS3Prefix(model.dynamodbS3Prefix);
            dynamodbS3BucketOwner(model.dynamodbS3BucketOwner);
            dynamodbStsRoleArn(model.dynamodbStsRoleArn);
        }

        public final String getDynamodbExport() {
            return dynamodbExport;
        }

        public final void setDynamodbExport(String dynamodbExport) {
            this.dynamodbExport = dynamodbExport;
        }

        @Override
        public final Builder dynamodbExport(String dynamodbExport) {
            this.dynamodbExport = dynamodbExport;
            return this;
        }

        @Override
        public final Builder dynamodbExport(DdbExportType dynamodbExport) {
            this.dynamodbExport(dynamodbExport == null ? null : dynamodbExport.toString());
            return this;
        }

        public final Boolean getDynamodbUnnestDDBJson() {
            return dynamodbUnnestDDBJson;
        }

        public final void setDynamodbUnnestDDBJson(Boolean dynamodbUnnestDDBJson) {
            this.dynamodbUnnestDDBJson = dynamodbUnnestDDBJson;
        }

        @Override
        public final Builder dynamodbUnnestDDBJson(Boolean dynamodbUnnestDDBJson) {
            this.dynamodbUnnestDDBJson = dynamodbUnnestDDBJson;
            return this;
        }

        public final String getDynamodbTableArn() {
            return dynamodbTableArn;
        }

        public final void setDynamodbTableArn(String dynamodbTableArn) {
            this.dynamodbTableArn = dynamodbTableArn;
        }

        @Override
        public final Builder dynamodbTableArn(String dynamodbTableArn) {
            this.dynamodbTableArn = dynamodbTableArn;
            return this;
        }

        public final String getDynamodbS3Bucket() {
            return dynamodbS3Bucket;
        }

        public final void setDynamodbS3Bucket(String dynamodbS3Bucket) {
            this.dynamodbS3Bucket = dynamodbS3Bucket;
        }

        @Override
        public final Builder dynamodbS3Bucket(String dynamodbS3Bucket) {
            this.dynamodbS3Bucket = dynamodbS3Bucket;
            return this;
        }

        public final String getDynamodbS3Prefix() {
            return dynamodbS3Prefix;
        }

        public final void setDynamodbS3Prefix(String dynamodbS3Prefix) {
            this.dynamodbS3Prefix = dynamodbS3Prefix;
        }

        @Override
        public final Builder dynamodbS3Prefix(String dynamodbS3Prefix) {
            this.dynamodbS3Prefix = dynamodbS3Prefix;
            return this;
        }

        public final String getDynamodbS3BucketOwner() {
            return dynamodbS3BucketOwner;
        }

        public final void setDynamodbS3BucketOwner(String dynamodbS3BucketOwner) {
            this.dynamodbS3BucketOwner = dynamodbS3BucketOwner;
        }

        @Override
        public final Builder dynamodbS3BucketOwner(String dynamodbS3BucketOwner) {
            this.dynamodbS3BucketOwner = dynamodbS3BucketOwner;
            return this;
        }

        public final String getDynamodbStsRoleArn() {
            return dynamodbStsRoleArn;
        }

        public final void setDynamodbStsRoleArn(String dynamodbStsRoleArn) {
            this.dynamodbStsRoleArn = dynamodbStsRoleArn;
        }

        @Override
        public final Builder dynamodbStsRoleArn(String dynamodbStsRoleArn) {
            this.dynamodbStsRoleArn = dynamodbStsRoleArn;
            return this;
        }

        @Override
        public DDBELTConnectionOptions build() {
            return new DDBELTConnectionOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
