/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetBlueprintsResponse extends GlueResponse implements
        ToCopyableBuilder<BatchGetBlueprintsResponse.Builder, BatchGetBlueprintsResponse> {
    private static final SdkField<List<Blueprint>> BLUEPRINTS_FIELD = SdkField
            .<List<Blueprint>> builder(MarshallingType.LIST)
            .memberName("Blueprints")
            .getter(getter(BatchGetBlueprintsResponse::blueprints))
            .setter(setter(Builder::blueprints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Blueprints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Blueprint> builder(MarshallingType.SDK_POJO)
                                            .constructor(Blueprint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> MISSING_BLUEPRINTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MissingBlueprints")
            .getter(getter(BatchGetBlueprintsResponse::missingBlueprints))
            .setter(setter(Builder::missingBlueprints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MissingBlueprints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINTS_FIELD,
            MISSING_BLUEPRINTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Blueprint> blueprints;

    private final List<String> missingBlueprints;

    private BatchGetBlueprintsResponse(BuilderImpl builder) {
        super(builder);
        this.blueprints = builder.blueprints;
        this.missingBlueprints = builder.missingBlueprints;
    }

    /**
     * For responses, this returns true if the service returned a value for the Blueprints property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBlueprints() {
        return blueprints != null && !(blueprints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a list of blueprint as a <code>Blueprints</code> object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlueprints} method.
     * </p>
     * 
     * @return Returns a list of blueprint as a <code>Blueprints</code> object.
     */
    public final List<Blueprint> blueprints() {
        return blueprints;
    }

    /**
     * For responses, this returns true if the service returned a value for the MissingBlueprints property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMissingBlueprints() {
        return missingBlueprints != null && !(missingBlueprints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a list of <code>BlueprintNames</code> that were not found.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMissingBlueprints} method.
     * </p>
     * 
     * @return Returns a list of <code>BlueprintNames</code> that were not found.
     */
    public final List<String> missingBlueprints() {
        return missingBlueprints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBlueprints() ? blueprints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMissingBlueprints() ? missingBlueprints() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetBlueprintsResponse)) {
            return false;
        }
        BatchGetBlueprintsResponse other = (BatchGetBlueprintsResponse) obj;
        return hasBlueprints() == other.hasBlueprints() && Objects.equals(blueprints(), other.blueprints())
                && hasMissingBlueprints() == other.hasMissingBlueprints()
                && Objects.equals(missingBlueprints(), other.missingBlueprints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetBlueprintsResponse").add("Blueprints", hasBlueprints() ? blueprints() : null)
                .add("MissingBlueprints", hasMissingBlueprints() ? missingBlueprints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Blueprints":
            return Optional.ofNullable(clazz.cast(blueprints()));
        case "MissingBlueprints":
            return Optional.ofNullable(clazz.cast(missingBlueprints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Blueprints", BLUEPRINTS_FIELD);
        map.put("MissingBlueprints", MISSING_BLUEPRINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetBlueprintsResponse, T> g) {
        return obj -> g.apply((BatchGetBlueprintsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetBlueprintsResponse> {
        /**
         * <p>
         * Returns a list of blueprint as a <code>Blueprints</code> object.
         * </p>
         * 
         * @param blueprints
         *        Returns a list of blueprint as a <code>Blueprints</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprints(Collection<Blueprint> blueprints);

        /**
         * <p>
         * Returns a list of blueprint as a <code>Blueprints</code> object.
         * </p>
         * 
         * @param blueprints
         *        Returns a list of blueprint as a <code>Blueprints</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprints(Blueprint... blueprints);

        /**
         * <p>
         * Returns a list of blueprint as a <code>Blueprints</code> object.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.Blueprint.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.glue.model.Blueprint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.Blueprint.Builder#build()} is called immediately and its
         * result is passed to {@link #blueprints(List<Blueprint>)}.
         * 
         * @param blueprints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.Blueprint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blueprints(java.util.Collection<Blueprint>)
         */
        Builder blueprints(Consumer<Blueprint.Builder>... blueprints);

        /**
         * <p>
         * Returns a list of <code>BlueprintNames</code> that were not found.
         * </p>
         * 
         * @param missingBlueprints
         *        Returns a list of <code>BlueprintNames</code> that were not found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missingBlueprints(Collection<String> missingBlueprints);

        /**
         * <p>
         * Returns a list of <code>BlueprintNames</code> that were not found.
         * </p>
         * 
         * @param missingBlueprints
         *        Returns a list of <code>BlueprintNames</code> that were not found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missingBlueprints(String... missingBlueprints);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<Blueprint> blueprints = DefaultSdkAutoConstructList.getInstance();

        private List<String> missingBlueprints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetBlueprintsResponse model) {
            super(model);
            blueprints(model.blueprints);
            missingBlueprints(model.missingBlueprints);
        }

        public final List<Blueprint.Builder> getBlueprints() {
            List<Blueprint.Builder> result = BlueprintsCopier.copyToBuilder(this.blueprints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlueprints(Collection<Blueprint.BuilderImpl> blueprints) {
            this.blueprints = BlueprintsCopier.copyFromBuilder(blueprints);
        }

        @Override
        public final Builder blueprints(Collection<Blueprint> blueprints) {
            this.blueprints = BlueprintsCopier.copy(blueprints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blueprints(Blueprint... blueprints) {
            blueprints(Arrays.asList(blueprints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blueprints(Consumer<Blueprint.Builder>... blueprints) {
            blueprints(Stream.of(blueprints).map(c -> Blueprint.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getMissingBlueprints() {
            if (missingBlueprints instanceof SdkAutoConstructList) {
                return null;
            }
            return missingBlueprints;
        }

        public final void setMissingBlueprints(Collection<String> missingBlueprints) {
            this.missingBlueprints = BlueprintNamesCopier.copy(missingBlueprints);
        }

        @Override
        public final Builder missingBlueprints(Collection<String> missingBlueprints) {
            this.missingBlueprints = BlueprintNamesCopier.copy(missingBlueprints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder missingBlueprints(String... missingBlueprints) {
            missingBlueprints(Arrays.asList(missingBlueprints));
            return this;
        }

        @Override
        public BatchGetBlueprintsResponse build() {
            return new BatchGetBlueprintsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
