/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.DataQualityGlueTable;
import software.amazon.awssdk.services.glue.model.GlueTable;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSource> {
    private static final SdkField<GlueTable> GLUE_TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GlueTable").getter(DataSource.getter(DataSource::glueTable)).setter(DataSource.setter(Builder::glueTable)).constructor(GlueTable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlueTable").build()}).build();
    private static final SdkField<DataQualityGlueTable> DATA_QUALITY_GLUE_TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataQualityGlueTable").getter(DataSource.getter(DataSource::dataQualityGlueTable)).setter(DataSource.setter(Builder::dataQualityGlueTable)).constructor(DataQualityGlueTable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataQualityGlueTable").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLUE_TABLE_FIELD, DATA_QUALITY_GLUE_TABLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final GlueTable glueTable;
    private final DataQualityGlueTable dataQualityGlueTable;

    private DataSource(BuilderImpl builder) {
        this.glueTable = builder.glueTable;
        this.dataQualityGlueTable = builder.dataQualityGlueTable;
    }

    public final GlueTable glueTable() {
        return this.glueTable;
    }

    public final DataQualityGlueTable dataQualityGlueTable() {
        return this.dataQualityGlueTable;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.glueTable());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataQualityGlueTable());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSource)) {
            return false;
        }
        DataSource other = (DataSource)obj;
        return Objects.equals(this.glueTable(), other.glueTable()) && Objects.equals(this.dataQualityGlueTable(), other.dataQualityGlueTable());
    }

    public final String toString() {
        return ToString.builder((String)"DataSource").add("GlueTable", (Object)this.glueTable()).add("DataQualityGlueTable", (Object)this.dataQualityGlueTable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GlueTable": {
                return Optional.ofNullable(clazz.cast(this.glueTable()));
            }
            case "DataQualityGlueTable": {
                return Optional.ofNullable(clazz.cast(this.dataQualityGlueTable()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GlueTable", GLUE_TABLE_FIELD);
        map.put("DataQualityGlueTable", DATA_QUALITY_GLUE_TABLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSource, T> g) {
        return obj -> g.apply((DataSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private GlueTable glueTable;
        private DataQualityGlueTable dataQualityGlueTable;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSource model) {
            this.glueTable(model.glueTable);
            this.dataQualityGlueTable(model.dataQualityGlueTable);
        }

        public final GlueTable.Builder getGlueTable() {
            return this.glueTable != null ? this.glueTable.toBuilder() : null;
        }

        public final void setGlueTable(GlueTable.BuilderImpl glueTable) {
            this.glueTable = glueTable != null ? glueTable.build() : null;
        }

        @Override
        public final Builder glueTable(GlueTable glueTable) {
            this.glueTable = glueTable;
            return this;
        }

        public final DataQualityGlueTable.Builder getDataQualityGlueTable() {
            return this.dataQualityGlueTable != null ? this.dataQualityGlueTable.toBuilder() : null;
        }

        public final void setDataQualityGlueTable(DataQualityGlueTable.BuilderImpl dataQualityGlueTable) {
            this.dataQualityGlueTable = dataQualityGlueTable != null ? dataQualityGlueTable.build() : null;
        }

        @Override
        public final Builder dataQualityGlueTable(DataQualityGlueTable dataQualityGlueTable) {
            this.dataQualityGlueTable = dataQualityGlueTable;
            return this;
        }

        public DataSource build() {
            return new DataSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSource> {
        public Builder glueTable(GlueTable var1);

        default public Builder glueTable(Consumer<GlueTable.Builder> glueTable) {
            return this.glueTable((GlueTable)((GlueTable.Builder)GlueTable.builder().applyMutation(glueTable)).build());
        }

        public Builder dataQualityGlueTable(DataQualityGlueTable var1);

        default public Builder dataQualityGlueTable(Consumer<DataQualityGlueTable.Builder> dataQualityGlueTable) {
            return this.dataQualityGlueTable((DataQualityGlueTable)((DataQualityGlueTable.Builder)DataQualityGlueTable.builder().applyMutation(dataQualityGlueTable)).build());
        }
    }
}

