/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateUserDefinedFunctionRequest extends GlueRequest implements
        ToCopyableBuilder<UpdateUserDefinedFunctionRequest.Builder, UpdateUserDefinedFunctionRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(UpdateUserDefinedFunctionRequest::catalogId))
            .setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(UpdateUserDefinedFunctionRequest::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionName").getter(getter(UpdateUserDefinedFunctionRequest::functionName))
            .setter(setter(Builder::functionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionName").build()).build();

    private static final SdkField<UserDefinedFunctionInput> FUNCTION_INPUT_FIELD = SdkField
            .<UserDefinedFunctionInput> builder(MarshallingType.SDK_POJO).memberName("FunctionInput")
            .getter(getter(UpdateUserDefinedFunctionRequest::functionInput)).setter(setter(Builder::functionInput))
            .constructor(UserDefinedFunctionInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionInput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            DATABASE_NAME_FIELD, FUNCTION_NAME_FIELD, FUNCTION_INPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalogId;

    private final String databaseName;

    private final String functionName;

    private final UserDefinedFunctionInput functionInput;

    private UpdateUserDefinedFunctionRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.functionName = builder.functionName;
        this.functionInput = builder.functionInput;
    }

    /**
     * <p>
     * The ID of the Data Catalog where the function to be updated is located. If none is provided, the Amazon Web
     * Services account ID is used by default.
     * </p>
     * 
     * @return The ID of the Data Catalog where the function to be updated is located. If none is provided, the Amazon
     *         Web Services account ID is used by default.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * The name of the catalog database where the function to be updated is located.
     * </p>
     * 
     * @return The name of the catalog database where the function to be updated is located.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The name of the function.
     * </p>
     * 
     * @return The name of the function.
     */
    public final String functionName() {
        return functionName;
    }

    /**
     * <p>
     * A <code>FunctionInput</code> object that redefines the function in the Data Catalog.
     * </p>
     * 
     * @return A <code>FunctionInput</code> object that redefines the function in the Data Catalog.
     */
    public final UserDefinedFunctionInput functionInput() {
        return functionInput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(functionName());
        hashCode = 31 * hashCode + Objects.hashCode(functionInput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserDefinedFunctionRequest)) {
            return false;
        }
        UpdateUserDefinedFunctionRequest other = (UpdateUserDefinedFunctionRequest) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(functionName(), other.functionName()) && Objects.equals(functionInput(), other.functionInput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateUserDefinedFunctionRequest").add("CatalogId", catalogId())
                .add("DatabaseName", databaseName()).add("FunctionName", functionName()).add("FunctionInput", functionInput())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "FunctionName":
            return Optional.ofNullable(clazz.cast(functionName()));
        case "FunctionInput":
            return Optional.ofNullable(clazz.cast(functionInput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CatalogId", CATALOG_ID_FIELD);
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("FunctionName", FUNCTION_NAME_FIELD);
        map.put("FunctionInput", FUNCTION_INPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserDefinedFunctionRequest, T> g) {
        return obj -> g.apply((UpdateUserDefinedFunctionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateUserDefinedFunctionRequest> {
        /**
         * <p>
         * The ID of the Data Catalog where the function to be updated is located. If none is provided, the Amazon Web
         * Services account ID is used by default.
         * </p>
         * 
         * @param catalogId
         *        The ID of the Data Catalog where the function to be updated is located. If none is provided, the
         *        Amazon Web Services account ID is used by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * The name of the catalog database where the function to be updated is located.
         * </p>
         * 
         * @param databaseName
         *        The name of the catalog database where the function to be updated is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The name of the function.
         * </p>
         * 
         * @param functionName
         *        The name of the function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionName(String functionName);

        /**
         * <p>
         * A <code>FunctionInput</code> object that redefines the function in the Data Catalog.
         * </p>
         * 
         * @param functionInput
         *        A <code>FunctionInput</code> object that redefines the function in the Data Catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionInput(UserDefinedFunctionInput functionInput);

        /**
         * <p>
         * A <code>FunctionInput</code> object that redefines the function in the Data Catalog.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserDefinedFunctionInput.Builder}
         * avoiding the need to create one manually via {@link UserDefinedFunctionInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserDefinedFunctionInput.Builder#build()} is called immediately
         * and its result is passed to {@link #functionInput(UserDefinedFunctionInput)}.
         * 
         * @param functionInput
         *        a consumer that will call methods on {@link UserDefinedFunctionInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #functionInput(UserDefinedFunctionInput)
         */
        default Builder functionInput(Consumer<UserDefinedFunctionInput.Builder> functionInput) {
            return functionInput(UserDefinedFunctionInput.builder().applyMutation(functionInput).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String catalogId;

        private String databaseName;

        private String functionName;

        private UserDefinedFunctionInput functionInput;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserDefinedFunctionRequest model) {
            super(model);
            catalogId(model.catalogId);
            databaseName(model.databaseName);
            functionName(model.functionName);
            functionInput(model.functionInput);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getFunctionName() {
            return functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final UserDefinedFunctionInput.Builder getFunctionInput() {
            return functionInput != null ? functionInput.toBuilder() : null;
        }

        public final void setFunctionInput(UserDefinedFunctionInput.BuilderImpl functionInput) {
            this.functionInput = functionInput != null ? functionInput.build() : null;
        }

        @Override
        public final Builder functionInput(UserDefinedFunctionInput functionInput) {
            this.functionInput = functionInput;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserDefinedFunctionRequest build() {
            return new UpdateUserDefinedFunctionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
