/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a transform that writes samples of the data to an Amazon S3 bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Spigot implements SdkPojo, Serializable, ToCopyableBuilder<Spigot.Builder, Spigot> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Spigot::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> INPUTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Inputs")
            .getter(getter(Spigot::inputs))
            .setter(setter(Builder::inputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Path")
            .getter(getter(Spigot::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final SdkField<Integer> TOPK_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Topk")
            .getter(getter(Spigot::topk)).setter(setter(Builder::topk))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Topk").build()).build();

    private static final SdkField<Double> PROB_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Prob")
            .getter(getter(Spigot::prob)).setter(setter(Builder::prob))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prob").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INPUTS_FIELD,
            PATH_FIELD, TOPK_FIELD, PROB_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<String> inputs;

    private final String path;

    private final Integer topk;

    private final Double prob;

    private Spigot(BuilderImpl builder) {
        this.name = builder.name;
        this.inputs = builder.inputs;
        this.path = builder.path;
        this.topk = builder.topk;
        this.prob = builder.prob;
    }

    /**
     * <p>
     * The name of the transform node.
     * </p>
     * 
     * @return The name of the transform node.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Inputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInputs() {
        return inputs != null && !(inputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data inputs identified by their node names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputs} method.
     * </p>
     * 
     * @return The data inputs identified by their node names.
     */
    public final List<String> inputs() {
        return inputs;
    }

    /**
     * <p>
     * A path in Amazon S3 where the transform will write a subset of records from the dataset to a JSON file in an
     * Amazon S3 bucket.
     * </p>
     * 
     * @return A path in Amazon S3 where the transform will write a subset of records from the dataset to a JSON file in
     *         an Amazon S3 bucket.
     */
    public final String path() {
        return path;
    }

    /**
     * <p>
     * Specifies a number of records to write starting from the beginning of the dataset.
     * </p>
     * 
     * @return Specifies a number of records to write starting from the beginning of the dataset.
     */
    public final Integer topk() {
        return topk;
    }

    /**
     * <p>
     * The probability (a decimal value with a maximum value of 1) of picking any given record. A value of 1 indicates
     * that each row read from the dataset should be included in the sample output.
     * </p>
     * 
     * @return The probability (a decimal value with a maximum value of 1) of picking any given record. A value of 1
     *         indicates that each row read from the dataset should be included in the sample output.
     */
    public final Double prob() {
        return prob;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputs() ? inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(topk());
        hashCode = 31 * hashCode + Objects.hashCode(prob());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Spigot)) {
            return false;
        }
        Spigot other = (Spigot) obj;
        return Objects.equals(name(), other.name()) && hasInputs() == other.hasInputs()
                && Objects.equals(inputs(), other.inputs()) && Objects.equals(path(), other.path())
                && Objects.equals(topk(), other.topk()) && Objects.equals(prob(), other.prob());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Spigot").add("Name", name()).add("Inputs", hasInputs() ? inputs() : null).add("Path", path())
                .add("Topk", topk()).add("Prob", prob()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Inputs":
            return Optional.ofNullable(clazz.cast(inputs()));
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        case "Topk":
            return Optional.ofNullable(clazz.cast(topk()));
        case "Prob":
            return Optional.ofNullable(clazz.cast(prob()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Inputs", INPUTS_FIELD);
        map.put("Path", PATH_FIELD);
        map.put("Topk", TOPK_FIELD);
        map.put("Prob", PROB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Spigot, T> g) {
        return obj -> g.apply((Spigot) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Spigot> {
        /**
         * <p>
         * The name of the transform node.
         * </p>
         * 
         * @param name
         *        The name of the transform node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The data inputs identified by their node names.
         * </p>
         * 
         * @param inputs
         *        The data inputs identified by their node names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Collection<String> inputs);

        /**
         * <p>
         * The data inputs identified by their node names.
         * </p>
         * 
         * @param inputs
         *        The data inputs identified by their node names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(String... inputs);

        /**
         * <p>
         * A path in Amazon S3 where the transform will write a subset of records from the dataset to a JSON file in an
         * Amazon S3 bucket.
         * </p>
         * 
         * @param path
         *        A path in Amazon S3 where the transform will write a subset of records from the dataset to a JSON file
         *        in an Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * Specifies a number of records to write starting from the beginning of the dataset.
         * </p>
         * 
         * @param topk
         *        Specifies a number of records to write starting from the beginning of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topk(Integer topk);

        /**
         * <p>
         * The probability (a decimal value with a maximum value of 1) of picking any given record. A value of 1
         * indicates that each row read from the dataset should be included in the sample output.
         * </p>
         * 
         * @param prob
         *        The probability (a decimal value with a maximum value of 1) of picking any given record. A value of 1
         *        indicates that each row read from the dataset should be included in the sample output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prob(Double prob);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();

        private String path;

        private Integer topk;

        private Double prob;

        private BuilderImpl() {
        }

        private BuilderImpl(Spigot model) {
            name(model.name);
            inputs(model.inputs);
            path(model.path);
            topk(model.topk);
            prob(model.prob);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getInputs() {
            if (inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String... inputs) {
            inputs(Arrays.asList(inputs));
            return this;
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final Integer getTopk() {
            return topk;
        }

        public final void setTopk(Integer topk) {
            this.topk = topk;
        }

        @Override
        public final Builder topk(Integer topk) {
            this.topk = topk;
            return this;
        }

        public final Double getProb() {
            return prob;
        }

        public final void setProb(Double prob) {
            this.prob = prob;
        }

        @Override
        public final Builder prob(Double prob) {
            this.prob = prob;
            return this;
        }

        @Override
        public Spigot build() {
            return new Spigot(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
