/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetWorkflowsResponse extends GlueResponse implements
        ToCopyableBuilder<BatchGetWorkflowsResponse.Builder, BatchGetWorkflowsResponse> {
    private static final SdkField<List<Workflow>> WORKFLOWS_FIELD = SdkField
            .<List<Workflow>> builder(MarshallingType.LIST)
            .memberName("Workflows")
            .getter(getter(BatchGetWorkflowsResponse::workflows))
            .setter(setter(Builder::workflows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Workflows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Workflow> builder(MarshallingType.SDK_POJO)
                                            .constructor(Workflow::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> MISSING_WORKFLOWS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MissingWorkflows")
            .getter(getter(BatchGetWorkflowsResponse::missingWorkflows))
            .setter(setter(Builder::missingWorkflows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MissingWorkflows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOWS_FIELD,
            MISSING_WORKFLOWS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Workflow> workflows;

    private final List<String> missingWorkflows;

    private BatchGetWorkflowsResponse(BuilderImpl builder) {
        super(builder);
        this.workflows = builder.workflows;
        this.missingWorkflows = builder.missingWorkflows;
    }

    /**
     * For responses, this returns true if the service returned a value for the Workflows property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWorkflows() {
        return workflows != null && !(workflows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of workflow resource metadata.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkflows} method.
     * </p>
     * 
     * @return A list of workflow resource metadata.
     */
    public final List<Workflow> workflows() {
        return workflows;
    }

    /**
     * For responses, this returns true if the service returned a value for the MissingWorkflows property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMissingWorkflows() {
        return missingWorkflows != null && !(missingWorkflows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of names of workflows not found.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMissingWorkflows} method.
     * </p>
     * 
     * @return A list of names of workflows not found.
     */
    public final List<String> missingWorkflows() {
        return missingWorkflows;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkflows() ? workflows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMissingWorkflows() ? missingWorkflows() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetWorkflowsResponse)) {
            return false;
        }
        BatchGetWorkflowsResponse other = (BatchGetWorkflowsResponse) obj;
        return hasWorkflows() == other.hasWorkflows() && Objects.equals(workflows(), other.workflows())
                && hasMissingWorkflows() == other.hasMissingWorkflows()
                && Objects.equals(missingWorkflows(), other.missingWorkflows());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetWorkflowsResponse").add("Workflows", hasWorkflows() ? workflows() : null)
                .add("MissingWorkflows", hasMissingWorkflows() ? missingWorkflows() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Workflows":
            return Optional.ofNullable(clazz.cast(workflows()));
        case "MissingWorkflows":
            return Optional.ofNullable(clazz.cast(missingWorkflows()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Workflows", WORKFLOWS_FIELD);
        map.put("MissingWorkflows", MISSING_WORKFLOWS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetWorkflowsResponse, T> g) {
        return obj -> g.apply((BatchGetWorkflowsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetWorkflowsResponse> {
        /**
         * <p>
         * A list of workflow resource metadata.
         * </p>
         * 
         * @param workflows
         *        A list of workflow resource metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflows(Collection<Workflow> workflows);

        /**
         * <p>
         * A list of workflow resource metadata.
         * </p>
         * 
         * @param workflows
         *        A list of workflow resource metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflows(Workflow... workflows);

        /**
         * <p>
         * A list of workflow resource metadata.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.Workflow.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.glue.model.Workflow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.Workflow.Builder#build()} is called immediately and its
         * result is passed to {@link #workflows(List<Workflow>)}.
         * 
         * @param workflows
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.Workflow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflows(java.util.Collection<Workflow>)
         */
        Builder workflows(Consumer<Workflow.Builder>... workflows);

        /**
         * <p>
         * A list of names of workflows not found.
         * </p>
         * 
         * @param missingWorkflows
         *        A list of names of workflows not found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missingWorkflows(Collection<String> missingWorkflows);

        /**
         * <p>
         * A list of names of workflows not found.
         * </p>
         * 
         * @param missingWorkflows
         *        A list of names of workflows not found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missingWorkflows(String... missingWorkflows);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<Workflow> workflows = DefaultSdkAutoConstructList.getInstance();

        private List<String> missingWorkflows = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetWorkflowsResponse model) {
            super(model);
            workflows(model.workflows);
            missingWorkflows(model.missingWorkflows);
        }

        public final List<Workflow.Builder> getWorkflows() {
            List<Workflow.Builder> result = WorkflowsCopier.copyToBuilder(this.workflows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkflows(Collection<Workflow.BuilderImpl> workflows) {
            this.workflows = WorkflowsCopier.copyFromBuilder(workflows);
        }

        @Override
        public final Builder workflows(Collection<Workflow> workflows) {
            this.workflows = WorkflowsCopier.copy(workflows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflows(Workflow... workflows) {
            workflows(Arrays.asList(workflows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflows(Consumer<Workflow.Builder>... workflows) {
            workflows(Stream.of(workflows).map(c -> Workflow.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getMissingWorkflows() {
            if (missingWorkflows instanceof SdkAutoConstructList) {
                return null;
            }
            return missingWorkflows;
        }

        public final void setMissingWorkflows(Collection<String> missingWorkflows) {
            this.missingWorkflows = WorkflowNamesCopier.copy(missingWorkflows);
        }

        @Override
        public final Builder missingWorkflows(Collection<String> missingWorkflows) {
            this.missingWorkflows = WorkflowNamesCopier.copy(missingWorkflows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder missingWorkflows(String... missingWorkflows) {
            missingWorkflows(Arrays.asList(missingWorkflows));
            return this;
        }

        @Override
        public BatchGetWorkflowsResponse build() {
            return new BatchGetWorkflowsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
