/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the set of parameters needed to perform aggregation in the aggregate transform.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AggregateOperation implements SdkPojo, Serializable,
        ToCopyableBuilder<AggregateOperation.Builder, AggregateOperation> {
    private static final SdkField<List<String>> COLUMN_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Column")
            .getter(getter(AggregateOperation::column))
            .setter(setter(Builder::column))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AGG_FUNC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AggFunc").getter(getter(AggregateOperation::aggFuncAsString)).setter(setter(Builder::aggFunc))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggFunc").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_FIELD, AGG_FUNC_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> column;

    private final String aggFunc;

    private AggregateOperation(BuilderImpl builder) {
        this.column = builder.column;
        this.aggFunc = builder.aggFunc;
    }

    /**
     * For responses, this returns true if the service returned a value for the Column property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasColumn() {
        return column != null && !(column instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the column on the data set on which the aggregation function will be applied.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColumn} method.
     * </p>
     * 
     * @return Specifies the column on the data set on which the aggregation function will be applied.
     */
    public final List<String> column() {
        return column;
    }

    /**
     * <p>
     * Specifies the aggregation function to apply.
     * </p>
     * <p>
     * Possible aggregation functions include: avg countDistinct, count, first, last, kurtosis, max, min, skewness,
     * stddev_samp, stddev_pop, sum, sumDistinct, var_samp, var_pop
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggFunc} will
     * return {@link AggFunction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aggFuncAsString}.
     * </p>
     * 
     * @return Specifies the aggregation function to apply.</p>
     *         <p>
     *         Possible aggregation functions include: avg countDistinct, count, first, last, kurtosis, max, min,
     *         skewness, stddev_samp, stddev_pop, sum, sumDistinct, var_samp, var_pop
     * @see AggFunction
     */
    public final AggFunction aggFunc() {
        return AggFunction.fromValue(aggFunc);
    }

    /**
     * <p>
     * Specifies the aggregation function to apply.
     * </p>
     * <p>
     * Possible aggregation functions include: avg countDistinct, count, first, last, kurtosis, max, min, skewness,
     * stddev_samp, stddev_pop, sum, sumDistinct, var_samp, var_pop
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggFunc} will
     * return {@link AggFunction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aggFuncAsString}.
     * </p>
     * 
     * @return Specifies the aggregation function to apply.</p>
     *         <p>
     *         Possible aggregation functions include: avg countDistinct, count, first, last, kurtosis, max, min,
     *         skewness, stddev_samp, stddev_pop, sum, sumDistinct, var_samp, var_pop
     * @see AggFunction
     */
    public final String aggFuncAsString() {
        return aggFunc;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasColumn() ? column() : null);
        hashCode = 31 * hashCode + Objects.hashCode(aggFuncAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregateOperation)) {
            return false;
        }
        AggregateOperation other = (AggregateOperation) obj;
        return hasColumn() == other.hasColumn() && Objects.equals(column(), other.column())
                && Objects.equals(aggFuncAsString(), other.aggFuncAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AggregateOperation").add("Column", hasColumn() ? column() : null)
                .add("AggFunc", aggFuncAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Column":
            return Optional.ofNullable(clazz.cast(column()));
        case "AggFunc":
            return Optional.ofNullable(clazz.cast(aggFuncAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Column", COLUMN_FIELD);
        map.put("AggFunc", AGG_FUNC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AggregateOperation, T> g) {
        return obj -> g.apply((AggregateOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AggregateOperation> {
        /**
         * <p>
         * Specifies the column on the data set on which the aggregation function will be applied.
         * </p>
         * 
         * @param column
         *        Specifies the column on the data set on which the aggregation function will be applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder column(Collection<String> column);

        /**
         * <p>
         * Specifies the column on the data set on which the aggregation function will be applied.
         * </p>
         * 
         * @param column
         *        Specifies the column on the data set on which the aggregation function will be applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder column(String... column);

        /**
         * <p>
         * Specifies the aggregation function to apply.
         * </p>
         * <p>
         * Possible aggregation functions include: avg countDistinct, count, first, last, kurtosis, max, min, skewness,
         * stddev_samp, stddev_pop, sum, sumDistinct, var_samp, var_pop
         * </p>
         * 
         * @param aggFunc
         *        Specifies the aggregation function to apply.</p>
         *        <p>
         *        Possible aggregation functions include: avg countDistinct, count, first, last, kurtosis, max, min,
         *        skewness, stddev_samp, stddev_pop, sum, sumDistinct, var_samp, var_pop
         * @see AggFunction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggFunction
         */
        Builder aggFunc(String aggFunc);

        /**
         * <p>
         * Specifies the aggregation function to apply.
         * </p>
         * <p>
         * Possible aggregation functions include: avg countDistinct, count, first, last, kurtosis, max, min, skewness,
         * stddev_samp, stddev_pop, sum, sumDistinct, var_samp, var_pop
         * </p>
         * 
         * @param aggFunc
         *        Specifies the aggregation function to apply.</p>
         *        <p>
         *        Possible aggregation functions include: avg countDistinct, count, first, last, kurtosis, max, min,
         *        skewness, stddev_samp, stddev_pop, sum, sumDistinct, var_samp, var_pop
         * @see AggFunction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggFunction
         */
        Builder aggFunc(AggFunction aggFunc);
    }

    static final class BuilderImpl implements Builder {
        private List<String> column = DefaultSdkAutoConstructList.getInstance();

        private String aggFunc;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregateOperation model) {
            column(model.column);
            aggFunc(model.aggFunc);
        }

        public final Collection<String> getColumn() {
            if (column instanceof SdkAutoConstructList) {
                return null;
            }
            return column;
        }

        public final void setColumn(Collection<String> column) {
            this.column = EnclosedInStringPropertiesCopier.copy(column);
        }

        @Override
        public final Builder column(Collection<String> column) {
            this.column = EnclosedInStringPropertiesCopier.copy(column);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder column(String... column) {
            column(Arrays.asList(column));
            return this;
        }

        public final String getAggFunc() {
            return aggFunc;
        }

        public final void setAggFunc(String aggFunc) {
            this.aggFunc = aggFunc;
        }

        @Override
        public final Builder aggFunc(String aggFunc) {
            this.aggFunc = aggFunc;
            return this;
        }

        @Override
        public final Builder aggFunc(AggFunction aggFunc) {
            this.aggFunc(aggFunc == null ? null : aggFunc.toString());
            return this;
        }

        @Override
        public AggregateOperation build() {
            return new AggregateOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
