/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterSchemaVersionRequest extends GlueRequest implements
        ToCopyableBuilder<RegisterSchemaVersionRequest.Builder, RegisterSchemaVersionRequest> {
    private static final SdkField<SchemaId> SCHEMA_ID_FIELD = SdkField.<SchemaId> builder(MarshallingType.SDK_POJO)
            .memberName("SchemaId").getter(getter(RegisterSchemaVersionRequest::schemaId)).setter(setter(Builder::schemaId))
            .constructor(SchemaId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaId").build()).build();

    private static final SdkField<String> SCHEMA_DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaDefinition").getter(getter(RegisterSchemaVersionRequest::schemaDefinition))
            .setter(setter(Builder::schemaDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaDefinition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_ID_FIELD,
            SCHEMA_DEFINITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final SchemaId schemaId;

    private final String schemaDefinition;

    private RegisterSchemaVersionRequest(BuilderImpl builder) {
        super(builder);
        this.schemaId = builder.schemaId;
        this.schemaDefinition = builder.schemaDefinition;
    }

    /**
     * <p>
     * This is a wrapper structure to contain schema identity fields. The structure contains:
     * </p>
     * <ul>
     * <li>
     * <p>
     * SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema. Either <code>SchemaArn</code> or
     * <code>SchemaName</code> and <code>RegistryName</code> has to be provided.
     * </p>
     * </li>
     * <li>
     * <p>
     * SchemaId$SchemaName: The name of the schema. Either <code>SchemaArn</code> or <code>SchemaName</code> and
     * <code>RegistryName</code> has to be provided.
     * </p>
     * </li>
     * </ul>
     * 
     * @return This is a wrapper structure to contain schema identity fields. The structure contains:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema. Either <code>SchemaArn</code> or
     *         <code>SchemaName</code> and <code>RegistryName</code> has to be provided.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SchemaId$SchemaName: The name of the schema. Either <code>SchemaArn</code> or <code>SchemaName</code> and
     *         <code>RegistryName</code> has to be provided.
     *         </p>
     *         </li>
     */
    public final SchemaId schemaId() {
        return schemaId;
    }

    /**
     * <p>
     * The schema definition using the <code>DataFormat</code> setting for the <code>SchemaName</code>.
     * </p>
     * 
     * @return The schema definition using the <code>DataFormat</code> setting for the <code>SchemaName</code>.
     */
    public final String schemaDefinition() {
        return schemaDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(schemaId());
        hashCode = 31 * hashCode + Objects.hashCode(schemaDefinition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterSchemaVersionRequest)) {
            return false;
        }
        RegisterSchemaVersionRequest other = (RegisterSchemaVersionRequest) obj;
        return Objects.equals(schemaId(), other.schemaId()) && Objects.equals(schemaDefinition(), other.schemaDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterSchemaVersionRequest").add("SchemaId", schemaId())
                .add("SchemaDefinition", schemaDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SchemaId":
            return Optional.ofNullable(clazz.cast(schemaId()));
        case "SchemaDefinition":
            return Optional.ofNullable(clazz.cast(schemaDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SchemaId", SCHEMA_ID_FIELD);
        map.put("SchemaDefinition", SCHEMA_DEFINITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisterSchemaVersionRequest, T> g) {
        return obj -> g.apply((RegisterSchemaVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterSchemaVersionRequest> {
        /**
         * <p>
         * This is a wrapper structure to contain schema identity fields. The structure contains:
         * </p>
         * <ul>
         * <li>
         * <p>
         * SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema. Either <code>SchemaArn</code> or
         * <code>SchemaName</code> and <code>RegistryName</code> has to be provided.
         * </p>
         * </li>
         * <li>
         * <p>
         * SchemaId$SchemaName: The name of the schema. Either <code>SchemaArn</code> or <code>SchemaName</code> and
         * <code>RegistryName</code> has to be provided.
         * </p>
         * </li>
         * </ul>
         * 
         * @param schemaId
         *        This is a wrapper structure to contain schema identity fields. The structure contains:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema. Either <code>SchemaArn</code> or
         *        <code>SchemaName</code> and <code>RegistryName</code> has to be provided.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SchemaId$SchemaName: The name of the schema. Either <code>SchemaArn</code> or <code>SchemaName</code>
         *        and <code>RegistryName</code> has to be provided.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaId(SchemaId schemaId);

        /**
         * <p>
         * This is a wrapper structure to contain schema identity fields. The structure contains:
         * </p>
         * <ul>
         * <li>
         * <p>
         * SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema. Either <code>SchemaArn</code> or
         * <code>SchemaName</code> and <code>RegistryName</code> has to be provided.
         * </p>
         * </li>
         * <li>
         * <p>
         * SchemaId$SchemaName: The name of the schema. Either <code>SchemaArn</code> or <code>SchemaName</code> and
         * <code>RegistryName</code> has to be provided.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link SchemaId.Builder} avoiding the need to
         * create one manually via {@link SchemaId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SchemaId.Builder#build()} is called immediately and its result is
         * passed to {@link #schemaId(SchemaId)}.
         * 
         * @param schemaId
         *        a consumer that will call methods on {@link SchemaId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaId(SchemaId)
         */
        default Builder schemaId(Consumer<SchemaId.Builder> schemaId) {
            return schemaId(SchemaId.builder().applyMutation(schemaId).build());
        }

        /**
         * <p>
         * The schema definition using the <code>DataFormat</code> setting for the <code>SchemaName</code>.
         * </p>
         * 
         * @param schemaDefinition
         *        The schema definition using the <code>DataFormat</code> setting for the <code>SchemaName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaDefinition(String schemaDefinition);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private SchemaId schemaId;

        private String schemaDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterSchemaVersionRequest model) {
            super(model);
            schemaId(model.schemaId);
            schemaDefinition(model.schemaDefinition);
        }

        public final SchemaId.Builder getSchemaId() {
            return schemaId != null ? schemaId.toBuilder() : null;
        }

        public final void setSchemaId(SchemaId.BuilderImpl schemaId) {
            this.schemaId = schemaId != null ? schemaId.build() : null;
        }

        @Override
        public final Builder schemaId(SchemaId schemaId) {
            this.schemaId = schemaId;
            return this;
        }

        public final String getSchemaDefinition() {
            return schemaDefinition;
        }

        public final void setSchemaDefinition(String schemaDefinition) {
            this.schemaDefinition = schemaDefinition;
        }

        @Override
        public final Builder schemaDefinition(String schemaDefinition) {
            this.schemaDefinition = schemaDefinition;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterSchemaVersionRequest build() {
            return new RegisterSchemaVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
