/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTablesRequest extends GlueRequest implements ToCopyableBuilder<GetTablesRequest.Builder, GetTablesRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(GetTablesRequest::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(GetTablesRequest::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Expression").getter(getter(GetTablesRequest::expression)).setter(setter(Builder::expression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetTablesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetTablesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransactionId").getter(getter(GetTablesRequest::transactionId)).setter(setter(Builder::transactionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactionId").build()).build();

    private static final SdkField<Instant> QUERY_AS_OF_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("QueryAsOfTime").getter(getter(GetTablesRequest::queryAsOfTime)).setter(setter(Builder::queryAsOfTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryAsOfTime").build()).build();

    private static final SdkField<Boolean> INCLUDE_STATUS_DETAILS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeStatusDetails").getter(getter(GetTablesRequest::includeStatusDetails))
            .setter(setter(Builder::includeStatusDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeStatusDetails").build())
            .build();

    private static final SdkField<List<String>> ATTRIBUTES_TO_GET_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AttributesToGet")
            .getter(getter(GetTablesRequest::attributesToGetAsStrings))
            .setter(setter(Builder::attributesToGetWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributesToGet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            DATABASE_NAME_FIELD, EXPRESSION_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, TRANSACTION_ID_FIELD,
            QUERY_AS_OF_TIME_FIELD, INCLUDE_STATUS_DETAILS_FIELD, ATTRIBUTES_TO_GET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalogId;

    private final String databaseName;

    private final String expression;

    private final String nextToken;

    private final Integer maxResults;

    private final String transactionId;

    private final Instant queryAsOfTime;

    private final Boolean includeStatusDetails;

    private final List<String> attributesToGet;

    private GetTablesRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.expression = builder.expression;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.transactionId = builder.transactionId;
        this.queryAsOfTime = builder.queryAsOfTime;
        this.includeStatusDetails = builder.includeStatusDetails;
        this.attributesToGet = builder.attributesToGet;
    }

    /**
     * <p>
     * The ID of the Data Catalog where the tables reside. If none is provided, the Amazon Web Services account ID is
     * used by default.
     * </p>
     * 
     * @return The ID of the Data Catalog where the tables reside. If none is provided, the Amazon Web Services account
     *         ID is used by default.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * The database in the catalog whose tables to list. For Hive compatibility, this name is entirely lowercase.
     * </p>
     * 
     * @return The database in the catalog whose tables to list. For Hive compatibility, this name is entirely
     *         lowercase.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * A regular expression pattern. If present, only those tables whose names match the pattern are returned.
     * </p>
     * 
     * @return A regular expression pattern. If present, only those tables whose names match the pattern are returned.
     */
    public final String expression() {
        return expression;
    }

    /**
     * <p>
     * A continuation token, included if this is a continuation call.
     * </p>
     * 
     * @return A continuation token, included if this is a continuation call.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of tables to return in a single response.
     * </p>
     * 
     * @return The maximum number of tables to return in a single response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The transaction ID at which to read the table contents.
     * </p>
     * 
     * @return The transaction ID at which to read the table contents.
     */
    public final String transactionId() {
        return transactionId;
    }

    /**
     * <p>
     * The time as of when to read the table contents. If not set, the most recent transaction commit time will be used.
     * Cannot be specified along with <code>TransactionId</code>.
     * </p>
     * 
     * @return The time as of when to read the table contents. If not set, the most recent transaction commit time will
     *         be used. Cannot be specified along with <code>TransactionId</code>.
     */
    public final Instant queryAsOfTime() {
        return queryAsOfTime;
    }

    /**
     * <p>
     * Specifies whether to include status details related to a request to create or update an Glue Data Catalog view.
     * </p>
     * 
     * @return Specifies whether to include status details related to a request to create or update an Glue Data Catalog
     *         view.
     */
    public final Boolean includeStatusDetails() {
        return includeStatusDetails;
    }

    /**
     * <p>
     * Specifies the table fields returned by the <code>GetTables</code> call. This parameter doesn’t accept an empty
     * list. The request must include <code>NAME</code>.
     * </p>
     * <p>
     * The following are the valid combinations of values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NAME</code> - Names of all tables in the database.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NAME</code>, <code>TABLE_TYPE</code> - Names of all tables and the table types.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributesToGet} method.
     * </p>
     * 
     * @return Specifies the table fields returned by the <code>GetTables</code> call. This parameter doesn’t accept an
     *         empty list. The request must include <code>NAME</code>.</p>
     *         <p>
     *         The following are the valid combinations of values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NAME</code> - Names of all tables in the database.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NAME</code>, <code>TABLE_TYPE</code> - Names of all tables and the table types.
     *         </p>
     *         </li>
     */
    public final List<TableAttributes> attributesToGet() {
        return TableAttributesListCopier.copyStringToEnum(attributesToGet);
    }

    /**
     * For responses, this returns true if the service returned a value for the AttributesToGet property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttributesToGet() {
        return attributesToGet != null && !(attributesToGet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the table fields returned by the <code>GetTables</code> call. This parameter doesn’t accept an empty
     * list. The request must include <code>NAME</code>.
     * </p>
     * <p>
     * The following are the valid combinations of values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NAME</code> - Names of all tables in the database.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NAME</code>, <code>TABLE_TYPE</code> - Names of all tables and the table types.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributesToGet} method.
     * </p>
     * 
     * @return Specifies the table fields returned by the <code>GetTables</code> call. This parameter doesn’t accept an
     *         empty list. The request must include <code>NAME</code>.</p>
     *         <p>
     *         The following are the valid combinations of values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NAME</code> - Names of all tables in the database.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NAME</code>, <code>TABLE_TYPE</code> - Names of all tables and the table types.
     *         </p>
     *         </li>
     */
    public final List<String> attributesToGetAsStrings() {
        return attributesToGet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(transactionId());
        hashCode = 31 * hashCode + Objects.hashCode(queryAsOfTime());
        hashCode = 31 * hashCode + Objects.hashCode(includeStatusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributesToGet() ? attributesToGetAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTablesRequest)) {
            return false;
        }
        GetTablesRequest other = (GetTablesRequest) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(expression(), other.expression()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(transactionId(), other.transactionId())
                && Objects.equals(queryAsOfTime(), other.queryAsOfTime())
                && Objects.equals(includeStatusDetails(), other.includeStatusDetails())
                && hasAttributesToGet() == other.hasAttributesToGet()
                && Objects.equals(attributesToGetAsStrings(), other.attributesToGetAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTablesRequest").add("CatalogId", catalogId()).add("DatabaseName", databaseName())
                .add("Expression", expression()).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("TransactionId", transactionId()).add("QueryAsOfTime", queryAsOfTime())
                .add("IncludeStatusDetails", includeStatusDetails())
                .add("AttributesToGet", hasAttributesToGet() ? attributesToGetAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "Expression":
            return Optional.ofNullable(clazz.cast(expression()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "TransactionId":
            return Optional.ofNullable(clazz.cast(transactionId()));
        case "QueryAsOfTime":
            return Optional.ofNullable(clazz.cast(queryAsOfTime()));
        case "IncludeStatusDetails":
            return Optional.ofNullable(clazz.cast(includeStatusDetails()));
        case "AttributesToGet":
            return Optional.ofNullable(clazz.cast(attributesToGetAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CatalogId", CATALOG_ID_FIELD);
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("Expression", EXPRESSION_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("TransactionId", TRANSACTION_ID_FIELD);
        map.put("QueryAsOfTime", QUERY_AS_OF_TIME_FIELD);
        map.put("IncludeStatusDetails", INCLUDE_STATUS_DETAILS_FIELD);
        map.put("AttributesToGet", ATTRIBUTES_TO_GET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTablesRequest, T> g) {
        return obj -> g.apply((GetTablesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetTablesRequest> {
        /**
         * <p>
         * The ID of the Data Catalog where the tables reside. If none is provided, the Amazon Web Services account ID
         * is used by default.
         * </p>
         * 
         * @param catalogId
         *        The ID of the Data Catalog where the tables reside. If none is provided, the Amazon Web Services
         *        account ID is used by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * The database in the catalog whose tables to list. For Hive compatibility, this name is entirely lowercase.
         * </p>
         * 
         * @param databaseName
         *        The database in the catalog whose tables to list. For Hive compatibility, this name is entirely
         *        lowercase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * A regular expression pattern. If present, only those tables whose names match the pattern are returned.
         * </p>
         * 
         * @param expression
         *        A regular expression pattern. If present, only those tables whose names match the pattern are
         *        returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(String expression);

        /**
         * <p>
         * A continuation token, included if this is a continuation call.
         * </p>
         * 
         * @param nextToken
         *        A continuation token, included if this is a continuation call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of tables to return in a single response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of tables to return in a single response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The transaction ID at which to read the table contents.
         * </p>
         * 
         * @param transactionId
         *        The transaction ID at which to read the table contents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactionId(String transactionId);

        /**
         * <p>
         * The time as of when to read the table contents. If not set, the most recent transaction commit time will be
         * used. Cannot be specified along with <code>TransactionId</code>.
         * </p>
         * 
         * @param queryAsOfTime
         *        The time as of when to read the table contents. If not set, the most recent transaction commit time
         *        will be used. Cannot be specified along with <code>TransactionId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryAsOfTime(Instant queryAsOfTime);

        /**
         * <p>
         * Specifies whether to include status details related to a request to create or update an Glue Data Catalog
         * view.
         * </p>
         * 
         * @param includeStatusDetails
         *        Specifies whether to include status details related to a request to create or update an Glue Data
         *        Catalog view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeStatusDetails(Boolean includeStatusDetails);

        /**
         * <p>
         * Specifies the table fields returned by the <code>GetTables</code> call. This parameter doesn’t accept an
         * empty list. The request must include <code>NAME</code>.
         * </p>
         * <p>
         * The following are the valid combinations of values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NAME</code> - Names of all tables in the database.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NAME</code>, <code>TABLE_TYPE</code> - Names of all tables and the table types.
         * </p>
         * </li>
         * </ul>
         * 
         * @param attributesToGet
         *        Specifies the table fields returned by the <code>GetTables</code> call. This parameter doesn’t accept
         *        an empty list. The request must include <code>NAME</code>.</p>
         *        <p>
         *        The following are the valid combinations of values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NAME</code> - Names of all tables in the database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NAME</code>, <code>TABLE_TYPE</code> - Names of all tables and the table types.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesToGetWithStrings(Collection<String> attributesToGet);

        /**
         * <p>
         * Specifies the table fields returned by the <code>GetTables</code> call. This parameter doesn’t accept an
         * empty list. The request must include <code>NAME</code>.
         * </p>
         * <p>
         * The following are the valid combinations of values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NAME</code> - Names of all tables in the database.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NAME</code>, <code>TABLE_TYPE</code> - Names of all tables and the table types.
         * </p>
         * </li>
         * </ul>
         * 
         * @param attributesToGet
         *        Specifies the table fields returned by the <code>GetTables</code> call. This parameter doesn’t accept
         *        an empty list. The request must include <code>NAME</code>.</p>
         *        <p>
         *        The following are the valid combinations of values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NAME</code> - Names of all tables in the database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NAME</code>, <code>TABLE_TYPE</code> - Names of all tables and the table types.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesToGetWithStrings(String... attributesToGet);

        /**
         * <p>
         * Specifies the table fields returned by the <code>GetTables</code> call. This parameter doesn’t accept an
         * empty list. The request must include <code>NAME</code>.
         * </p>
         * <p>
         * The following are the valid combinations of values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NAME</code> - Names of all tables in the database.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NAME</code>, <code>TABLE_TYPE</code> - Names of all tables and the table types.
         * </p>
         * </li>
         * </ul>
         * 
         * @param attributesToGet
         *        Specifies the table fields returned by the <code>GetTables</code> call. This parameter doesn’t accept
         *        an empty list. The request must include <code>NAME</code>.</p>
         *        <p>
         *        The following are the valid combinations of values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NAME</code> - Names of all tables in the database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NAME</code>, <code>TABLE_TYPE</code> - Names of all tables and the table types.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesToGet(Collection<TableAttributes> attributesToGet);

        /**
         * <p>
         * Specifies the table fields returned by the <code>GetTables</code> call. This parameter doesn’t accept an
         * empty list. The request must include <code>NAME</code>.
         * </p>
         * <p>
         * The following are the valid combinations of values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NAME</code> - Names of all tables in the database.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NAME</code>, <code>TABLE_TYPE</code> - Names of all tables and the table types.
         * </p>
         * </li>
         * </ul>
         * 
         * @param attributesToGet
         *        Specifies the table fields returned by the <code>GetTables</code> call. This parameter doesn’t accept
         *        an empty list. The request must include <code>NAME</code>.</p>
         *        <p>
         *        The following are the valid combinations of values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NAME</code> - Names of all tables in the database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NAME</code>, <code>TABLE_TYPE</code> - Names of all tables and the table types.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesToGet(TableAttributes... attributesToGet);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String catalogId;

        private String databaseName;

        private String expression;

        private String nextToken;

        private Integer maxResults;

        private String transactionId;

        private Instant queryAsOfTime;

        private Boolean includeStatusDetails;

        private List<String> attributesToGet = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTablesRequest model) {
            super(model);
            catalogId(model.catalogId);
            databaseName(model.databaseName);
            expression(model.expression);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            transactionId(model.transactionId);
            queryAsOfTime(model.queryAsOfTime);
            includeStatusDetails(model.includeStatusDetails);
            attributesToGetWithStrings(model.attributesToGet);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getExpression() {
            return expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getTransactionId() {
            return transactionId;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final Instant getQueryAsOfTime() {
            return queryAsOfTime;
        }

        public final void setQueryAsOfTime(Instant queryAsOfTime) {
            this.queryAsOfTime = queryAsOfTime;
        }

        @Override
        public final Builder queryAsOfTime(Instant queryAsOfTime) {
            this.queryAsOfTime = queryAsOfTime;
            return this;
        }

        public final Boolean getIncludeStatusDetails() {
            return includeStatusDetails;
        }

        public final void setIncludeStatusDetails(Boolean includeStatusDetails) {
            this.includeStatusDetails = includeStatusDetails;
        }

        @Override
        public final Builder includeStatusDetails(Boolean includeStatusDetails) {
            this.includeStatusDetails = includeStatusDetails;
            return this;
        }

        public final Collection<String> getAttributesToGet() {
            if (attributesToGet instanceof SdkAutoConstructList) {
                return null;
            }
            return attributesToGet;
        }

        public final void setAttributesToGet(Collection<String> attributesToGet) {
            this.attributesToGet = TableAttributesListCopier.copy(attributesToGet);
        }

        @Override
        public final Builder attributesToGetWithStrings(Collection<String> attributesToGet) {
            this.attributesToGet = TableAttributesListCopier.copy(attributesToGet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToGetWithStrings(String... attributesToGet) {
            attributesToGetWithStrings(Arrays.asList(attributesToGet));
            return this;
        }

        @Override
        public final Builder attributesToGet(Collection<TableAttributes> attributesToGet) {
            this.attributesToGet = TableAttributesListCopier.copyEnumToString(attributesToGet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToGet(TableAttributes... attributesToGet) {
            attributesToGet(Arrays.asList(attributesToGet));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTablesRequest build() {
            return new GetTablesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
