/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines column statistics supported for floating-point number data columns.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DoubleColumnStatisticsData implements SdkPojo, Serializable,
        ToCopyableBuilder<DoubleColumnStatisticsData.Builder, DoubleColumnStatisticsData> {
    private static final SdkField<Double> MINIMUM_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MinimumValue").getter(getter(DoubleColumnStatisticsData::minimumValue))
            .setter(setter(Builder::minimumValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumValue").build()).build();

    private static final SdkField<Double> MAXIMUM_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MaximumValue").getter(getter(DoubleColumnStatisticsData::maximumValue))
            .setter(setter(Builder::maximumValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumValue").build()).build();

    private static final SdkField<Long> NUMBER_OF_NULLS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("NumberOfNulls").getter(getter(DoubleColumnStatisticsData::numberOfNulls))
            .setter(setter(Builder::numberOfNulls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfNulls").build()).build();

    private static final SdkField<Long> NUMBER_OF_DISTINCT_VALUES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("NumberOfDistinctValues").getter(getter(DoubleColumnStatisticsData::numberOfDistinctValues))
            .setter(setter(Builder::numberOfDistinctValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfDistinctValues").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MINIMUM_VALUE_FIELD,
            MAXIMUM_VALUE_FIELD, NUMBER_OF_NULLS_FIELD, NUMBER_OF_DISTINCT_VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double minimumValue;

    private final Double maximumValue;

    private final Long numberOfNulls;

    private final Long numberOfDistinctValues;

    private DoubleColumnStatisticsData(BuilderImpl builder) {
        this.minimumValue = builder.minimumValue;
        this.maximumValue = builder.maximumValue;
        this.numberOfNulls = builder.numberOfNulls;
        this.numberOfDistinctValues = builder.numberOfDistinctValues;
    }

    /**
     * <p>
     * The lowest value in the column.
     * </p>
     * 
     * @return The lowest value in the column.
     */
    public final Double minimumValue() {
        return minimumValue;
    }

    /**
     * <p>
     * The highest value in the column.
     * </p>
     * 
     * @return The highest value in the column.
     */
    public final Double maximumValue() {
        return maximumValue;
    }

    /**
     * <p>
     * The number of null values in the column.
     * </p>
     * 
     * @return The number of null values in the column.
     */
    public final Long numberOfNulls() {
        return numberOfNulls;
    }

    /**
     * <p>
     * The number of distinct values in a column.
     * </p>
     * 
     * @return The number of distinct values in a column.
     */
    public final Long numberOfDistinctValues() {
        return numberOfDistinctValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minimumValue());
        hashCode = 31 * hashCode + Objects.hashCode(maximumValue());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfNulls());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfDistinctValues());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DoubleColumnStatisticsData)) {
            return false;
        }
        DoubleColumnStatisticsData other = (DoubleColumnStatisticsData) obj;
        return Objects.equals(minimumValue(), other.minimumValue()) && Objects.equals(maximumValue(), other.maximumValue())
                && Objects.equals(numberOfNulls(), other.numberOfNulls())
                && Objects.equals(numberOfDistinctValues(), other.numberOfDistinctValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DoubleColumnStatisticsData").add("MinimumValue", minimumValue())
                .add("MaximumValue", maximumValue()).add("NumberOfNulls", numberOfNulls())
                .add("NumberOfDistinctValues", numberOfDistinctValues()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinimumValue":
            return Optional.ofNullable(clazz.cast(minimumValue()));
        case "MaximumValue":
            return Optional.ofNullable(clazz.cast(maximumValue()));
        case "NumberOfNulls":
            return Optional.ofNullable(clazz.cast(numberOfNulls()));
        case "NumberOfDistinctValues":
            return Optional.ofNullable(clazz.cast(numberOfDistinctValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MinimumValue", MINIMUM_VALUE_FIELD);
        map.put("MaximumValue", MAXIMUM_VALUE_FIELD);
        map.put("NumberOfNulls", NUMBER_OF_NULLS_FIELD);
        map.put("NumberOfDistinctValues", NUMBER_OF_DISTINCT_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DoubleColumnStatisticsData, T> g) {
        return obj -> g.apply((DoubleColumnStatisticsData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DoubleColumnStatisticsData> {
        /**
         * <p>
         * The lowest value in the column.
         * </p>
         * 
         * @param minimumValue
         *        The lowest value in the column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumValue(Double minimumValue);

        /**
         * <p>
         * The highest value in the column.
         * </p>
         * 
         * @param maximumValue
         *        The highest value in the column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumValue(Double maximumValue);

        /**
         * <p>
         * The number of null values in the column.
         * </p>
         * 
         * @param numberOfNulls
         *        The number of null values in the column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfNulls(Long numberOfNulls);

        /**
         * <p>
         * The number of distinct values in a column.
         * </p>
         * 
         * @param numberOfDistinctValues
         *        The number of distinct values in a column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfDistinctValues(Long numberOfDistinctValues);
    }

    static final class BuilderImpl implements Builder {
        private Double minimumValue;

        private Double maximumValue;

        private Long numberOfNulls;

        private Long numberOfDistinctValues;

        private BuilderImpl() {
        }

        private BuilderImpl(DoubleColumnStatisticsData model) {
            minimumValue(model.minimumValue);
            maximumValue(model.maximumValue);
            numberOfNulls(model.numberOfNulls);
            numberOfDistinctValues(model.numberOfDistinctValues);
        }

        public final Double getMinimumValue() {
            return minimumValue;
        }

        public final void setMinimumValue(Double minimumValue) {
            this.minimumValue = minimumValue;
        }

        @Override
        public final Builder minimumValue(Double minimumValue) {
            this.minimumValue = minimumValue;
            return this;
        }

        public final Double getMaximumValue() {
            return maximumValue;
        }

        public final void setMaximumValue(Double maximumValue) {
            this.maximumValue = maximumValue;
        }

        @Override
        public final Builder maximumValue(Double maximumValue) {
            this.maximumValue = maximumValue;
            return this;
        }

        public final Long getNumberOfNulls() {
            return numberOfNulls;
        }

        public final void setNumberOfNulls(Long numberOfNulls) {
            this.numberOfNulls = numberOfNulls;
        }

        @Override
        public final Builder numberOfNulls(Long numberOfNulls) {
            this.numberOfNulls = numberOfNulls;
            return this;
        }

        public final Long getNumberOfDistinctValues() {
            return numberOfDistinctValues;
        }

        public final void setNumberOfDistinctValues(Long numberOfDistinctValues) {
            this.numberOfDistinctValues = numberOfDistinctValues;
        }

        @Override
        public final Builder numberOfDistinctValues(Long numberOfDistinctValues) {
            this.numberOfDistinctValues = numberOfDistinctValues;
            return this;
        }

        @Override
        public DoubleColumnStatisticsData build() {
            return new DoubleColumnStatisticsData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
