/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.SourceControlAuthStrategy;
import software.amazon.awssdk.services.glue.model.SourceControlProvider;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSourceControlFromJobRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, UpdateSourceControlFromJobRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobName").getter(UpdateSourceControlFromJobRequest.getter(UpdateSourceControlFromJobRequest::jobName)).setter(UpdateSourceControlFromJobRequest.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()}).build();
    private static final SdkField<String> PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Provider").getter(UpdateSourceControlFromJobRequest.getter(UpdateSourceControlFromJobRequest::providerAsString)).setter(UpdateSourceControlFromJobRequest.setter(Builder::provider)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Provider").build()}).build();
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RepositoryName").getter(UpdateSourceControlFromJobRequest.getter(UpdateSourceControlFromJobRequest::repositoryName)).setter(UpdateSourceControlFromJobRequest.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryName").build()}).build();
    private static final SdkField<String> REPOSITORY_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RepositoryOwner").getter(UpdateSourceControlFromJobRequest.getter(UpdateSourceControlFromJobRequest::repositoryOwner)).setter(UpdateSourceControlFromJobRequest.setter(Builder::repositoryOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryOwner").build()}).build();
    private static final SdkField<String> BRANCH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BranchName").getter(UpdateSourceControlFromJobRequest.getter(UpdateSourceControlFromJobRequest::branchName)).setter(UpdateSourceControlFromJobRequest.setter(Builder::branchName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BranchName").build()}).build();
    private static final SdkField<String> FOLDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Folder").getter(UpdateSourceControlFromJobRequest.getter(UpdateSourceControlFromJobRequest::folder)).setter(UpdateSourceControlFromJobRequest.setter(Builder::folder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Folder").build()}).build();
    private static final SdkField<String> COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CommitId").getter(UpdateSourceControlFromJobRequest.getter(UpdateSourceControlFromJobRequest::commitId)).setter(UpdateSourceControlFromJobRequest.setter(Builder::commitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommitId").build()}).build();
    private static final SdkField<String> AUTH_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthStrategy").getter(UpdateSourceControlFromJobRequest.getter(UpdateSourceControlFromJobRequest::authStrategyAsString)).setter(UpdateSourceControlFromJobRequest.setter(Builder::authStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthStrategy").build()}).build();
    private static final SdkField<String> AUTH_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthToken").getter(UpdateSourceControlFromJobRequest.getter(UpdateSourceControlFromJobRequest::authToken)).setter(UpdateSourceControlFromJobRequest.setter(Builder::authToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD, PROVIDER_FIELD, REPOSITORY_NAME_FIELD, REPOSITORY_OWNER_FIELD, BRANCH_NAME_FIELD, FOLDER_FIELD, COMMIT_ID_FIELD, AUTH_STRATEGY_FIELD, AUTH_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateSourceControlFromJobRequest.memberNameToFieldInitializer();
    private final String jobName;
    private final String provider;
    private final String repositoryName;
    private final String repositoryOwner;
    private final String branchName;
    private final String folder;
    private final String commitId;
    private final String authStrategy;
    private final String authToken;

    private UpdateSourceControlFromJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.provider = builder.provider;
        this.repositoryName = builder.repositoryName;
        this.repositoryOwner = builder.repositoryOwner;
        this.branchName = builder.branchName;
        this.folder = builder.folder;
        this.commitId = builder.commitId;
        this.authStrategy = builder.authStrategy;
        this.authToken = builder.authToken;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final SourceControlProvider provider() {
        return SourceControlProvider.fromValue(this.provider);
    }

    public final String providerAsString() {
        return this.provider;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public final String repositoryOwner() {
        return this.repositoryOwner;
    }

    public final String branchName() {
        return this.branchName;
    }

    public final String folder() {
        return this.folder;
    }

    public final String commitId() {
        return this.commitId;
    }

    public final SourceControlAuthStrategy authStrategy() {
        return SourceControlAuthStrategy.fromValue(this.authStrategy);
    }

    public final String authStrategyAsString() {
        return this.authStrategy;
    }

    public final String authToken() {
        return this.authToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.branchName());
        hashCode = 31 * hashCode + Objects.hashCode(this.folder());
        hashCode = 31 * hashCode + Objects.hashCode(this.commitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.authStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.authToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSourceControlFromJobRequest)) {
            return false;
        }
        UpdateSourceControlFromJobRequest other = (UpdateSourceControlFromJobRequest)((Object)obj);
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.providerAsString(), other.providerAsString()) && Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.repositoryOwner(), other.repositoryOwner()) && Objects.equals(this.branchName(), other.branchName()) && Objects.equals(this.folder(), other.folder()) && Objects.equals(this.commitId(), other.commitId()) && Objects.equals(this.authStrategyAsString(), other.authStrategyAsString()) && Objects.equals(this.authToken(), other.authToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSourceControlFromJobRequest").add("JobName", (Object)this.jobName()).add("Provider", (Object)this.providerAsString()).add("RepositoryName", (Object)this.repositoryName()).add("RepositoryOwner", (Object)this.repositoryOwner()).add("BranchName", (Object)this.branchName()).add("Folder", (Object)this.folder()).add("CommitId", (Object)this.commitId()).add("AuthStrategy", (Object)this.authStrategyAsString()).add("AuthToken", (Object)this.authToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "Provider": {
                return Optional.ofNullable(clazz.cast(this.providerAsString()));
            }
            case "RepositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "RepositoryOwner": {
                return Optional.ofNullable(clazz.cast(this.repositoryOwner()));
            }
            case "BranchName": {
                return Optional.ofNullable(clazz.cast(this.branchName()));
            }
            case "Folder": {
                return Optional.ofNullable(clazz.cast(this.folder()));
            }
            case "CommitId": {
                return Optional.ofNullable(clazz.cast(this.commitId()));
            }
            case "AuthStrategy": {
                return Optional.ofNullable(clazz.cast(this.authStrategyAsString()));
            }
            case "AuthToken": {
                return Optional.ofNullable(clazz.cast(this.authToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("JobName", JOB_NAME_FIELD);
        map.put("Provider", PROVIDER_FIELD);
        map.put("RepositoryName", REPOSITORY_NAME_FIELD);
        map.put("RepositoryOwner", REPOSITORY_OWNER_FIELD);
        map.put("BranchName", BRANCH_NAME_FIELD);
        map.put("Folder", FOLDER_FIELD);
        map.put("CommitId", COMMIT_ID_FIELD);
        map.put("AuthStrategy", AUTH_STRATEGY_FIELD);
        map.put("AuthToken", AUTH_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSourceControlFromJobRequest, T> g) {
        return obj -> g.apply((UpdateSourceControlFromJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String jobName;
        private String provider;
        private String repositoryName;
        private String repositoryOwner;
        private String branchName;
        private String folder;
        private String commitId;
        private String authStrategy;
        private String authToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSourceControlFromJobRequest model) {
            super(model);
            this.jobName(model.jobName);
            this.provider(model.provider);
            this.repositoryName(model.repositoryName);
            this.repositoryOwner(model.repositoryOwner);
            this.branchName(model.branchName);
            this.folder(model.folder);
            this.commitId(model.commitId);
            this.authStrategy(model.authStrategy);
            this.authToken(model.authToken);
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getProvider() {
            return this.provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        @Override
        public final Builder provider(SourceControlProvider provider) {
            this.provider(provider == null ? null : provider.toString());
            return this;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getRepositoryOwner() {
            return this.repositoryOwner;
        }

        public final void setRepositoryOwner(String repositoryOwner) {
            this.repositoryOwner = repositoryOwner;
        }

        @Override
        public final Builder repositoryOwner(String repositoryOwner) {
            this.repositoryOwner = repositoryOwner;
            return this;
        }

        public final String getBranchName() {
            return this.branchName;
        }

        public final void setBranchName(String branchName) {
            this.branchName = branchName;
        }

        @Override
        public final Builder branchName(String branchName) {
            this.branchName = branchName;
            return this;
        }

        public final String getFolder() {
            return this.folder;
        }

        public final void setFolder(String folder) {
            this.folder = folder;
        }

        @Override
        public final Builder folder(String folder) {
            this.folder = folder;
            return this;
        }

        public final String getCommitId() {
            return this.commitId;
        }

        public final void setCommitId(String commitId) {
            this.commitId = commitId;
        }

        @Override
        public final Builder commitId(String commitId) {
            this.commitId = commitId;
            return this;
        }

        public final String getAuthStrategy() {
            return this.authStrategy;
        }

        public final void setAuthStrategy(String authStrategy) {
            this.authStrategy = authStrategy;
        }

        @Override
        public final Builder authStrategy(String authStrategy) {
            this.authStrategy = authStrategy;
            return this;
        }

        @Override
        public final Builder authStrategy(SourceControlAuthStrategy authStrategy) {
            this.authStrategy(authStrategy == null ? null : authStrategy.toString());
            return this;
        }

        public final String getAuthToken() {
            return this.authToken;
        }

        public final void setAuthToken(String authToken) {
            this.authToken = authToken;
        }

        @Override
        public final Builder authToken(String authToken) {
            this.authToken = authToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSourceControlFromJobRequest build() {
            return new UpdateSourceControlFromJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSourceControlFromJobRequest> {
        public Builder jobName(String var1);

        public Builder provider(String var1);

        public Builder provider(SourceControlProvider var1);

        public Builder repositoryName(String var1);

        public Builder repositoryOwner(String var1);

        public Builder branchName(String var1);

        public Builder folder(String var1);

        public Builder commitId(String var1);

        public Builder authStrategy(String var1);

        public Builder authStrategy(SourceControlAuthStrategy var1);

        public Builder authToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

