/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateClassifierRequest extends GlueRequest implements
        ToCopyableBuilder<UpdateClassifierRequest.Builder, UpdateClassifierRequest> {
    private static final SdkField<UpdateGrokClassifierRequest> GROK_CLASSIFIER_FIELD = SdkField
            .<UpdateGrokClassifierRequest> builder(MarshallingType.SDK_POJO).memberName("GrokClassifier")
            .getter(getter(UpdateClassifierRequest::grokClassifier)).setter(setter(Builder::grokClassifier))
            .constructor(UpdateGrokClassifierRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrokClassifier").build()).build();

    private static final SdkField<UpdateXMLClassifierRequest> XML_CLASSIFIER_FIELD = SdkField
            .<UpdateXMLClassifierRequest> builder(MarshallingType.SDK_POJO).memberName("XMLClassifier")
            .getter(getter(UpdateClassifierRequest::xmlClassifier)).setter(setter(Builder::xmlClassifier))
            .constructor(UpdateXMLClassifierRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XMLClassifier").build()).build();

    private static final SdkField<UpdateJsonClassifierRequest> JSON_CLASSIFIER_FIELD = SdkField
            .<UpdateJsonClassifierRequest> builder(MarshallingType.SDK_POJO).memberName("JsonClassifier")
            .getter(getter(UpdateClassifierRequest::jsonClassifier)).setter(setter(Builder::jsonClassifier))
            .constructor(UpdateJsonClassifierRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JsonClassifier").build()).build();

    private static final SdkField<UpdateCsvClassifierRequest> CSV_CLASSIFIER_FIELD = SdkField
            .<UpdateCsvClassifierRequest> builder(MarshallingType.SDK_POJO).memberName("CsvClassifier")
            .getter(getter(UpdateClassifierRequest::csvClassifier)).setter(setter(Builder::csvClassifier))
            .constructor(UpdateCsvClassifierRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CsvClassifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROK_CLASSIFIER_FIELD,
            XML_CLASSIFIER_FIELD, JSON_CLASSIFIER_FIELD, CSV_CLASSIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final UpdateGrokClassifierRequest grokClassifier;

    private final UpdateXMLClassifierRequest xmlClassifier;

    private final UpdateJsonClassifierRequest jsonClassifier;

    private final UpdateCsvClassifierRequest csvClassifier;

    private UpdateClassifierRequest(BuilderImpl builder) {
        super(builder);
        this.grokClassifier = builder.grokClassifier;
        this.xmlClassifier = builder.xmlClassifier;
        this.jsonClassifier = builder.jsonClassifier;
        this.csvClassifier = builder.csvClassifier;
    }

    /**
     * <p>
     * A <code>GrokClassifier</code> object with updated fields.
     * </p>
     * 
     * @return A <code>GrokClassifier</code> object with updated fields.
     */
    public final UpdateGrokClassifierRequest grokClassifier() {
        return grokClassifier;
    }

    /**
     * <p>
     * An <code>XMLClassifier</code> object with updated fields.
     * </p>
     * 
     * @return An <code>XMLClassifier</code> object with updated fields.
     */
    public final UpdateXMLClassifierRequest xmlClassifier() {
        return xmlClassifier;
    }

    /**
     * <p>
     * A <code>JsonClassifier</code> object with updated fields.
     * </p>
     * 
     * @return A <code>JsonClassifier</code> object with updated fields.
     */
    public final UpdateJsonClassifierRequest jsonClassifier() {
        return jsonClassifier;
    }

    /**
     * <p>
     * A <code>CsvClassifier</code> object with updated fields.
     * </p>
     * 
     * @return A <code>CsvClassifier</code> object with updated fields.
     */
    public final UpdateCsvClassifierRequest csvClassifier() {
        return csvClassifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(grokClassifier());
        hashCode = 31 * hashCode + Objects.hashCode(xmlClassifier());
        hashCode = 31 * hashCode + Objects.hashCode(jsonClassifier());
        hashCode = 31 * hashCode + Objects.hashCode(csvClassifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateClassifierRequest)) {
            return false;
        }
        UpdateClassifierRequest other = (UpdateClassifierRequest) obj;
        return Objects.equals(grokClassifier(), other.grokClassifier()) && Objects.equals(xmlClassifier(), other.xmlClassifier())
                && Objects.equals(jsonClassifier(), other.jsonClassifier())
                && Objects.equals(csvClassifier(), other.csvClassifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateClassifierRequest").add("GrokClassifier", grokClassifier())
                .add("XMLClassifier", xmlClassifier()).add("JsonClassifier", jsonClassifier())
                .add("CsvClassifier", csvClassifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GrokClassifier":
            return Optional.ofNullable(clazz.cast(grokClassifier()));
        case "XMLClassifier":
            return Optional.ofNullable(clazz.cast(xmlClassifier()));
        case "JsonClassifier":
            return Optional.ofNullable(clazz.cast(jsonClassifier()));
        case "CsvClassifier":
            return Optional.ofNullable(clazz.cast(csvClassifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GrokClassifier", GROK_CLASSIFIER_FIELD);
        map.put("XMLClassifier", XML_CLASSIFIER_FIELD);
        map.put("JsonClassifier", JSON_CLASSIFIER_FIELD);
        map.put("CsvClassifier", CSV_CLASSIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateClassifierRequest, T> g) {
        return obj -> g.apply((UpdateClassifierRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateClassifierRequest> {
        /**
         * <p>
         * A <code>GrokClassifier</code> object with updated fields.
         * </p>
         * 
         * @param grokClassifier
         *        A <code>GrokClassifier</code> object with updated fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grokClassifier(UpdateGrokClassifierRequest grokClassifier);

        /**
         * <p>
         * A <code>GrokClassifier</code> object with updated fields.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateGrokClassifierRequest.Builder}
         * avoiding the need to create one manually via {@link UpdateGrokClassifierRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateGrokClassifierRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #grokClassifier(UpdateGrokClassifierRequest)}.
         * 
         * @param grokClassifier
         *        a consumer that will call methods on {@link UpdateGrokClassifierRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #grokClassifier(UpdateGrokClassifierRequest)
         */
        default Builder grokClassifier(Consumer<UpdateGrokClassifierRequest.Builder> grokClassifier) {
            return grokClassifier(UpdateGrokClassifierRequest.builder().applyMutation(grokClassifier).build());
        }

        /**
         * <p>
         * An <code>XMLClassifier</code> object with updated fields.
         * </p>
         * 
         * @param xmlClassifier
         *        An <code>XMLClassifier</code> object with updated fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xmlClassifier(UpdateXMLClassifierRequest xmlClassifier);

        /**
         * <p>
         * An <code>XMLClassifier</code> object with updated fields.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateXMLClassifierRequest.Builder}
         * avoiding the need to create one manually via {@link UpdateXMLClassifierRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateXMLClassifierRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #xmlClassifier(UpdateXMLClassifierRequest)}.
         * 
         * @param xmlClassifier
         *        a consumer that will call methods on {@link UpdateXMLClassifierRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #xmlClassifier(UpdateXMLClassifierRequest)
         */
        default Builder xmlClassifier(Consumer<UpdateXMLClassifierRequest.Builder> xmlClassifier) {
            return xmlClassifier(UpdateXMLClassifierRequest.builder().applyMutation(xmlClassifier).build());
        }

        /**
         * <p>
         * A <code>JsonClassifier</code> object with updated fields.
         * </p>
         * 
         * @param jsonClassifier
         *        A <code>JsonClassifier</code> object with updated fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jsonClassifier(UpdateJsonClassifierRequest jsonClassifier);

        /**
         * <p>
         * A <code>JsonClassifier</code> object with updated fields.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateJsonClassifierRequest.Builder}
         * avoiding the need to create one manually via {@link UpdateJsonClassifierRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateJsonClassifierRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #jsonClassifier(UpdateJsonClassifierRequest)}.
         * 
         * @param jsonClassifier
         *        a consumer that will call methods on {@link UpdateJsonClassifierRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jsonClassifier(UpdateJsonClassifierRequest)
         */
        default Builder jsonClassifier(Consumer<UpdateJsonClassifierRequest.Builder> jsonClassifier) {
            return jsonClassifier(UpdateJsonClassifierRequest.builder().applyMutation(jsonClassifier).build());
        }

        /**
         * <p>
         * A <code>CsvClassifier</code> object with updated fields.
         * </p>
         * 
         * @param csvClassifier
         *        A <code>CsvClassifier</code> object with updated fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder csvClassifier(UpdateCsvClassifierRequest csvClassifier);

        /**
         * <p>
         * A <code>CsvClassifier</code> object with updated fields.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateCsvClassifierRequest.Builder}
         * avoiding the need to create one manually via {@link UpdateCsvClassifierRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateCsvClassifierRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #csvClassifier(UpdateCsvClassifierRequest)}.
         * 
         * @param csvClassifier
         *        a consumer that will call methods on {@link UpdateCsvClassifierRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #csvClassifier(UpdateCsvClassifierRequest)
         */
        default Builder csvClassifier(Consumer<UpdateCsvClassifierRequest.Builder> csvClassifier) {
            return csvClassifier(UpdateCsvClassifierRequest.builder().applyMutation(csvClassifier).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private UpdateGrokClassifierRequest grokClassifier;

        private UpdateXMLClassifierRequest xmlClassifier;

        private UpdateJsonClassifierRequest jsonClassifier;

        private UpdateCsvClassifierRequest csvClassifier;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateClassifierRequest model) {
            super(model);
            grokClassifier(model.grokClassifier);
            xmlClassifier(model.xmlClassifier);
            jsonClassifier(model.jsonClassifier);
            csvClassifier(model.csvClassifier);
        }

        public final UpdateGrokClassifierRequest.Builder getGrokClassifier() {
            return grokClassifier != null ? grokClassifier.toBuilder() : null;
        }

        public final void setGrokClassifier(UpdateGrokClassifierRequest.BuilderImpl grokClassifier) {
            this.grokClassifier = grokClassifier != null ? grokClassifier.build() : null;
        }

        @Override
        public final Builder grokClassifier(UpdateGrokClassifierRequest grokClassifier) {
            this.grokClassifier = grokClassifier;
            return this;
        }

        public final UpdateXMLClassifierRequest.Builder getXmlClassifier() {
            return xmlClassifier != null ? xmlClassifier.toBuilder() : null;
        }

        public final void setXmlClassifier(UpdateXMLClassifierRequest.BuilderImpl xmlClassifier) {
            this.xmlClassifier = xmlClassifier != null ? xmlClassifier.build() : null;
        }

        @Override
        public final Builder xmlClassifier(UpdateXMLClassifierRequest xmlClassifier) {
            this.xmlClassifier = xmlClassifier;
            return this;
        }

        public final UpdateJsonClassifierRequest.Builder getJsonClassifier() {
            return jsonClassifier != null ? jsonClassifier.toBuilder() : null;
        }

        public final void setJsonClassifier(UpdateJsonClassifierRequest.BuilderImpl jsonClassifier) {
            this.jsonClassifier = jsonClassifier != null ? jsonClassifier.build() : null;
        }

        @Override
        public final Builder jsonClassifier(UpdateJsonClassifierRequest jsonClassifier) {
            this.jsonClassifier = jsonClassifier;
            return this;
        }

        public final UpdateCsvClassifierRequest.Builder getCsvClassifier() {
            return csvClassifier != null ? csvClassifier.toBuilder() : null;
        }

        public final void setCsvClassifier(UpdateCsvClassifierRequest.BuilderImpl csvClassifier) {
            this.csvClassifier = csvClassifier != null ? csvClassifier.build() : null;
        }

        @Override
        public final Builder csvClassifier(UpdateCsvClassifierRequest csvClassifier) {
            this.csvClassifier = csvClassifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateClassifierRequest build() {
            return new UpdateClassifierRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
