/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a single entry in the list of values for <code>SqlAliases</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SqlAlias implements SdkPojo, Serializable, ToCopyableBuilder<SqlAlias.Builder, SqlAlias> {
    private static final SdkField<String> FROM_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("From")
            .getter(getter(SqlAlias::from)).setter(setter(Builder::from))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("From").build()).build();

    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Alias")
            .getter(getter(SqlAlias::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_FIELD, ALIAS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String from;

    private final String alias;

    private SqlAlias(BuilderImpl builder) {
        this.from = builder.from;
        this.alias = builder.alias;
    }

    /**
     * <p>
     * A table, or a column in a table.
     * </p>
     * 
     * @return A table, or a column in a table.
     */
    public final String from() {
        return from;
    }

    /**
     * <p>
     * A temporary name given to a table, or a column in a table.
     * </p>
     * 
     * @return A temporary name given to a table, or a column in a table.
     */
    public final String alias() {
        return alias;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(from());
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SqlAlias)) {
            return false;
        }
        SqlAlias other = (SqlAlias) obj;
        return Objects.equals(from(), other.from()) && Objects.equals(alias(), other.alias());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SqlAlias").add("From", from()).add("Alias", alias()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "From":
            return Optional.ofNullable(clazz.cast(from()));
        case "Alias":
            return Optional.ofNullable(clazz.cast(alias()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("From", FROM_FIELD);
        map.put("Alias", ALIAS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SqlAlias, T> g) {
        return obj -> g.apply((SqlAlias) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SqlAlias> {
        /**
         * <p>
         * A table, or a column in a table.
         * </p>
         * 
         * @param from
         *        A table, or a column in a table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder from(String from);

        /**
         * <p>
         * A temporary name given to a table, or a column in a table.
         * </p>
         * 
         * @param alias
         *        A temporary name given to a table, or a column in a table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);
    }

    static final class BuilderImpl implements Builder {
        private String from;

        private String alias;

        private BuilderImpl() {
        }

        private BuilderImpl(SqlAlias model) {
            from(model.from);
            alias(model.alias);
        }

        public final String getFrom() {
            return from;
        }

        public final void setFrom(String from) {
            this.from = from;
        }

        @Override
        public final Builder from(String from) {
            this.from = from;
            return this;
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        @Override
        public SqlAlias build() {
            return new SqlAlias(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
