/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies how Amazon Simple Storage Service (Amazon S3) data should be encrypted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3Encryption implements SdkPojo, Serializable, ToCopyableBuilder<S3Encryption.Builder, S3Encryption> {
    private static final SdkField<String> S3_ENCRYPTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3EncryptionMode").getter(getter(S3Encryption::s3EncryptionModeAsString))
            .setter(setter(Builder::s3EncryptionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3EncryptionMode").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyArn").getter(getter(S3Encryption::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_ENCRYPTION_MODE_FIELD,
            KMS_KEY_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String s3EncryptionMode;

    private final String kmsKeyArn;

    private S3Encryption(BuilderImpl builder) {
        this.s3EncryptionMode = builder.s3EncryptionMode;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    /**
     * <p>
     * The encryption mode to use for Amazon S3 data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3EncryptionMode}
     * will return {@link S3EncryptionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #s3EncryptionModeAsString}.
     * </p>
     * 
     * @return The encryption mode to use for Amazon S3 data.
     * @see S3EncryptionMode
     */
    public final S3EncryptionMode s3EncryptionMode() {
        return S3EncryptionMode.fromValue(s3EncryptionMode);
    }

    /**
     * <p>
     * The encryption mode to use for Amazon S3 data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3EncryptionMode}
     * will return {@link S3EncryptionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #s3EncryptionModeAsString}.
     * </p>
     * 
     * @return The encryption mode to use for Amazon S3 data.
     * @see S3EncryptionMode
     */
    public final String s3EncryptionModeAsString() {
        return s3EncryptionMode;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3EncryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Encryption)) {
            return false;
        }
        S3Encryption other = (S3Encryption) obj;
        return Objects.equals(s3EncryptionModeAsString(), other.s3EncryptionModeAsString())
                && Objects.equals(kmsKeyArn(), other.kmsKeyArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3Encryption").add("S3EncryptionMode", s3EncryptionModeAsString()).add("KmsKeyArn", kmsKeyArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3EncryptionMode":
            return Optional.ofNullable(clazz.cast(s3EncryptionModeAsString()));
        case "KmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("S3EncryptionMode", S3_ENCRYPTION_MODE_FIELD);
        map.put("KmsKeyArn", KMS_KEY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3Encryption, T> g) {
        return obj -> g.apply((S3Encryption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3Encryption> {
        /**
         * <p>
         * The encryption mode to use for Amazon S3 data.
         * </p>
         * 
         * @param s3EncryptionMode
         *        The encryption mode to use for Amazon S3 data.
         * @see S3EncryptionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3EncryptionMode
         */
        Builder s3EncryptionMode(String s3EncryptionMode);

        /**
         * <p>
         * The encryption mode to use for Amazon S3 data.
         * </p>
         * 
         * @param s3EncryptionMode
         *        The encryption mode to use for Amazon S3 data.
         * @see S3EncryptionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3EncryptionMode
         */
        Builder s3EncryptionMode(S3EncryptionMode s3EncryptionMode);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
         * </p>
         * 
         * @param kmsKeyArn
         *        The Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);
    }

    static final class BuilderImpl implements Builder {
        private String s3EncryptionMode;

        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Encryption model) {
            s3EncryptionMode(model.s3EncryptionMode);
            kmsKeyArn(model.kmsKeyArn);
        }

        public final String getS3EncryptionMode() {
            return s3EncryptionMode;
        }

        public final void setS3EncryptionMode(String s3EncryptionMode) {
            this.s3EncryptionMode = s3EncryptionMode;
        }

        @Override
        public final Builder s3EncryptionMode(String s3EncryptionMode) {
            this.s3EncryptionMode = s3EncryptionMode;
            return this;
        }

        @Override
        public final Builder s3EncryptionMode(S3EncryptionMode s3EncryptionMode) {
            this.s3EncryptionMode(s3EncryptionMode == null ? null : s3EncryptionMode.toString());
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        @Override
        public S3Encryption build() {
            return new S3Encryption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
