/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the mapping of data property keys.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Mapping implements SdkPojo, Serializable, ToCopyableBuilder<Mapping.Builder, Mapping> {
    private static final SdkField<String> TO_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ToKey")
            .getter(getter(Mapping::toKey)).setter(setter(Builder::toKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToKey").build()).build();

    private static final SdkField<List<String>> FROM_PATH_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FromPath")
            .getter(getter(Mapping::fromPath))
            .setter(setter(Builder::fromPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromPath").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FROM_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FromType").getter(getter(Mapping::fromType)).setter(setter(Builder::fromType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromType").build()).build();

    private static final SdkField<String> TO_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ToType")
            .getter(getter(Mapping::toType)).setter(setter(Builder::toType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToType").build()).build();

    private static final SdkField<Boolean> DROPPED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Dropped").getter(getter(Mapping::dropped)).setter(setter(Builder::dropped))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dropped").build()).build();

    private static final SdkField<List<Mapping>> CHILDREN_FIELD = SdkField
            .<List<Mapping>> builder(MarshallingType.LIST)
            .memberName("Children")
            .getter(getter(Mapping::children))
            .setter(setter(Builder::children))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Children").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Mapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(Mapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TO_KEY_FIELD, FROM_PATH_FIELD,
            FROM_TYPE_FIELD, TO_TYPE_FIELD, DROPPED_FIELD, CHILDREN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String toKey;

    private final List<String> fromPath;

    private final String fromType;

    private final String toType;

    private final Boolean dropped;

    private final List<Mapping> children;

    private Mapping(BuilderImpl builder) {
        this.toKey = builder.toKey;
        this.fromPath = builder.fromPath;
        this.fromType = builder.fromType;
        this.toType = builder.toType;
        this.dropped = builder.dropped;
        this.children = builder.children;
    }

    /**
     * <p>
     * After the apply mapping, what the name of the column should be. Can be the same as <code>FromPath</code>.
     * </p>
     * 
     * @return After the apply mapping, what the name of the column should be. Can be the same as <code>FromPath</code>.
     */
    public final String toKey() {
        return toKey;
    }

    /**
     * For responses, this returns true if the service returned a value for the FromPath property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFromPath() {
        return fromPath != null && !(fromPath instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The table or column to be modified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFromPath} method.
     * </p>
     * 
     * @return The table or column to be modified.
     */
    public final List<String> fromPath() {
        return fromPath;
    }

    /**
     * <p>
     * The type of the data to be modified.
     * </p>
     * 
     * @return The type of the data to be modified.
     */
    public final String fromType() {
        return fromType;
    }

    /**
     * <p>
     * The data type that the data is to be modified to.
     * </p>
     * 
     * @return The data type that the data is to be modified to.
     */
    public final String toType() {
        return toType;
    }

    /**
     * <p>
     * If true, then the column is removed.
     * </p>
     * 
     * @return If true, then the column is removed.
     */
    public final Boolean dropped() {
        return dropped;
    }

    /**
     * For responses, this returns true if the service returned a value for the Children property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasChildren() {
        return children != null && !(children instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Only applicable to nested data structures. If you want to change the parent structure, but also one of its
     * children, you can fill out this data strucutre. It is also <code>Mapping</code>, but its <code>FromPath</code>
     * will be the parent's <code>FromPath</code> plus the <code>FromPath</code> from this structure.
     * </p>
     * <p>
     * For the children part, suppose you have the structure:
     * </p>
     * <p>
     * <code>{ "FromPath": "OuterStructure", "ToKey": "OuterStructure", "ToType": "Struct", "Dropped": false, "Chidlren": [{ "FromPath": "inner", "ToKey": "inner", "ToType": "Double", "Dropped": false, }] }</code>
     * </p>
     * <p>
     * You can specify a <code>Mapping</code> that looks like:
     * </p>
     * <p>
     * <code>{ "FromPath": "OuterStructure", "ToKey": "OuterStructure", "ToType": "Struct", "Dropped": false, "Chidlren": [{ "FromPath": "inner", "ToKey": "inner", "ToType": "Double", "Dropped": false, }] }</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChildren} method.
     * </p>
     * 
     * @return Only applicable to nested data structures. If you want to change the parent structure, but also one of
     *         its children, you can fill out this data strucutre. It is also <code>Mapping</code>, but its
     *         <code>FromPath</code> will be the parent's <code>FromPath</code> plus the <code>FromPath</code> from this
     *         structure.</p>
     *         <p>
     *         For the children part, suppose you have the structure:
     *         </p>
     *         <p>
     *         <code>{ "FromPath": "OuterStructure", "ToKey": "OuterStructure", "ToType": "Struct", "Dropped": false, "Chidlren": [{ "FromPath": "inner", "ToKey": "inner", "ToType": "Double", "Dropped": false, }] }</code>
     *         </p>
     *         <p>
     *         You can specify a <code>Mapping</code> that looks like:
     *         </p>
     *         <p>
     *         <code>{ "FromPath": "OuterStructure", "ToKey": "OuterStructure", "ToType": "Struct", "Dropped": false, "Chidlren": [{ "FromPath": "inner", "ToKey": "inner", "ToType": "Double", "Dropped": false, }] }</code>
     */
    public final List<Mapping> children() {
        return children;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(toKey());
        hashCode = 31 * hashCode + Objects.hashCode(hasFromPath() ? fromPath() : null);
        hashCode = 31 * hashCode + Objects.hashCode(fromType());
        hashCode = 31 * hashCode + Objects.hashCode(toType());
        hashCode = 31 * hashCode + Objects.hashCode(dropped());
        hashCode = 31 * hashCode + Objects.hashCode(hasChildren() ? children() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Mapping)) {
            return false;
        }
        Mapping other = (Mapping) obj;
        return Objects.equals(toKey(), other.toKey()) && hasFromPath() == other.hasFromPath()
                && Objects.equals(fromPath(), other.fromPath()) && Objects.equals(fromType(), other.fromType())
                && Objects.equals(toType(), other.toType()) && Objects.equals(dropped(), other.dropped())
                && hasChildren() == other.hasChildren() && Objects.equals(children(), other.children());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Mapping").add("ToKey", toKey()).add("FromPath", hasFromPath() ? fromPath() : null)
                .add("FromType", fromType()).add("ToType", toType()).add("Dropped", dropped())
                .add("Children", hasChildren() ? children() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ToKey":
            return Optional.ofNullable(clazz.cast(toKey()));
        case "FromPath":
            return Optional.ofNullable(clazz.cast(fromPath()));
        case "FromType":
            return Optional.ofNullable(clazz.cast(fromType()));
        case "ToType":
            return Optional.ofNullable(clazz.cast(toType()));
        case "Dropped":
            return Optional.ofNullable(clazz.cast(dropped()));
        case "Children":
            return Optional.ofNullable(clazz.cast(children()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ToKey", TO_KEY_FIELD);
        map.put("FromPath", FROM_PATH_FIELD);
        map.put("FromType", FROM_TYPE_FIELD);
        map.put("ToType", TO_TYPE_FIELD);
        map.put("Dropped", DROPPED_FIELD);
        map.put("Children", CHILDREN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Mapping, T> g) {
        return obj -> g.apply((Mapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Mapping> {
        /**
         * <p>
         * After the apply mapping, what the name of the column should be. Can be the same as <code>FromPath</code>.
         * </p>
         * 
         * @param toKey
         *        After the apply mapping, what the name of the column should be. Can be the same as
         *        <code>FromPath</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toKey(String toKey);

        /**
         * <p>
         * The table or column to be modified.
         * </p>
         * 
         * @param fromPath
         *        The table or column to be modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromPath(Collection<String> fromPath);

        /**
         * <p>
         * The table or column to be modified.
         * </p>
         * 
         * @param fromPath
         *        The table or column to be modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromPath(String... fromPath);

        /**
         * <p>
         * The type of the data to be modified.
         * </p>
         * 
         * @param fromType
         *        The type of the data to be modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromType(String fromType);

        /**
         * <p>
         * The data type that the data is to be modified to.
         * </p>
         * 
         * @param toType
         *        The data type that the data is to be modified to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toType(String toType);

        /**
         * <p>
         * If true, then the column is removed.
         * </p>
         * 
         * @param dropped
         *        If true, then the column is removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dropped(Boolean dropped);

        /**
         * <p>
         * Only applicable to nested data structures. If you want to change the parent structure, but also one of its
         * children, you can fill out this data strucutre. It is also <code>Mapping</code>, but its
         * <code>FromPath</code> will be the parent's <code>FromPath</code> plus the <code>FromPath</code> from this
         * structure.
         * </p>
         * <p>
         * For the children part, suppose you have the structure:
         * </p>
         * <p>
         * <code>{ "FromPath": "OuterStructure", "ToKey": "OuterStructure", "ToType": "Struct", "Dropped": false, "Chidlren": [{ "FromPath": "inner", "ToKey": "inner", "ToType": "Double", "Dropped": false, }] }</code>
         * </p>
         * <p>
         * You can specify a <code>Mapping</code> that looks like:
         * </p>
         * <p>
         * <code>{ "FromPath": "OuterStructure", "ToKey": "OuterStructure", "ToType": "Struct", "Dropped": false, "Chidlren": [{ "FromPath": "inner", "ToKey": "inner", "ToType": "Double", "Dropped": false, }] }</code>
         * </p>
         * 
         * @param children
         *        Only applicable to nested data structures. If you want to change the parent structure, but also one of
         *        its children, you can fill out this data strucutre. It is also <code>Mapping</code>, but its
         *        <code>FromPath</code> will be the parent's <code>FromPath</code> plus the <code>FromPath</code> from
         *        this structure.</p>
         *        <p>
         *        For the children part, suppose you have the structure:
         *        </p>
         *        <p>
         *        <code>{ "FromPath": "OuterStructure", "ToKey": "OuterStructure", "ToType": "Struct", "Dropped": false, "Chidlren": [{ "FromPath": "inner", "ToKey": "inner", "ToType": "Double", "Dropped": false, }] }</code>
         *        </p>
         *        <p>
         *        You can specify a <code>Mapping</code> that looks like:
         *        </p>
         *        <p>
         *        <code>{ "FromPath": "OuterStructure", "ToKey": "OuterStructure", "ToType": "Struct", "Dropped": false, "Chidlren": [{ "FromPath": "inner", "ToKey": "inner", "ToType": "Double", "Dropped": false, }] }</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder children(Collection<Mapping> children);

        /**
         * <p>
         * Only applicable to nested data structures. If you want to change the parent structure, but also one of its
         * children, you can fill out this data strucutre. It is also <code>Mapping</code>, but its
         * <code>FromPath</code> will be the parent's <code>FromPath</code> plus the <code>FromPath</code> from this
         * structure.
         * </p>
         * <p>
         * For the children part, suppose you have the structure:
         * </p>
         * <p>
         * <code>{ "FromPath": "OuterStructure", "ToKey": "OuterStructure", "ToType": "Struct", "Dropped": false, "Chidlren": [{ "FromPath": "inner", "ToKey": "inner", "ToType": "Double", "Dropped": false, }] }</code>
         * </p>
         * <p>
         * You can specify a <code>Mapping</code> that looks like:
         * </p>
         * <p>
         * <code>{ "FromPath": "OuterStructure", "ToKey": "OuterStructure", "ToType": "Struct", "Dropped": false, "Chidlren": [{ "FromPath": "inner", "ToKey": "inner", "ToType": "Double", "Dropped": false, }] }</code>
         * </p>
         * 
         * @param children
         *        Only applicable to nested data structures. If you want to change the parent structure, but also one of
         *        its children, you can fill out this data strucutre. It is also <code>Mapping</code>, but its
         *        <code>FromPath</code> will be the parent's <code>FromPath</code> plus the <code>FromPath</code> from
         *        this structure.</p>
         *        <p>
         *        For the children part, suppose you have the structure:
         *        </p>
         *        <p>
         *        <code>{ "FromPath": "OuterStructure", "ToKey": "OuterStructure", "ToType": "Struct", "Dropped": false, "Chidlren": [{ "FromPath": "inner", "ToKey": "inner", "ToType": "Double", "Dropped": false, }] }</code>
         *        </p>
         *        <p>
         *        You can specify a <code>Mapping</code> that looks like:
         *        </p>
         *        <p>
         *        <code>{ "FromPath": "OuterStructure", "ToKey": "OuterStructure", "ToType": "Struct", "Dropped": false, "Chidlren": [{ "FromPath": "inner", "ToKey": "inner", "ToType": "Double", "Dropped": false, }] }</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder children(Mapping... children);

        /**
         * <p>
         * Only applicable to nested data structures. If you want to change the parent structure, but also one of its
         * children, you can fill out this data strucutre. It is also <code>Mapping</code>, but its
         * <code>FromPath</code> will be the parent's <code>FromPath</code> plus the <code>FromPath</code> from this
         * structure.
         * </p>
         * <p>
         * For the children part, suppose you have the structure:
         * </p>
         * <p>
         * <code>{ "FromPath": "OuterStructure", "ToKey": "OuterStructure", "ToType": "Struct", "Dropped": false, "Chidlren": [{ "FromPath": "inner", "ToKey": "inner", "ToType": "Double", "Dropped": false, }] }</code>
         * </p>
         * <p>
         * You can specify a <code>Mapping</code> that looks like:
         * </p>
         * <p>
         * <code>{ "FromPath": "OuterStructure", "ToKey": "OuterStructure", "ToType": "Struct", "Dropped": false, "Chidlren": [{ "FromPath": "inner", "ToKey": "inner", "ToType": "Double", "Dropped": false, }] }</code>
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.Mapping.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.glue.model.Mapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.Mapping.Builder#build()} is called immediately and its
         * result is passed to {@link #children(List<Mapping>)}.
         * 
         * @param children
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.Mapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #children(java.util.Collection<Mapping>)
         */
        Builder children(Consumer<Builder>... children);
    }

    static final class BuilderImpl implements Builder {
        private String toKey;

        private List<String> fromPath = DefaultSdkAutoConstructList.getInstance();

        private String fromType;

        private String toType;

        private Boolean dropped;

        private List<Mapping> children = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Mapping model) {
            toKey(model.toKey);
            fromPath(model.fromPath);
            fromType(model.fromType);
            toType(model.toType);
            dropped(model.dropped);
            children(model.children);
        }

        public final String getToKey() {
            return toKey;
        }

        public final void setToKey(String toKey) {
            this.toKey = toKey;
        }

        @Override
        public final Builder toKey(String toKey) {
            this.toKey = toKey;
            return this;
        }

        public final Collection<String> getFromPath() {
            if (fromPath instanceof SdkAutoConstructList) {
                return null;
            }
            return fromPath;
        }

        public final void setFromPath(Collection<String> fromPath) {
            this.fromPath = EnclosedInStringPropertiesCopier.copy(fromPath);
        }

        @Override
        public final Builder fromPath(Collection<String> fromPath) {
            this.fromPath = EnclosedInStringPropertiesCopier.copy(fromPath);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fromPath(String... fromPath) {
            fromPath(Arrays.asList(fromPath));
            return this;
        }

        public final String getFromType() {
            return fromType;
        }

        public final void setFromType(String fromType) {
            this.fromType = fromType;
        }

        @Override
        public final Builder fromType(String fromType) {
            this.fromType = fromType;
            return this;
        }

        public final String getToType() {
            return toType;
        }

        public final void setToType(String toType) {
            this.toType = toType;
        }

        @Override
        public final Builder toType(String toType) {
            this.toType = toType;
            return this;
        }

        public final Boolean getDropped() {
            return dropped;
        }

        public final void setDropped(Boolean dropped) {
            this.dropped = dropped;
        }

        @Override
        public final Builder dropped(Boolean dropped) {
            this.dropped = dropped;
            return this;
        }

        public final List<Builder> getChildren() {
            List<Builder> result = MappingsCopier.copyToBuilder(this.children);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChildren(Collection<BuilderImpl> children) {
            this.children = MappingsCopier.copyFromBuilder(children);
        }

        @Override
        public final Builder children(Collection<Mapping> children) {
            this.children = MappingsCopier.copy(children);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder children(Mapping... children) {
            children(Arrays.asList(children));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder children(Consumer<Builder>... children) {
            children(Stream.of(children).map(c -> Mapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Mapping build() {
            return new Mapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
