/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSessionsResponse extends GlueResponse implements
        ToCopyableBuilder<ListSessionsResponse.Builder, ListSessionsResponse> {
    private static final SdkField<List<String>> IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Ids")
            .getter(getter(ListSessionsResponse::ids))
            .setter(setter(Builder::ids))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ids").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Session>> SESSIONS_FIELD = SdkField
            .<List<Session>> builder(MarshallingType.LIST)
            .memberName("Sessions")
            .getter(getter(ListSessionsResponse::sessions))
            .setter(setter(Builder::sessions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sessions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Session> builder(MarshallingType.SDK_POJO)
                                            .constructor(Session::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListSessionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDS_FIELD, SESSIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> ids;

    private final List<Session> sessions;

    private final String nextToken;

    private ListSessionsResponse(BuilderImpl builder) {
        super(builder);
        this.ids = builder.ids;
        this.sessions = builder.sessions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ids property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasIds() {
        return ids != null && !(ids instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns the ID of the session.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIds} method.
     * </p>
     * 
     * @return Returns the ID of the session.
     */
    public final List<String> ids() {
        return ids;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sessions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSessions() {
        return sessions != null && !(sessions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns the session object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSessions} method.
     * </p>
     * 
     * @return Returns the session object.
     */
    public final List<Session> sessions() {
        return sessions;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no more result.
     * </p>
     * 
     * @return The token for the next set of results, or null if there are no more result.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasIds() ? ids() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSessions() ? sessions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSessionsResponse)) {
            return false;
        }
        ListSessionsResponse other = (ListSessionsResponse) obj;
        return hasIds() == other.hasIds() && Objects.equals(ids(), other.ids()) && hasSessions() == other.hasSessions()
                && Objects.equals(sessions(), other.sessions()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSessionsResponse").add("Ids", hasIds() ? ids() : null)
                .add("Sessions", hasSessions() ? sessions() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ids":
            return Optional.ofNullable(clazz.cast(ids()));
        case "Sessions":
            return Optional.ofNullable(clazz.cast(sessions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Ids", IDS_FIELD);
        map.put("Sessions", SESSIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSessionsResponse, T> g) {
        return obj -> g.apply((ListSessionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSessionsResponse> {
        /**
         * <p>
         * Returns the ID of the session.
         * </p>
         * 
         * @param ids
         *        Returns the ID of the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ids(Collection<String> ids);

        /**
         * <p>
         * Returns the ID of the session.
         * </p>
         * 
         * @param ids
         *        Returns the ID of the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ids(String... ids);

        /**
         * <p>
         * Returns the session object.
         * </p>
         * 
         * @param sessions
         *        Returns the session object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessions(Collection<Session> sessions);

        /**
         * <p>
         * Returns the session object.
         * </p>
         * 
         * @param sessions
         *        Returns the session object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessions(Session... sessions);

        /**
         * <p>
         * Returns the session object.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.Session.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.glue.model.Session#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.Session.Builder#build()} is called immediately and its
         * result is passed to {@link #sessions(List<Session>)}.
         * 
         * @param sessions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.Session.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sessions(java.util.Collection<Session>)
         */
        Builder sessions(Consumer<Session.Builder>... sessions);

        /**
         * <p>
         * The token for the next set of results, or null if there are no more result.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or null if there are no more result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<String> ids = DefaultSdkAutoConstructList.getInstance();

        private List<Session> sessions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSessionsResponse model) {
            super(model);
            ids(model.ids);
            sessions(model.sessions);
            nextToken(model.nextToken);
        }

        public final Collection<String> getIds() {
            if (ids instanceof SdkAutoConstructList) {
                return null;
            }
            return ids;
        }

        public final void setIds(Collection<String> ids) {
            this.ids = SessionIdListCopier.copy(ids);
        }

        @Override
        public final Builder ids(Collection<String> ids) {
            this.ids = SessionIdListCopier.copy(ids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ids(String... ids) {
            ids(Arrays.asList(ids));
            return this;
        }

        public final List<Session.Builder> getSessions() {
            List<Session.Builder> result = SessionListCopier.copyToBuilder(this.sessions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSessions(Collection<Session.BuilderImpl> sessions) {
            this.sessions = SessionListCopier.copyFromBuilder(sessions);
        }

        @Override
        public final Builder sessions(Collection<Session> sessions) {
            this.sessions = SessionListCopier.copy(sessions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessions(Session... sessions) {
            sessions(Arrays.asList(sessions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessions(Consumer<Session.Builder>... sessions) {
            sessions(Stream.of(sessions).map(c -> Session.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSessionsResponse build() {
            return new ListSessionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
