/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure for an integration that writes data into a resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InboundIntegration implements SdkPojo, Serializable,
        ToCopyableBuilder<InboundIntegration.Builder, InboundIntegration> {
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceArn").getter(getter(InboundIntegration::sourceArn)).setter(setter(Builder::sourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()).build();

    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetArn").getter(getter(InboundIntegration::targetArn)).setter(setter(Builder::targetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetArn").build()).build();

    private static final SdkField<String> INTEGRATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IntegrationArn").getter(getter(InboundIntegration::integrationArn))
            .setter(setter(Builder::integrationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(InboundIntegration::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTime").getter(getter(InboundIntegration::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()).build();

    private static final SdkField<List<IntegrationError>> ERRORS_FIELD = SdkField
            .<List<IntegrationError>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(InboundIntegration::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IntegrationError> builder(MarshallingType.SDK_POJO)
                                            .constructor(IntegrationError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ARN_FIELD,
            TARGET_ARN_FIELD, INTEGRATION_ARN_FIELD, STATUS_FIELD, CREATE_TIME_FIELD, ERRORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceArn;

    private final String targetArn;

    private final String integrationArn;

    private final String status;

    private final Instant createTime;

    private final List<IntegrationError> errors;

    private InboundIntegration(BuilderImpl builder) {
        this.sourceArn = builder.sourceArn;
        this.targetArn = builder.targetArn;
        this.integrationArn = builder.integrationArn;
        this.status = builder.status;
        this.createTime = builder.createTime;
        this.errors = builder.errors;
    }

    /**
     * <p>
     * The ARN of the source resource for the integration.
     * </p>
     * 
     * @return The ARN of the source resource for the integration.
     */
    public final String sourceArn() {
        return sourceArn;
    }

    /**
     * <p>
     * The ARN of the target resource for the integration.
     * </p>
     * 
     * @return The ARN of the target resource for the integration.
     */
    public final String targetArn() {
        return targetArn;
    }

    /**
     * <p>
     * The ARN of the zero-ETL integration.
     * </p>
     * 
     * @return The ARN of the zero-ETL integration.
     */
    public final String integrationArn() {
        return integrationArn;
    }

    /**
     * <p>
     * The possible statuses are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATING: The integration is being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * ACTIVE: The integration creation succeeds.
     * </p>
     * </li>
     * <li>
     * <p>
     * MODIFYING: The integration is being modified.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED: The integration creation fails.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETING: The integration is deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * SYNCING: The integration is synchronizing.
     * </p>
     * </li>
     * <li>
     * <p>
     * NEEDS_ATTENTION: The integration needs attention, such as synchronization.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IntegrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The possible statuses are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         CREATING: The integration is being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACTIVE: The integration creation succeeds.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MODIFYING: The integration is being modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED: The integration creation fails.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETING: The integration is deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SYNCING: The integration is synchronizing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NEEDS_ATTENTION: The integration needs attention, such as synchronization.
     *         </p>
     *         </li>
     * @see IntegrationStatus
     */
    public final IntegrationStatus status() {
        return IntegrationStatus.fromValue(status);
    }

    /**
     * <p>
     * The possible statuses are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATING: The integration is being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * ACTIVE: The integration creation succeeds.
     * </p>
     * </li>
     * <li>
     * <p>
     * MODIFYING: The integration is being modified.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED: The integration creation fails.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETING: The integration is deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * SYNCING: The integration is synchronizing.
     * </p>
     * </li>
     * <li>
     * <p>
     * NEEDS_ATTENTION: The integration needs attention, such as synchronization.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IntegrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The possible statuses are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         CREATING: The integration is being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACTIVE: The integration creation succeeds.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MODIFYING: The integration is being modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED: The integration creation fails.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETING: The integration is deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SYNCING: The integration is synchronizing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NEEDS_ATTENTION: The integration needs attention, such as synchronization.
     *         </p>
     *         </li>
     * @see IntegrationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time that the integration was created, in UTC.
     * </p>
     * 
     * @return The time that the integration was created, in UTC.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of errors associated with the integration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return A list of errors associated with the integration.
     */
    public final List<IntegrationError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(integrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InboundIntegration)) {
            return false;
        }
        InboundIntegration other = (InboundIntegration) obj;
        return Objects.equals(sourceArn(), other.sourceArn()) && Objects.equals(targetArn(), other.targetArn())
                && Objects.equals(integrationArn(), other.integrationArn())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(createTime(), other.createTime())
                && hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InboundIntegration").add("SourceArn", sourceArn()).add("TargetArn", targetArn())
                .add("IntegrationArn", integrationArn()).add("Status", statusAsString()).add("CreateTime", createTime())
                .add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceArn":
            return Optional.ofNullable(clazz.cast(sourceArn()));
        case "TargetArn":
            return Optional.ofNullable(clazz.cast(targetArn()));
        case "IntegrationArn":
            return Optional.ofNullable(clazz.cast(integrationArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceArn", SOURCE_ARN_FIELD);
        map.put("TargetArn", TARGET_ARN_FIELD);
        map.put("IntegrationArn", INTEGRATION_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreateTime", CREATE_TIME_FIELD);
        map.put("Errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InboundIntegration, T> g) {
        return obj -> g.apply((InboundIntegration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InboundIntegration> {
        /**
         * <p>
         * The ARN of the source resource for the integration.
         * </p>
         * 
         * @param sourceArn
         *        The ARN of the source resource for the integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArn(String sourceArn);

        /**
         * <p>
         * The ARN of the target resource for the integration.
         * </p>
         * 
         * @param targetArn
         *        The ARN of the target resource for the integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetArn(String targetArn);

        /**
         * <p>
         * The ARN of the zero-ETL integration.
         * </p>
         * 
         * @param integrationArn
         *        The ARN of the zero-ETL integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationArn(String integrationArn);

        /**
         * <p>
         * The possible statuses are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CREATING: The integration is being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * ACTIVE: The integration creation succeeds.
         * </p>
         * </li>
         * <li>
         * <p>
         * MODIFYING: The integration is being modified.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED: The integration creation fails.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETING: The integration is deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * SYNCING: The integration is synchronizing.
         * </p>
         * </li>
         * <li>
         * <p>
         * NEEDS_ATTENTION: The integration needs attention, such as synchronization.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The possible statuses are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        CREATING: The integration is being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ACTIVE: The integration creation succeeds.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        MODIFYING: The integration is being modified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED: The integration creation fails.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETING: The integration is deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SYNCING: The integration is synchronizing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NEEDS_ATTENTION: The integration needs attention, such as synchronization.
         *        </p>
         *        </li>
         * @see IntegrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntegrationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The possible statuses are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CREATING: The integration is being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * ACTIVE: The integration creation succeeds.
         * </p>
         * </li>
         * <li>
         * <p>
         * MODIFYING: The integration is being modified.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED: The integration creation fails.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETING: The integration is deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * SYNCING: The integration is synchronizing.
         * </p>
         * </li>
         * <li>
         * <p>
         * NEEDS_ATTENTION: The integration needs attention, such as synchronization.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The possible statuses are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        CREATING: The integration is being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ACTIVE: The integration creation succeeds.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        MODIFYING: The integration is being modified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED: The integration creation fails.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETING: The integration is deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SYNCING: The integration is synchronizing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NEEDS_ATTENTION: The integration needs attention, such as synchronization.
         *        </p>
         *        </li>
         * @see IntegrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntegrationStatus
         */
        Builder status(IntegrationStatus status);

        /**
         * <p>
         * The time that the integration was created, in UTC.
         * </p>
         * 
         * @param createTime
         *        The time that the integration was created, in UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * A list of errors associated with the integration.
         * </p>
         * 
         * @param errors
         *        A list of errors associated with the integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<IntegrationError> errors);

        /**
         * <p>
         * A list of errors associated with the integration.
         * </p>
         * 
         * @param errors
         *        A list of errors associated with the integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(IntegrationError... errors);

        /**
         * <p>
         * A list of errors associated with the integration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.IntegrationError.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.glue.model.IntegrationError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.IntegrationError.Builder#build()} is called immediately and
         * its result is passed to {@link #errors(List<IntegrationError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.IntegrationError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<IntegrationError>)
         */
        Builder errors(Consumer<IntegrationError.Builder>... errors);
    }

    static final class BuilderImpl implements Builder {
        private String sourceArn;

        private String targetArn;

        private String integrationArn;

        private String status;

        private Instant createTime;

        private List<IntegrationError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InboundIntegration model) {
            sourceArn(model.sourceArn);
            targetArn(model.targetArn);
            integrationArn(model.integrationArn);
            status(model.status);
            createTime(model.createTime);
            errors(model.errors);
        }

        public final String getSourceArn() {
            return sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final String getTargetArn() {
            return targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final String getIntegrationArn() {
            return integrationArn;
        }

        public final void setIntegrationArn(String integrationArn) {
            this.integrationArn = integrationArn;
        }

        @Override
        public final Builder integrationArn(String integrationArn) {
            this.integrationArn = integrationArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IntegrationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final List<IntegrationError.Builder> getErrors() {
            List<IntegrationError.Builder> result = IntegrationErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<IntegrationError.BuilderImpl> errors) {
            this.errors = IntegrationErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<IntegrationError> errors) {
            this.errors = IntegrationErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(IntegrationError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<IntegrationError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> IntegrationError.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public InboundIntegration build() {
            return new InboundIntegration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
