/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConnectionTypeResponse extends GlueResponse implements
        ToCopyableBuilder<DescribeConnectionTypeResponse.Builder, DescribeConnectionTypeResponse> {
    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionType").getter(getter(DescribeConnectionTypeResponse::connectionType))
            .setter(setter(Builder::connectionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionType").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeConnectionTypeResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Capabilities> CAPABILITIES_FIELD = SdkField.<Capabilities> builder(MarshallingType.SDK_POJO)
            .memberName("Capabilities").getter(getter(DescribeConnectionTypeResponse::capabilities))
            .setter(setter(Builder::capabilities)).constructor(Capabilities::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build()).build();

    private static final SdkField<Map<String, Property>> CONNECTION_PROPERTIES_FIELD = SdkField
            .<Map<String, Property>> builder(MarshallingType.MAP)
            .memberName("ConnectionProperties")
            .getter(getter(DescribeConnectionTypeResponse::connectionProperties))
            .setter(setter(Builder::connectionProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Property> builder(MarshallingType.SDK_POJO)
                                            .constructor(Property::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, Property>> CONNECTION_OPTIONS_FIELD = SdkField
            .<Map<String, Property>> builder(MarshallingType.MAP)
            .memberName("ConnectionOptions")
            .getter(getter(DescribeConnectionTypeResponse::connectionOptions))
            .setter(setter(Builder::connectionOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionOptions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Property> builder(MarshallingType.SDK_POJO)
                                            .constructor(Property::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<AuthConfiguration> AUTHENTICATION_CONFIGURATION_FIELD = SdkField
            .<AuthConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("AuthenticationConfiguration")
            .getter(getter(DescribeConnectionTypeResponse::authenticationConfiguration))
            .setter(setter(Builder::authenticationConfiguration))
            .constructor(AuthConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationConfiguration")
                    .build()).build();

    private static final SdkField<Map<String, ComputeEnvironmentConfiguration>> COMPUTE_ENVIRONMENT_CONFIGURATIONS_FIELD = SdkField
            .<Map<String, ComputeEnvironmentConfiguration>> builder(MarshallingType.MAP)
            .memberName("ComputeEnvironmentConfigurations")
            .getter(getter(DescribeConnectionTypeResponse::computeEnvironmentConfigurations))
            .setter(setter(Builder::computeEnvironmentConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeEnvironmentConfigurations")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ComputeEnvironmentConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComputeEnvironmentConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, Property>> PHYSICAL_CONNECTION_REQUIREMENTS_FIELD = SdkField
            .<Map<String, Property>> builder(MarshallingType.MAP)
            .memberName("PhysicalConnectionRequirements")
            .getter(getter(DescribeConnectionTypeResponse::physicalConnectionRequirements))
            .setter(setter(Builder::physicalConnectionRequirements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhysicalConnectionRequirements")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Property> builder(MarshallingType.SDK_POJO)
                                            .constructor(Property::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, Property>> ATHENA_CONNECTION_PROPERTIES_FIELD = SdkField
            .<Map<String, Property>> builder(MarshallingType.MAP)
            .memberName("AthenaConnectionProperties")
            .getter(getter(DescribeConnectionTypeResponse::athenaConnectionProperties))
            .setter(setter(Builder::athenaConnectionProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AthenaConnectionProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Property> builder(MarshallingType.SDK_POJO)
                                            .constructor(Property::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, Property>> PYTHON_CONNECTION_PROPERTIES_FIELD = SdkField
            .<Map<String, Property>> builder(MarshallingType.MAP)
            .memberName("PythonConnectionProperties")
            .getter(getter(DescribeConnectionTypeResponse::pythonConnectionProperties))
            .setter(setter(Builder::pythonConnectionProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PythonConnectionProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Property> builder(MarshallingType.SDK_POJO)
                                            .constructor(Property::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, Property>> SPARK_CONNECTION_PROPERTIES_FIELD = SdkField
            .<Map<String, Property>> builder(MarshallingType.MAP)
            .memberName("SparkConnectionProperties")
            .getter(getter(DescribeConnectionTypeResponse::sparkConnectionProperties))
            .setter(setter(Builder::sparkConnectionProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SparkConnectionProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Property> builder(MarshallingType.SDK_POJO)
                                            .constructor(Property::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_TYPE_FIELD,
            DESCRIPTION_FIELD, CAPABILITIES_FIELD, CONNECTION_PROPERTIES_FIELD, CONNECTION_OPTIONS_FIELD,
            AUTHENTICATION_CONFIGURATION_FIELD, COMPUTE_ENVIRONMENT_CONFIGURATIONS_FIELD, PHYSICAL_CONNECTION_REQUIREMENTS_FIELD,
            ATHENA_CONNECTION_PROPERTIES_FIELD, PYTHON_CONNECTION_PROPERTIES_FIELD, SPARK_CONNECTION_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String connectionType;

    private final String description;

    private final Capabilities capabilities;

    private final Map<String, Property> connectionProperties;

    private final Map<String, Property> connectionOptions;

    private final AuthConfiguration authenticationConfiguration;

    private final Map<String, ComputeEnvironmentConfiguration> computeEnvironmentConfigurations;

    private final Map<String, Property> physicalConnectionRequirements;

    private final Map<String, Property> athenaConnectionProperties;

    private final Map<String, Property> pythonConnectionProperties;

    private final Map<String, Property> sparkConnectionProperties;

    private DescribeConnectionTypeResponse(BuilderImpl builder) {
        super(builder);
        this.connectionType = builder.connectionType;
        this.description = builder.description;
        this.capabilities = builder.capabilities;
        this.connectionProperties = builder.connectionProperties;
        this.connectionOptions = builder.connectionOptions;
        this.authenticationConfiguration = builder.authenticationConfiguration;
        this.computeEnvironmentConfigurations = builder.computeEnvironmentConfigurations;
        this.physicalConnectionRequirements = builder.physicalConnectionRequirements;
        this.athenaConnectionProperties = builder.athenaConnectionProperties;
        this.pythonConnectionProperties = builder.pythonConnectionProperties;
        this.sparkConnectionProperties = builder.sparkConnectionProperties;
    }

    /**
     * <p>
     * The name of the connection type.
     * </p>
     * 
     * @return The name of the connection type.
     */
    public final String connectionType() {
        return connectionType;
    }

    /**
     * <p>
     * A description of the connection type.
     * </p>
     * 
     * @return A description of the connection type.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The supported authentication types, data interface types (compute environments), and data operations of the
     * connector.
     * </p>
     * 
     * @return The supported authentication types, data interface types (compute environments), and data operations of
     *         the connector.
     */
    public final Capabilities capabilities() {
        return capabilities;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConnectionProperties property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConnectionProperties() {
        return connectionProperties != null && !(connectionProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Connection properties which are common across compute environments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectionProperties} method.
     * </p>
     * 
     * @return Connection properties which are common across compute environments.
     */
    public final Map<String, Property> connectionProperties() {
        return connectionProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConnectionOptions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConnectionOptions() {
        return connectionOptions != null && !(connectionOptions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Returns properties that can be set when creating a connection in the
     * <code>ConnectionInput.ConnectionProperties</code>. <code>ConnectionOptions</code> defines parameters that can be
     * set in a Spark ETL script in the connection options map passed to a dataframe.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectionOptions} method.
     * </p>
     * 
     * @return Returns properties that can be set when creating a connection in the
     *         <code>ConnectionInput.ConnectionProperties</code>. <code>ConnectionOptions</code> defines parameters that
     *         can be set in a Spark ETL script in the connection options map passed to a dataframe.
     */
    public final Map<String, Property> connectionOptions() {
        return connectionOptions;
    }

    /**
     * <p>
     * The type of authentication used for the connection.
     * </p>
     * 
     * @return The type of authentication used for the connection.
     */
    public final AuthConfiguration authenticationConfiguration() {
        return authenticationConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the ComputeEnvironmentConfigurations
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasComputeEnvironmentConfigurations() {
        return computeEnvironmentConfigurations != null && !(computeEnvironmentConfigurations instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The compute environments that are supported by the connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComputeEnvironmentConfigurations}
     * method.
     * </p>
     * 
     * @return The compute environments that are supported by the connection.
     */
    public final Map<String, ComputeEnvironmentConfiguration> computeEnvironmentConfigurations() {
        return computeEnvironmentConfigurations;
    }

    /**
     * For responses, this returns true if the service returned a value for the PhysicalConnectionRequirements property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPhysicalConnectionRequirements() {
        return physicalConnectionRequirements != null && !(physicalConnectionRequirements instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Physical requirements for a connection, such as VPC, Subnet and Security Group specifications.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPhysicalConnectionRequirements} method.
     * </p>
     * 
     * @return Physical requirements for a connection, such as VPC, Subnet and Security Group specifications.
     */
    public final Map<String, Property> physicalConnectionRequirements() {
        return physicalConnectionRequirements;
    }

    /**
     * For responses, this returns true if the service returned a value for the AthenaConnectionProperties property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAthenaConnectionProperties() {
        return athenaConnectionProperties != null && !(athenaConnectionProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Connection properties specific to the Athena compute environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAthenaConnectionProperties} method.
     * </p>
     * 
     * @return Connection properties specific to the Athena compute environment.
     */
    public final Map<String, Property> athenaConnectionProperties() {
        return athenaConnectionProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the PythonConnectionProperties property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPythonConnectionProperties() {
        return pythonConnectionProperties != null && !(pythonConnectionProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Connection properties specific to the Python compute environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPythonConnectionProperties} method.
     * </p>
     * 
     * @return Connection properties specific to the Python compute environment.
     */
    public final Map<String, Property> pythonConnectionProperties() {
        return pythonConnectionProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the SparkConnectionProperties property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSparkConnectionProperties() {
        return sparkConnectionProperties != null && !(sparkConnectionProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Connection properties specific to the Spark compute environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSparkConnectionProperties} method.
     * </p>
     * 
     * @return Connection properties specific to the Spark compute environment.
     */
    public final Map<String, Property> sparkConnectionProperties() {
        return sparkConnectionProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectionType());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(capabilities());
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectionProperties() ? connectionProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectionOptions() ? connectionOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(authenticationConfiguration());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasComputeEnvironmentConfigurations() ? computeEnvironmentConfigurations() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasPhysicalConnectionRequirements() ? physicalConnectionRequirements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAthenaConnectionProperties() ? athenaConnectionProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPythonConnectionProperties() ? pythonConnectionProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSparkConnectionProperties() ? sparkConnectionProperties() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConnectionTypeResponse)) {
            return false;
        }
        DescribeConnectionTypeResponse other = (DescribeConnectionTypeResponse) obj;
        return Objects.equals(connectionType(), other.connectionType()) && Objects.equals(description(), other.description())
                && Objects.equals(capabilities(), other.capabilities())
                && hasConnectionProperties() == other.hasConnectionProperties()
                && Objects.equals(connectionProperties(), other.connectionProperties())
                && hasConnectionOptions() == other.hasConnectionOptions()
                && Objects.equals(connectionOptions(), other.connectionOptions())
                && Objects.equals(authenticationConfiguration(), other.authenticationConfiguration())
                && hasComputeEnvironmentConfigurations() == other.hasComputeEnvironmentConfigurations()
                && Objects.equals(computeEnvironmentConfigurations(), other.computeEnvironmentConfigurations())
                && hasPhysicalConnectionRequirements() == other.hasPhysicalConnectionRequirements()
                && Objects.equals(physicalConnectionRequirements(), other.physicalConnectionRequirements())
                && hasAthenaConnectionProperties() == other.hasAthenaConnectionProperties()
                && Objects.equals(athenaConnectionProperties(), other.athenaConnectionProperties())
                && hasPythonConnectionProperties() == other.hasPythonConnectionProperties()
                && Objects.equals(pythonConnectionProperties(), other.pythonConnectionProperties())
                && hasSparkConnectionProperties() == other.hasSparkConnectionProperties()
                && Objects.equals(sparkConnectionProperties(), other.sparkConnectionProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeConnectionTypeResponse")
                .add("ConnectionType", connectionType())
                .add("Description", description())
                .add("Capabilities", capabilities())
                .add("ConnectionProperties", hasConnectionProperties() ? connectionProperties() : null)
                .add("ConnectionOptions", hasConnectionOptions() ? connectionOptions() : null)
                .add("AuthenticationConfiguration", authenticationConfiguration())
                .add("ComputeEnvironmentConfigurations",
                        hasComputeEnvironmentConfigurations() ? computeEnvironmentConfigurations() : null)
                .add("PhysicalConnectionRequirements",
                        hasPhysicalConnectionRequirements() ? physicalConnectionRequirements() : null)
                .add("AthenaConnectionProperties", hasAthenaConnectionProperties() ? athenaConnectionProperties() : null)
                .add("PythonConnectionProperties", hasPythonConnectionProperties() ? pythonConnectionProperties() : null)
                .add("SparkConnectionProperties", hasSparkConnectionProperties() ? sparkConnectionProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectionType":
            return Optional.ofNullable(clazz.cast(connectionType()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Capabilities":
            return Optional.ofNullable(clazz.cast(capabilities()));
        case "ConnectionProperties":
            return Optional.ofNullable(clazz.cast(connectionProperties()));
        case "ConnectionOptions":
            return Optional.ofNullable(clazz.cast(connectionOptions()));
        case "AuthenticationConfiguration":
            return Optional.ofNullable(clazz.cast(authenticationConfiguration()));
        case "ComputeEnvironmentConfigurations":
            return Optional.ofNullable(clazz.cast(computeEnvironmentConfigurations()));
        case "PhysicalConnectionRequirements":
            return Optional.ofNullable(clazz.cast(physicalConnectionRequirements()));
        case "AthenaConnectionProperties":
            return Optional.ofNullable(clazz.cast(athenaConnectionProperties()));
        case "PythonConnectionProperties":
            return Optional.ofNullable(clazz.cast(pythonConnectionProperties()));
        case "SparkConnectionProperties":
            return Optional.ofNullable(clazz.cast(sparkConnectionProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConnectionType", CONNECTION_TYPE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Capabilities", CAPABILITIES_FIELD);
        map.put("ConnectionProperties", CONNECTION_PROPERTIES_FIELD);
        map.put("ConnectionOptions", CONNECTION_OPTIONS_FIELD);
        map.put("AuthenticationConfiguration", AUTHENTICATION_CONFIGURATION_FIELD);
        map.put("ComputeEnvironmentConfigurations", COMPUTE_ENVIRONMENT_CONFIGURATIONS_FIELD);
        map.put("PhysicalConnectionRequirements", PHYSICAL_CONNECTION_REQUIREMENTS_FIELD);
        map.put("AthenaConnectionProperties", ATHENA_CONNECTION_PROPERTIES_FIELD);
        map.put("PythonConnectionProperties", PYTHON_CONNECTION_PROPERTIES_FIELD);
        map.put("SparkConnectionProperties", SPARK_CONNECTION_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeConnectionTypeResponse, T> g) {
        return obj -> g.apply((DescribeConnectionTypeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeConnectionTypeResponse> {
        /**
         * <p>
         * The name of the connection type.
         * </p>
         * 
         * @param connectionType
         *        The name of the connection type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionType(String connectionType);

        /**
         * <p>
         * A description of the connection type.
         * </p>
         * 
         * @param description
         *        A description of the connection type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The supported authentication types, data interface types (compute environments), and data operations of the
         * connector.
         * </p>
         * 
         * @param capabilities
         *        The supported authentication types, data interface types (compute environments), and data operations
         *        of the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Capabilities capabilities);

        /**
         * <p>
         * The supported authentication types, data interface types (compute environments), and data operations of the
         * connector.
         * </p>
         * This is a convenience method that creates an instance of the {@link Capabilities.Builder} avoiding the need
         * to create one manually via {@link Capabilities#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Capabilities.Builder#build()} is called immediately and its
         * result is passed to {@link #capabilities(Capabilities)}.
         * 
         * @param capabilities
         *        a consumer that will call methods on {@link Capabilities.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capabilities(Capabilities)
         */
        default Builder capabilities(Consumer<Capabilities.Builder> capabilities) {
            return capabilities(Capabilities.builder().applyMutation(capabilities).build());
        }

        /**
         * <p>
         * Connection properties which are common across compute environments.
         * </p>
         * 
         * @param connectionProperties
         *        Connection properties which are common across compute environments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionProperties(Map<String, Property> connectionProperties);

        /**
         * <p>
         * Returns properties that can be set when creating a connection in the
         * <code>ConnectionInput.ConnectionProperties</code>. <code>ConnectionOptions</code> defines parameters that can
         * be set in a Spark ETL script in the connection options map passed to a dataframe.
         * </p>
         * 
         * @param connectionOptions
         *        Returns properties that can be set when creating a connection in the
         *        <code>ConnectionInput.ConnectionProperties</code>. <code>ConnectionOptions</code> defines parameters
         *        that can be set in a Spark ETL script in the connection options map passed to a dataframe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionOptions(Map<String, Property> connectionOptions);

        /**
         * <p>
         * The type of authentication used for the connection.
         * </p>
         * 
         * @param authenticationConfiguration
         *        The type of authentication used for the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationConfiguration(AuthConfiguration authenticationConfiguration);

        /**
         * <p>
         * The type of authentication used for the connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuthConfiguration.Builder} avoiding the
         * need to create one manually via {@link AuthConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuthConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #authenticationConfiguration(AuthConfiguration)}.
         * 
         * @param authenticationConfiguration
         *        a consumer that will call methods on {@link AuthConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authenticationConfiguration(AuthConfiguration)
         */
        default Builder authenticationConfiguration(Consumer<AuthConfiguration.Builder> authenticationConfiguration) {
            return authenticationConfiguration(AuthConfiguration.builder().applyMutation(authenticationConfiguration).build());
        }

        /**
         * <p>
         * The compute environments that are supported by the connection.
         * </p>
         * 
         * @param computeEnvironmentConfigurations
         *        The compute environments that are supported by the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironmentConfigurations(Map<String, ComputeEnvironmentConfiguration> computeEnvironmentConfigurations);

        /**
         * <p>
         * Physical requirements for a connection, such as VPC, Subnet and Security Group specifications.
         * </p>
         * 
         * @param physicalConnectionRequirements
         *        Physical requirements for a connection, such as VPC, Subnet and Security Group specifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder physicalConnectionRequirements(Map<String, Property> physicalConnectionRequirements);

        /**
         * <p>
         * Connection properties specific to the Athena compute environment.
         * </p>
         * 
         * @param athenaConnectionProperties
         *        Connection properties specific to the Athena compute environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder athenaConnectionProperties(Map<String, Property> athenaConnectionProperties);

        /**
         * <p>
         * Connection properties specific to the Python compute environment.
         * </p>
         * 
         * @param pythonConnectionProperties
         *        Connection properties specific to the Python compute environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pythonConnectionProperties(Map<String, Property> pythonConnectionProperties);

        /**
         * <p>
         * Connection properties specific to the Spark compute environment.
         * </p>
         * 
         * @param sparkConnectionProperties
         *        Connection properties specific to the Spark compute environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sparkConnectionProperties(Map<String, Property> sparkConnectionProperties);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private String connectionType;

        private String description;

        private Capabilities capabilities;

        private Map<String, Property> connectionProperties = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, Property> connectionOptions = DefaultSdkAutoConstructMap.getInstance();

        private AuthConfiguration authenticationConfiguration;

        private Map<String, ComputeEnvironmentConfiguration> computeEnvironmentConfigurations = DefaultSdkAutoConstructMap
                .getInstance();

        private Map<String, Property> physicalConnectionRequirements = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, Property> athenaConnectionProperties = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, Property> pythonConnectionProperties = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, Property> sparkConnectionProperties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConnectionTypeResponse model) {
            super(model);
            connectionType(model.connectionType);
            description(model.description);
            capabilities(model.capabilities);
            connectionProperties(model.connectionProperties);
            connectionOptions(model.connectionOptions);
            authenticationConfiguration(model.authenticationConfiguration);
            computeEnvironmentConfigurations(model.computeEnvironmentConfigurations);
            physicalConnectionRequirements(model.physicalConnectionRequirements);
            athenaConnectionProperties(model.athenaConnectionProperties);
            pythonConnectionProperties(model.pythonConnectionProperties);
            sparkConnectionProperties(model.sparkConnectionProperties);
        }

        public final String getConnectionType() {
            return connectionType;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Capabilities.Builder getCapabilities() {
            return capabilities != null ? capabilities.toBuilder() : null;
        }

        public final void setCapabilities(Capabilities.BuilderImpl capabilities) {
            this.capabilities = capabilities != null ? capabilities.build() : null;
        }

        @Override
        public final Builder capabilities(Capabilities capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public final Map<String, Property.Builder> getConnectionProperties() {
            Map<String, Property.Builder> result = PropertiesMapCopier.copyToBuilder(this.connectionProperties);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setConnectionProperties(Map<String, Property.BuilderImpl> connectionProperties) {
            this.connectionProperties = PropertiesMapCopier.copyFromBuilder(connectionProperties);
        }

        @Override
        public final Builder connectionProperties(Map<String, Property> connectionProperties) {
            this.connectionProperties = PropertiesMapCopier.copy(connectionProperties);
            return this;
        }

        public final Map<String, Property.Builder> getConnectionOptions() {
            Map<String, Property.Builder> result = PropertiesMapCopier.copyToBuilder(this.connectionOptions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setConnectionOptions(Map<String, Property.BuilderImpl> connectionOptions) {
            this.connectionOptions = PropertiesMapCopier.copyFromBuilder(connectionOptions);
        }

        @Override
        public final Builder connectionOptions(Map<String, Property> connectionOptions) {
            this.connectionOptions = PropertiesMapCopier.copy(connectionOptions);
            return this;
        }

        public final AuthConfiguration.Builder getAuthenticationConfiguration() {
            return authenticationConfiguration != null ? authenticationConfiguration.toBuilder() : null;
        }

        public final void setAuthenticationConfiguration(AuthConfiguration.BuilderImpl authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration != null ? authenticationConfiguration.build() : null;
        }

        @Override
        public final Builder authenticationConfiguration(AuthConfiguration authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration;
            return this;
        }

        public final Map<String, ComputeEnvironmentConfiguration.Builder> getComputeEnvironmentConfigurations() {
            Map<String, ComputeEnvironmentConfiguration.Builder> result = ComputeEnvironmentConfigurationMapCopier
                    .copyToBuilder(this.computeEnvironmentConfigurations);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setComputeEnvironmentConfigurations(
                Map<String, ComputeEnvironmentConfiguration.BuilderImpl> computeEnvironmentConfigurations) {
            this.computeEnvironmentConfigurations = ComputeEnvironmentConfigurationMapCopier
                    .copyFromBuilder(computeEnvironmentConfigurations);
        }

        @Override
        public final Builder computeEnvironmentConfigurations(
                Map<String, ComputeEnvironmentConfiguration> computeEnvironmentConfigurations) {
            this.computeEnvironmentConfigurations = ComputeEnvironmentConfigurationMapCopier
                    .copy(computeEnvironmentConfigurations);
            return this;
        }

        public final Map<String, Property.Builder> getPhysicalConnectionRequirements() {
            Map<String, Property.Builder> result = PropertiesMapCopier.copyToBuilder(this.physicalConnectionRequirements);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPhysicalConnectionRequirements(Map<String, Property.BuilderImpl> physicalConnectionRequirements) {
            this.physicalConnectionRequirements = PropertiesMapCopier.copyFromBuilder(physicalConnectionRequirements);
        }

        @Override
        public final Builder physicalConnectionRequirements(Map<String, Property> physicalConnectionRequirements) {
            this.physicalConnectionRequirements = PropertiesMapCopier.copy(physicalConnectionRequirements);
            return this;
        }

        public final Map<String, Property.Builder> getAthenaConnectionProperties() {
            Map<String, Property.Builder> result = PropertiesMapCopier.copyToBuilder(this.athenaConnectionProperties);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAthenaConnectionProperties(Map<String, Property.BuilderImpl> athenaConnectionProperties) {
            this.athenaConnectionProperties = PropertiesMapCopier.copyFromBuilder(athenaConnectionProperties);
        }

        @Override
        public final Builder athenaConnectionProperties(Map<String, Property> athenaConnectionProperties) {
            this.athenaConnectionProperties = PropertiesMapCopier.copy(athenaConnectionProperties);
            return this;
        }

        public final Map<String, Property.Builder> getPythonConnectionProperties() {
            Map<String, Property.Builder> result = PropertiesMapCopier.copyToBuilder(this.pythonConnectionProperties);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPythonConnectionProperties(Map<String, Property.BuilderImpl> pythonConnectionProperties) {
            this.pythonConnectionProperties = PropertiesMapCopier.copyFromBuilder(pythonConnectionProperties);
        }

        @Override
        public final Builder pythonConnectionProperties(Map<String, Property> pythonConnectionProperties) {
            this.pythonConnectionProperties = PropertiesMapCopier.copy(pythonConnectionProperties);
            return this;
        }

        public final Map<String, Property.Builder> getSparkConnectionProperties() {
            Map<String, Property.Builder> result = PropertiesMapCopier.copyToBuilder(this.sparkConnectionProperties);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSparkConnectionProperties(Map<String, Property.BuilderImpl> sparkConnectionProperties) {
            this.sparkConnectionProperties = PropertiesMapCopier.copyFromBuilder(sparkConnectionProperties);
        }

        @Override
        public final Builder sparkConnectionProperties(Map<String, Property> sparkConnectionProperties) {
            this.sparkConnectionProperties = PropertiesMapCopier.copy(sparkConnectionProperties);
            return this;
        }

        @Override
        public DescribeConnectionTypeResponse build() {
            return new DescribeConnectionTypeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
