/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that is used to specify a connection to create or update.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectionInput implements SdkPojo, Serializable, ToCopyableBuilder<ConnectionInput.Builder, ConnectionInput> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ConnectionInput::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ConnectionInput::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionType").getter(getter(ConnectionInput::connectionTypeAsString))
            .setter(setter(Builder::connectionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionType").build()).build();

    private static final SdkField<List<String>> MATCH_CRITERIA_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MatchCriteria")
            .getter(getter(ConnectionInput::matchCriteria))
            .setter(setter(Builder::matchCriteria))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchCriteria").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> CONNECTION_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("ConnectionProperties")
            .getter(getter(ConnectionInput::connectionPropertiesAsStrings))
            .setter(setter(Builder::connectionPropertiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> SPARK_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("SparkProperties")
            .getter(getter(ConnectionInput::sparkProperties))
            .setter(setter(Builder::sparkProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SparkProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> ATHENA_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("AthenaProperties")
            .getter(getter(ConnectionInput::athenaProperties))
            .setter(setter(Builder::athenaProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AthenaProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> PYTHON_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("PythonProperties")
            .getter(getter(ConnectionInput::pythonProperties))
            .setter(setter(Builder::pythonProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PythonProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<PhysicalConnectionRequirements> PHYSICAL_CONNECTION_REQUIREMENTS_FIELD = SdkField
            .<PhysicalConnectionRequirements> builder(MarshallingType.SDK_POJO)
            .memberName("PhysicalConnectionRequirements")
            .getter(getter(ConnectionInput::physicalConnectionRequirements))
            .setter(setter(Builder::physicalConnectionRequirements))
            .constructor(PhysicalConnectionRequirements::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhysicalConnectionRequirements")
                    .build()).build();

    private static final SdkField<AuthenticationConfigurationInput> AUTHENTICATION_CONFIGURATION_FIELD = SdkField
            .<AuthenticationConfigurationInput> builder(MarshallingType.SDK_POJO)
            .memberName("AuthenticationConfiguration")
            .getter(getter(ConnectionInput::authenticationConfiguration))
            .setter(setter(Builder::authenticationConfiguration))
            .constructor(AuthenticationConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationConfiguration")
                    .build()).build();

    private static final SdkField<Boolean> VALIDATE_CREDENTIALS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ValidateCredentials").getter(getter(ConnectionInput::validateCredentials))
            .setter(setter(Builder::validateCredentials))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidateCredentials").build())
            .build();

    private static final SdkField<List<String>> VALIDATE_FOR_COMPUTE_ENVIRONMENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ValidateForComputeEnvironments")
            .getter(getter(ConnectionInput::validateForComputeEnvironmentsAsStrings))
            .setter(setter(Builder::validateForComputeEnvironmentsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidateForComputeEnvironments")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            CONNECTION_TYPE_FIELD, MATCH_CRITERIA_FIELD, CONNECTION_PROPERTIES_FIELD, SPARK_PROPERTIES_FIELD,
            ATHENA_PROPERTIES_FIELD, PYTHON_PROPERTIES_FIELD, PHYSICAL_CONNECTION_REQUIREMENTS_FIELD,
            AUTHENTICATION_CONFIGURATION_FIELD, VALIDATE_CREDENTIALS_FIELD, VALIDATE_FOR_COMPUTE_ENVIRONMENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final String connectionType;

    private final List<String> matchCriteria;

    private final Map<String, String> connectionProperties;

    private final Map<String, String> sparkProperties;

    private final Map<String, String> athenaProperties;

    private final Map<String, String> pythonProperties;

    private final PhysicalConnectionRequirements physicalConnectionRequirements;

    private final AuthenticationConfigurationInput authenticationConfiguration;

    private final Boolean validateCredentials;

    private final List<String> validateForComputeEnvironments;

    private ConnectionInput(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.connectionType = builder.connectionType;
        this.matchCriteria = builder.matchCriteria;
        this.connectionProperties = builder.connectionProperties;
        this.sparkProperties = builder.sparkProperties;
        this.athenaProperties = builder.athenaProperties;
        this.pythonProperties = builder.pythonProperties;
        this.physicalConnectionRequirements = builder.physicalConnectionRequirements;
        this.authenticationConfiguration = builder.authenticationConfiguration;
        this.validateCredentials = builder.validateCredentials;
        this.validateForComputeEnvironments = builder.validateForComputeEnvironments;
    }

    /**
     * <p>
     * The name of the connection.
     * </p>
     * 
     * @return The name of the connection.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the connection.
     * </p>
     * 
     * @return The description of the connection.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The type of the connection. Currently, these types are supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>JDBC</code> - Designates a connection to a database through Java Database Connectivity (JDBC).
     * </p>
     * <p>
     * <code>JDBC</code> Connections use the following ConnectionParameters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Required: All of (<code>HOST</code>, <code>PORT</code>, <code>JDBC_ENGINE</code>) or
     * <code>JDBC_CONNECTION_URL</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Required: All of (<code>USERNAME</code>, <code>PASSWORD</code>) or <code>SECRET_ID</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Optional: <code>JDBC_ENFORCE_SSL</code>, <code>CUSTOM_JDBC_CERT</code>, <code>CUSTOM_JDBC_CERT_STRING</code>,
     * <code>SKIP_CUSTOM_JDBC_CERT_VALIDATION</code>. These parameters are used to configure SSL with JDBC.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>KAFKA</code> - Designates a connection to an Apache Kafka streaming platform.
     * </p>
     * <p>
     * <code>KAFKA</code> Connections use the following ConnectionParameters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Required: <code>KAFKA_BOOTSTRAP_SERVERS</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Optional: <code>KAFKA_SSL_ENABLED</code>, <code>KAFKA_CUSTOM_CERT</code>,
     * <code>KAFKA_SKIP_CUSTOM_CERT_VALIDATION</code>. These parameters are used to configure SSL with
     * <code>KAFKA</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Optional: <code>KAFKA_CLIENT_KEYSTORE</code>, <code>KAFKA_CLIENT_KEYSTORE_PASSWORD</code>,
     * <code>KAFKA_CLIENT_KEY_PASSWORD</code>, <code>ENCRYPTED_KAFKA_CLIENT_KEYSTORE_PASSWORD</code>,
     * <code>ENCRYPTED_KAFKA_CLIENT_KEY_PASSWORD</code>. These parameters are used to configure TLS client configuration
     * with SSL in <code>KAFKA</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Optional: <code>KAFKA_SASL_MECHANISM</code>. Can be specified as <code>SCRAM-SHA-512</code>, <code>GSSAPI</code>,
     * or <code>AWS_MSK_IAM</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Optional: <code>KAFKA_SASL_SCRAM_USERNAME</code>, <code>KAFKA_SASL_SCRAM_PASSWORD</code>,
     * <code>ENCRYPTED_KAFKA_SASL_SCRAM_PASSWORD</code>. These parameters are used to configure SASL/SCRAM-SHA-512
     * authentication with <code>KAFKA</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Optional: <code>KAFKA_SASL_GSSAPI_KEYTAB</code>, <code>KAFKA_SASL_GSSAPI_KRB5_CONF</code>,
     * <code>KAFKA_SASL_GSSAPI_SERVICE</code>, <code>KAFKA_SASL_GSSAPI_PRINCIPAL</code>. These parameters are used to
     * configure SASL/GSSAPI authentication with <code>KAFKA</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>MONGODB</code> - Designates a connection to a MongoDB document database.
     * </p>
     * <p>
     * <code>MONGODB</code> Connections use the following ConnectionParameters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Required: <code>CONNECTION_URL</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Required: All of (<code>USERNAME</code>, <code>PASSWORD</code>) or <code>SECRET_ID</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>VIEW_VALIDATION_REDSHIFT</code> - Designates a connection used for view validation by Amazon Redshift.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VIEW_VALIDATION_ATHENA</code> - Designates a connection used for view validation by Amazon Athena.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NETWORK</code> - Designates a network connection to a data source within an Amazon Virtual Private Cloud
     * environment (Amazon VPC).
     * </p>
     * <p>
     * <code>NETWORK</code> Connections do not require ConnectionParameters. Instead, provide a
     * PhysicalConnectionRequirements.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MARKETPLACE</code> - Uses configuration settings contained in a connector purchased from Amazon Web
     * Services Marketplace to read from and write to data stores that are not natively supported by Glue.
     * </p>
     * <p>
     * <code>MARKETPLACE</code> Connections use the following ConnectionParameters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Required: <code>CONNECTOR_TYPE</code>, <code>CONNECTOR_URL</code>, <code>CONNECTOR_CLASS_NAME</code>,
     * <code>CONNECTION_URL</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Required for <code>JDBC</code> <code>CONNECTOR_TYPE</code> connections: All of (<code>USERNAME</code>,
     * <code>PASSWORD</code>) or <code>SECRET_ID</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>CUSTOM</code> - Uses configuration settings contained in a custom connector to read from and write to data
     * stores that are not natively supported by Glue.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Additionally, a <code>ConnectionType</code> for the following SaaS connectors is supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FACEBOOKADS</code> - Designates a connection to Facebook Ads.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GOOGLEADS</code> - Designates a connection to Google Ads.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GOOGLESHEETS</code> - Designates a connection to Google Sheets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GOOGLEANALYTICS4</code> - Designates a connection to Google Analytics 4.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HUBSPOT</code> - Designates a connection to HubSpot.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INSTAGRAMADS</code> - Designates a connection to Instagram Ads.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INTERCOM</code> - Designates a connection to Intercom.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>JIRACLOUD</code> - Designates a connection to Jira Cloud.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MARKETO</code> - Designates a connection to Adobe Marketo Engage.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NETSUITEERP</code> - Designates a connection to Oracle NetSuite.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SALESFORCE</code> - Designates a connection to Salesforce using OAuth authentication.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SALESFORCEMARKETINGCLOUD</code> - Designates a connection to Salesforce Marketing Cloud.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SALESFORCEPARDOT</code> - Designates a connection to Salesforce Marketing Cloud Account Engagement (MCAE).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SAPODATA</code> - Designates a connection to SAP OData.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SERVICENOW</code> - Designates a connection to ServiceNow.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SLACK</code> - Designates a connection to Slack.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SNAPCHATADS</code> - Designates a connection to Snapchat Ads.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STRIPE</code> - Designates a connection to Stripe.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ZENDESK</code> - Designates a connection to Zendesk.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ZOHOCRM</code> - Designates a connection to Zoho CRM.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information on the connection parameters needed for a particular connector, see the documentation for
     * the connector in <a href="https://docs.aws.amazon.com/glue/latest/dg/console-connections.html">Adding an Glue
     * connection</a>in the Glue User Guide.
     * </p>
     * <p>
     * <code>SFTP</code> is not supported.
     * </p>
     * <p>
     * For more information about how optional ConnectionProperties are used to configure features in Glue, consult <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/connection-defining.html">Glue connection properties</a>.
     * </p>
     * <p>
     * For more information about how optional ConnectionProperties are used to configure features in Glue Studio,
     * consult <a href="https://docs.aws.amazon.com/glue/latest/ug/connectors-chapter.html">Using connectors and
     * connections</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionType}
     * will return {@link ConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionTypeAsString}.
     * </p>
     * 
     * @return The type of the connection. Currently, these types are supported:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>JDBC</code> - Designates a connection to a database through Java Database Connectivity (JDBC).
     *         </p>
     *         <p>
     *         <code>JDBC</code> Connections use the following ConnectionParameters.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Required: All of (<code>HOST</code>, <code>PORT</code>, <code>JDBC_ENGINE</code>) or
     *         <code>JDBC_CONNECTION_URL</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Required: All of (<code>USERNAME</code>, <code>PASSWORD</code>) or <code>SECRET_ID</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Optional: <code>JDBC_ENFORCE_SSL</code>, <code>CUSTOM_JDBC_CERT</code>,
     *         <code>CUSTOM_JDBC_CERT_STRING</code>, <code>SKIP_CUSTOM_JDBC_CERT_VALIDATION</code>. These parameters are
     *         used to configure SSL with JDBC.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KAFKA</code> - Designates a connection to an Apache Kafka streaming platform.
     *         </p>
     *         <p>
     *         <code>KAFKA</code> Connections use the following ConnectionParameters.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Required: <code>KAFKA_BOOTSTRAP_SERVERS</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Optional: <code>KAFKA_SSL_ENABLED</code>, <code>KAFKA_CUSTOM_CERT</code>,
     *         <code>KAFKA_SKIP_CUSTOM_CERT_VALIDATION</code>. These parameters are used to configure SSL with
     *         <code>KAFKA</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Optional: <code>KAFKA_CLIENT_KEYSTORE</code>, <code>KAFKA_CLIENT_KEYSTORE_PASSWORD</code>,
     *         <code>KAFKA_CLIENT_KEY_PASSWORD</code>, <code>ENCRYPTED_KAFKA_CLIENT_KEYSTORE_PASSWORD</code>,
     *         <code>ENCRYPTED_KAFKA_CLIENT_KEY_PASSWORD</code>. These parameters are used to configure TLS client
     *         configuration with SSL in <code>KAFKA</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Optional: <code>KAFKA_SASL_MECHANISM</code>. Can be specified as <code>SCRAM-SHA-512</code>,
     *         <code>GSSAPI</code>, or <code>AWS_MSK_IAM</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Optional: <code>KAFKA_SASL_SCRAM_USERNAME</code>, <code>KAFKA_SASL_SCRAM_PASSWORD</code>,
     *         <code>ENCRYPTED_KAFKA_SASL_SCRAM_PASSWORD</code>. These parameters are used to configure
     *         SASL/SCRAM-SHA-512 authentication with <code>KAFKA</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Optional: <code>KAFKA_SASL_GSSAPI_KEYTAB</code>, <code>KAFKA_SASL_GSSAPI_KRB5_CONF</code>,
     *         <code>KAFKA_SASL_GSSAPI_SERVICE</code>, <code>KAFKA_SASL_GSSAPI_PRINCIPAL</code>. These parameters are
     *         used to configure SASL/GSSAPI authentication with <code>KAFKA</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MONGODB</code> - Designates a connection to a MongoDB document database.
     *         </p>
     *         <p>
     *         <code>MONGODB</code> Connections use the following ConnectionParameters.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Required: <code>CONNECTION_URL</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Required: All of (<code>USERNAME</code>, <code>PASSWORD</code>) or <code>SECRET_ID</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VIEW_VALIDATION_REDSHIFT</code> - Designates a connection used for view validation by Amazon
     *         Redshift.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VIEW_VALIDATION_ATHENA</code> - Designates a connection used for view validation by Amazon Athena.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NETWORK</code> - Designates a network connection to a data source within an Amazon Virtual Private
     *         Cloud environment (Amazon VPC).
     *         </p>
     *         <p>
     *         <code>NETWORK</code> Connections do not require ConnectionParameters. Instead, provide a
     *         PhysicalConnectionRequirements.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MARKETPLACE</code> - Uses configuration settings contained in a connector purchased from Amazon Web
     *         Services Marketplace to read from and write to data stores that are not natively supported by Glue.
     *         </p>
     *         <p>
     *         <code>MARKETPLACE</code> Connections use the following ConnectionParameters.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Required: <code>CONNECTOR_TYPE</code>, <code>CONNECTOR_URL</code>, <code>CONNECTOR_CLASS_NAME</code>,
     *         <code>CONNECTION_URL</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Required for <code>JDBC</code> <code>CONNECTOR_TYPE</code> connections: All of (<code>USERNAME</code>,
     *         <code>PASSWORD</code>) or <code>SECRET_ID</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CUSTOM</code> - Uses configuration settings contained in a custom connector to read from and write
     *         to data stores that are not natively supported by Glue.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Additionally, a <code>ConnectionType</code> for the following SaaS connectors is supported:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FACEBOOKADS</code> - Designates a connection to Facebook Ads.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GOOGLEADS</code> - Designates a connection to Google Ads.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GOOGLESHEETS</code> - Designates a connection to Google Sheets.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GOOGLEANALYTICS4</code> - Designates a connection to Google Analytics 4.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HUBSPOT</code> - Designates a connection to HubSpot.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INSTAGRAMADS</code> - Designates a connection to Instagram Ads.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INTERCOM</code> - Designates a connection to Intercom.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>JIRACLOUD</code> - Designates a connection to Jira Cloud.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MARKETO</code> - Designates a connection to Adobe Marketo Engage.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NETSUITEERP</code> - Designates a connection to Oracle NetSuite.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SALESFORCE</code> - Designates a connection to Salesforce using OAuth authentication.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SALESFORCEMARKETINGCLOUD</code> - Designates a connection to Salesforce Marketing Cloud.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SALESFORCEPARDOT</code> - Designates a connection to Salesforce Marketing Cloud Account Engagement
     *         (MCAE).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SAPODATA</code> - Designates a connection to SAP OData.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SERVICENOW</code> - Designates a connection to ServiceNow.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SLACK</code> - Designates a connection to Slack.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SNAPCHATADS</code> - Designates a connection to Snapchat Ads.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STRIPE</code> - Designates a connection to Stripe.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ZENDESK</code> - Designates a connection to Zendesk.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ZOHOCRM</code> - Designates a connection to Zoho CRM.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information on the connection parameters needed for a particular connector, see the
     *         documentation for the connector in <a
     *         href="https://docs.aws.amazon.com/glue/latest/dg/console-connections.html">Adding an Glue
     *         connection</a>in the Glue User Guide.
     *         </p>
     *         <p>
     *         <code>SFTP</code> is not supported.
     *         </p>
     *         <p>
     *         For more information about how optional ConnectionProperties are used to configure features in Glue,
     *         consult <a href="https://docs.aws.amazon.com/glue/latest/dg/connection-defining.html">Glue connection
     *         properties</a>.
     *         </p>
     *         <p>
     *         For more information about how optional ConnectionProperties are used to configure features in Glue
     *         Studio, consult <a href="https://docs.aws.amazon.com/glue/latest/ug/connectors-chapter.html">Using
     *         connectors and connections</a>.
     * @see ConnectionType
     */
    public final ConnectionType connectionType() {
        return ConnectionType.fromValue(connectionType);
    }

    /**
     * <p>
     * The type of the connection. Currently, these types are supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>JDBC</code> - Designates a connection to a database through Java Database Connectivity (JDBC).
     * </p>
     * <p>
     * <code>JDBC</code> Connections use the following ConnectionParameters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Required: All of (<code>HOST</code>, <code>PORT</code>, <code>JDBC_ENGINE</code>) or
     * <code>JDBC_CONNECTION_URL</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Required: All of (<code>USERNAME</code>, <code>PASSWORD</code>) or <code>SECRET_ID</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Optional: <code>JDBC_ENFORCE_SSL</code>, <code>CUSTOM_JDBC_CERT</code>, <code>CUSTOM_JDBC_CERT_STRING</code>,
     * <code>SKIP_CUSTOM_JDBC_CERT_VALIDATION</code>. These parameters are used to configure SSL with JDBC.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>KAFKA</code> - Designates a connection to an Apache Kafka streaming platform.
     * </p>
     * <p>
     * <code>KAFKA</code> Connections use the following ConnectionParameters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Required: <code>KAFKA_BOOTSTRAP_SERVERS</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Optional: <code>KAFKA_SSL_ENABLED</code>, <code>KAFKA_CUSTOM_CERT</code>,
     * <code>KAFKA_SKIP_CUSTOM_CERT_VALIDATION</code>. These parameters are used to configure SSL with
     * <code>KAFKA</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Optional: <code>KAFKA_CLIENT_KEYSTORE</code>, <code>KAFKA_CLIENT_KEYSTORE_PASSWORD</code>,
     * <code>KAFKA_CLIENT_KEY_PASSWORD</code>, <code>ENCRYPTED_KAFKA_CLIENT_KEYSTORE_PASSWORD</code>,
     * <code>ENCRYPTED_KAFKA_CLIENT_KEY_PASSWORD</code>. These parameters are used to configure TLS client configuration
     * with SSL in <code>KAFKA</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Optional: <code>KAFKA_SASL_MECHANISM</code>. Can be specified as <code>SCRAM-SHA-512</code>, <code>GSSAPI</code>,
     * or <code>AWS_MSK_IAM</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Optional: <code>KAFKA_SASL_SCRAM_USERNAME</code>, <code>KAFKA_SASL_SCRAM_PASSWORD</code>,
     * <code>ENCRYPTED_KAFKA_SASL_SCRAM_PASSWORD</code>. These parameters are used to configure SASL/SCRAM-SHA-512
     * authentication with <code>KAFKA</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Optional: <code>KAFKA_SASL_GSSAPI_KEYTAB</code>, <code>KAFKA_SASL_GSSAPI_KRB5_CONF</code>,
     * <code>KAFKA_SASL_GSSAPI_SERVICE</code>, <code>KAFKA_SASL_GSSAPI_PRINCIPAL</code>. These parameters are used to
     * configure SASL/GSSAPI authentication with <code>KAFKA</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>MONGODB</code> - Designates a connection to a MongoDB document database.
     * </p>
     * <p>
     * <code>MONGODB</code> Connections use the following ConnectionParameters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Required: <code>CONNECTION_URL</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Required: All of (<code>USERNAME</code>, <code>PASSWORD</code>) or <code>SECRET_ID</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>VIEW_VALIDATION_REDSHIFT</code> - Designates a connection used for view validation by Amazon Redshift.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VIEW_VALIDATION_ATHENA</code> - Designates a connection used for view validation by Amazon Athena.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NETWORK</code> - Designates a network connection to a data source within an Amazon Virtual Private Cloud
     * environment (Amazon VPC).
     * </p>
     * <p>
     * <code>NETWORK</code> Connections do not require ConnectionParameters. Instead, provide a
     * PhysicalConnectionRequirements.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MARKETPLACE</code> - Uses configuration settings contained in a connector purchased from Amazon Web
     * Services Marketplace to read from and write to data stores that are not natively supported by Glue.
     * </p>
     * <p>
     * <code>MARKETPLACE</code> Connections use the following ConnectionParameters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Required: <code>CONNECTOR_TYPE</code>, <code>CONNECTOR_URL</code>, <code>CONNECTOR_CLASS_NAME</code>,
     * <code>CONNECTION_URL</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Required for <code>JDBC</code> <code>CONNECTOR_TYPE</code> connections: All of (<code>USERNAME</code>,
     * <code>PASSWORD</code>) or <code>SECRET_ID</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>CUSTOM</code> - Uses configuration settings contained in a custom connector to read from and write to data
     * stores that are not natively supported by Glue.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Additionally, a <code>ConnectionType</code> for the following SaaS connectors is supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FACEBOOKADS</code> - Designates a connection to Facebook Ads.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GOOGLEADS</code> - Designates a connection to Google Ads.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GOOGLESHEETS</code> - Designates a connection to Google Sheets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GOOGLEANALYTICS4</code> - Designates a connection to Google Analytics 4.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HUBSPOT</code> - Designates a connection to HubSpot.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INSTAGRAMADS</code> - Designates a connection to Instagram Ads.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INTERCOM</code> - Designates a connection to Intercom.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>JIRACLOUD</code> - Designates a connection to Jira Cloud.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MARKETO</code> - Designates a connection to Adobe Marketo Engage.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NETSUITEERP</code> - Designates a connection to Oracle NetSuite.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SALESFORCE</code> - Designates a connection to Salesforce using OAuth authentication.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SALESFORCEMARKETINGCLOUD</code> - Designates a connection to Salesforce Marketing Cloud.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SALESFORCEPARDOT</code> - Designates a connection to Salesforce Marketing Cloud Account Engagement (MCAE).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SAPODATA</code> - Designates a connection to SAP OData.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SERVICENOW</code> - Designates a connection to ServiceNow.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SLACK</code> - Designates a connection to Slack.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SNAPCHATADS</code> - Designates a connection to Snapchat Ads.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STRIPE</code> - Designates a connection to Stripe.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ZENDESK</code> - Designates a connection to Zendesk.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ZOHOCRM</code> - Designates a connection to Zoho CRM.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information on the connection parameters needed for a particular connector, see the documentation for
     * the connector in <a href="https://docs.aws.amazon.com/glue/latest/dg/console-connections.html">Adding an Glue
     * connection</a>in the Glue User Guide.
     * </p>
     * <p>
     * <code>SFTP</code> is not supported.
     * </p>
     * <p>
     * For more information about how optional ConnectionProperties are used to configure features in Glue, consult <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/connection-defining.html">Glue connection properties</a>.
     * </p>
     * <p>
     * For more information about how optional ConnectionProperties are used to configure features in Glue Studio,
     * consult <a href="https://docs.aws.amazon.com/glue/latest/ug/connectors-chapter.html">Using connectors and
     * connections</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionType}
     * will return {@link ConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionTypeAsString}.
     * </p>
     * 
     * @return The type of the connection. Currently, these types are supported:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>JDBC</code> - Designates a connection to a database through Java Database Connectivity (JDBC).
     *         </p>
     *         <p>
     *         <code>JDBC</code> Connections use the following ConnectionParameters.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Required: All of (<code>HOST</code>, <code>PORT</code>, <code>JDBC_ENGINE</code>) or
     *         <code>JDBC_CONNECTION_URL</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Required: All of (<code>USERNAME</code>, <code>PASSWORD</code>) or <code>SECRET_ID</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Optional: <code>JDBC_ENFORCE_SSL</code>, <code>CUSTOM_JDBC_CERT</code>,
     *         <code>CUSTOM_JDBC_CERT_STRING</code>, <code>SKIP_CUSTOM_JDBC_CERT_VALIDATION</code>. These parameters are
     *         used to configure SSL with JDBC.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KAFKA</code> - Designates a connection to an Apache Kafka streaming platform.
     *         </p>
     *         <p>
     *         <code>KAFKA</code> Connections use the following ConnectionParameters.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Required: <code>KAFKA_BOOTSTRAP_SERVERS</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Optional: <code>KAFKA_SSL_ENABLED</code>, <code>KAFKA_CUSTOM_CERT</code>,
     *         <code>KAFKA_SKIP_CUSTOM_CERT_VALIDATION</code>. These parameters are used to configure SSL with
     *         <code>KAFKA</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Optional: <code>KAFKA_CLIENT_KEYSTORE</code>, <code>KAFKA_CLIENT_KEYSTORE_PASSWORD</code>,
     *         <code>KAFKA_CLIENT_KEY_PASSWORD</code>, <code>ENCRYPTED_KAFKA_CLIENT_KEYSTORE_PASSWORD</code>,
     *         <code>ENCRYPTED_KAFKA_CLIENT_KEY_PASSWORD</code>. These parameters are used to configure TLS client
     *         configuration with SSL in <code>KAFKA</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Optional: <code>KAFKA_SASL_MECHANISM</code>. Can be specified as <code>SCRAM-SHA-512</code>,
     *         <code>GSSAPI</code>, or <code>AWS_MSK_IAM</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Optional: <code>KAFKA_SASL_SCRAM_USERNAME</code>, <code>KAFKA_SASL_SCRAM_PASSWORD</code>,
     *         <code>ENCRYPTED_KAFKA_SASL_SCRAM_PASSWORD</code>. These parameters are used to configure
     *         SASL/SCRAM-SHA-512 authentication with <code>KAFKA</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Optional: <code>KAFKA_SASL_GSSAPI_KEYTAB</code>, <code>KAFKA_SASL_GSSAPI_KRB5_CONF</code>,
     *         <code>KAFKA_SASL_GSSAPI_SERVICE</code>, <code>KAFKA_SASL_GSSAPI_PRINCIPAL</code>. These parameters are
     *         used to configure SASL/GSSAPI authentication with <code>KAFKA</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MONGODB</code> - Designates a connection to a MongoDB document database.
     *         </p>
     *         <p>
     *         <code>MONGODB</code> Connections use the following ConnectionParameters.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Required: <code>CONNECTION_URL</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Required: All of (<code>USERNAME</code>, <code>PASSWORD</code>) or <code>SECRET_ID</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VIEW_VALIDATION_REDSHIFT</code> - Designates a connection used for view validation by Amazon
     *         Redshift.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VIEW_VALIDATION_ATHENA</code> - Designates a connection used for view validation by Amazon Athena.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NETWORK</code> - Designates a network connection to a data source within an Amazon Virtual Private
     *         Cloud environment (Amazon VPC).
     *         </p>
     *         <p>
     *         <code>NETWORK</code> Connections do not require ConnectionParameters. Instead, provide a
     *         PhysicalConnectionRequirements.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MARKETPLACE</code> - Uses configuration settings contained in a connector purchased from Amazon Web
     *         Services Marketplace to read from and write to data stores that are not natively supported by Glue.
     *         </p>
     *         <p>
     *         <code>MARKETPLACE</code> Connections use the following ConnectionParameters.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Required: <code>CONNECTOR_TYPE</code>, <code>CONNECTOR_URL</code>, <code>CONNECTOR_CLASS_NAME</code>,
     *         <code>CONNECTION_URL</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Required for <code>JDBC</code> <code>CONNECTOR_TYPE</code> connections: All of (<code>USERNAME</code>,
     *         <code>PASSWORD</code>) or <code>SECRET_ID</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CUSTOM</code> - Uses configuration settings contained in a custom connector to read from and write
     *         to data stores that are not natively supported by Glue.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Additionally, a <code>ConnectionType</code> for the following SaaS connectors is supported:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FACEBOOKADS</code> - Designates a connection to Facebook Ads.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GOOGLEADS</code> - Designates a connection to Google Ads.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GOOGLESHEETS</code> - Designates a connection to Google Sheets.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GOOGLEANALYTICS4</code> - Designates a connection to Google Analytics 4.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HUBSPOT</code> - Designates a connection to HubSpot.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INSTAGRAMADS</code> - Designates a connection to Instagram Ads.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INTERCOM</code> - Designates a connection to Intercom.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>JIRACLOUD</code> - Designates a connection to Jira Cloud.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MARKETO</code> - Designates a connection to Adobe Marketo Engage.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NETSUITEERP</code> - Designates a connection to Oracle NetSuite.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SALESFORCE</code> - Designates a connection to Salesforce using OAuth authentication.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SALESFORCEMARKETINGCLOUD</code> - Designates a connection to Salesforce Marketing Cloud.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SALESFORCEPARDOT</code> - Designates a connection to Salesforce Marketing Cloud Account Engagement
     *         (MCAE).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SAPODATA</code> - Designates a connection to SAP OData.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SERVICENOW</code> - Designates a connection to ServiceNow.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SLACK</code> - Designates a connection to Slack.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SNAPCHATADS</code> - Designates a connection to Snapchat Ads.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STRIPE</code> - Designates a connection to Stripe.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ZENDESK</code> - Designates a connection to Zendesk.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ZOHOCRM</code> - Designates a connection to Zoho CRM.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information on the connection parameters needed for a particular connector, see the
     *         documentation for the connector in <a
     *         href="https://docs.aws.amazon.com/glue/latest/dg/console-connections.html">Adding an Glue
     *         connection</a>in the Glue User Guide.
     *         </p>
     *         <p>
     *         <code>SFTP</code> is not supported.
     *         </p>
     *         <p>
     *         For more information about how optional ConnectionProperties are used to configure features in Glue,
     *         consult <a href="https://docs.aws.amazon.com/glue/latest/dg/connection-defining.html">Glue connection
     *         properties</a>.
     *         </p>
     *         <p>
     *         For more information about how optional ConnectionProperties are used to configure features in Glue
     *         Studio, consult <a href="https://docs.aws.amazon.com/glue/latest/ug/connectors-chapter.html">Using
     *         connectors and connections</a>.
     * @see ConnectionType
     */
    public final String connectionTypeAsString() {
        return connectionType;
    }

    /**
     * For responses, this returns true if the service returned a value for the MatchCriteria property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMatchCriteria() {
        return matchCriteria != null && !(matchCriteria instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of criteria that can be used in selecting this connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMatchCriteria} method.
     * </p>
     * 
     * @return A list of criteria that can be used in selecting this connection.
     */
    public final List<String> matchCriteria() {
        return matchCriteria;
    }

    /**
     * <p>
     * These key-value pairs define parameters for the connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectionProperties} method.
     * </p>
     * 
     * @return These key-value pairs define parameters for the connection.
     */
    public final Map<ConnectionPropertyKey, String> connectionProperties() {
        return ConnectionPropertiesCopier.copyStringToEnum(connectionProperties);
    }

    /**
     * For responses, this returns true if the service returned a value for the ConnectionProperties property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConnectionProperties() {
        return connectionProperties != null && !(connectionProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * These key-value pairs define parameters for the connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectionProperties} method.
     * </p>
     * 
     * @return These key-value pairs define parameters for the connection.
     */
    public final Map<String, String> connectionPropertiesAsStrings() {
        return connectionProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the SparkProperties property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSparkProperties() {
        return sparkProperties != null && !(sparkProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Connection properties specific to the Spark compute environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSparkProperties} method.
     * </p>
     * 
     * @return Connection properties specific to the Spark compute environment.
     */
    public final Map<String, String> sparkProperties() {
        return sparkProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the AthenaProperties property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAthenaProperties() {
        return athenaProperties != null && !(athenaProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Connection properties specific to the Athena compute environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAthenaProperties} method.
     * </p>
     * 
     * @return Connection properties specific to the Athena compute environment.
     */
    public final Map<String, String> athenaProperties() {
        return athenaProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the PythonProperties property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPythonProperties() {
        return pythonProperties != null && !(pythonProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Connection properties specific to the Python compute environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPythonProperties} method.
     * </p>
     * 
     * @return Connection properties specific to the Python compute environment.
     */
    public final Map<String, String> pythonProperties() {
        return pythonProperties;
    }

    /**
     * <p>
     * The physical connection requirements, such as virtual private cloud (VPC) and <code>SecurityGroup</code>, that
     * are needed to successfully make this connection.
     * </p>
     * 
     * @return The physical connection requirements, such as virtual private cloud (VPC) and <code>SecurityGroup</code>,
     *         that are needed to successfully make this connection.
     */
    public final PhysicalConnectionRequirements physicalConnectionRequirements() {
        return physicalConnectionRequirements;
    }

    /**
     * <p>
     * The authentication properties of the connection.
     * </p>
     * 
     * @return The authentication properties of the connection.
     */
    public final AuthenticationConfigurationInput authenticationConfiguration() {
        return authenticationConfiguration;
    }

    /**
     * <p>
     * A flag to validate the credentials during create connection. Default is true.
     * </p>
     * 
     * @return A flag to validate the credentials during create connection. Default is true.
     */
    public final Boolean validateCredentials() {
        return validateCredentials;
    }

    /**
     * <p>
     * The compute environments that the specified connection properties are validated against.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValidateForComputeEnvironments} method.
     * </p>
     * 
     * @return The compute environments that the specified connection properties are validated against.
     */
    public final List<ComputeEnvironment> validateForComputeEnvironments() {
        return ComputeEnvironmentListCopier.copyStringToEnum(validateForComputeEnvironments);
    }

    /**
     * For responses, this returns true if the service returned a value for the ValidateForComputeEnvironments property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasValidateForComputeEnvironments() {
        return validateForComputeEnvironments != null && !(validateForComputeEnvironments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The compute environments that the specified connection properties are validated against.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValidateForComputeEnvironments} method.
     * </p>
     * 
     * @return The compute environments that the specified connection properties are validated against.
     */
    public final List<String> validateForComputeEnvironmentsAsStrings() {
        return validateForComputeEnvironments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(connectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasMatchCriteria() ? matchCriteria() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectionProperties() ? connectionPropertiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSparkProperties() ? sparkProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAthenaProperties() ? athenaProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPythonProperties() ? pythonProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(physicalConnectionRequirements());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(validateCredentials());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasValidateForComputeEnvironments() ? validateForComputeEnvironmentsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionInput)) {
            return false;
        }
        ConnectionInput other = (ConnectionInput) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(connectionTypeAsString(), other.connectionTypeAsString())
                && hasMatchCriteria() == other.hasMatchCriteria() && Objects.equals(matchCriteria(), other.matchCriteria())
                && hasConnectionProperties() == other.hasConnectionProperties()
                && Objects.equals(connectionPropertiesAsStrings(), other.connectionPropertiesAsStrings())
                && hasSparkProperties() == other.hasSparkProperties()
                && Objects.equals(sparkProperties(), other.sparkProperties())
                && hasAthenaProperties() == other.hasAthenaProperties()
                && Objects.equals(athenaProperties(), other.athenaProperties())
                && hasPythonProperties() == other.hasPythonProperties()
                && Objects.equals(pythonProperties(), other.pythonProperties())
                && Objects.equals(physicalConnectionRequirements(), other.physicalConnectionRequirements())
                && Objects.equals(authenticationConfiguration(), other.authenticationConfiguration())
                && Objects.equals(validateCredentials(), other.validateCredentials())
                && hasValidateForComputeEnvironments() == other.hasValidateForComputeEnvironments()
                && Objects.equals(validateForComputeEnvironmentsAsStrings(), other.validateForComputeEnvironmentsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ConnectionInput")
                .add("Name", name())
                .add("Description", description())
                .add("ConnectionType", connectionTypeAsString())
                .add("MatchCriteria", hasMatchCriteria() ? matchCriteria() : null)
                .add("ConnectionProperties", hasConnectionProperties() ? connectionPropertiesAsStrings() : null)
                .add("SparkProperties", hasSparkProperties() ? sparkProperties() : null)
                .add("AthenaProperties", hasAthenaProperties() ? athenaProperties() : null)
                .add("PythonProperties", hasPythonProperties() ? pythonProperties() : null)
                .add("PhysicalConnectionRequirements", physicalConnectionRequirements())
                .add("AuthenticationConfiguration", authenticationConfiguration())
                .add("ValidateCredentials", validateCredentials())
                .add("ValidateForComputeEnvironments",
                        hasValidateForComputeEnvironments() ? validateForComputeEnvironmentsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ConnectionType":
            return Optional.ofNullable(clazz.cast(connectionTypeAsString()));
        case "MatchCriteria":
            return Optional.ofNullable(clazz.cast(matchCriteria()));
        case "ConnectionProperties":
            return Optional.ofNullable(clazz.cast(connectionPropertiesAsStrings()));
        case "SparkProperties":
            return Optional.ofNullable(clazz.cast(sparkProperties()));
        case "AthenaProperties":
            return Optional.ofNullable(clazz.cast(athenaProperties()));
        case "PythonProperties":
            return Optional.ofNullable(clazz.cast(pythonProperties()));
        case "PhysicalConnectionRequirements":
            return Optional.ofNullable(clazz.cast(physicalConnectionRequirements()));
        case "AuthenticationConfiguration":
            return Optional.ofNullable(clazz.cast(authenticationConfiguration()));
        case "ValidateCredentials":
            return Optional.ofNullable(clazz.cast(validateCredentials()));
        case "ValidateForComputeEnvironments":
            return Optional.ofNullable(clazz.cast(validateForComputeEnvironmentsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ConnectionType", CONNECTION_TYPE_FIELD);
        map.put("MatchCriteria", MATCH_CRITERIA_FIELD);
        map.put("ConnectionProperties", CONNECTION_PROPERTIES_FIELD);
        map.put("SparkProperties", SPARK_PROPERTIES_FIELD);
        map.put("AthenaProperties", ATHENA_PROPERTIES_FIELD);
        map.put("PythonProperties", PYTHON_PROPERTIES_FIELD);
        map.put("PhysicalConnectionRequirements", PHYSICAL_CONNECTION_REQUIREMENTS_FIELD);
        map.put("AuthenticationConfiguration", AUTHENTICATION_CONFIGURATION_FIELD);
        map.put("ValidateCredentials", VALIDATE_CREDENTIALS_FIELD);
        map.put("ValidateForComputeEnvironments", VALIDATE_FOR_COMPUTE_ENVIRONMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectionInput, T> g) {
        return obj -> g.apply((ConnectionInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectionInput> {
        /**
         * <p>
         * The name of the connection.
         * </p>
         * 
         * @param name
         *        The name of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the connection.
         * </p>
         * 
         * @param description
         *        The description of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of the connection. Currently, these types are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>JDBC</code> - Designates a connection to a database through Java Database Connectivity (JDBC).
         * </p>
         * <p>
         * <code>JDBC</code> Connections use the following ConnectionParameters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Required: All of (<code>HOST</code>, <code>PORT</code>, <code>JDBC_ENGINE</code>) or
         * <code>JDBC_CONNECTION_URL</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Required: All of (<code>USERNAME</code>, <code>PASSWORD</code>) or <code>SECRET_ID</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Optional: <code>JDBC_ENFORCE_SSL</code>, <code>CUSTOM_JDBC_CERT</code>, <code>CUSTOM_JDBC_CERT_STRING</code>,
         * <code>SKIP_CUSTOM_JDBC_CERT_VALIDATION</code>. These parameters are used to configure SSL with JDBC.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>KAFKA</code> - Designates a connection to an Apache Kafka streaming platform.
         * </p>
         * <p>
         * <code>KAFKA</code> Connections use the following ConnectionParameters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Required: <code>KAFKA_BOOTSTRAP_SERVERS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Optional: <code>KAFKA_SSL_ENABLED</code>, <code>KAFKA_CUSTOM_CERT</code>,
         * <code>KAFKA_SKIP_CUSTOM_CERT_VALIDATION</code>. These parameters are used to configure SSL with
         * <code>KAFKA</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Optional: <code>KAFKA_CLIENT_KEYSTORE</code>, <code>KAFKA_CLIENT_KEYSTORE_PASSWORD</code>,
         * <code>KAFKA_CLIENT_KEY_PASSWORD</code>, <code>ENCRYPTED_KAFKA_CLIENT_KEYSTORE_PASSWORD</code>,
         * <code>ENCRYPTED_KAFKA_CLIENT_KEY_PASSWORD</code>. These parameters are used to configure TLS client
         * configuration with SSL in <code>KAFKA</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Optional: <code>KAFKA_SASL_MECHANISM</code>. Can be specified as <code>SCRAM-SHA-512</code>,
         * <code>GSSAPI</code>, or <code>AWS_MSK_IAM</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Optional: <code>KAFKA_SASL_SCRAM_USERNAME</code>, <code>KAFKA_SASL_SCRAM_PASSWORD</code>,
         * <code>ENCRYPTED_KAFKA_SASL_SCRAM_PASSWORD</code>. These parameters are used to configure SASL/SCRAM-SHA-512
         * authentication with <code>KAFKA</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Optional: <code>KAFKA_SASL_GSSAPI_KEYTAB</code>, <code>KAFKA_SASL_GSSAPI_KRB5_CONF</code>,
         * <code>KAFKA_SASL_GSSAPI_SERVICE</code>, <code>KAFKA_SASL_GSSAPI_PRINCIPAL</code>. These parameters are used
         * to configure SASL/GSSAPI authentication with <code>KAFKA</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>MONGODB</code> - Designates a connection to a MongoDB document database.
         * </p>
         * <p>
         * <code>MONGODB</code> Connections use the following ConnectionParameters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Required: <code>CONNECTION_URL</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Required: All of (<code>USERNAME</code>, <code>PASSWORD</code>) or <code>SECRET_ID</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>VIEW_VALIDATION_REDSHIFT</code> - Designates a connection used for view validation by Amazon Redshift.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VIEW_VALIDATION_ATHENA</code> - Designates a connection used for view validation by Amazon Athena.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NETWORK</code> - Designates a network connection to a data source within an Amazon Virtual Private
         * Cloud environment (Amazon VPC).
         * </p>
         * <p>
         * <code>NETWORK</code> Connections do not require ConnectionParameters. Instead, provide a
         * PhysicalConnectionRequirements.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MARKETPLACE</code> - Uses configuration settings contained in a connector purchased from Amazon Web
         * Services Marketplace to read from and write to data stores that are not natively supported by Glue.
         * </p>
         * <p>
         * <code>MARKETPLACE</code> Connections use the following ConnectionParameters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Required: <code>CONNECTOR_TYPE</code>, <code>CONNECTOR_URL</code>, <code>CONNECTOR_CLASS_NAME</code>,
         * <code>CONNECTION_URL</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Required for <code>JDBC</code> <code>CONNECTOR_TYPE</code> connections: All of (<code>USERNAME</code>,
         * <code>PASSWORD</code>) or <code>SECRET_ID</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>CUSTOM</code> - Uses configuration settings contained in a custom connector to read from and write to
         * data stores that are not natively supported by Glue.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Additionally, a <code>ConnectionType</code> for the following SaaS connectors is supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FACEBOOKADS</code> - Designates a connection to Facebook Ads.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GOOGLEADS</code> - Designates a connection to Google Ads.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GOOGLESHEETS</code> - Designates a connection to Google Sheets.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GOOGLEANALYTICS4</code> - Designates a connection to Google Analytics 4.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HUBSPOT</code> - Designates a connection to HubSpot.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INSTAGRAMADS</code> - Designates a connection to Instagram Ads.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INTERCOM</code> - Designates a connection to Intercom.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>JIRACLOUD</code> - Designates a connection to Jira Cloud.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MARKETO</code> - Designates a connection to Adobe Marketo Engage.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NETSUITEERP</code> - Designates a connection to Oracle NetSuite.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SALESFORCE</code> - Designates a connection to Salesforce using OAuth authentication.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SALESFORCEMARKETINGCLOUD</code> - Designates a connection to Salesforce Marketing Cloud.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SALESFORCEPARDOT</code> - Designates a connection to Salesforce Marketing Cloud Account Engagement
         * (MCAE).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SAPODATA</code> - Designates a connection to SAP OData.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SERVICENOW</code> - Designates a connection to ServiceNow.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SLACK</code> - Designates a connection to Slack.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SNAPCHATADS</code> - Designates a connection to Snapchat Ads.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STRIPE</code> - Designates a connection to Stripe.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ZENDESK</code> - Designates a connection to Zendesk.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ZOHOCRM</code> - Designates a connection to Zoho CRM.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information on the connection parameters needed for a particular connector, see the documentation
         * for the connector in <a href="https://docs.aws.amazon.com/glue/latest/dg/console-connections.html">Adding an
         * Glue connection</a>in the Glue User Guide.
         * </p>
         * <p>
         * <code>SFTP</code> is not supported.
         * </p>
         * <p>
         * For more information about how optional ConnectionProperties are used to configure features in Glue, consult
         * <a href="https://docs.aws.amazon.com/glue/latest/dg/connection-defining.html">Glue connection properties</a>.
         * </p>
         * <p>
         * For more information about how optional ConnectionProperties are used to configure features in Glue Studio,
         * consult <a href="https://docs.aws.amazon.com/glue/latest/ug/connectors-chapter.html">Using connectors and
         * connections</a>.
         * </p>
         * 
         * @param connectionType
         *        The type of the connection. Currently, these types are supported:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>JDBC</code> - Designates a connection to a database through Java Database Connectivity (JDBC).
         *        </p>
         *        <p>
         *        <code>JDBC</code> Connections use the following ConnectionParameters.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Required: All of (<code>HOST</code>, <code>PORT</code>, <code>JDBC_ENGINE</code>) or
         *        <code>JDBC_CONNECTION_URL</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Required: All of (<code>USERNAME</code>, <code>PASSWORD</code>) or <code>SECRET_ID</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Optional: <code>JDBC_ENFORCE_SSL</code>, <code>CUSTOM_JDBC_CERT</code>,
         *        <code>CUSTOM_JDBC_CERT_STRING</code>, <code>SKIP_CUSTOM_JDBC_CERT_VALIDATION</code>. These parameters
         *        are used to configure SSL with JDBC.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KAFKA</code> - Designates a connection to an Apache Kafka streaming platform.
         *        </p>
         *        <p>
         *        <code>KAFKA</code> Connections use the following ConnectionParameters.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Required: <code>KAFKA_BOOTSTRAP_SERVERS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Optional: <code>KAFKA_SSL_ENABLED</code>, <code>KAFKA_CUSTOM_CERT</code>,
         *        <code>KAFKA_SKIP_CUSTOM_CERT_VALIDATION</code>. These parameters are used to configure SSL with
         *        <code>KAFKA</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Optional: <code>KAFKA_CLIENT_KEYSTORE</code>, <code>KAFKA_CLIENT_KEYSTORE_PASSWORD</code>,
         *        <code>KAFKA_CLIENT_KEY_PASSWORD</code>, <code>ENCRYPTED_KAFKA_CLIENT_KEYSTORE_PASSWORD</code>,
         *        <code>ENCRYPTED_KAFKA_CLIENT_KEY_PASSWORD</code>. These parameters are used to configure TLS client
         *        configuration with SSL in <code>KAFKA</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Optional: <code>KAFKA_SASL_MECHANISM</code>. Can be specified as <code>SCRAM-SHA-512</code>,
         *        <code>GSSAPI</code>, or <code>AWS_MSK_IAM</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Optional: <code>KAFKA_SASL_SCRAM_USERNAME</code>, <code>KAFKA_SASL_SCRAM_PASSWORD</code>,
         *        <code>ENCRYPTED_KAFKA_SASL_SCRAM_PASSWORD</code>. These parameters are used to configure
         *        SASL/SCRAM-SHA-512 authentication with <code>KAFKA</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Optional: <code>KAFKA_SASL_GSSAPI_KEYTAB</code>, <code>KAFKA_SASL_GSSAPI_KRB5_CONF</code>,
         *        <code>KAFKA_SASL_GSSAPI_SERVICE</code>, <code>KAFKA_SASL_GSSAPI_PRINCIPAL</code>. These parameters are
         *        used to configure SASL/GSSAPI authentication with <code>KAFKA</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MONGODB</code> - Designates a connection to a MongoDB document database.
         *        </p>
         *        <p>
         *        <code>MONGODB</code> Connections use the following ConnectionParameters.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Required: <code>CONNECTION_URL</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Required: All of (<code>USERNAME</code>, <code>PASSWORD</code>) or <code>SECRET_ID</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VIEW_VALIDATION_REDSHIFT</code> - Designates a connection used for view validation by Amazon
         *        Redshift.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VIEW_VALIDATION_ATHENA</code> - Designates a connection used for view validation by Amazon
         *        Athena.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NETWORK</code> - Designates a network connection to a data source within an Amazon Virtual
         *        Private Cloud environment (Amazon VPC).
         *        </p>
         *        <p>
         *        <code>NETWORK</code> Connections do not require ConnectionParameters. Instead, provide a
         *        PhysicalConnectionRequirements.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MARKETPLACE</code> - Uses configuration settings contained in a connector purchased from Amazon
         *        Web Services Marketplace to read from and write to data stores that are not natively supported by
         *        Glue.
         *        </p>
         *        <p>
         *        <code>MARKETPLACE</code> Connections use the following ConnectionParameters.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Required: <code>CONNECTOR_TYPE</code>, <code>CONNECTOR_URL</code>, <code>CONNECTOR_CLASS_NAME</code>,
         *        <code>CONNECTION_URL</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Required for <code>JDBC</code> <code>CONNECTOR_TYPE</code> connections: All of (<code>USERNAME</code>,
         *        <code>PASSWORD</code>) or <code>SECRET_ID</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CUSTOM</code> - Uses configuration settings contained in a custom connector to read from and
         *        write to data stores that are not natively supported by Glue.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Additionally, a <code>ConnectionType</code> for the following SaaS connectors is supported:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FACEBOOKADS</code> - Designates a connection to Facebook Ads.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GOOGLEADS</code> - Designates a connection to Google Ads.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GOOGLESHEETS</code> - Designates a connection to Google Sheets.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GOOGLEANALYTICS4</code> - Designates a connection to Google Analytics 4.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HUBSPOT</code> - Designates a connection to HubSpot.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INSTAGRAMADS</code> - Designates a connection to Instagram Ads.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INTERCOM</code> - Designates a connection to Intercom.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>JIRACLOUD</code> - Designates a connection to Jira Cloud.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MARKETO</code> - Designates a connection to Adobe Marketo Engage.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NETSUITEERP</code> - Designates a connection to Oracle NetSuite.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SALESFORCE</code> - Designates a connection to Salesforce using OAuth authentication.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SALESFORCEMARKETINGCLOUD</code> - Designates a connection to Salesforce Marketing Cloud.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SALESFORCEPARDOT</code> - Designates a connection to Salesforce Marketing Cloud Account
         *        Engagement (MCAE).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SAPODATA</code> - Designates a connection to SAP OData.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SERVICENOW</code> - Designates a connection to ServiceNow.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SLACK</code> - Designates a connection to Slack.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SNAPCHATADS</code> - Designates a connection to Snapchat Ads.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STRIPE</code> - Designates a connection to Stripe.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ZENDESK</code> - Designates a connection to Zendesk.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ZOHOCRM</code> - Designates a connection to Zoho CRM.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information on the connection parameters needed for a particular connector, see the
         *        documentation for the connector in <a
         *        href="https://docs.aws.amazon.com/glue/latest/dg/console-connections.html">Adding an Glue
         *        connection</a>in the Glue User Guide.
         *        </p>
         *        <p>
         *        <code>SFTP</code> is not supported.
         *        </p>
         *        <p>
         *        For more information about how optional ConnectionProperties are used to configure features in Glue,
         *        consult <a href="https://docs.aws.amazon.com/glue/latest/dg/connection-defining.html">Glue connection
         *        properties</a>.
         *        </p>
         *        <p>
         *        For more information about how optional ConnectionProperties are used to configure features in Glue
         *        Studio, consult <a href="https://docs.aws.amazon.com/glue/latest/ug/connectors-chapter.html">Using
         *        connectors and connections</a>.
         * @see ConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionType
         */
        Builder connectionType(String connectionType);

        /**
         * <p>
         * The type of the connection. Currently, these types are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>JDBC</code> - Designates a connection to a database through Java Database Connectivity (JDBC).
         * </p>
         * <p>
         * <code>JDBC</code> Connections use the following ConnectionParameters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Required: All of (<code>HOST</code>, <code>PORT</code>, <code>JDBC_ENGINE</code>) or
         * <code>JDBC_CONNECTION_URL</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Required: All of (<code>USERNAME</code>, <code>PASSWORD</code>) or <code>SECRET_ID</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Optional: <code>JDBC_ENFORCE_SSL</code>, <code>CUSTOM_JDBC_CERT</code>, <code>CUSTOM_JDBC_CERT_STRING</code>,
         * <code>SKIP_CUSTOM_JDBC_CERT_VALIDATION</code>. These parameters are used to configure SSL with JDBC.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>KAFKA</code> - Designates a connection to an Apache Kafka streaming platform.
         * </p>
         * <p>
         * <code>KAFKA</code> Connections use the following ConnectionParameters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Required: <code>KAFKA_BOOTSTRAP_SERVERS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Optional: <code>KAFKA_SSL_ENABLED</code>, <code>KAFKA_CUSTOM_CERT</code>,
         * <code>KAFKA_SKIP_CUSTOM_CERT_VALIDATION</code>. These parameters are used to configure SSL with
         * <code>KAFKA</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Optional: <code>KAFKA_CLIENT_KEYSTORE</code>, <code>KAFKA_CLIENT_KEYSTORE_PASSWORD</code>,
         * <code>KAFKA_CLIENT_KEY_PASSWORD</code>, <code>ENCRYPTED_KAFKA_CLIENT_KEYSTORE_PASSWORD</code>,
         * <code>ENCRYPTED_KAFKA_CLIENT_KEY_PASSWORD</code>. These parameters are used to configure TLS client
         * configuration with SSL in <code>KAFKA</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Optional: <code>KAFKA_SASL_MECHANISM</code>. Can be specified as <code>SCRAM-SHA-512</code>,
         * <code>GSSAPI</code>, or <code>AWS_MSK_IAM</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Optional: <code>KAFKA_SASL_SCRAM_USERNAME</code>, <code>KAFKA_SASL_SCRAM_PASSWORD</code>,
         * <code>ENCRYPTED_KAFKA_SASL_SCRAM_PASSWORD</code>. These parameters are used to configure SASL/SCRAM-SHA-512
         * authentication with <code>KAFKA</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Optional: <code>KAFKA_SASL_GSSAPI_KEYTAB</code>, <code>KAFKA_SASL_GSSAPI_KRB5_CONF</code>,
         * <code>KAFKA_SASL_GSSAPI_SERVICE</code>, <code>KAFKA_SASL_GSSAPI_PRINCIPAL</code>. These parameters are used
         * to configure SASL/GSSAPI authentication with <code>KAFKA</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>MONGODB</code> - Designates a connection to a MongoDB document database.
         * </p>
         * <p>
         * <code>MONGODB</code> Connections use the following ConnectionParameters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Required: <code>CONNECTION_URL</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Required: All of (<code>USERNAME</code>, <code>PASSWORD</code>) or <code>SECRET_ID</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>VIEW_VALIDATION_REDSHIFT</code> - Designates a connection used for view validation by Amazon Redshift.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VIEW_VALIDATION_ATHENA</code> - Designates a connection used for view validation by Amazon Athena.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NETWORK</code> - Designates a network connection to a data source within an Amazon Virtual Private
         * Cloud environment (Amazon VPC).
         * </p>
         * <p>
         * <code>NETWORK</code> Connections do not require ConnectionParameters. Instead, provide a
         * PhysicalConnectionRequirements.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MARKETPLACE</code> - Uses configuration settings contained in a connector purchased from Amazon Web
         * Services Marketplace to read from and write to data stores that are not natively supported by Glue.
         * </p>
         * <p>
         * <code>MARKETPLACE</code> Connections use the following ConnectionParameters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Required: <code>CONNECTOR_TYPE</code>, <code>CONNECTOR_URL</code>, <code>CONNECTOR_CLASS_NAME</code>,
         * <code>CONNECTION_URL</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Required for <code>JDBC</code> <code>CONNECTOR_TYPE</code> connections: All of (<code>USERNAME</code>,
         * <code>PASSWORD</code>) or <code>SECRET_ID</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>CUSTOM</code> - Uses configuration settings contained in a custom connector to read from and write to
         * data stores that are not natively supported by Glue.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Additionally, a <code>ConnectionType</code> for the following SaaS connectors is supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FACEBOOKADS</code> - Designates a connection to Facebook Ads.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GOOGLEADS</code> - Designates a connection to Google Ads.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GOOGLESHEETS</code> - Designates a connection to Google Sheets.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GOOGLEANALYTICS4</code> - Designates a connection to Google Analytics 4.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HUBSPOT</code> - Designates a connection to HubSpot.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INSTAGRAMADS</code> - Designates a connection to Instagram Ads.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INTERCOM</code> - Designates a connection to Intercom.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>JIRACLOUD</code> - Designates a connection to Jira Cloud.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MARKETO</code> - Designates a connection to Adobe Marketo Engage.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NETSUITEERP</code> - Designates a connection to Oracle NetSuite.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SALESFORCE</code> - Designates a connection to Salesforce using OAuth authentication.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SALESFORCEMARKETINGCLOUD</code> - Designates a connection to Salesforce Marketing Cloud.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SALESFORCEPARDOT</code> - Designates a connection to Salesforce Marketing Cloud Account Engagement
         * (MCAE).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SAPODATA</code> - Designates a connection to SAP OData.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SERVICENOW</code> - Designates a connection to ServiceNow.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SLACK</code> - Designates a connection to Slack.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SNAPCHATADS</code> - Designates a connection to Snapchat Ads.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STRIPE</code> - Designates a connection to Stripe.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ZENDESK</code> - Designates a connection to Zendesk.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ZOHOCRM</code> - Designates a connection to Zoho CRM.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information on the connection parameters needed for a particular connector, see the documentation
         * for the connector in <a href="https://docs.aws.amazon.com/glue/latest/dg/console-connections.html">Adding an
         * Glue connection</a>in the Glue User Guide.
         * </p>
         * <p>
         * <code>SFTP</code> is not supported.
         * </p>
         * <p>
         * For more information about how optional ConnectionProperties are used to configure features in Glue, consult
         * <a href="https://docs.aws.amazon.com/glue/latest/dg/connection-defining.html">Glue connection properties</a>.
         * </p>
         * <p>
         * For more information about how optional ConnectionProperties are used to configure features in Glue Studio,
         * consult <a href="https://docs.aws.amazon.com/glue/latest/ug/connectors-chapter.html">Using connectors and
         * connections</a>.
         * </p>
         * 
         * @param connectionType
         *        The type of the connection. Currently, these types are supported:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>JDBC</code> - Designates a connection to a database through Java Database Connectivity (JDBC).
         *        </p>
         *        <p>
         *        <code>JDBC</code> Connections use the following ConnectionParameters.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Required: All of (<code>HOST</code>, <code>PORT</code>, <code>JDBC_ENGINE</code>) or
         *        <code>JDBC_CONNECTION_URL</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Required: All of (<code>USERNAME</code>, <code>PASSWORD</code>) or <code>SECRET_ID</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Optional: <code>JDBC_ENFORCE_SSL</code>, <code>CUSTOM_JDBC_CERT</code>,
         *        <code>CUSTOM_JDBC_CERT_STRING</code>, <code>SKIP_CUSTOM_JDBC_CERT_VALIDATION</code>. These parameters
         *        are used to configure SSL with JDBC.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KAFKA</code> - Designates a connection to an Apache Kafka streaming platform.
         *        </p>
         *        <p>
         *        <code>KAFKA</code> Connections use the following ConnectionParameters.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Required: <code>KAFKA_BOOTSTRAP_SERVERS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Optional: <code>KAFKA_SSL_ENABLED</code>, <code>KAFKA_CUSTOM_CERT</code>,
         *        <code>KAFKA_SKIP_CUSTOM_CERT_VALIDATION</code>. These parameters are used to configure SSL with
         *        <code>KAFKA</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Optional: <code>KAFKA_CLIENT_KEYSTORE</code>, <code>KAFKA_CLIENT_KEYSTORE_PASSWORD</code>,
         *        <code>KAFKA_CLIENT_KEY_PASSWORD</code>, <code>ENCRYPTED_KAFKA_CLIENT_KEYSTORE_PASSWORD</code>,
         *        <code>ENCRYPTED_KAFKA_CLIENT_KEY_PASSWORD</code>. These parameters are used to configure TLS client
         *        configuration with SSL in <code>KAFKA</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Optional: <code>KAFKA_SASL_MECHANISM</code>. Can be specified as <code>SCRAM-SHA-512</code>,
         *        <code>GSSAPI</code>, or <code>AWS_MSK_IAM</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Optional: <code>KAFKA_SASL_SCRAM_USERNAME</code>, <code>KAFKA_SASL_SCRAM_PASSWORD</code>,
         *        <code>ENCRYPTED_KAFKA_SASL_SCRAM_PASSWORD</code>. These parameters are used to configure
         *        SASL/SCRAM-SHA-512 authentication with <code>KAFKA</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Optional: <code>KAFKA_SASL_GSSAPI_KEYTAB</code>, <code>KAFKA_SASL_GSSAPI_KRB5_CONF</code>,
         *        <code>KAFKA_SASL_GSSAPI_SERVICE</code>, <code>KAFKA_SASL_GSSAPI_PRINCIPAL</code>. These parameters are
         *        used to configure SASL/GSSAPI authentication with <code>KAFKA</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MONGODB</code> - Designates a connection to a MongoDB document database.
         *        </p>
         *        <p>
         *        <code>MONGODB</code> Connections use the following ConnectionParameters.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Required: <code>CONNECTION_URL</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Required: All of (<code>USERNAME</code>, <code>PASSWORD</code>) or <code>SECRET_ID</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VIEW_VALIDATION_REDSHIFT</code> - Designates a connection used for view validation by Amazon
         *        Redshift.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VIEW_VALIDATION_ATHENA</code> - Designates a connection used for view validation by Amazon
         *        Athena.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NETWORK</code> - Designates a network connection to a data source within an Amazon Virtual
         *        Private Cloud environment (Amazon VPC).
         *        </p>
         *        <p>
         *        <code>NETWORK</code> Connections do not require ConnectionParameters. Instead, provide a
         *        PhysicalConnectionRequirements.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MARKETPLACE</code> - Uses configuration settings contained in a connector purchased from Amazon
         *        Web Services Marketplace to read from and write to data stores that are not natively supported by
         *        Glue.
         *        </p>
         *        <p>
         *        <code>MARKETPLACE</code> Connections use the following ConnectionParameters.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Required: <code>CONNECTOR_TYPE</code>, <code>CONNECTOR_URL</code>, <code>CONNECTOR_CLASS_NAME</code>,
         *        <code>CONNECTION_URL</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Required for <code>JDBC</code> <code>CONNECTOR_TYPE</code> connections: All of (<code>USERNAME</code>,
         *        <code>PASSWORD</code>) or <code>SECRET_ID</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CUSTOM</code> - Uses configuration settings contained in a custom connector to read from and
         *        write to data stores that are not natively supported by Glue.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Additionally, a <code>ConnectionType</code> for the following SaaS connectors is supported:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FACEBOOKADS</code> - Designates a connection to Facebook Ads.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GOOGLEADS</code> - Designates a connection to Google Ads.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GOOGLESHEETS</code> - Designates a connection to Google Sheets.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GOOGLEANALYTICS4</code> - Designates a connection to Google Analytics 4.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HUBSPOT</code> - Designates a connection to HubSpot.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INSTAGRAMADS</code> - Designates a connection to Instagram Ads.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INTERCOM</code> - Designates a connection to Intercom.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>JIRACLOUD</code> - Designates a connection to Jira Cloud.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MARKETO</code> - Designates a connection to Adobe Marketo Engage.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NETSUITEERP</code> - Designates a connection to Oracle NetSuite.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SALESFORCE</code> - Designates a connection to Salesforce using OAuth authentication.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SALESFORCEMARKETINGCLOUD</code> - Designates a connection to Salesforce Marketing Cloud.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SALESFORCEPARDOT</code> - Designates a connection to Salesforce Marketing Cloud Account
         *        Engagement (MCAE).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SAPODATA</code> - Designates a connection to SAP OData.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SERVICENOW</code> - Designates a connection to ServiceNow.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SLACK</code> - Designates a connection to Slack.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SNAPCHATADS</code> - Designates a connection to Snapchat Ads.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STRIPE</code> - Designates a connection to Stripe.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ZENDESK</code> - Designates a connection to Zendesk.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ZOHOCRM</code> - Designates a connection to Zoho CRM.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information on the connection parameters needed for a particular connector, see the
         *        documentation for the connector in <a
         *        href="https://docs.aws.amazon.com/glue/latest/dg/console-connections.html">Adding an Glue
         *        connection</a>in the Glue User Guide.
         *        </p>
         *        <p>
         *        <code>SFTP</code> is not supported.
         *        </p>
         *        <p>
         *        For more information about how optional ConnectionProperties are used to configure features in Glue,
         *        consult <a href="https://docs.aws.amazon.com/glue/latest/dg/connection-defining.html">Glue connection
         *        properties</a>.
         *        </p>
         *        <p>
         *        For more information about how optional ConnectionProperties are used to configure features in Glue
         *        Studio, consult <a href="https://docs.aws.amazon.com/glue/latest/ug/connectors-chapter.html">Using
         *        connectors and connections</a>.
         * @see ConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionType
         */
        Builder connectionType(ConnectionType connectionType);

        /**
         * <p>
         * A list of criteria that can be used in selecting this connection.
         * </p>
         * 
         * @param matchCriteria
         *        A list of criteria that can be used in selecting this connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchCriteria(Collection<String> matchCriteria);

        /**
         * <p>
         * A list of criteria that can be used in selecting this connection.
         * </p>
         * 
         * @param matchCriteria
         *        A list of criteria that can be used in selecting this connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchCriteria(String... matchCriteria);

        /**
         * <p>
         * These key-value pairs define parameters for the connection.
         * </p>
         * 
         * @param connectionProperties
         *        These key-value pairs define parameters for the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionPropertiesWithStrings(Map<String, String> connectionProperties);

        /**
         * <p>
         * These key-value pairs define parameters for the connection.
         * </p>
         * 
         * @param connectionProperties
         *        These key-value pairs define parameters for the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionProperties(Map<ConnectionPropertyKey, String> connectionProperties);

        /**
         * <p>
         * Connection properties specific to the Spark compute environment.
         * </p>
         * 
         * @param sparkProperties
         *        Connection properties specific to the Spark compute environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sparkProperties(Map<String, String> sparkProperties);

        /**
         * <p>
         * Connection properties specific to the Athena compute environment.
         * </p>
         * 
         * @param athenaProperties
         *        Connection properties specific to the Athena compute environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder athenaProperties(Map<String, String> athenaProperties);

        /**
         * <p>
         * Connection properties specific to the Python compute environment.
         * </p>
         * 
         * @param pythonProperties
         *        Connection properties specific to the Python compute environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pythonProperties(Map<String, String> pythonProperties);

        /**
         * <p>
         * The physical connection requirements, such as virtual private cloud (VPC) and <code>SecurityGroup</code>,
         * that are needed to successfully make this connection.
         * </p>
         * 
         * @param physicalConnectionRequirements
         *        The physical connection requirements, such as virtual private cloud (VPC) and
         *        <code>SecurityGroup</code>, that are needed to successfully make this connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder physicalConnectionRequirements(PhysicalConnectionRequirements physicalConnectionRequirements);

        /**
         * <p>
         * The physical connection requirements, such as virtual private cloud (VPC) and <code>SecurityGroup</code>,
         * that are needed to successfully make this connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link PhysicalConnectionRequirements.Builder}
         * avoiding the need to create one manually via {@link PhysicalConnectionRequirements#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PhysicalConnectionRequirements.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #physicalConnectionRequirements(PhysicalConnectionRequirements)}.
         * 
         * @param physicalConnectionRequirements
         *        a consumer that will call methods on {@link PhysicalConnectionRequirements.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #physicalConnectionRequirements(PhysicalConnectionRequirements)
         */
        default Builder physicalConnectionRequirements(
                Consumer<PhysicalConnectionRequirements.Builder> physicalConnectionRequirements) {
            return physicalConnectionRequirements(PhysicalConnectionRequirements.builder()
                    .applyMutation(physicalConnectionRequirements).build());
        }

        /**
         * <p>
         * The authentication properties of the connection.
         * </p>
         * 
         * @param authenticationConfiguration
         *        The authentication properties of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationConfiguration(AuthenticationConfigurationInput authenticationConfiguration);

        /**
         * <p>
         * The authentication properties of the connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuthenticationConfigurationInput.Builder}
         * avoiding the need to create one manually via {@link AuthenticationConfigurationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuthenticationConfigurationInput.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #authenticationConfiguration(AuthenticationConfigurationInput)}.
         * 
         * @param authenticationConfiguration
         *        a consumer that will call methods on {@link AuthenticationConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authenticationConfiguration(AuthenticationConfigurationInput)
         */
        default Builder authenticationConfiguration(Consumer<AuthenticationConfigurationInput.Builder> authenticationConfiguration) {
            return authenticationConfiguration(AuthenticationConfigurationInput.builder()
                    .applyMutation(authenticationConfiguration).build());
        }

        /**
         * <p>
         * A flag to validate the credentials during create connection. Default is true.
         * </p>
         * 
         * @param validateCredentials
         *        A flag to validate the credentials during create connection. Default is true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validateCredentials(Boolean validateCredentials);

        /**
         * <p>
         * The compute environments that the specified connection properties are validated against.
         * </p>
         * 
         * @param validateForComputeEnvironments
         *        The compute environments that the specified connection properties are validated against.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validateForComputeEnvironmentsWithStrings(Collection<String> validateForComputeEnvironments);

        /**
         * <p>
         * The compute environments that the specified connection properties are validated against.
         * </p>
         * 
         * @param validateForComputeEnvironments
         *        The compute environments that the specified connection properties are validated against.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validateForComputeEnvironmentsWithStrings(String... validateForComputeEnvironments);

        /**
         * <p>
         * The compute environments that the specified connection properties are validated against.
         * </p>
         * 
         * @param validateForComputeEnvironments
         *        The compute environments that the specified connection properties are validated against.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validateForComputeEnvironments(Collection<ComputeEnvironment> validateForComputeEnvironments);

        /**
         * <p>
         * The compute environments that the specified connection properties are validated against.
         * </p>
         * 
         * @param validateForComputeEnvironments
         *        The compute environments that the specified connection properties are validated against.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validateForComputeEnvironments(ComputeEnvironment... validateForComputeEnvironments);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private String connectionType;

        private List<String> matchCriteria = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> connectionProperties = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> sparkProperties = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> athenaProperties = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> pythonProperties = DefaultSdkAutoConstructMap.getInstance();

        private PhysicalConnectionRequirements physicalConnectionRequirements;

        private AuthenticationConfigurationInput authenticationConfiguration;

        private Boolean validateCredentials;

        private List<String> validateForComputeEnvironments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionInput model) {
            name(model.name);
            description(model.description);
            connectionType(model.connectionType);
            matchCriteria(model.matchCriteria);
            connectionPropertiesWithStrings(model.connectionProperties);
            sparkProperties(model.sparkProperties);
            athenaProperties(model.athenaProperties);
            pythonProperties(model.pythonProperties);
            physicalConnectionRequirements(model.physicalConnectionRequirements);
            authenticationConfiguration(model.authenticationConfiguration);
            validateCredentials(model.validateCredentials);
            validateForComputeEnvironmentsWithStrings(model.validateForComputeEnvironments);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getConnectionType() {
            return connectionType;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        public final Builder connectionType(ConnectionType connectionType) {
            this.connectionType(connectionType == null ? null : connectionType.toString());
            return this;
        }

        public final Collection<String> getMatchCriteria() {
            if (matchCriteria instanceof SdkAutoConstructList) {
                return null;
            }
            return matchCriteria;
        }

        public final void setMatchCriteria(Collection<String> matchCriteria) {
            this.matchCriteria = MatchCriteriaCopier.copy(matchCriteria);
        }

        @Override
        public final Builder matchCriteria(Collection<String> matchCriteria) {
            this.matchCriteria = MatchCriteriaCopier.copy(matchCriteria);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchCriteria(String... matchCriteria) {
            matchCriteria(Arrays.asList(matchCriteria));
            return this;
        }

        public final Map<String, String> getConnectionProperties() {
            if (connectionProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return connectionProperties;
        }

        public final void setConnectionProperties(Map<String, String> connectionProperties) {
            this.connectionProperties = ConnectionPropertiesCopier.copy(connectionProperties);
        }

        @Override
        public final Builder connectionPropertiesWithStrings(Map<String, String> connectionProperties) {
            this.connectionProperties = ConnectionPropertiesCopier.copy(connectionProperties);
            return this;
        }

        @Override
        public final Builder connectionProperties(Map<ConnectionPropertyKey, String> connectionProperties) {
            this.connectionProperties = ConnectionPropertiesCopier.copyEnumToString(connectionProperties);
            return this;
        }

        public final Map<String, String> getSparkProperties() {
            if (sparkProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return sparkProperties;
        }

        public final void setSparkProperties(Map<String, String> sparkProperties) {
            this.sparkProperties = PropertyMapCopier.copy(sparkProperties);
        }

        @Override
        public final Builder sparkProperties(Map<String, String> sparkProperties) {
            this.sparkProperties = PropertyMapCopier.copy(sparkProperties);
            return this;
        }

        public final Map<String, String> getAthenaProperties() {
            if (athenaProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return athenaProperties;
        }

        public final void setAthenaProperties(Map<String, String> athenaProperties) {
            this.athenaProperties = PropertyMapCopier.copy(athenaProperties);
        }

        @Override
        public final Builder athenaProperties(Map<String, String> athenaProperties) {
            this.athenaProperties = PropertyMapCopier.copy(athenaProperties);
            return this;
        }

        public final Map<String, String> getPythonProperties() {
            if (pythonProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return pythonProperties;
        }

        public final void setPythonProperties(Map<String, String> pythonProperties) {
            this.pythonProperties = PropertyMapCopier.copy(pythonProperties);
        }

        @Override
        public final Builder pythonProperties(Map<String, String> pythonProperties) {
            this.pythonProperties = PropertyMapCopier.copy(pythonProperties);
            return this;
        }

        public final PhysicalConnectionRequirements.Builder getPhysicalConnectionRequirements() {
            return physicalConnectionRequirements != null ? physicalConnectionRequirements.toBuilder() : null;
        }

        public final void setPhysicalConnectionRequirements(
                PhysicalConnectionRequirements.BuilderImpl physicalConnectionRequirements) {
            this.physicalConnectionRequirements = physicalConnectionRequirements != null ? physicalConnectionRequirements.build()
                    : null;
        }

        @Override
        public final Builder physicalConnectionRequirements(PhysicalConnectionRequirements physicalConnectionRequirements) {
            this.physicalConnectionRequirements = physicalConnectionRequirements;
            return this;
        }

        public final AuthenticationConfigurationInput.Builder getAuthenticationConfiguration() {
            return authenticationConfiguration != null ? authenticationConfiguration.toBuilder() : null;
        }

        public final void setAuthenticationConfiguration(AuthenticationConfigurationInput.BuilderImpl authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration != null ? authenticationConfiguration.build() : null;
        }

        @Override
        public final Builder authenticationConfiguration(AuthenticationConfigurationInput authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration;
            return this;
        }

        public final Boolean getValidateCredentials() {
            return validateCredentials;
        }

        public final void setValidateCredentials(Boolean validateCredentials) {
            this.validateCredentials = validateCredentials;
        }

        @Override
        public final Builder validateCredentials(Boolean validateCredentials) {
            this.validateCredentials = validateCredentials;
            return this;
        }

        public final Collection<String> getValidateForComputeEnvironments() {
            if (validateForComputeEnvironments instanceof SdkAutoConstructList) {
                return null;
            }
            return validateForComputeEnvironments;
        }

        public final void setValidateForComputeEnvironments(Collection<String> validateForComputeEnvironments) {
            this.validateForComputeEnvironments = ComputeEnvironmentListCopier.copy(validateForComputeEnvironments);
        }

        @Override
        public final Builder validateForComputeEnvironmentsWithStrings(Collection<String> validateForComputeEnvironments) {
            this.validateForComputeEnvironments = ComputeEnvironmentListCopier.copy(validateForComputeEnvironments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validateForComputeEnvironmentsWithStrings(String... validateForComputeEnvironments) {
            validateForComputeEnvironmentsWithStrings(Arrays.asList(validateForComputeEnvironments));
            return this;
        }

        @Override
        public final Builder validateForComputeEnvironments(Collection<ComputeEnvironment> validateForComputeEnvironments) {
            this.validateForComputeEnvironments = ComputeEnvironmentListCopier.copyEnumToString(validateForComputeEnvironments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validateForComputeEnvironments(ComputeEnvironment... validateForComputeEnvironments) {
            validateForComputeEnvironments(Arrays.asList(validateForComputeEnvironments));
            return this;
        }

        @Override
        public ConnectionInput build() {
            return new ConnectionInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
