/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains the values and structure used to update a partition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdatePartitionRequestEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchUpdatePartitionRequestEntry.Builder, BatchUpdatePartitionRequestEntry> {
    private static final SdkField<List<String>> PARTITION_VALUE_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PartitionValueList")
            .getter(getter(BatchUpdatePartitionRequestEntry::partitionValueList))
            .setter(setter(Builder::partitionValueList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionValueList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<PartitionInput> PARTITION_INPUT_FIELD = SdkField
            .<PartitionInput> builder(MarshallingType.SDK_POJO).memberName("PartitionInput")
            .getter(getter(BatchUpdatePartitionRequestEntry::partitionInput)).setter(setter(Builder::partitionInput))
            .constructor(PartitionInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionInput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTITION_VALUE_LIST_FIELD,
            PARTITION_INPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> partitionValueList;

    private final PartitionInput partitionInput;

    private BatchUpdatePartitionRequestEntry(BuilderImpl builder) {
        this.partitionValueList = builder.partitionValueList;
        this.partitionInput = builder.partitionInput;
    }

    /**
     * For responses, this returns true if the service returned a value for the PartitionValueList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPartitionValueList() {
        return partitionValueList != null && !(partitionValueList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of values defining the partitions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPartitionValueList} method.
     * </p>
     * 
     * @return A list of values defining the partitions.
     */
    public final List<String> partitionValueList() {
        return partitionValueList;
    }

    /**
     * <p>
     * The structure used to update a partition.
     * </p>
     * 
     * @return The structure used to update a partition.
     */
    public final PartitionInput partitionInput() {
        return partitionInput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPartitionValueList() ? partitionValueList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(partitionInput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdatePartitionRequestEntry)) {
            return false;
        }
        BatchUpdatePartitionRequestEntry other = (BatchUpdatePartitionRequestEntry) obj;
        return hasPartitionValueList() == other.hasPartitionValueList()
                && Objects.equals(partitionValueList(), other.partitionValueList())
                && Objects.equals(partitionInput(), other.partitionInput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchUpdatePartitionRequestEntry")
                .add("PartitionValueList", hasPartitionValueList() ? partitionValueList() : null)
                .add("PartitionInput", partitionInput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PartitionValueList":
            return Optional.ofNullable(clazz.cast(partitionValueList()));
        case "PartitionInput":
            return Optional.ofNullable(clazz.cast(partitionInput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PartitionValueList", PARTITION_VALUE_LIST_FIELD);
        map.put("PartitionInput", PARTITION_INPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdatePartitionRequestEntry, T> g) {
        return obj -> g.apply((BatchUpdatePartitionRequestEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchUpdatePartitionRequestEntry> {
        /**
         * <p>
         * A list of values defining the partitions.
         * </p>
         * 
         * @param partitionValueList
         *        A list of values defining the partitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionValueList(Collection<String> partitionValueList);

        /**
         * <p>
         * A list of values defining the partitions.
         * </p>
         * 
         * @param partitionValueList
         *        A list of values defining the partitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionValueList(String... partitionValueList);

        /**
         * <p>
         * The structure used to update a partition.
         * </p>
         * 
         * @param partitionInput
         *        The structure used to update a partition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionInput(PartitionInput partitionInput);

        /**
         * <p>
         * The structure used to update a partition.
         * </p>
         * This is a convenience method that creates an instance of the {@link PartitionInput.Builder} avoiding the need
         * to create one manually via {@link PartitionInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PartitionInput.Builder#build()} is called immediately and its
         * result is passed to {@link #partitionInput(PartitionInput)}.
         * 
         * @param partitionInput
         *        a consumer that will call methods on {@link PartitionInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #partitionInput(PartitionInput)
         */
        default Builder partitionInput(Consumer<PartitionInput.Builder> partitionInput) {
            return partitionInput(PartitionInput.builder().applyMutation(partitionInput).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> partitionValueList = DefaultSdkAutoConstructList.getInstance();

        private PartitionInput partitionInput;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdatePartitionRequestEntry model) {
            partitionValueList(model.partitionValueList);
            partitionInput(model.partitionInput);
        }

        public final Collection<String> getPartitionValueList() {
            if (partitionValueList instanceof SdkAutoConstructList) {
                return null;
            }
            return partitionValueList;
        }

        public final void setPartitionValueList(Collection<String> partitionValueList) {
            this.partitionValueList = BoundedPartitionValueListCopier.copy(partitionValueList);
        }

        @Override
        public final Builder partitionValueList(Collection<String> partitionValueList) {
            this.partitionValueList = BoundedPartitionValueListCopier.copy(partitionValueList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionValueList(String... partitionValueList) {
            partitionValueList(Arrays.asList(partitionValueList));
            return this;
        }

        public final PartitionInput.Builder getPartitionInput() {
            return partitionInput != null ? partitionInput.toBuilder() : null;
        }

        public final void setPartitionInput(PartitionInput.BuilderImpl partitionInput) {
            this.partitionInput = partitionInput != null ? partitionInput.build() : null;
        }

        @Override
        public final Builder partitionInput(PartitionInput partitionInput) {
            this.partitionInput = partitionInput;
            return this;
        }

        @Override
        public BatchUpdatePartitionRequestEntry build() {
            return new BatchUpdatePartitionRequestEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
