/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GrokClassifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GrokClassifier> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GrokClassifier.getter(GrokClassifier::name)).setter(GrokClassifier.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> CLASSIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Classification").getter(GrokClassifier.getter(GrokClassifier::classification)).setter(GrokClassifier.setter(Builder::classification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Classification").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(GrokClassifier.getter(GrokClassifier::creationTime)).setter(GrokClassifier.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdated").getter(GrokClassifier.getter(GrokClassifier::lastUpdated)).setter(GrokClassifier.setter(Builder::lastUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdated").build()}).build();
    private static final SdkField<Long> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Version").getter(GrokClassifier.getter(GrokClassifier::version)).setter(GrokClassifier.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<String> GROK_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GrokPattern").getter(GrokClassifier.getter(GrokClassifier::grokPattern)).setter(GrokClassifier.setter(Builder::grokPattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrokPattern").build()}).build();
    private static final SdkField<String> CUSTOM_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomPatterns").getter(GrokClassifier.getter(GrokClassifier::customPatterns)).setter(GrokClassifier.setter(Builder::customPatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomPatterns").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CLASSIFICATION_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_FIELD, VERSION_FIELD, GROK_PATTERN_FIELD, CUSTOM_PATTERNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Classification", CLASSIFICATION_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("LastUpdated", LAST_UPDATED_FIELD);
            this.put("Version", VERSION_FIELD);
            this.put("GrokPattern", GROK_PATTERN_FIELD);
            this.put("CustomPatterns", CUSTOM_PATTERNS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String classification;
    private final Instant creationTime;
    private final Instant lastUpdated;
    private final Long version;
    private final String grokPattern;
    private final String customPatterns;

    private GrokClassifier(BuilderImpl builder) {
        this.name = builder.name;
        this.classification = builder.classification;
        this.creationTime = builder.creationTime;
        this.lastUpdated = builder.lastUpdated;
        this.version = builder.version;
        this.grokPattern = builder.grokPattern;
        this.customPatterns = builder.customPatterns;
    }

    public final String name() {
        return this.name;
    }

    public final String classification() {
        return this.classification;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastUpdated() {
        return this.lastUpdated;
    }

    public final Long version() {
        return this.version;
    }

    public final String grokPattern() {
        return this.grokPattern;
    }

    public final String customPatterns() {
        return this.customPatterns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.classification());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.grokPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.customPatterns());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrokClassifier)) {
            return false;
        }
        GrokClassifier other = (GrokClassifier)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.classification(), other.classification()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdated(), other.lastUpdated()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.grokPattern(), other.grokPattern()) && Objects.equals(this.customPatterns(), other.customPatterns());
    }

    public final String toString() {
        return ToString.builder((String)"GrokClassifier").add("Name", (Object)this.name()).add("Classification", (Object)this.classification()).add("CreationTime", (Object)this.creationTime()).add("LastUpdated", (Object)this.lastUpdated()).add("Version", (Object)this.version()).add("GrokPattern", (Object)this.grokPattern()).add("CustomPatterns", (Object)this.customPatterns()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Classification": {
                return Optional.ofNullable(clazz.cast(this.classification()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastUpdated": {
                return Optional.ofNullable(clazz.cast(this.lastUpdated()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "GrokPattern": {
                return Optional.ofNullable(clazz.cast(this.grokPattern()));
            }
            case "CustomPatterns": {
                return Optional.ofNullable(clazz.cast(this.customPatterns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GrokClassifier, T> g) {
        return obj -> g.apply((GrokClassifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String classification;
        private Instant creationTime;
        private Instant lastUpdated;
        private Long version;
        private String grokPattern;
        private String customPatterns;

        private BuilderImpl() {
        }

        private BuilderImpl(GrokClassifier model) {
            this.name(model.name);
            this.classification(model.classification);
            this.creationTime(model.creationTime);
            this.lastUpdated(model.lastUpdated);
            this.version(model.version);
            this.grokPattern(model.grokPattern);
            this.customPatterns(model.customPatterns);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getClassification() {
            return this.classification;
        }

        public final void setClassification(String classification) {
            this.classification = classification;
        }

        @Override
        public final Builder classification(String classification) {
            this.classification = classification;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdated() {
            return this.lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final Long getVersion() {
            return this.version;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final String getGrokPattern() {
            return this.grokPattern;
        }

        public final void setGrokPattern(String grokPattern) {
            this.grokPattern = grokPattern;
        }

        @Override
        public final Builder grokPattern(String grokPattern) {
            this.grokPattern = grokPattern;
            return this;
        }

        public final String getCustomPatterns() {
            return this.customPatterns;
        }

        public final void setCustomPatterns(String customPatterns) {
            this.customPatterns = customPatterns;
        }

        @Override
        public final Builder customPatterns(String customPatterns) {
            this.customPatterns = customPatterns;
            return this;
        }

        public GrokClassifier build() {
            return new GrokClassifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GrokClassifier> {
        public Builder name(String var1);

        public Builder classification(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdated(Instant var1);

        public Builder version(Long var1);

        public Builder grokPattern(String var1);

        public Builder customPatterns(String var1);
    }
}

