/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.SourceProcessingProperties;
import software.amazon.awssdk.services.glue.model.TargetProcessingProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateIntegrationResourcePropertyResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, UpdateIntegrationResourcePropertyResponse> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(UpdateIntegrationResourcePropertyResponse.getter(UpdateIntegrationResourcePropertyResponse::resourceArn)).setter(UpdateIntegrationResourcePropertyResponse.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<SourceProcessingProperties> SOURCE_PROCESSING_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceProcessingProperties").getter(UpdateIntegrationResourcePropertyResponse.getter(UpdateIntegrationResourcePropertyResponse::sourceProcessingProperties)).setter(UpdateIntegrationResourcePropertyResponse.setter(Builder::sourceProcessingProperties)).constructor(SourceProcessingProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceProcessingProperties").build()}).build();
    private static final SdkField<TargetProcessingProperties> TARGET_PROCESSING_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetProcessingProperties").getter(UpdateIntegrationResourcePropertyResponse.getter(UpdateIntegrationResourcePropertyResponse::targetProcessingProperties)).setter(UpdateIntegrationResourcePropertyResponse.setter(Builder::targetProcessingProperties)).constructor(TargetProcessingProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetProcessingProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, SOURCE_PROCESSING_PROPERTIES_FIELD, TARGET_PROCESSING_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ResourceArn", RESOURCE_ARN_FIELD);
            this.put("SourceProcessingProperties", SOURCE_PROCESSING_PROPERTIES_FIELD);
            this.put("TargetProcessingProperties", TARGET_PROCESSING_PROPERTIES_FIELD);
        }
    });
    private final String resourceArn;
    private final SourceProcessingProperties sourceProcessingProperties;
    private final TargetProcessingProperties targetProcessingProperties;

    private UpdateIntegrationResourcePropertyResponse(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.sourceProcessingProperties = builder.sourceProcessingProperties;
        this.targetProcessingProperties = builder.targetProcessingProperties;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final SourceProcessingProperties sourceProcessingProperties() {
        return this.sourceProcessingProperties;
    }

    public final TargetProcessingProperties targetProcessingProperties() {
        return this.targetProcessingProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceProcessingProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetProcessingProperties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIntegrationResourcePropertyResponse)) {
            return false;
        }
        UpdateIntegrationResourcePropertyResponse other = (UpdateIntegrationResourcePropertyResponse)((Object)obj);
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.sourceProcessingProperties(), other.sourceProcessingProperties()) && Objects.equals(this.targetProcessingProperties(), other.targetProcessingProperties());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateIntegrationResourcePropertyResponse").add("ResourceArn", (Object)this.resourceArn()).add("SourceProcessingProperties", (Object)this.sourceProcessingProperties()).add("TargetProcessingProperties", (Object)this.targetProcessingProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "SourceProcessingProperties": {
                return Optional.ofNullable(clazz.cast(this.sourceProcessingProperties()));
            }
            case "TargetProcessingProperties": {
                return Optional.ofNullable(clazz.cast(this.targetProcessingProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateIntegrationResourcePropertyResponse, T> g) {
        return obj -> g.apply((UpdateIntegrationResourcePropertyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private String resourceArn;
        private SourceProcessingProperties sourceProcessingProperties;
        private TargetProcessingProperties targetProcessingProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIntegrationResourcePropertyResponse model) {
            super(model);
            this.resourceArn(model.resourceArn);
            this.sourceProcessingProperties(model.sourceProcessingProperties);
            this.targetProcessingProperties(model.targetProcessingProperties);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final SourceProcessingProperties.Builder getSourceProcessingProperties() {
            return this.sourceProcessingProperties != null ? this.sourceProcessingProperties.toBuilder() : null;
        }

        public final void setSourceProcessingProperties(SourceProcessingProperties.BuilderImpl sourceProcessingProperties) {
            this.sourceProcessingProperties = sourceProcessingProperties != null ? sourceProcessingProperties.build() : null;
        }

        @Override
        public final Builder sourceProcessingProperties(SourceProcessingProperties sourceProcessingProperties) {
            this.sourceProcessingProperties = sourceProcessingProperties;
            return this;
        }

        public final TargetProcessingProperties.Builder getTargetProcessingProperties() {
            return this.targetProcessingProperties != null ? this.targetProcessingProperties.toBuilder() : null;
        }

        public final void setTargetProcessingProperties(TargetProcessingProperties.BuilderImpl targetProcessingProperties) {
            this.targetProcessingProperties = targetProcessingProperties != null ? targetProcessingProperties.build() : null;
        }

        @Override
        public final Builder targetProcessingProperties(TargetProcessingProperties targetProcessingProperties) {
            this.targetProcessingProperties = targetProcessingProperties;
            return this;
        }

        @Override
        public UpdateIntegrationResourcePropertyResponse build() {
            return new UpdateIntegrationResourcePropertyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateIntegrationResourcePropertyResponse> {
        public Builder resourceArn(String var1);

        public Builder sourceProcessingProperties(SourceProcessingProperties var1);

        default public Builder sourceProcessingProperties(Consumer<SourceProcessingProperties.Builder> sourceProcessingProperties) {
            return this.sourceProcessingProperties((SourceProcessingProperties)((SourceProcessingProperties.Builder)SourceProcessingProperties.builder().applyMutation(sourceProcessingProperties)).build());
        }

        public Builder targetProcessingProperties(TargetProcessingProperties var1);

        default public Builder targetProcessingProperties(Consumer<TargetProcessingProperties.Builder> targetProcessingProperties) {
            return this.targetProcessingProperties((TargetProcessingProperties)((TargetProcessingProperties.Builder)TargetProcessingProperties.builder().applyMutation(targetProcessingProperties)).build());
        }
    }
}

