/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.EnableAdditionalMetadataCopier;
import software.amazon.awssdk.services.glue.model.JdbcMetadataEntry;
import software.amazon.awssdk.services.glue.model.PathListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JdbcTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JdbcTarget> {
    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionName").getter(JdbcTarget.getter(JdbcTarget::connectionName)).setter(JdbcTarget.setter(Builder::connectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionName").build()}).build();
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Path").getter(JdbcTarget.getter(JdbcTarget::path)).setter(JdbcTarget.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()}).build();
    private static final SdkField<List<String>> EXCLUSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Exclusions").getter(JdbcTarget.getter(JdbcTarget::exclusions)).setter(JdbcTarget.setter(Builder::exclusions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Exclusions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ENABLE_ADDITIONAL_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnableAdditionalMetadata").getter(JdbcTarget.getter(JdbcTarget::enableAdditionalMetadataAsStrings)).setter(JdbcTarget.setter(Builder::enableAdditionalMetadataWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableAdditionalMetadata").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_NAME_FIELD, PATH_FIELD, EXCLUSIONS_FIELD, ENABLE_ADDITIONAL_METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ConnectionName", CONNECTION_NAME_FIELD);
            this.put("Path", PATH_FIELD);
            this.put("Exclusions", EXCLUSIONS_FIELD);
            this.put("EnableAdditionalMetadata", ENABLE_ADDITIONAL_METADATA_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String connectionName;
    private final String path;
    private final List<String> exclusions;
    private final List<String> enableAdditionalMetadata;

    private JdbcTarget(BuilderImpl builder) {
        this.connectionName = builder.connectionName;
        this.path = builder.path;
        this.exclusions = builder.exclusions;
        this.enableAdditionalMetadata = builder.enableAdditionalMetadata;
    }

    public final String connectionName() {
        return this.connectionName;
    }

    public final String path() {
        return this.path;
    }

    public final boolean hasExclusions() {
        return this.exclusions != null && !(this.exclusions instanceof SdkAutoConstructList);
    }

    public final List<String> exclusions() {
        return this.exclusions;
    }

    public final List<JdbcMetadataEntry> enableAdditionalMetadata() {
        return EnableAdditionalMetadataCopier.copyStringToEnum(this.enableAdditionalMetadata);
    }

    public final boolean hasEnableAdditionalMetadata() {
        return this.enableAdditionalMetadata != null && !(this.enableAdditionalMetadata instanceof SdkAutoConstructList);
    }

    public final List<String> enableAdditionalMetadataAsStrings() {
        return this.enableAdditionalMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExclusions() ? this.exclusions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnableAdditionalMetadata() ? this.enableAdditionalMetadataAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JdbcTarget)) {
            return false;
        }
        JdbcTarget other = (JdbcTarget)obj;
        return Objects.equals(this.connectionName(), other.connectionName()) && Objects.equals(this.path(), other.path()) && this.hasExclusions() == other.hasExclusions() && Objects.equals(this.exclusions(), other.exclusions()) && this.hasEnableAdditionalMetadata() == other.hasEnableAdditionalMetadata() && Objects.equals(this.enableAdditionalMetadataAsStrings(), other.enableAdditionalMetadataAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"JdbcTarget").add("ConnectionName", (Object)this.connectionName()).add("Path", (Object)this.path()).add("Exclusions", this.hasExclusions() ? this.exclusions() : null).add("EnableAdditionalMetadata", this.hasEnableAdditionalMetadata() ? this.enableAdditionalMetadataAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionName": {
                return Optional.ofNullable(clazz.cast(this.connectionName()));
            }
            case "Path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "Exclusions": {
                return Optional.ofNullable(clazz.cast(this.exclusions()));
            }
            case "EnableAdditionalMetadata": {
                return Optional.ofNullable(clazz.cast(this.enableAdditionalMetadataAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<JdbcTarget, T> g) {
        return obj -> g.apply((JdbcTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String connectionName;
        private String path;
        private List<String> exclusions = DefaultSdkAutoConstructList.getInstance();
        private List<String> enableAdditionalMetadata = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JdbcTarget model) {
            this.connectionName(model.connectionName);
            this.path(model.path);
            this.exclusions(model.exclusions);
            this.enableAdditionalMetadataWithStrings(model.enableAdditionalMetadata);
        }

        public final String getConnectionName() {
            return this.connectionName;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final Collection<String> getExclusions() {
            if (this.exclusions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exclusions;
        }

        public final void setExclusions(Collection<String> exclusions) {
            this.exclusions = PathListCopier.copy(exclusions);
        }

        @Override
        public final Builder exclusions(Collection<String> exclusions) {
            this.exclusions = PathListCopier.copy(exclusions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusions(String ... exclusions) {
            this.exclusions(Arrays.asList(exclusions));
            return this;
        }

        public final Collection<String> getEnableAdditionalMetadata() {
            if (this.enableAdditionalMetadata instanceof SdkAutoConstructList) {
                return null;
            }
            return this.enableAdditionalMetadata;
        }

        public final void setEnableAdditionalMetadata(Collection<String> enableAdditionalMetadata) {
            this.enableAdditionalMetadata = EnableAdditionalMetadataCopier.copy(enableAdditionalMetadata);
        }

        @Override
        public final Builder enableAdditionalMetadataWithStrings(Collection<String> enableAdditionalMetadata) {
            this.enableAdditionalMetadata = EnableAdditionalMetadataCopier.copy(enableAdditionalMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enableAdditionalMetadataWithStrings(String ... enableAdditionalMetadata) {
            this.enableAdditionalMetadataWithStrings(Arrays.asList(enableAdditionalMetadata));
            return this;
        }

        @Override
        public final Builder enableAdditionalMetadata(Collection<JdbcMetadataEntry> enableAdditionalMetadata) {
            this.enableAdditionalMetadata = EnableAdditionalMetadataCopier.copyEnumToString(enableAdditionalMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enableAdditionalMetadata(JdbcMetadataEntry ... enableAdditionalMetadata) {
            this.enableAdditionalMetadata(Arrays.asList(enableAdditionalMetadata));
            return this;
        }

        public JdbcTarget build() {
            return new JdbcTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JdbcTarget> {
        public Builder connectionName(String var1);

        public Builder path(String var1);

        public Builder exclusions(Collection<String> var1);

        public Builder exclusions(String ... var1);

        public Builder enableAdditionalMetadataWithStrings(Collection<String> var1);

        public Builder enableAdditionalMetadataWithStrings(String ... var1);

        public Builder enableAdditionalMetadata(Collection<JdbcMetadataEntry> var1);

        public Builder enableAdditionalMetadata(JdbcMetadataEntry ... var1);
    }
}

