/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.AllowedValuesStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigurationObject
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigurationObject> {
    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultValue").getter(ConfigurationObject.getter(ConfigurationObject::defaultValue)).setter(ConfigurationObject.setter(Builder::defaultValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()}).build();
    private static final SdkField<List<String>> ALLOWED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowedValues").getter(ConfigurationObject.getter(ConfigurationObject::allowedValues)).setter(ConfigurationObject.setter(Builder::allowedValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MIN_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MinValue").getter(ConfigurationObject.getter(ConfigurationObject::minValue)).setter(ConfigurationObject.setter(Builder::minValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinValue").build()}).build();
    private static final SdkField<String> MAX_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxValue").getter(ConfigurationObject.getter(ConfigurationObject::maxValue)).setter(ConfigurationObject.setter(Builder::maxValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_VALUE_FIELD, ALLOWED_VALUES_FIELD, MIN_VALUE_FIELD, MAX_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DefaultValue", DEFAULT_VALUE_FIELD);
            this.put("AllowedValues", ALLOWED_VALUES_FIELD);
            this.put("MinValue", MIN_VALUE_FIELD);
            this.put("MaxValue", MAX_VALUE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String defaultValue;
    private final List<String> allowedValues;
    private final String minValue;
    private final String maxValue;

    private ConfigurationObject(BuilderImpl builder) {
        this.defaultValue = builder.defaultValue;
        this.allowedValues = builder.allowedValues;
        this.minValue = builder.minValue;
        this.maxValue = builder.maxValue;
    }

    public final String defaultValue() {
        return this.defaultValue;
    }

    public final boolean hasAllowedValues() {
        return this.allowedValues != null && !(this.allowedValues instanceof SdkAutoConstructList);
    }

    public final List<String> allowedValues() {
        return this.allowedValues;
    }

    public final String minValue() {
        return this.minValue;
    }

    public final String maxValue() {
        return this.maxValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedValues() ? this.allowedValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.minValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationObject)) {
            return false;
        }
        ConfigurationObject other = (ConfigurationObject)obj;
        return Objects.equals(this.defaultValue(), other.defaultValue()) && this.hasAllowedValues() == other.hasAllowedValues() && Objects.equals(this.allowedValues(), other.allowedValues()) && Objects.equals(this.minValue(), other.minValue()) && Objects.equals(this.maxValue(), other.maxValue());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigurationObject").add("DefaultValue", (Object)this.defaultValue()).add("AllowedValues", this.hasAllowedValues() ? this.allowedValues() : null).add("MinValue", (Object)this.minValue()).add("MaxValue", (Object)this.maxValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
            case "AllowedValues": {
                return Optional.ofNullable(clazz.cast(this.allowedValues()));
            }
            case "MinValue": {
                return Optional.ofNullable(clazz.cast(this.minValue()));
            }
            case "MaxValue": {
                return Optional.ofNullable(clazz.cast(this.maxValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationObject, T> g) {
        return obj -> g.apply((ConfigurationObject)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String defaultValue;
        private List<String> allowedValues = DefaultSdkAutoConstructList.getInstance();
        private String minValue;
        private String maxValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationObject model) {
            this.defaultValue(model.defaultValue);
            this.allowedValues(model.allowedValues);
            this.minValue(model.minValue);
            this.maxValue(model.maxValue);
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final Collection<String> getAllowedValues() {
            if (this.allowedValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedValues;
        }

        public final void setAllowedValues(Collection<String> allowedValues) {
            this.allowedValues = AllowedValuesStringListCopier.copy(allowedValues);
        }

        @Override
        public final Builder allowedValues(Collection<String> allowedValues) {
            this.allowedValues = AllowedValuesStringListCopier.copy(allowedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedValues(String ... allowedValues) {
            this.allowedValues(Arrays.asList(allowedValues));
            return this;
        }

        public final String getMinValue() {
            return this.minValue;
        }

        public final void setMinValue(String minValue) {
            this.minValue = minValue;
        }

        @Override
        public final Builder minValue(String minValue) {
            this.minValue = minValue;
            return this;
        }

        public final String getMaxValue() {
            return this.maxValue;
        }

        public final void setMaxValue(String maxValue) {
            this.maxValue = maxValue;
        }

        @Override
        public final Builder maxValue(String maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public ConfigurationObject build() {
            return new ConfigurationObject(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigurationObject> {
        public Builder defaultValue(String var1);

        public Builder allowedValues(Collection<String> var1);

        public Builder allowedValues(String ... var1);

        public Builder minValue(String var1);

        public Builder maxValue(String var1);
    }
}

