/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.AdditionalOptionsCopier;
import software.amazon.awssdk.services.glue.model.Option;
import software.amazon.awssdk.services.glue.model.OptionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SnowflakeNodeData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SnowflakeNodeData> {
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceType").getter(SnowflakeNodeData.getter(SnowflakeNodeData::sourceType)).setter(SnowflakeNodeData.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()}).build();
    private static final SdkField<Option> CONNECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Connection").getter(SnowflakeNodeData.getter(SnowflakeNodeData::connection)).setter(SnowflakeNodeData.setter(Builder::connection)).constructor(Option::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Connection").build()}).build();
    private static final SdkField<String> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Schema").getter(SnowflakeNodeData.getter(SnowflakeNodeData::schema)).setter(SnowflakeNodeData.setter(Builder::schema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()}).build();
    private static final SdkField<String> TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Table").getter(SnowflakeNodeData.getter(SnowflakeNodeData::table)).setter(SnowflakeNodeData.setter(Builder::table)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()}).build();
    private static final SdkField<String> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Database").getter(SnowflakeNodeData.getter(SnowflakeNodeData::database)).setter(SnowflakeNodeData.setter(Builder::database)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()}).build();
    private static final SdkField<String> TEMP_DIR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TempDir").getter(SnowflakeNodeData.getter(SnowflakeNodeData::tempDir)).setter(SnowflakeNodeData.setter(Builder::tempDir)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TempDir").build()}).build();
    private static final SdkField<Option> IAM_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IamRole").getter(SnowflakeNodeData.getter(SnowflakeNodeData::iamRole)).setter(SnowflakeNodeData.setter(Builder::iamRole)).constructor(Option::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRole").build()}).build();
    private static final SdkField<Map<String, String>> ADDITIONAL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AdditionalOptions").getter(SnowflakeNodeData.getter(SnowflakeNodeData::additionalOptions)).setter(SnowflakeNodeData.setter(Builder::additionalOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalOptions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> SAMPLE_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SampleQuery").getter(SnowflakeNodeData.getter(SnowflakeNodeData::sampleQuery)).setter(SnowflakeNodeData.setter(Builder::sampleQuery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleQuery").build()}).build();
    private static final SdkField<String> PRE_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreAction").getter(SnowflakeNodeData.getter(SnowflakeNodeData::preAction)).setter(SnowflakeNodeData.setter(Builder::preAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreAction").build()}).build();
    private static final SdkField<String> POST_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PostAction").getter(SnowflakeNodeData.getter(SnowflakeNodeData::postAction)).setter(SnowflakeNodeData.setter(Builder::postAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostAction").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(SnowflakeNodeData.getter(SnowflakeNodeData::action)).setter(SnowflakeNodeData.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<Boolean> UPSERT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Upsert").getter(SnowflakeNodeData.getter(SnowflakeNodeData::upsert)).setter(SnowflakeNodeData.setter(Builder::upsert)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Upsert").build()}).build();
    private static final SdkField<String> MERGE_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MergeAction").getter(SnowflakeNodeData.getter(SnowflakeNodeData::mergeAction)).setter(SnowflakeNodeData.setter(Builder::mergeAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MergeAction").build()}).build();
    private static final SdkField<String> MERGE_WHEN_MATCHED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MergeWhenMatched").getter(SnowflakeNodeData.getter(SnowflakeNodeData::mergeWhenMatched)).setter(SnowflakeNodeData.setter(Builder::mergeWhenMatched)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MergeWhenMatched").build()}).build();
    private static final SdkField<String> MERGE_WHEN_NOT_MATCHED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MergeWhenNotMatched").getter(SnowflakeNodeData.getter(SnowflakeNodeData::mergeWhenNotMatched)).setter(SnowflakeNodeData.setter(Builder::mergeWhenNotMatched)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MergeWhenNotMatched").build()}).build();
    private static final SdkField<String> MERGE_CLAUSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MergeClause").getter(SnowflakeNodeData.getter(SnowflakeNodeData::mergeClause)).setter(SnowflakeNodeData.setter(Builder::mergeClause)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MergeClause").build()}).build();
    private static final SdkField<String> STAGING_TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StagingTable").getter(SnowflakeNodeData.getter(SnowflakeNodeData::stagingTable)).setter(SnowflakeNodeData.setter(Builder::stagingTable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StagingTable").build()}).build();
    private static final SdkField<List<Option>> SELECTED_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SelectedColumns").getter(SnowflakeNodeData.getter(SnowflakeNodeData::selectedColumns)).setter(SnowflakeNodeData.setter(Builder::selectedColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Option::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> AUTO_PUSHDOWN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoPushdown").getter(SnowflakeNodeData.getter(SnowflakeNodeData::autoPushdown)).setter(SnowflakeNodeData.setter(Builder::autoPushdown)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoPushdown").build()}).build();
    private static final SdkField<List<Option>> TABLE_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TableSchema").getter(SnowflakeNodeData.getter(SnowflakeNodeData::tableSchema)).setter(SnowflakeNodeData.setter(Builder::tableSchema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableSchema").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Option::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_TYPE_FIELD, CONNECTION_FIELD, SCHEMA_FIELD, TABLE_FIELD, DATABASE_FIELD, TEMP_DIR_FIELD, IAM_ROLE_FIELD, ADDITIONAL_OPTIONS_FIELD, SAMPLE_QUERY_FIELD, PRE_ACTION_FIELD, POST_ACTION_FIELD, ACTION_FIELD, UPSERT_FIELD, MERGE_ACTION_FIELD, MERGE_WHEN_MATCHED_FIELD, MERGE_WHEN_NOT_MATCHED_FIELD, MERGE_CLAUSE_FIELD, STAGING_TABLE_FIELD, SELECTED_COLUMNS_FIELD, AUTO_PUSHDOWN_FIELD, TABLE_SCHEMA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SourceType", SOURCE_TYPE_FIELD);
            this.put("Connection", CONNECTION_FIELD);
            this.put("Schema", SCHEMA_FIELD);
            this.put("Table", TABLE_FIELD);
            this.put("Database", DATABASE_FIELD);
            this.put("TempDir", TEMP_DIR_FIELD);
            this.put("IamRole", IAM_ROLE_FIELD);
            this.put("AdditionalOptions", ADDITIONAL_OPTIONS_FIELD);
            this.put("SampleQuery", SAMPLE_QUERY_FIELD);
            this.put("PreAction", PRE_ACTION_FIELD);
            this.put("PostAction", POST_ACTION_FIELD);
            this.put("Action", ACTION_FIELD);
            this.put("Upsert", UPSERT_FIELD);
            this.put("MergeAction", MERGE_ACTION_FIELD);
            this.put("MergeWhenMatched", MERGE_WHEN_MATCHED_FIELD);
            this.put("MergeWhenNotMatched", MERGE_WHEN_NOT_MATCHED_FIELD);
            this.put("MergeClause", MERGE_CLAUSE_FIELD);
            this.put("StagingTable", STAGING_TABLE_FIELD);
            this.put("SelectedColumns", SELECTED_COLUMNS_FIELD);
            this.put("AutoPushdown", AUTO_PUSHDOWN_FIELD);
            this.put("TableSchema", TABLE_SCHEMA_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String sourceType;
    private final Option connection;
    private final String schema;
    private final String table;
    private final String database;
    private final String tempDir;
    private final Option iamRole;
    private final Map<String, String> additionalOptions;
    private final String sampleQuery;
    private final String preAction;
    private final String postAction;
    private final String action;
    private final Boolean upsert;
    private final String mergeAction;
    private final String mergeWhenMatched;
    private final String mergeWhenNotMatched;
    private final String mergeClause;
    private final String stagingTable;
    private final List<Option> selectedColumns;
    private final Boolean autoPushdown;
    private final List<Option> tableSchema;

    private SnowflakeNodeData(BuilderImpl builder) {
        this.sourceType = builder.sourceType;
        this.connection = builder.connection;
        this.schema = builder.schema;
        this.table = builder.table;
        this.database = builder.database;
        this.tempDir = builder.tempDir;
        this.iamRole = builder.iamRole;
        this.additionalOptions = builder.additionalOptions;
        this.sampleQuery = builder.sampleQuery;
        this.preAction = builder.preAction;
        this.postAction = builder.postAction;
        this.action = builder.action;
        this.upsert = builder.upsert;
        this.mergeAction = builder.mergeAction;
        this.mergeWhenMatched = builder.mergeWhenMatched;
        this.mergeWhenNotMatched = builder.mergeWhenNotMatched;
        this.mergeClause = builder.mergeClause;
        this.stagingTable = builder.stagingTable;
        this.selectedColumns = builder.selectedColumns;
        this.autoPushdown = builder.autoPushdown;
        this.tableSchema = builder.tableSchema;
    }

    public final String sourceType() {
        return this.sourceType;
    }

    public final Option connection() {
        return this.connection;
    }

    public final String schema() {
        return this.schema;
    }

    public final String table() {
        return this.table;
    }

    public final String database() {
        return this.database;
    }

    public final String tempDir() {
        return this.tempDir;
    }

    public final Option iamRole() {
        return this.iamRole;
    }

    public final boolean hasAdditionalOptions() {
        return this.additionalOptions != null && !(this.additionalOptions instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> additionalOptions() {
        return this.additionalOptions;
    }

    public final String sampleQuery() {
        return this.sampleQuery;
    }

    public final String preAction() {
        return this.preAction;
    }

    public final String postAction() {
        return this.postAction;
    }

    public final String action() {
        return this.action;
    }

    public final Boolean upsert() {
        return this.upsert;
    }

    public final String mergeAction() {
        return this.mergeAction;
    }

    public final String mergeWhenMatched() {
        return this.mergeWhenMatched;
    }

    public final String mergeWhenNotMatched() {
        return this.mergeWhenNotMatched;
    }

    public final String mergeClause() {
        return this.mergeClause;
    }

    public final String stagingTable() {
        return this.stagingTable;
    }

    public final boolean hasSelectedColumns() {
        return this.selectedColumns != null && !(this.selectedColumns instanceof SdkAutoConstructList);
    }

    public final List<Option> selectedColumns() {
        return this.selectedColumns;
    }

    public final Boolean autoPushdown() {
        return this.autoPushdown;
    }

    public final boolean hasTableSchema() {
        return this.tableSchema != null && !(this.tableSchema instanceof SdkAutoConstructList);
    }

    public final List<Option> tableSchema() {
        return this.tableSchema;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.connection());
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        hashCode = 31 * hashCode + Objects.hashCode(this.table());
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.tempDir());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalOptions() ? this.additionalOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.preAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.postAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.upsert());
        hashCode = 31 * hashCode + Objects.hashCode(this.mergeAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.mergeWhenMatched());
        hashCode = 31 * hashCode + Objects.hashCode(this.mergeWhenNotMatched());
        hashCode = 31 * hashCode + Objects.hashCode(this.mergeClause());
        hashCode = 31 * hashCode + Objects.hashCode(this.stagingTable());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSelectedColumns() ? this.selectedColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.autoPushdown());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTableSchema() ? this.tableSchema() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnowflakeNodeData)) {
            return false;
        }
        SnowflakeNodeData other = (SnowflakeNodeData)obj;
        return Objects.equals(this.sourceType(), other.sourceType()) && Objects.equals(this.connection(), other.connection()) && Objects.equals(this.schema(), other.schema()) && Objects.equals(this.table(), other.table()) && Objects.equals(this.database(), other.database()) && Objects.equals(this.tempDir(), other.tempDir()) && Objects.equals(this.iamRole(), other.iamRole()) && this.hasAdditionalOptions() == other.hasAdditionalOptions() && Objects.equals(this.additionalOptions(), other.additionalOptions()) && Objects.equals(this.sampleQuery(), other.sampleQuery()) && Objects.equals(this.preAction(), other.preAction()) && Objects.equals(this.postAction(), other.postAction()) && Objects.equals(this.action(), other.action()) && Objects.equals(this.upsert(), other.upsert()) && Objects.equals(this.mergeAction(), other.mergeAction()) && Objects.equals(this.mergeWhenMatched(), other.mergeWhenMatched()) && Objects.equals(this.mergeWhenNotMatched(), other.mergeWhenNotMatched()) && Objects.equals(this.mergeClause(), other.mergeClause()) && Objects.equals(this.stagingTable(), other.stagingTable()) && this.hasSelectedColumns() == other.hasSelectedColumns() && Objects.equals(this.selectedColumns(), other.selectedColumns()) && Objects.equals(this.autoPushdown(), other.autoPushdown()) && this.hasTableSchema() == other.hasTableSchema() && Objects.equals(this.tableSchema(), other.tableSchema());
    }

    public final String toString() {
        return ToString.builder((String)"SnowflakeNodeData").add("SourceType", (Object)this.sourceType()).add("Connection", (Object)this.connection()).add("Schema", (Object)this.schema()).add("Table", (Object)this.table()).add("Database", (Object)this.database()).add("TempDir", (Object)this.tempDir()).add("IamRole", (Object)this.iamRole()).add("AdditionalOptions", this.hasAdditionalOptions() ? this.additionalOptions() : null).add("SampleQuery", (Object)this.sampleQuery()).add("PreAction", (Object)this.preAction()).add("PostAction", (Object)this.postAction()).add("Action", (Object)this.action()).add("Upsert", (Object)this.upsert()).add("MergeAction", (Object)this.mergeAction()).add("MergeWhenMatched", (Object)this.mergeWhenMatched()).add("MergeWhenNotMatched", (Object)this.mergeWhenNotMatched()).add("MergeClause", (Object)this.mergeClause()).add("StagingTable", (Object)this.stagingTable()).add("SelectedColumns", this.hasSelectedColumns() ? this.selectedColumns() : null).add("AutoPushdown", (Object)this.autoPushdown()).add("TableSchema", this.hasTableSchema() ? this.tableSchema() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceType()));
            }
            case "Connection": {
                return Optional.ofNullable(clazz.cast(this.connection()));
            }
            case "Schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
            case "Table": {
                return Optional.ofNullable(clazz.cast(this.table()));
            }
            case "Database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
            case "TempDir": {
                return Optional.ofNullable(clazz.cast(this.tempDir()));
            }
            case "IamRole": {
                return Optional.ofNullable(clazz.cast(this.iamRole()));
            }
            case "AdditionalOptions": {
                return Optional.ofNullable(clazz.cast(this.additionalOptions()));
            }
            case "SampleQuery": {
                return Optional.ofNullable(clazz.cast(this.sampleQuery()));
            }
            case "PreAction": {
                return Optional.ofNullable(clazz.cast(this.preAction()));
            }
            case "PostAction": {
                return Optional.ofNullable(clazz.cast(this.postAction()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "Upsert": {
                return Optional.ofNullable(clazz.cast(this.upsert()));
            }
            case "MergeAction": {
                return Optional.ofNullable(clazz.cast(this.mergeAction()));
            }
            case "MergeWhenMatched": {
                return Optional.ofNullable(clazz.cast(this.mergeWhenMatched()));
            }
            case "MergeWhenNotMatched": {
                return Optional.ofNullable(clazz.cast(this.mergeWhenNotMatched()));
            }
            case "MergeClause": {
                return Optional.ofNullable(clazz.cast(this.mergeClause()));
            }
            case "StagingTable": {
                return Optional.ofNullable(clazz.cast(this.stagingTable()));
            }
            case "SelectedColumns": {
                return Optional.ofNullable(clazz.cast(this.selectedColumns()));
            }
            case "AutoPushdown": {
                return Optional.ofNullable(clazz.cast(this.autoPushdown()));
            }
            case "TableSchema": {
                return Optional.ofNullable(clazz.cast(this.tableSchema()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SnowflakeNodeData, T> g) {
        return obj -> g.apply((SnowflakeNodeData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceType;
        private Option connection;
        private String schema;
        private String table;
        private String database;
        private String tempDir;
        private Option iamRole;
        private Map<String, String> additionalOptions = DefaultSdkAutoConstructMap.getInstance();
        private String sampleQuery;
        private String preAction;
        private String postAction;
        private String action;
        private Boolean upsert;
        private String mergeAction;
        private String mergeWhenMatched;
        private String mergeWhenNotMatched;
        private String mergeClause;
        private String stagingTable;
        private List<Option> selectedColumns = DefaultSdkAutoConstructList.getInstance();
        private Boolean autoPushdown;
        private List<Option> tableSchema = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SnowflakeNodeData model) {
            this.sourceType(model.sourceType);
            this.connection(model.connection);
            this.schema(model.schema);
            this.table(model.table);
            this.database(model.database);
            this.tempDir(model.tempDir);
            this.iamRole(model.iamRole);
            this.additionalOptions(model.additionalOptions);
            this.sampleQuery(model.sampleQuery);
            this.preAction(model.preAction);
            this.postAction(model.postAction);
            this.action(model.action);
            this.upsert(model.upsert);
            this.mergeAction(model.mergeAction);
            this.mergeWhenMatched(model.mergeWhenMatched);
            this.mergeWhenNotMatched(model.mergeWhenNotMatched);
            this.mergeClause(model.mergeClause);
            this.stagingTable(model.stagingTable);
            this.selectedColumns(model.selectedColumns);
            this.autoPushdown(model.autoPushdown);
            this.tableSchema(model.tableSchema);
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final Option.Builder getConnection() {
            return this.connection != null ? this.connection.toBuilder() : null;
        }

        public final void setConnection(Option.BuilderImpl connection) {
            this.connection = connection != null ? connection.build() : null;
        }

        @Override
        public final Builder connection(Option connection) {
            this.connection = connection;
            return this;
        }

        public final String getSchema() {
            return this.schema;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final String getTable() {
            return this.table;
        }

        public final void setTable(String table) {
            this.table = table;
        }

        @Override
        public final Builder table(String table) {
            this.table = table;
            return this;
        }

        public final String getDatabase() {
            return this.database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getTempDir() {
            return this.tempDir;
        }

        public final void setTempDir(String tempDir) {
            this.tempDir = tempDir;
        }

        @Override
        public final Builder tempDir(String tempDir) {
            this.tempDir = tempDir;
            return this;
        }

        public final Option.Builder getIamRole() {
            return this.iamRole != null ? this.iamRole.toBuilder() : null;
        }

        public final void setIamRole(Option.BuilderImpl iamRole) {
            this.iamRole = iamRole != null ? iamRole.build() : null;
        }

        @Override
        public final Builder iamRole(Option iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public final Map<String, String> getAdditionalOptions() {
            if (this.additionalOptions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.additionalOptions;
        }

        public final void setAdditionalOptions(Map<String, String> additionalOptions) {
            this.additionalOptions = AdditionalOptionsCopier.copy(additionalOptions);
        }

        @Override
        public final Builder additionalOptions(Map<String, String> additionalOptions) {
            this.additionalOptions = AdditionalOptionsCopier.copy(additionalOptions);
            return this;
        }

        public final String getSampleQuery() {
            return this.sampleQuery;
        }

        public final void setSampleQuery(String sampleQuery) {
            this.sampleQuery = sampleQuery;
        }

        @Override
        public final Builder sampleQuery(String sampleQuery) {
            this.sampleQuery = sampleQuery;
            return this;
        }

        public final String getPreAction() {
            return this.preAction;
        }

        public final void setPreAction(String preAction) {
            this.preAction = preAction;
        }

        @Override
        public final Builder preAction(String preAction) {
            this.preAction = preAction;
            return this;
        }

        public final String getPostAction() {
            return this.postAction;
        }

        public final void setPostAction(String postAction) {
            this.postAction = postAction;
        }

        @Override
        public final Builder postAction(String postAction) {
            this.postAction = postAction;
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final Boolean getUpsert() {
            return this.upsert;
        }

        public final void setUpsert(Boolean upsert) {
            this.upsert = upsert;
        }

        @Override
        public final Builder upsert(Boolean upsert) {
            this.upsert = upsert;
            return this;
        }

        public final String getMergeAction() {
            return this.mergeAction;
        }

        public final void setMergeAction(String mergeAction) {
            this.mergeAction = mergeAction;
        }

        @Override
        public final Builder mergeAction(String mergeAction) {
            this.mergeAction = mergeAction;
            return this;
        }

        public final String getMergeWhenMatched() {
            return this.mergeWhenMatched;
        }

        public final void setMergeWhenMatched(String mergeWhenMatched) {
            this.mergeWhenMatched = mergeWhenMatched;
        }

        @Override
        public final Builder mergeWhenMatched(String mergeWhenMatched) {
            this.mergeWhenMatched = mergeWhenMatched;
            return this;
        }

        public final String getMergeWhenNotMatched() {
            return this.mergeWhenNotMatched;
        }

        public final void setMergeWhenNotMatched(String mergeWhenNotMatched) {
            this.mergeWhenNotMatched = mergeWhenNotMatched;
        }

        @Override
        public final Builder mergeWhenNotMatched(String mergeWhenNotMatched) {
            this.mergeWhenNotMatched = mergeWhenNotMatched;
            return this;
        }

        public final String getMergeClause() {
            return this.mergeClause;
        }

        public final void setMergeClause(String mergeClause) {
            this.mergeClause = mergeClause;
        }

        @Override
        public final Builder mergeClause(String mergeClause) {
            this.mergeClause = mergeClause;
            return this;
        }

        public final String getStagingTable() {
            return this.stagingTable;
        }

        public final void setStagingTable(String stagingTable) {
            this.stagingTable = stagingTable;
        }

        @Override
        public final Builder stagingTable(String stagingTable) {
            this.stagingTable = stagingTable;
            return this;
        }

        public final List<Option.Builder> getSelectedColumns() {
            List<Option.Builder> result = OptionListCopier.copyToBuilder(this.selectedColumns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSelectedColumns(Collection<Option.BuilderImpl> selectedColumns) {
            this.selectedColumns = OptionListCopier.copyFromBuilder(selectedColumns);
        }

        @Override
        public final Builder selectedColumns(Collection<Option> selectedColumns) {
            this.selectedColumns = OptionListCopier.copy(selectedColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedColumns(Option ... selectedColumns) {
            this.selectedColumns(Arrays.asList(selectedColumns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedColumns(Consumer<Option.Builder> ... selectedColumns) {
            this.selectedColumns(Stream.of(selectedColumns).map(c -> (Option)((Option.Builder)Option.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getAutoPushdown() {
            return this.autoPushdown;
        }

        public final void setAutoPushdown(Boolean autoPushdown) {
            this.autoPushdown = autoPushdown;
        }

        @Override
        public final Builder autoPushdown(Boolean autoPushdown) {
            this.autoPushdown = autoPushdown;
            return this;
        }

        public final List<Option.Builder> getTableSchema() {
            List<Option.Builder> result = OptionListCopier.copyToBuilder(this.tableSchema);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTableSchema(Collection<Option.BuilderImpl> tableSchema) {
            this.tableSchema = OptionListCopier.copyFromBuilder(tableSchema);
        }

        @Override
        public final Builder tableSchema(Collection<Option> tableSchema) {
            this.tableSchema = OptionListCopier.copy(tableSchema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableSchema(Option ... tableSchema) {
            this.tableSchema(Arrays.asList(tableSchema));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableSchema(Consumer<Option.Builder> ... tableSchema) {
            this.tableSchema(Stream.of(tableSchema).map(c -> (Option)((Option.Builder)Option.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SnowflakeNodeData build() {
            return new SnowflakeNodeData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SnowflakeNodeData> {
        public Builder sourceType(String var1);

        public Builder connection(Option var1);

        default public Builder connection(Consumer<Option.Builder> connection) {
            return this.connection((Option)((Option.Builder)Option.builder().applyMutation(connection)).build());
        }

        public Builder schema(String var1);

        public Builder table(String var1);

        public Builder database(String var1);

        public Builder tempDir(String var1);

        public Builder iamRole(Option var1);

        default public Builder iamRole(Consumer<Option.Builder> iamRole) {
            return this.iamRole((Option)((Option.Builder)Option.builder().applyMutation(iamRole)).build());
        }

        public Builder additionalOptions(Map<String, String> var1);

        public Builder sampleQuery(String var1);

        public Builder preAction(String var1);

        public Builder postAction(String var1);

        public Builder action(String var1);

        public Builder upsert(Boolean var1);

        public Builder mergeAction(String var1);

        public Builder mergeWhenMatched(String var1);

        public Builder mergeWhenNotMatched(String var1);

        public Builder mergeClause(String var1);

        public Builder stagingTable(String var1);

        public Builder selectedColumns(Collection<Option> var1);

        public Builder selectedColumns(Option ... var1);

        public Builder selectedColumns(Consumer<Option.Builder> ... var1);

        public Builder autoPushdown(Boolean var1);

        public Builder tableSchema(Collection<Option> var1);

        public Builder tableSchema(Option ... var1);

        public Builder tableSchema(Consumer<Option.Builder> ... var1);
    }
}

