/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IcebergRetentionMetrics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IcebergRetentionMetrics> {
    private static final SdkField<Long> NUMBER_OF_DATA_FILES_DELETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NumberOfDataFilesDeleted").getter(IcebergRetentionMetrics.getter(IcebergRetentionMetrics::numberOfDataFilesDeleted)).setter(IcebergRetentionMetrics.setter(Builder::numberOfDataFilesDeleted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfDataFilesDeleted").build()}).build();
    private static final SdkField<Long> NUMBER_OF_MANIFEST_FILES_DELETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NumberOfManifestFilesDeleted").getter(IcebergRetentionMetrics.getter(IcebergRetentionMetrics::numberOfManifestFilesDeleted)).setter(IcebergRetentionMetrics.setter(Builder::numberOfManifestFilesDeleted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfManifestFilesDeleted").build()}).build();
    private static final SdkField<Long> NUMBER_OF_MANIFEST_LISTS_DELETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NumberOfManifestListsDeleted").getter(IcebergRetentionMetrics.getter(IcebergRetentionMetrics::numberOfManifestListsDeleted)).setter(IcebergRetentionMetrics.setter(Builder::numberOfManifestListsDeleted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfManifestListsDeleted").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_DPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfDpus").getter(IcebergRetentionMetrics.getter(IcebergRetentionMetrics::numberOfDpus)).setter(IcebergRetentionMetrics.setter(Builder::numberOfDpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfDpus").build()}).build();
    private static final SdkField<Double> JOB_DURATION_IN_HOUR_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("JobDurationInHour").getter(IcebergRetentionMetrics.getter(IcebergRetentionMetrics::jobDurationInHour)).setter(IcebergRetentionMetrics.setter(Builder::jobDurationInHour)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDurationInHour").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_OF_DATA_FILES_DELETED_FIELD, NUMBER_OF_MANIFEST_FILES_DELETED_FIELD, NUMBER_OF_MANIFEST_LISTS_DELETED_FIELD, NUMBER_OF_DPUS_FIELD, JOB_DURATION_IN_HOUR_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long numberOfDataFilesDeleted;
    private final Long numberOfManifestFilesDeleted;
    private final Long numberOfManifestListsDeleted;
    private final Integer numberOfDpus;
    private final Double jobDurationInHour;

    private IcebergRetentionMetrics(BuilderImpl builder) {
        this.numberOfDataFilesDeleted = builder.numberOfDataFilesDeleted;
        this.numberOfManifestFilesDeleted = builder.numberOfManifestFilesDeleted;
        this.numberOfManifestListsDeleted = builder.numberOfManifestListsDeleted;
        this.numberOfDpus = builder.numberOfDpus;
        this.jobDurationInHour = builder.jobDurationInHour;
    }

    public final Long numberOfDataFilesDeleted() {
        return this.numberOfDataFilesDeleted;
    }

    public final Long numberOfManifestFilesDeleted() {
        return this.numberOfManifestFilesDeleted;
    }

    public final Long numberOfManifestListsDeleted() {
        return this.numberOfManifestListsDeleted;
    }

    public final Integer numberOfDpus() {
        return this.numberOfDpus;
    }

    public final Double jobDurationInHour() {
        return this.jobDurationInHour;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfDataFilesDeleted());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfManifestFilesDeleted());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfManifestListsDeleted());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfDpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDurationInHour());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcebergRetentionMetrics)) {
            return false;
        }
        IcebergRetentionMetrics other = (IcebergRetentionMetrics)obj;
        return Objects.equals(this.numberOfDataFilesDeleted(), other.numberOfDataFilesDeleted()) && Objects.equals(this.numberOfManifestFilesDeleted(), other.numberOfManifestFilesDeleted()) && Objects.equals(this.numberOfManifestListsDeleted(), other.numberOfManifestListsDeleted()) && Objects.equals(this.numberOfDpus(), other.numberOfDpus()) && Objects.equals(this.jobDurationInHour(), other.jobDurationInHour());
    }

    public final String toString() {
        return ToString.builder((String)"IcebergRetentionMetrics").add("NumberOfDataFilesDeleted", (Object)this.numberOfDataFilesDeleted()).add("NumberOfManifestFilesDeleted", (Object)this.numberOfManifestFilesDeleted()).add("NumberOfManifestListsDeleted", (Object)this.numberOfManifestListsDeleted()).add("NumberOfDpus", (Object)this.numberOfDpus()).add("JobDurationInHour", (Object)this.jobDurationInHour()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NumberOfDataFilesDeleted": {
                return Optional.ofNullable(clazz.cast(this.numberOfDataFilesDeleted()));
            }
            case "NumberOfManifestFilesDeleted": {
                return Optional.ofNullable(clazz.cast(this.numberOfManifestFilesDeleted()));
            }
            case "NumberOfManifestListsDeleted": {
                return Optional.ofNullable(clazz.cast(this.numberOfManifestListsDeleted()));
            }
            case "NumberOfDpus": {
                return Optional.ofNullable(clazz.cast(this.numberOfDpus()));
            }
            case "JobDurationInHour": {
                return Optional.ofNullable(clazz.cast(this.jobDurationInHour()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IcebergRetentionMetrics, T> g) {
        return obj -> g.apply((IcebergRetentionMetrics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long numberOfDataFilesDeleted;
        private Long numberOfManifestFilesDeleted;
        private Long numberOfManifestListsDeleted;
        private Integer numberOfDpus;
        private Double jobDurationInHour;

        private BuilderImpl() {
        }

        private BuilderImpl(IcebergRetentionMetrics model) {
            this.numberOfDataFilesDeleted(model.numberOfDataFilesDeleted);
            this.numberOfManifestFilesDeleted(model.numberOfManifestFilesDeleted);
            this.numberOfManifestListsDeleted(model.numberOfManifestListsDeleted);
            this.numberOfDpus(model.numberOfDpus);
            this.jobDurationInHour(model.jobDurationInHour);
        }

        public final Long getNumberOfDataFilesDeleted() {
            return this.numberOfDataFilesDeleted;
        }

        public final void setNumberOfDataFilesDeleted(Long numberOfDataFilesDeleted) {
            this.numberOfDataFilesDeleted = numberOfDataFilesDeleted;
        }

        @Override
        public final Builder numberOfDataFilesDeleted(Long numberOfDataFilesDeleted) {
            this.numberOfDataFilesDeleted = numberOfDataFilesDeleted;
            return this;
        }

        public final Long getNumberOfManifestFilesDeleted() {
            return this.numberOfManifestFilesDeleted;
        }

        public final void setNumberOfManifestFilesDeleted(Long numberOfManifestFilesDeleted) {
            this.numberOfManifestFilesDeleted = numberOfManifestFilesDeleted;
        }

        @Override
        public final Builder numberOfManifestFilesDeleted(Long numberOfManifestFilesDeleted) {
            this.numberOfManifestFilesDeleted = numberOfManifestFilesDeleted;
            return this;
        }

        public final Long getNumberOfManifestListsDeleted() {
            return this.numberOfManifestListsDeleted;
        }

        public final void setNumberOfManifestListsDeleted(Long numberOfManifestListsDeleted) {
            this.numberOfManifestListsDeleted = numberOfManifestListsDeleted;
        }

        @Override
        public final Builder numberOfManifestListsDeleted(Long numberOfManifestListsDeleted) {
            this.numberOfManifestListsDeleted = numberOfManifestListsDeleted;
            return this;
        }

        public final Integer getNumberOfDpus() {
            return this.numberOfDpus;
        }

        public final void setNumberOfDpus(Integer numberOfDpus) {
            this.numberOfDpus = numberOfDpus;
        }

        @Override
        public final Builder numberOfDpus(Integer numberOfDpus) {
            this.numberOfDpus = numberOfDpus;
            return this;
        }

        public final Double getJobDurationInHour() {
            return this.jobDurationInHour;
        }

        public final void setJobDurationInHour(Double jobDurationInHour) {
            this.jobDurationInHour = jobDurationInHour;
        }

        @Override
        public final Builder jobDurationInHour(Double jobDurationInHour) {
            this.jobDurationInHour = jobDurationInHour;
            return this;
        }

        public IcebergRetentionMetrics build() {
            return new IcebergRetentionMetrics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IcebergRetentionMetrics> {
        public Builder numberOfDataFilesDeleted(Long var1);

        public Builder numberOfManifestFilesDeleted(Long var1);

        public Builder numberOfManifestListsDeleted(Long var1);

        public Builder numberOfDpus(Integer var1);

        public Builder jobDurationInHour(Double var1);
    }
}

