/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.AggregateOperation;
import software.amazon.awssdk.services.glue.model.AggregateOperationsCopier;
import software.amazon.awssdk.services.glue.model.GlueStudioPathListCopier;
import software.amazon.awssdk.services.glue.model.OneInputCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Aggregate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Aggregate> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Aggregate.getter(Aggregate::name)).setter(Aggregate.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Inputs").getter(Aggregate.getter(Aggregate::inputs)).setter(Aggregate.setter(Builder::inputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<List<String>>> GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Groups").getter(Aggregate.getter(Aggregate::groups)).setter(Aggregate.setter(Builder::groups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<List<AggregateOperation>> AGGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Aggs").getter(Aggregate.getter(Aggregate::aggs)).setter(Aggregate.setter(Builder::aggs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AggregateOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INPUTS_FIELD, GROUPS_FIELD, AGGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<String> inputs;
    private final List<List<String>> groups;
    private final List<AggregateOperation> aggs;

    private Aggregate(BuilderImpl builder) {
        this.name = builder.name;
        this.inputs = builder.inputs;
        this.groups = builder.groups;
        this.aggs = builder.aggs;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasInputs() {
        return this.inputs != null && !(this.inputs instanceof SdkAutoConstructList);
    }

    public final List<String> inputs() {
        return this.inputs;
    }

    public final boolean hasGroups() {
        return this.groups != null && !(this.groups instanceof SdkAutoConstructList);
    }

    public final List<List<String>> groups() {
        return this.groups;
    }

    public final boolean hasAggs() {
        return this.aggs != null && !(this.aggs instanceof SdkAutoConstructList);
    }

    public final List<AggregateOperation> aggs() {
        return this.aggs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputs() ? this.inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroups() ? this.groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAggs() ? this.aggs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Aggregate)) {
            return false;
        }
        Aggregate other = (Aggregate)obj;
        return Objects.equals(this.name(), other.name()) && this.hasInputs() == other.hasInputs() && Objects.equals(this.inputs(), other.inputs()) && this.hasGroups() == other.hasGroups() && Objects.equals(this.groups(), other.groups()) && this.hasAggs() == other.hasAggs() && Objects.equals(this.aggs(), other.aggs());
    }

    public final String toString() {
        return ToString.builder((String)"Aggregate").add("Name", (Object)this.name()).add("Inputs", this.hasInputs() ? this.inputs() : null).add("Groups", this.hasGroups() ? this.groups() : null).add("Aggs", this.hasAggs() ? this.aggs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Inputs": {
                return Optional.ofNullable(clazz.cast(this.inputs()));
            }
            case "Groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
            case "Aggs": {
                return Optional.ofNullable(clazz.cast(this.aggs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Aggregate, T> g) {
        return obj -> g.apply((Aggregate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();
        private List<List<String>> groups = DefaultSdkAutoConstructList.getInstance();
        private List<AggregateOperation> aggs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Aggregate model) {
            this.name(model.name);
            this.inputs(model.inputs);
            this.groups(model.groups);
            this.aggs(model.aggs);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getInputs() {
            if (this.inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String ... inputs) {
            this.inputs(Arrays.asList(inputs));
            return this;
        }

        public final Collection<? extends Collection<String>> getGroups() {
            if (this.groups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.groups;
        }

        public final void setGroups(Collection<? extends Collection<String>> groups) {
            this.groups = GlueStudioPathListCopier.copy(groups);
        }

        @Override
        public final Builder groups(Collection<? extends Collection<String>> groups) {
            this.groups = GlueStudioPathListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Collection<String> ... groups) {
            this.groups((Collection<? extends Collection<String>>)Arrays.asList(groups));
            return this;
        }

        public final List<AggregateOperation.Builder> getAggs() {
            List<AggregateOperation.Builder> result = AggregateOperationsCopier.copyToBuilder(this.aggs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggs(Collection<AggregateOperation.BuilderImpl> aggs) {
            this.aggs = AggregateOperationsCopier.copyFromBuilder(aggs);
        }

        @Override
        public final Builder aggs(Collection<AggregateOperation> aggs) {
            this.aggs = AggregateOperationsCopier.copy(aggs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggs(AggregateOperation ... aggs) {
            this.aggs(Arrays.asList(aggs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggs(Consumer<AggregateOperation.Builder> ... aggs) {
            this.aggs(Stream.of(aggs).map(c -> (AggregateOperation)((AggregateOperation.Builder)AggregateOperation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Aggregate build() {
            return new Aggregate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Aggregate> {
        public Builder name(String var1);

        public Builder inputs(Collection<String> var1);

        public Builder inputs(String ... var1);

        public Builder groups(Collection<? extends Collection<String>> var1);

        public Builder groups(Collection<String> ... var1);

        public Builder aggs(Collection<AggregateOperation> var1);

        public Builder aggs(AggregateOperation ... var1);

        public Builder aggs(Consumer<AggregateOperation.Builder> ... var1);
    }
}

