/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.ListDevEndpointsRequest;
import software.amazon.awssdk.services.glue.model.ListDevEndpointsResponse;

public class ListDevEndpointsIterable
implements SdkIterable<ListDevEndpointsResponse> {
    private final GlueClient client;
    private final ListDevEndpointsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDevEndpointsIterable(GlueClient client, ListDevEndpointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDevEndpointsResponseFetcher();
    }

    public Iterator<ListDevEndpointsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListDevEndpointsResponseFetcher
    implements SyncPageFetcher<ListDevEndpointsResponse> {
        private ListDevEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(ListDevEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDevEndpointsResponse nextPage(ListDevEndpointsResponse previousPage) {
            if (previousPage == null) {
                return ListDevEndpointsIterable.this.client.listDevEndpoints(ListDevEndpointsIterable.this.firstRequest);
            }
            return ListDevEndpointsIterable.this.client.listDevEndpoints((ListDevEndpointsRequest)((Object)ListDevEndpointsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

