/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the encryption-at-rest configuration for the Data Catalog.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EncryptionAtRest implements SdkPojo, Serializable,
        ToCopyableBuilder<EncryptionAtRest.Builder, EncryptionAtRest> {
    private static final SdkField<String> CATALOG_ENCRYPTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogEncryptionMode").getter(getter(EncryptionAtRest::catalogEncryptionModeAsString))
            .setter(setter(Builder::catalogEncryptionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogEncryptionMode").build())
            .build();

    private static final SdkField<String> SSE_AWS_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SseAwsKmsKeyId").getter(getter(EncryptionAtRest::sseAwsKmsKeyId))
            .setter(setter(Builder::sseAwsKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SseAwsKmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ENCRYPTION_MODE_FIELD,
            SSE_AWS_KMS_KEY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String catalogEncryptionMode;

    private final String sseAwsKmsKeyId;

    private EncryptionAtRest(BuilderImpl builder) {
        this.catalogEncryptionMode = builder.catalogEncryptionMode;
        this.sseAwsKmsKeyId = builder.sseAwsKmsKeyId;
    }

    /**
     * <p>
     * The encryption-at-rest mode for encrypting Data Catalog data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #catalogEncryptionMode} will return {@link CatalogEncryptionMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #catalogEncryptionModeAsString}.
     * </p>
     * 
     * @return The encryption-at-rest mode for encrypting Data Catalog data.
     * @see CatalogEncryptionMode
     */
    public final CatalogEncryptionMode catalogEncryptionMode() {
        return CatalogEncryptionMode.fromValue(catalogEncryptionMode);
    }

    /**
     * <p>
     * The encryption-at-rest mode for encrypting Data Catalog data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #catalogEncryptionMode} will return {@link CatalogEncryptionMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #catalogEncryptionModeAsString}.
     * </p>
     * 
     * @return The encryption-at-rest mode for encrypting Data Catalog data.
     * @see CatalogEncryptionMode
     */
    public final String catalogEncryptionModeAsString() {
        return catalogEncryptionMode;
    }

    /**
     * <p>
     * The ID of the KMS key to use for encryption at rest.
     * </p>
     * 
     * @return The ID of the KMS key to use for encryption at rest.
     */
    public final String sseAwsKmsKeyId() {
        return sseAwsKmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(catalogEncryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sseAwsKmsKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionAtRest)) {
            return false;
        }
        EncryptionAtRest other = (EncryptionAtRest) obj;
        return Objects.equals(catalogEncryptionModeAsString(), other.catalogEncryptionModeAsString())
                && Objects.equals(sseAwsKmsKeyId(), other.sseAwsKmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EncryptionAtRest").add("CatalogEncryptionMode", catalogEncryptionModeAsString())
                .add("SseAwsKmsKeyId", sseAwsKmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogEncryptionMode":
            return Optional.ofNullable(clazz.cast(catalogEncryptionModeAsString()));
        case "SseAwsKmsKeyId":
            return Optional.ofNullable(clazz.cast(sseAwsKmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EncryptionAtRest, T> g) {
        return obj -> g.apply((EncryptionAtRest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EncryptionAtRest> {
        /**
         * <p>
         * The encryption-at-rest mode for encrypting Data Catalog data.
         * </p>
         * 
         * @param catalogEncryptionMode
         *        The encryption-at-rest mode for encrypting Data Catalog data.
         * @see CatalogEncryptionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CatalogEncryptionMode
         */
        Builder catalogEncryptionMode(String catalogEncryptionMode);

        /**
         * <p>
         * The encryption-at-rest mode for encrypting Data Catalog data.
         * </p>
         * 
         * @param catalogEncryptionMode
         *        The encryption-at-rest mode for encrypting Data Catalog data.
         * @see CatalogEncryptionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CatalogEncryptionMode
         */
        Builder catalogEncryptionMode(CatalogEncryptionMode catalogEncryptionMode);

        /**
         * <p>
         * The ID of the KMS key to use for encryption at rest.
         * </p>
         * 
         * @param sseAwsKmsKeyId
         *        The ID of the KMS key to use for encryption at rest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseAwsKmsKeyId(String sseAwsKmsKeyId);
    }

    static final class BuilderImpl implements Builder {
        private String catalogEncryptionMode;

        private String sseAwsKmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionAtRest model) {
            catalogEncryptionMode(model.catalogEncryptionMode);
            sseAwsKmsKeyId(model.sseAwsKmsKeyId);
        }

        public final String getCatalogEncryptionMode() {
            return catalogEncryptionMode;
        }

        public final void setCatalogEncryptionMode(String catalogEncryptionMode) {
            this.catalogEncryptionMode = catalogEncryptionMode;
        }

        @Override
        public final Builder catalogEncryptionMode(String catalogEncryptionMode) {
            this.catalogEncryptionMode = catalogEncryptionMode;
            return this;
        }

        @Override
        public final Builder catalogEncryptionMode(CatalogEncryptionMode catalogEncryptionMode) {
            this.catalogEncryptionMode(catalogEncryptionMode == null ? null : catalogEncryptionMode.toString());
            return this;
        }

        public final String getSseAwsKmsKeyId() {
            return sseAwsKmsKeyId;
        }

        public final void setSseAwsKmsKeyId(String sseAwsKmsKeyId) {
            this.sseAwsKmsKeyId = sseAwsKmsKeyId;
        }

        @Override
        public final Builder sseAwsKmsKeyId(String sseAwsKmsKeyId) {
            this.sseAwsKmsKeyId = sseAwsKmsKeyId;
            return this;
        }

        @Override
        public EncryptionAtRest build() {
            return new EncryptionAtRest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
