/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StatementState {
    WAITING("WAITING"),
    RUNNING("RUNNING"),
    AVAILABLE("AVAILABLE"),
    CANCELLING("CANCELLING"),
    CANCELLED("CANCELLED"),
    ERROR("ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StatementState> VALUE_MAP;
    private final String value;

    private StatementState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StatementState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StatementState> knownValues() {
        EnumSet<StatementState> knownValues = EnumSet.allOf(StatementState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StatementState.class, StatementState::toString);
    }
}

