/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WorkerType {
    STANDARD("Standard"),
    G_1_X("G.1X"),
    G_2_X("G.2X"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WorkerType> VALUE_MAP;
    private final String value;

    private WorkerType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WorkerType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WorkerType> knownValues() {
        EnumSet<WorkerType> knownValues = EnumSet.allOf(WorkerType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WorkerType.class, WorkerType::toString);
    }
}

