/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.PrincipalType;
import software.amazon.awssdk.services.glue.model.ResourceUri;
import software.amazon.awssdk.services.glue.model.ResourceUriListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserDefinedFunctionInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserDefinedFunctionInput> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionName").getter(UserDefinedFunctionInput.getter(UserDefinedFunctionInput::functionName)).setter(UserDefinedFunctionInput.setter(Builder::functionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionName").build()}).build();
    private static final SdkField<String> CLASS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClassName").getter(UserDefinedFunctionInput.getter(UserDefinedFunctionInput::className)).setter(UserDefinedFunctionInput.setter(Builder::className)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClassName").build()}).build();
    private static final SdkField<String> OWNER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerName").getter(UserDefinedFunctionInput.getter(UserDefinedFunctionInput::ownerName)).setter(UserDefinedFunctionInput.setter(Builder::ownerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerName").build()}).build();
    private static final SdkField<String> OWNER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerType").getter(UserDefinedFunctionInput.getter(UserDefinedFunctionInput::ownerTypeAsString)).setter(UserDefinedFunctionInput.setter(Builder::ownerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerType").build()}).build();
    private static final SdkField<List<ResourceUri>> RESOURCE_URIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceUris").getter(UserDefinedFunctionInput.getter(UserDefinedFunctionInput::resourceUris)).setter(UserDefinedFunctionInput.setter(Builder::resourceUris)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceUris").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceUri::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD, CLASS_NAME_FIELD, OWNER_NAME_FIELD, OWNER_TYPE_FIELD, RESOURCE_URIS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String functionName;
    private final String className;
    private final String ownerName;
    private final String ownerType;
    private final List<ResourceUri> resourceUris;

    private UserDefinedFunctionInput(BuilderImpl builder) {
        this.functionName = builder.functionName;
        this.className = builder.className;
        this.ownerName = builder.ownerName;
        this.ownerType = builder.ownerType;
        this.resourceUris = builder.resourceUris;
    }

    public final String functionName() {
        return this.functionName;
    }

    public final String className() {
        return this.className;
    }

    public final String ownerName() {
        return this.ownerName;
    }

    public final PrincipalType ownerType() {
        return PrincipalType.fromValue(this.ownerType);
    }

    public final String ownerTypeAsString() {
        return this.ownerType;
    }

    public final boolean hasResourceUris() {
        return this.resourceUris != null && !(this.resourceUris instanceof SdkAutoConstructList);
    }

    public final List<ResourceUri> resourceUris() {
        return this.resourceUris;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.functionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.className());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceUris() ? this.resourceUris() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserDefinedFunctionInput)) {
            return false;
        }
        UserDefinedFunctionInput other = (UserDefinedFunctionInput)obj;
        return Objects.equals(this.functionName(), other.functionName()) && Objects.equals(this.className(), other.className()) && Objects.equals(this.ownerName(), other.ownerName()) && Objects.equals(this.ownerTypeAsString(), other.ownerTypeAsString()) && this.hasResourceUris() == other.hasResourceUris() && Objects.equals(this.resourceUris(), other.resourceUris());
    }

    public final String toString() {
        return ToString.builder((String)"UserDefinedFunctionInput").add("FunctionName", (Object)this.functionName()).add("ClassName", (Object)this.className()).add("OwnerName", (Object)this.ownerName()).add("OwnerType", (Object)this.ownerTypeAsString()).add("ResourceUris", this.hasResourceUris() ? this.resourceUris() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionName": {
                return Optional.ofNullable(clazz.cast(this.functionName()));
            }
            case "ClassName": {
                return Optional.ofNullable(clazz.cast(this.className()));
            }
            case "OwnerName": {
                return Optional.ofNullable(clazz.cast(this.ownerName()));
            }
            case "OwnerType": {
                return Optional.ofNullable(clazz.cast(this.ownerTypeAsString()));
            }
            case "ResourceUris": {
                return Optional.ofNullable(clazz.cast(this.resourceUris()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserDefinedFunctionInput, T> g) {
        return obj -> g.apply((UserDefinedFunctionInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String functionName;
        private String className;
        private String ownerName;
        private String ownerType;
        private List<ResourceUri> resourceUris = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UserDefinedFunctionInput model) {
            this.functionName(model.functionName);
            this.className(model.className);
            this.ownerName(model.ownerName);
            this.ownerType(model.ownerType);
            this.resourceUris(model.resourceUris);
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        @Transient
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final String getClassName() {
            return this.className;
        }

        public final void setClassName(String className) {
            this.className = className;
        }

        @Override
        @Transient
        public final Builder className(String className) {
            this.className = className;
            return this;
        }

        public final String getOwnerName() {
            return this.ownerName;
        }

        public final void setOwnerName(String ownerName) {
            this.ownerName = ownerName;
        }

        @Override
        @Transient
        public final Builder ownerName(String ownerName) {
            this.ownerName = ownerName;
            return this;
        }

        public final String getOwnerType() {
            return this.ownerType;
        }

        public final void setOwnerType(String ownerType) {
            this.ownerType = ownerType;
        }

        @Override
        @Transient
        public final Builder ownerType(String ownerType) {
            this.ownerType = ownerType;
            return this;
        }

        @Override
        @Transient
        public final Builder ownerType(PrincipalType ownerType) {
            this.ownerType(ownerType == null ? null : ownerType.toString());
            return this;
        }

        public final List<ResourceUri.Builder> getResourceUris() {
            List<ResourceUri.Builder> result = ResourceUriListCopier.copyToBuilder(this.resourceUris);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceUris(Collection<ResourceUri.BuilderImpl> resourceUris) {
            this.resourceUris = ResourceUriListCopier.copyFromBuilder(resourceUris);
        }

        @Override
        @Transient
        public final Builder resourceUris(Collection<ResourceUri> resourceUris) {
            this.resourceUris = ResourceUriListCopier.copy(resourceUris);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resourceUris(ResourceUri ... resourceUris) {
            this.resourceUris(Arrays.asList(resourceUris));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resourceUris(Consumer<ResourceUri.Builder> ... resourceUris) {
            this.resourceUris(Stream.of(resourceUris).map(c -> (ResourceUri)((ResourceUri.Builder)ResourceUri.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public UserDefinedFunctionInput build() {
            return new UserDefinedFunctionInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserDefinedFunctionInput> {
        public Builder functionName(String var1);

        public Builder className(String var1);

        public Builder ownerName(String var1);

        public Builder ownerType(String var1);

        public Builder ownerType(PrincipalType var1);

        public Builder resourceUris(Collection<ResourceUri> var1);

        public Builder resourceUris(ResourceUri ... var1);

        public Builder resourceUris(Consumer<ResourceUri.Builder> ... var1);
    }
}

