/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.Blueprint;
import software.amazon.awssdk.services.glue.model.BlueprintNamesCopier;
import software.amazon.awssdk.services.glue.model.BlueprintsCopier;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetBlueprintsResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, BatchGetBlueprintsResponse> {
    private static final SdkField<List<Blueprint>> BLUEPRINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Blueprints").getter(BatchGetBlueprintsResponse.getter(BatchGetBlueprintsResponse::blueprints)).setter(BatchGetBlueprintsResponse.setter(Builder::blueprints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Blueprints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Blueprint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> MISSING_BLUEPRINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MissingBlueprints").getter(BatchGetBlueprintsResponse.getter(BatchGetBlueprintsResponse::missingBlueprints)).setter(BatchGetBlueprintsResponse.setter(Builder::missingBlueprints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MissingBlueprints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINTS_FIELD, MISSING_BLUEPRINTS_FIELD));
    private final List<Blueprint> blueprints;
    private final List<String> missingBlueprints;

    private BatchGetBlueprintsResponse(BuilderImpl builder) {
        super(builder);
        this.blueprints = builder.blueprints;
        this.missingBlueprints = builder.missingBlueprints;
    }

    public final boolean hasBlueprints() {
        return this.blueprints != null && !(this.blueprints instanceof SdkAutoConstructList);
    }

    public final List<Blueprint> blueprints() {
        return this.blueprints;
    }

    public final boolean hasMissingBlueprints() {
        return this.missingBlueprints != null && !(this.missingBlueprints instanceof SdkAutoConstructList);
    }

    public final List<String> missingBlueprints() {
        return this.missingBlueprints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlueprints() ? this.blueprints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMissingBlueprints() ? this.missingBlueprints() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetBlueprintsResponse)) {
            return false;
        }
        BatchGetBlueprintsResponse other = (BatchGetBlueprintsResponse)((Object)obj);
        return this.hasBlueprints() == other.hasBlueprints() && Objects.equals(this.blueprints(), other.blueprints()) && this.hasMissingBlueprints() == other.hasMissingBlueprints() && Objects.equals(this.missingBlueprints(), other.missingBlueprints());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetBlueprintsResponse").add("Blueprints", this.hasBlueprints() ? this.blueprints() : null).add("MissingBlueprints", this.hasMissingBlueprints() ? this.missingBlueprints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Blueprints": {
                return Optional.ofNullable(clazz.cast(this.blueprints()));
            }
            case "MissingBlueprints": {
                return Optional.ofNullable(clazz.cast(this.missingBlueprints()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetBlueprintsResponse, T> g) {
        return obj -> g.apply((BatchGetBlueprintsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<Blueprint> blueprints = DefaultSdkAutoConstructList.getInstance();
        private List<String> missingBlueprints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetBlueprintsResponse model) {
            super(model);
            this.blueprints(model.blueprints);
            this.missingBlueprints(model.missingBlueprints);
        }

        public final List<Blueprint.Builder> getBlueprints() {
            List<Blueprint.Builder> result = BlueprintsCopier.copyToBuilder(this.blueprints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlueprints(Collection<Blueprint.BuilderImpl> blueprints) {
            this.blueprints = BlueprintsCopier.copyFromBuilder(blueprints);
        }

        @Override
        public final Builder blueprints(Collection<Blueprint> blueprints) {
            this.blueprints = BlueprintsCopier.copy(blueprints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blueprints(Blueprint ... blueprints) {
            this.blueprints(Arrays.asList(blueprints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blueprints(Consumer<Blueprint.Builder> ... blueprints) {
            this.blueprints(Stream.of(blueprints).map(c -> (Blueprint)((Blueprint.Builder)Blueprint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getMissingBlueprints() {
            if (this.missingBlueprints instanceof SdkAutoConstructList) {
                return null;
            }
            return this.missingBlueprints;
        }

        public final void setMissingBlueprints(Collection<String> missingBlueprints) {
            this.missingBlueprints = BlueprintNamesCopier.copy(missingBlueprints);
        }

        @Override
        public final Builder missingBlueprints(Collection<String> missingBlueprints) {
            this.missingBlueprints = BlueprintNamesCopier.copy(missingBlueprints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder missingBlueprints(String ... missingBlueprints) {
            this.missingBlueprints(Arrays.asList(missingBlueprints));
            return this;
        }

        @Override
        public BatchGetBlueprintsResponse build() {
            return new BatchGetBlueprintsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetBlueprintsResponse> {
        public Builder blueprints(Collection<Blueprint> var1);

        public Builder blueprints(Blueprint ... var1);

        public Builder blueprints(Consumer<Blueprint.Builder> ... var1);

        public Builder missingBlueprints(Collection<String> var1);

        public Builder missingBlueprints(String ... var1);
    }
}

