/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GlueTable
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GlueTable> {
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(GlueTable.getter(GlueTable::databaseName)).setter(GlueTable.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(GlueTable.getter(GlueTable::tableName)).setter(GlueTable.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogId").getter(GlueTable.getter(GlueTable::catalogId)).setter(GlueTable.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionName").getter(GlueTable.getter(GlueTable::connectionName)).setter(GlueTable.setter(Builder::connectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_NAME_FIELD, TABLE_NAME_FIELD, CATALOG_ID_FIELD, CONNECTION_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String databaseName;
    private final String tableName;
    private final String catalogId;
    private final String connectionName;

    private GlueTable(BuilderImpl builder) {
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.catalogId = builder.catalogId;
        this.connectionName = builder.connectionName;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final String connectionName() {
        return this.connectionName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlueTable)) {
            return false;
        }
        GlueTable other = (GlueTable)obj;
        return Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.connectionName(), other.connectionName());
    }

    public final String toString() {
        return ToString.builder((String)"GlueTable").add("DatabaseName", (Object)this.databaseName()).add("TableName", (Object)this.tableName()).add("CatalogId", (Object)this.catalogId()).add("ConnectionName", (Object)this.connectionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "ConnectionName": {
                return Optional.ofNullable(clazz.cast(this.connectionName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GlueTable, T> g) {
        return obj -> g.apply((GlueTable)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String databaseName;
        private String tableName;
        private String catalogId;
        private String connectionName;

        private BuilderImpl() {
        }

        private BuilderImpl(GlueTable model) {
            this.databaseName(model.databaseName);
            this.tableName(model.tableName);
            this.catalogId(model.catalogId);
            this.connectionName(model.connectionName);
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getConnectionName() {
            return this.connectionName;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public GlueTable build() {
            return new GlueTable(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GlueTable> {
        public Builder databaseName(String var1);

        public Builder tableName(String var1);

        public Builder catalogId(String var1);

        public Builder connectionName(String var1);
    }
}

