/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.TaskStatusType;
import software.amazon.awssdk.services.glue.model.TaskType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaskRunFilterCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaskRunFilterCriteria> {
    private static final SdkField<String> TASK_RUN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskRunType").getter(TaskRunFilterCriteria.getter(TaskRunFilterCriteria::taskRunTypeAsString)).setter(TaskRunFilterCriteria.setter(Builder::taskRunType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskRunType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(TaskRunFilterCriteria.getter(TaskRunFilterCriteria::statusAsString)).setter(TaskRunFilterCriteria.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> STARTED_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartedBefore").getter(TaskRunFilterCriteria.getter(TaskRunFilterCriteria::startedBefore)).setter(TaskRunFilterCriteria.setter(Builder::startedBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedBefore").build()}).build();
    private static final SdkField<Instant> STARTED_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartedAfter").getter(TaskRunFilterCriteria.getter(TaskRunFilterCriteria::startedAfter)).setter(TaskRunFilterCriteria.setter(Builder::startedAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedAfter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_RUN_TYPE_FIELD, STATUS_FIELD, STARTED_BEFORE_FIELD, STARTED_AFTER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String taskRunType;
    private final String status;
    private final Instant startedBefore;
    private final Instant startedAfter;

    private TaskRunFilterCriteria(BuilderImpl builder) {
        this.taskRunType = builder.taskRunType;
        this.status = builder.status;
        this.startedBefore = builder.startedBefore;
        this.startedAfter = builder.startedAfter;
    }

    public final TaskType taskRunType() {
        return TaskType.fromValue(this.taskRunType);
    }

    public final String taskRunTypeAsString() {
        return this.taskRunType;
    }

    public final TaskStatusType status() {
        return TaskStatusType.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant startedBefore() {
        return this.startedBefore;
    }

    public final Instant startedAfter() {
        return this.startedAfter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskRunTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAfter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskRunFilterCriteria)) {
            return false;
        }
        TaskRunFilterCriteria other = (TaskRunFilterCriteria)obj;
        return Objects.equals(this.taskRunTypeAsString(), other.taskRunTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.startedBefore(), other.startedBefore()) && Objects.equals(this.startedAfter(), other.startedAfter());
    }

    public final String toString() {
        return ToString.builder((String)"TaskRunFilterCriteria").add("TaskRunType", (Object)this.taskRunTypeAsString()).add("Status", (Object)this.statusAsString()).add("StartedBefore", (Object)this.startedBefore()).add("StartedAfter", (Object)this.startedAfter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TaskRunType": {
                return Optional.ofNullable(clazz.cast(this.taskRunTypeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StartedBefore": {
                return Optional.ofNullable(clazz.cast(this.startedBefore()));
            }
            case "StartedAfter": {
                return Optional.ofNullable(clazz.cast(this.startedAfter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TaskRunFilterCriteria, T> g) {
        return obj -> g.apply((TaskRunFilterCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String taskRunType;
        private String status;
        private Instant startedBefore;
        private Instant startedAfter;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskRunFilterCriteria model) {
            this.taskRunType(model.taskRunType);
            this.status(model.status);
            this.startedBefore(model.startedBefore);
            this.startedAfter(model.startedAfter);
        }

        public final String getTaskRunType() {
            return this.taskRunType;
        }

        public final void setTaskRunType(String taskRunType) {
            this.taskRunType = taskRunType;
        }

        @Override
        @Transient
        public final Builder taskRunType(String taskRunType) {
            this.taskRunType = taskRunType;
            return this;
        }

        @Override
        @Transient
        public final Builder taskRunType(TaskType taskRunType) {
            this.taskRunType(taskRunType == null ? null : taskRunType.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(TaskStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartedBefore() {
            return this.startedBefore;
        }

        public final void setStartedBefore(Instant startedBefore) {
            this.startedBefore = startedBefore;
        }

        @Override
        @Transient
        public final Builder startedBefore(Instant startedBefore) {
            this.startedBefore = startedBefore;
            return this;
        }

        public final Instant getStartedAfter() {
            return this.startedAfter;
        }

        public final void setStartedAfter(Instant startedAfter) {
            this.startedAfter = startedAfter;
        }

        @Override
        @Transient
        public final Builder startedAfter(Instant startedAfter) {
            this.startedAfter = startedAfter;
            return this;
        }

        public TaskRunFilterCriteria build() {
            return new TaskRunFilterCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaskRunFilterCriteria> {
        public Builder taskRunType(String var1);

        public Builder taskRunType(TaskType var1);

        public Builder status(String var1);

        public Builder status(TaskStatusType var1);

        public Builder startedBefore(Instant var1);

        public Builder startedAfter(Instant var1);
    }
}

